﻿// <summary>ソースコード：流量入力モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYMCO.OptionImpl.McDischargeObservedForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>流量入力モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/13][新規作成]</para>
    /// </remarks>
    public class McDischargeObservedDefine
    {


        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID DISCHARGE_OBSERVED_LIB = new HySID("DischargeObserved_Factory");


        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>流量入力モデル種別</summary>
        public static readonly HySObjectKind DISCHARGE_OBSERVED_KIND = new HySObjectKind("DischargeObserved_Model");
        /// <summary>流量入力モデル名称</summary>
        public static readonly HySString DISCHARGE_OBSERVED_NAME = new HySString(Properties.Resources.MODEL_NAME /* "流量入力モデル" */);


        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // McDischargeObserved用
        // ===============================
        /// <summary>送信パターン１ 流量出力</summary>
        public static readonly HySID OUT_PATTERN_0D = new HySID("QUANTITY_OF_WATER_FLOW_0D");
        /// <summary>送信パターン２ ダム諸量出力</summary>
        public static readonly HySID OUT_PATTERN_0D_DAM = new HySID("DAM_0D");
        /// <summary>送信パターン３ 取水施設出力</summary>
        public static readonly HySID OUT_PATTERN_0D_PUMP = new HySID("PUMP_0D");
        /// <summary>送信パターン４ 流量出力</summary>
        public static readonly HySID OUT_PATTERN_1D = new HySID("QUANTITY_OF_WATER_FLOW");
        /// <summary>送信パターン５ ダム諸量出力</summary>
        public static readonly HySID OUT_PATTERN_1D_DAM = new HySID("DAM");
        /// <summary>送信パターン６ 取水施設出力</summary>
        public static readonly HySID OUT_PATTERN_1D_PUMP = new HySID("PUMP");


        /// <summary>入力ファイルの形式プロパティ：CSV</summary>
        public static readonly string INPUTFILE_TYPE_CSV = "csv";
        /// <summary>入力ファイルの形式プロパティ：Wisef</summary>
        public static readonly string INPUTFILE_TYPE_WSF = "wsf";

    }
}
