﻿// <summary>ソースコード：流量入力モデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/13][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McDischargeObservedForDevelop.McDischargeObservedFactory();
        }
    }
}


namespace CommonMP.HYMCO.OptionImpl.McDischargeObservedForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>流量入力モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/13][新規作成]</para>
    /// </remarks>
    public class McDischargeObservedFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McDischargeObservedDefine.DISCHARGE_OBSERVED_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;

            if (csModelKind.Equals(McDischargeObservedDefine.DISCHARGE_OBSERVED_KIND) == true)
            {
                csCalModel = new McDischargeObservedModel();
            }
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(McDischargeObservedDefine.DISCHARGE_OBSERVED_KIND) == true)
            {
                csCalInfoData = new McDischargeObservedCalInfo();
            }
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(McDischargeObservedDefine.DISCHARGE_OBSERVED_KIND) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                // 各モデルのプロパティ情報を設定します
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", "入力ファイル名", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "");

                csRtnCellPrptyDt.AddInfoType("m_csSerialNum", "観測所地点数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_csSerialNum", 1);

                csRtnCellPrptyDt.AddInfoType("m_csFileType", string.Format("入力ファイルの形式({0}:CSVファイル, {1}:wisefファイル)",
                                                                McDischargeObservedDefine.INPUTFILE_TYPE_CSV,
                                                                McDischargeObservedDefine.INPUTFILE_TYPE_WSF), McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csFileType", McDischargeObservedDefine.INPUTFILE_TYPE_CSV);

                csRtnCellPrptyDt.AddInfoType("m_lOutPoint", "出力地点(0:全て, 1～:出力地点指定)", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lOutPoint", 0); //0:全て/1～:出力地点

                // 受信可能なパターン
                {
                }
                // 送信パターンの設定
                {
                    // start of 送信パターンその１設定
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDischargeObservedDefine.OUT_PATTERN_0D, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.DISCHARGE /*"流量" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE /*"流量" */, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその１設定

                    // start of 送信パターンその２設定
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDischargeObservedDefine.OUT_PATTERN_0D_DAM, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.DAM_DATA /*"ダム諸量"*/) as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（０次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6); // セル内の情報は6個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.RESERVOIR_WATER_LEVEL /*"貯水位"*/, HySDataKindDefine.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(1, Properties.Resources.RESERVOIR_STORAGE /*"貯水量"*/, HySDataKindDefine.WATER_VOLUME, "m3");
                            csCellChara.SetDataKind(2, Properties.Resources.PERCENTAGE_OF_STORAGE /*"貯水率"*/, HySDataKindDefine.ANY_VALUE, "%");
                            csCellChara.SetDataKind(3, Properties.Resources.INFLOW /*"流入量"*/, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                            csCellChara.SetDataKind(4, Properties.Resources.OUTFLOW /*放流量"*/, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                            csCellChara.SetDataKind(5, Properties.Resources.FREE_CAPACITY /*"空き容量"*/, HySDataKindDefine.WATER_VOLUME, "m3");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその２設定

                    // start of 送信パターンその３設定
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDischargeObservedDefine.OUT_PATTERN_0D_PUMP, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.WATER_INTAKE_FACILITY /*"取水施設"*/) as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（０次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.INTAKE_DISCHARGE /*"取水量"*/, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその３設定
                    // start of 送信パターンその４設定
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDischargeObservedDefine.OUT_PATTERN_1D, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.DISCHARGE /*"流量" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE /*"流量" */, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその４設定

                    // start of 送信パターンその５設定
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDischargeObservedDefine.OUT_PATTERN_1D_DAM, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.DAM_DATA /*"ダム諸量"*/) as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6); // セル内の情報は6個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.RESERVOIR_WATER_LEVEL /*"貯水位"*/, HySDataKindDefine.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(1, Properties.Resources.RESERVOIR_STORAGE /*"貯水量"*/, HySDataKindDefine.WATER_VOLUME, "m3");
                            csCellChara.SetDataKind(2, Properties.Resources.PERCENTAGE_OF_STORAGE /*"貯水率"*/, HySDataKindDefine.ANY_VALUE, "%");
                            csCellChara.SetDataKind(3, Properties.Resources.INFLOW /*"流入量"*/, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                            csCellChara.SetDataKind(4, Properties.Resources.OUTFLOW /*"放流量"*/, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                            csCellChara.SetDataKind(5, Properties.Resources.FREE_CAPACITY /*"空き容量"*/, HySDataKindDefine.WATER_VOLUME, "m3");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその５設定

                    // start of 送信パターンその６設定
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDischargeObservedDefine.OUT_PATTERN_1D_PUMP, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.WATER_INTAKE_FACILITY /*"取水施設"*/) as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.INTAKE_DISCHARGE /*"取水量"*/, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその６設定

                }
            }
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(McDischargeObservedDefine.DISCHARGE_OBSERVED_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_INPUT_MODEL,    // <-- 入力モデル
                    McModelLibraryDefine.MODEL_CLASSIFICATION_INPUT_CSV_FILE,
                    McDischargeObservedDefine.DISCHARGE_OBSERVED_KIND, // モデルの識別子
                    McDischargeObservedDefine.DISCHARGE_OBSERVED_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.1.0 ");
            csModelInfo.SetSummaryInf(Properties.Resources.MODEL_SUMMARY /* "流入量・放流量（wisef or csv形式のファイル）を入力する。" */);
            csModelInfo.SetCreatorInf(Properties.Resources.MODEL_CREATOR /* "CommonMP" */);
            csModelInfo.SetIconName("McDischargeObserved");
            csModelInfo.SetManualFileName("McDischargeObserved.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo); // 入力モデル情報の追加


            return m_csCalModelInforList;
        }

    }
}
