﻿// <summary>ソースコード：地上観測所雨量入力モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McRainfallGaugingForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>地上観測所雨量入力モデル共通定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class McRainfallGaugingDefine
    {
        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static readonly HySID RAINFALL_GAUGING_LIB = new HySID("RainfallGauging_Factory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>降雨観測値・予測値の入力モジュール種別</summary>
        public static readonly HySObjectKind RAINFALL_GAUGING_KIND = new HySObjectKind("RainfallGauging_Model");
        /// <summary>降雨観測値・予測値の入力モジュール名称</summary>
        public static readonly HySString RAINFALL_GAUGING_NAME = new HySString(Properties.Resources.MODEL_NAME);


        //********************************
        //===== モデル個別定義 ========
        //********************************
        /// <summary>送信パターン１　ポイント</summary>
        public static readonly HySID OUT_PATTERN_0D = new HySID("OUT_PATTERN_0D");
        /// <summary>送信パターン２　１次元</summary>
        public static readonly HySID OUT_PATTERN_1D = new HySID("OUT_PATTERN_1D");

    }
}
