﻿// <summary>ソースコード：地上観測所雨量入力モデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>地上観測所雨量入力モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE :HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McRainfallGaugingForDevelop.McRainfallGaugingFactory();
        }
    }
}

namespace CommonMP.HYMCO.OptionImpl.McRainfallGaugingForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>地上観測所雨量入力モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class McRainfallGaugingFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSampleModelFactory csFactory = new McSampleModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>

        public McRainfallGaugingFactory()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>

        public override HySID CreateFactoryID()
        {
            return McRainfallGaugingForDevelop.McRainfallGaugingDefine.RAINFALL_GAUGING_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;

            if (csModelKind == McRainfallGaugingDefine.RAINFALL_GAUGING_KIND)
            {
                csCalModel = new McRainfallGaugingModel();
            }


            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind == McRainfallGaugingDefine.RAINFALL_GAUGING_KIND)
            {
                csCalInfoData = new McRainfallGaugingCalInfo();
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == McRainfallGaugingDefine.RAINFALL_GAUGING_KIND)
            {
                
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID , csModelKind);

                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);
                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", "入力ファイル名", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "");
                csRtnCellPrptyDt.AddInfoType("m_csSerialNum", "観測所地点数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_csSerialNum", 1);

                csRtnCellPrptyDt.AddInfoType("m_csFileType", string.Format("入力ファイルの形式({0}:CSVファイル, {1}:wisefファイル)", 
                                                                "csv", "wsf"), McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csFileType", "csv");

                csRtnCellPrptyDt.AddInfoType("m_lOutPoint", "出力地点(0:全て, 1～:出力地点指定)", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lOutPoint", 0); //0:全て/1～:出力地点


                // 第１送信パターンの設定
                McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                    McRainfallGaugingDefine.OUT_PATTERN_0D,
                    McTranInfoDefine.SINGLE_CELL_SERIAL,
                    Properties.Resources.RAINFALL /* "降雨量" */) as McTranInfoPattern;
                {
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, Properties.Resources.RAINFALL /* "降雨" */, HySDataKindDefine.SCALOR_RAIN_FALL, "mm/hr");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 第２送信パターンの設定
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                    McRainfallGaugingDefine.OUT_PATTERN_1D ,
                    McTranInfoDefine.D1_CELL_SERIAL ,
                    Properties.Resources.RAINFALL /* "降雨量" */) as McTranInfoPattern;
                {
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, Properties.Resources.RAINFALL /* "降雨量" */ , HySDataKindDefine.SCALOR_RAIN_FALL, "mm/hr");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind == McRainfallGaugingDefine.RAINFALL_GAUGING_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

            }


            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL,
                McModelLibraryDefine.MODEL_CLASSIFICATION_INPUT_CSV_FILE,    // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                McRainfallGaugingDefine.RAINFALL_GAUGING_KIND,
                McRainfallGaugingDefine.RAINFALL_GAUGING_NAME);
            csModelInfo.SetVersionInf("Ver1.1.0");
            csModelInfo.SetSummaryInf(Properties.Resources.MODEL_SUMMARY);
            csModelInfo.SetCreatorInf(Properties.Resources.MODEL_CREATOR);
            csModelInfo.SetIconName("McRainfallGauging");
            csModelInfo.SetManualFileName("McRainfallGauging.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            return m_csCalModelInforList;
        }
    }
}
