﻿// <summary>ソースコード：ＨＹＭＣＯ標準モデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptionl.HymcoStandardModel;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// [CommonMP][ver 1.5.0][2014/10/01][新規作成]
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McRemainMaxValue.McRemainedMaxValFactory();
        }
    }
}

namespace CommonMP.HYMCO.OptionImpl.McRemainMaxValue
{
    /// <summary><para>class outline:</para>
    /// <para>最大値保持モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.5.0][2014/10/01][新規作成]
    /// </para>
    /// </remarks>
    public class McRemainedMaxValFactory : McModelFactoryBase //McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HymcoStandardModelFactory csFactory = new HymcoStandardModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McRemainedMaxValFactory( )
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McRemainedMaxValDefine.HYMCO_STANDARD_MODEL_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;
            if (csModelKind.Equals(McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csCalModel = new McRemainedMaxValFileOutCtlMdl();
            }
            else
            {
            }
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;
            if (csModelKind.Equals(McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csCalInfoData = new CommonMP.HYMCO.CoreOptionl.HymcoStandardModel.McGISFileOutInfo();
            }
            else
            {
            }
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            McModelPropertyInfo csRtnPrpertyData = null;
            McCellModelPropertyInfo csRtnCellPrptyDt = null;


            if (csModelKind.Equals(McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_KIND) == true)
            {
                //２Ｄ－ＧＩＳ（メッシュ）ファイル（時系列）出力モデルならば
                //csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnPrpertyData = new McModelPropertyInfo(csLibraryID, csModelKind);

                csRtnPrpertyData.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為
                csRtnPrpertyData.AddInfoType("OUTTIME_LAG", Properties.McRainfallGaugingResources.MODEL_OUTPUT_TIME_LAG, McDefine.ValKind.DOUBLE);
                csRtnPrpertyData.SetInfo("OUTTIME_LAG", 15.0D);

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, Properties.McRainfallGaugingResources.MODEL_OVERRITE_FILE, McDefine.ValKind.LONG);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, 1); // デフォルトは上書き

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, Properties.McRainfallGaugingResources.MODEL_PROPERTY_OUTPUT_FILE, McDefine.ValKind.STRING);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ".\\OutputData\\LastValOutputFile.d2gis");

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, Properties.McRainfallGaugingResources.MODEL_OUTPUT_FOLDER, McDefine.ValKind.STRING);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "OutputData");

                csRtnPrpertyData.AddInfoType(HymcoStandardModelDefine.WRITE_FILE_NAME, Properties.McRainfallGaugingResources.MODEL_EXPORT_FILE_NAME, McDefine.ValKind.STRING);
                csRtnPrpertyData.SetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, "LastValOutputFile.d2gis");

                // 受信パターンの設定
                {
                }

            }
            else
            {
            }

            return csRtnPrpertyData;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;
            if (csModelKind.Equals(McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_KIND) == true)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
            }
            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

    
            //ＣＳＶファイル（時系列）出力モデルならば
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_GIS_FILE,
                    McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_KIND,
                    McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McRainfallGaugingResources.MODEL_SUMMARY_OUTPUT_CSV_FILE);//"時系列－ＣＳＶファイル書き出し要素"
            csModelInfo.SetCreatorInf(Properties.McRainfallGaugingResources.MODEL_CREATOR_MY_MODEL);//"CommonMP"
            csModelInfo.SetManualFileName(".\\SystemModel\\McRemainedMaxValFileOutCtlMdl.pdf");
            csModelInfo.SetLibraryDispMode(true);
            csModelInfo.SetIconName("DefaultOutput");

            m_csCalModelInforList.AddLast(csModelInfo);

            return m_csCalModelInforList;
        }

    }
}
