﻿// <summary>ソースコード：ＨＹＭＣＯ標準要素モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.FileIO;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreOptionl.HymcoStandardModel;


namespace CommonMP.HYMCO.OptionImpl.McRemainMaxValue
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳファイル出力</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.5.0][2014/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>
    /// 受信したＧＩＳ情報を、ＧＩＳメッシュ形式のファイルに出力する
    /// 出力対象はセル内の全セル情報
    /// </para>
    /// </remarks>
    public class McRemainedMaxValFileOutCtlMdl : McGISFileOutCtlMdl 
    {
        /// <summary>出力ファイル名称</summary>
        //protected HySString m_csOutFileNameWithFullPath = new HySString("..\\temp\\MaxValResult.csv");//HySEnvInf.GetHomeDirectory() + new HySString("\\temp\\Result.csv");
        /// <summary>出力ファイルインスタンス</summary>
        //protected HySFile m_csOutFile = null;
        /// <summary>出力ファイル形式（将来拡張用）</summary>
        //protected HySDefine.FileType m_csOutType = HySDefine.FileType.CSV_TYPE;

        /// <summary>出力切替SWITCH（==true:ファイル出力ON,==false:ファイル出力OFF）</summary>
        //protected bool m_bFileOutFlg = true;

        /// <summary>タイムステップ</summary>
        //protected double m_dTimeStep = 0.0D;

        /// <summary> 内部変数 </summary>
        //McGISFileOutInfo m_csOutFileInfo = null;

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csInputDataList, ref csErrorInf)</para>
        /// </example>
        /// <param name="csInputDataList">入力情報リスト</param>
        /// <param name="csErrorInf">エラー出力</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        public override bool ReceiveConnectionCheck(ref HySDataLinkedList csInputDataList, ref McStructErrorInfo csErrorInf)
        {
            return base. ReceiveConnectionCheck(ref  csInputDataList, ref  csErrorInf);
        }
        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf)
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csOutputDataList, ref csErrorInf)</para>
        /// </example>
        /// <param name="csOutputDataList">出力情報リスト</param>
        /// <param name="csErrorInf">エラー出力</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        public override bool SendConnectionCheck(ref HySDataLinkedList csOutputDataList, ref McStructErrorInfo csErrorInf)
        {
            return base.SendConnectionCheck(ref  csOutputDataList, ref  csErrorInf);
        }

        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf)
        {
            // Do Nothing.
            return true;
        } 

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Initialize(ref csInitialData, ref csInputDataList, ref csOutputDataList)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定上右方</param>
        /// <param name="csInputDataList">前段接続要素からの伝送情報リスト</param>
        /// <param name="csOutputDataList">前段接続要素への伝送情報リスト</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool Initialize(ref McPropertyInfoRoot csInitialData, ref HySDataLinkedList csInputDataList, ref HySDataLinkedList csOutputDataList)
        {
            return base.Initialize(ref  csInitialData, ref  csInputDataList, ref  csOutputDataList);
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData)
        {
            // Do Nothing
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のモデルを初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Initialize(ref csInitialData, ref csInputDataList, ref csOutputDataList)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="csInputDataList">前段接続要素からの伝送情報リスト</param>
        /// <param name="csOutputDataList">前段接続要素への伝送情報リスト</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中に 初期値情報を変更した場合にコールされる(将来拡張用)</para>
        /// </remarks>
        public override bool OnlineInitialize(ref McPropertyInfoRoot csInitialData, ref HySDataLinkedList csInputDataList, ref HySDataLinkedList csOutputDataList)
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadyCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool ReadyCalculation()
        {
            bool bRtn = true;

            if (m_csOutFileInfo.m_lOverWriteSW != 1)
            {   // 上書きではない場合
                string sCalLot = this.GetCalculationLotName().ToString();
                // 出力ファイル名称設定
                m_csOutFileNameWithFullPath = new HySString(
                    this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString() + "\\" +
                    m_csOutFileInfo.m_sOutDirPath + "\\" + sCalLot + "\\" + m_csOutFileInfo.m_sOutFileName);
            }

            // 出力ファイル設定
            m_csOutFile = new HySFile(m_csOutFileNameWithFullPath.ToString());

            // 出力ファイル初期生成
            if (m_csOutFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
            {
                if (m_csOutFileInfo.m_csFileOutGIS2DData != null)
                {
                    // ヘッダー情報を書き出しておく
                    m_csOutFileInfo.m_csFileOutGIS2DData.CSVHeaderWrite(m_csOutFile);
                }
                if (m_csOutFileInfo.m_csFileOutGIS3DData != null)
                {   // ３次元対応は将来
                    //m_csOutFileInfo.m_csFileOutGIS2DData.CSVHeaderWrite(m_csOutFile);
                }
                m_csOutFile.Close();
            }
            else
            {
                bRtn = false;
                McStructErrorInfo csErrorInfo = HySCommonInfoHash.GetCorrespondData(McDefine.CALCULATION_ERROR_INF, this.m_csElement.GetOwnerProjectID()) as McStructErrorInfo;
                if (csErrorInfo != null)
                {
                    // ver1.5 エラートレース日本語対応
                    csErrorInfo.AddCheckErrorData(this.m_csElement.GetID(), McRemainedMaxValDefine.GIS_MAX_VAL_FILE_OUT_KIND
                        , Properties.McRainfallGaugingResources.STATEMENT_NO_CREATE_GIS_FILE );
                    // csErrorInfo.AddCheckErrorData(this.m_csElement.GetID(), HymcoStandardModelDefine.GIS_MAX_VAL_FILE_OUT_KIND
                    //     , "Cannot Create GIS File.");
                }
            }

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算中断時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SuspendCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>オペレーター操作等により計算中断時に　コールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool SuspendCalculation()
        {
            // ToDo
            // オペレーター操作等により計算中断時に　コールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // メソッド自身を削除してください
            //m_lCalculate_Call_Before_DataFution_Call += 1; // Calculate Call 回数カウントアップ
            //HySDataLinkedList csOutputDataList = m_csInputData[0] as HySDataLinkedList;
            //this.DataFusion(ref csOutputDataList);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算終了時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CompleteCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool CompleteCalculation()
        {
            bool bRtn = true;
            // 計算が終わったところで、蓄積された情報を一気にファイルに書き出すことが出来たならば良い！！
            //m_lCalculate_Call_Before_DataFution_Call += 1; // Calculate Call 回数カウントアップ
            //HySDataLinkedList csOutputDataList = m_csInputData[0] as HySDataLinkedList;
            //this.DataFusion(ref csOutputDataList);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputDataList)</para>
        /// </example>
        /// <param name="csInputDataList">演算に必要な入力情報リスト</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long Calculate(ref HySDataLinkedList csInputDataList)
        {
            m_lCalculate_Call_Before_DataFution_Call += 1; // Calculate Call 回数カウントアップ
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion(ref csOutputDataList)</para>
        /// </example>
        /// <param name="csOutputDataList">演算結果を公開する出力情報リスト</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long DataFusion(ref HySDataLinkedList csOutputDataList)
        {
            long lRtn = 0;
            if (m_lCalculate_Call_Before_DataFution_Call == 0)
            {
                return lRtn;
            }

            // データ取得
            this.ReadDoubleData();


            long lDtNum = m_csOutFileInfo.m_csDataList.Count;  // 保管中の情報の数


            LinkedListNode<McOutRecordBase> csDtNode;

            McOutRecordBase csData = null;
            //McOutD2Record csD2Data = null;
            McOutD3Record csD3Data = null;

            HySTime csTm = null;

            if (lDtNum >= 1)
            {
                this.ReadyCalculation();  // ファイルを新規に作成し、　ヘッダー情報を書き込む

                if (m_csOutFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                {   // ファイルは新規に開く

                    for (int iLp = 0; iLp < lDtNum; iLp++)
                    {   // 保管中の情報分繰り返す
                        for (int ii = 0; ii < lDtNum - 1; ii++)
                        {
                            m_csOutFileInfo.m_csDataList.RemoveFirst();
                        }
                        // 保管情報を１レコードづつ取り出す
                        csDtNode = m_csOutFileInfo.m_csDataList.First;
                        csData = csDtNode.Value;
                        csTm = csData.m_csTime; // レコードの時刻
                        //if ((m_csOutFileInfo.m_csLastOutTime + m_csOutFileInfo.m_csOutTimeLag).After(csTm) == false)
                        {   // 出力すべきレコード時刻か？

                            if (m_csOutFileInfo.m_lDimNum == 2)
                            {   // ２次元データならば
                                //csD2Data = csData as McOutD2Record;
                                csD3Data = csData as McOutD3Record;
                                HySGeoDim2MeshData csOutRcd = m_csOutFileInfo.m_csFileOutGIS2DData.CreateNewRecord() as HySGeoDim2MeshData;
                                HySCellData[,] csD2Cells = csOutRcd.GetMeshData();

                                for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                                {
                                    for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                                    {
                                        // １レコード分の情報を　設定する
                                        //csD2Cells[lDt, lDt2].m_dData[0] = csD2Data.m_dD2DT[lDt, lDt2];
                                        for (int iIdx = 0; iIdx < m_csOutFileInfo.m_lCellCharaIdxNum; iIdx++)
                                        {
                                            csD2Cells[lDt, lDt2].m_dData[iIdx] = csD3Data.m_dD3DT[lDt, lDt2, iIdx];
                                        }
                                    }
                                }
                                //csOutRcd.SetTime(csD2Data.m_csTime);
                                csOutRcd.SetTime(csD3Data.m_csTime);
                                // 書き出しデータに　書き出すレコードを追加する
                                //m_csOutFileInfo.m_csFileOutGIS2DData.AddData(csOutRcd);

                                // CSVに追加書き込みする
                                m_csOutFileInfo.m_csFileOutGIS2DData.CSVDataAppend(m_csOutFile, csOutRcd);

                            }
                            else if (m_csOutFileInfo.m_lDimNum == 3)
                            {   // ３次元データならば
                                /* ３次元は将来用  */
                            }

                            m_csOutFileInfo.m_csLastOutTime.SetTime(csTm);
                            // 最終保管レコードの時刻を設定
                        }

                        // 読み出した情報は一時保管情報から削除する
                        m_csOutFileInfo.m_csDataList.RemoveFirst();
                    }   // end of for(保管中の情報分繰り返す)

                    m_csOutFile.Close();
                }   // end of FileOpen
                else
                {
                    // Do Nothing
                }
            }
            
            m_lCalculate_Call_Before_DataFution_Call = 0;
            
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataFusion( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion()
        {
            // Do Nothing
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>入力された伝送データのdouble型データを取得し一時保管しておく</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ReadData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long ReadDoubleData()
        {
            McTimeSeriesGeoD2MeshTranInfo csCellD2Trn = null;
            McTimeSeriesGeoD3MeshTranInfo csCellD3Trn = null;

            csCellD2Trn = m_csInputData[0] as McTimeSeriesGeoD2MeshTranInfo;
            csCellD3Trn = m_csInputData[0] as McTimeSeriesGeoD3MeshTranInfo;

            // 入力された伝送情報を読み出す
            if (csCellD2Trn != null)
            {   // ２次元の場合

                //if (m_csOutFileInfo.m_csFileOutGIS2DData == null)
                //{
                //    m_csOutFileInfo.m_csFileOutGIS2DData = new HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, 1);
                //}
                //if (m_csOutFileInfo.m_csCellCharactor == null)
                //{
                //    m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(1);
                //    HySDataCharacteristicInCell csCellCharactor = csCellD2Trn.GetCellDataCharacteristic();
                //    m_csOutFileInfo.m_csCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[m_csOutFileInfo.m_lOutDataIdx].Clone();
                //    m_csOutFileInfo.m_csCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csFileOutGIS2DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);
                //}

                McGeoDim2MeshTranInfo csDtD2Rcd = null;
                HySCellData[,] csD2Cells = null;
                //McOutD2Record csRcd = null;  // １レコード分のデータ
                McOutD3Record csRcd = null;  // １レコード分のデータ
                //McReceiveCellDataIF csInputCellData = m_InputCellData[0];

                long lDtNum = csCellD2Trn.SetCursorPlus(m_csOutFileInfo.m_csLastINTime);// 最終時刻以後に情報が追加されているか？

                for (long lDtLp = 0; lDtLp < lDtNum; lDtLp++)
                {   // 追加された情報分処理を行う

                    if (lDtLp < lDtNum - 1)
                    {
                        csCellD2Trn.MoveCursorNext();  // 途中のデータは読み飛ばす
                        continue;
                    }
                    csDtD2Rcd = (McGeoDim2MeshTranInfo)csCellD2Trn.GetCursorData();
                    csD2Cells = csDtD2Rcd.GetMeshData();
                    //csRcd = new McOutD2Record(m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat);  // １レコード情報格納クラスの生成
                    csRcd = new McOutD3Record(m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lCellCharaIdxNum);  // １レコード情報格納クラスの生成
                    for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                    {
                        for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                        {
                            // １レコード分の情報を　設定する
                            //csRcd.m_dD2DT[lDt, lDt2] = csInputCellData.Data(csD2Cells[lDt, lDt2], m_csOutFileInfo.m_lOutDataIdx);
                            for (int iLp = 0; iLp < m_csOutFileInfo.m_lCellCharaIdxNum; iLp++)
                            {
                                csRcd.m_dD3DT[lDt, lDt2, iLp] = csD2Cells[lDt, lDt2].m_dData[iLp];
                            }

                        }
                    }
                    csRcd.m_csTime = csDtD2Rcd.GetLastTime();

                    // 読み出した情報を一時保管しておく
                    m_csOutFileInfo.m_csDataList.Clear();  // <-- 保管されている情報は消す
                    m_csOutFileInfo.m_csDataList.AddLast(csRcd);  //<--- 最後の情報のみ入れる
                    m_csOutFileInfo.m_csLastINTime.SetTime(csRcd.m_csTime);

                    csCellD2Trn.MoveCursorNext();
                }
            }
            else if (csCellD3Trn != null)
            {   // ３次元の場合
                
                //if (m_csOutFileInfo.m_csFileOutGIS3DData == null)
                //{
                //    m_csOutFileInfo.m_csFileOutGIS3DData = new HySGeoDim3MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lDtDimAlt, 1);
                //}
                //if (m_csOutFileInfo.m_csCellCharactor == null)
                //{
                //    m_csOutFileInfo.m_csCellCharactor = new HySDataCharacteristicInCell(1);
                //    HySDataCharacteristicInCell csCellCharactor = csCellD3Trn.GetCellDataCharacteristic();
                //    m_csOutFileInfo.m_csCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[m_csOutFileInfo.m_lOutDataIdx].Clone();
                //    m_csOutFileInfo.m_csCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[m_csOutFileInfo.m_lOutDataIdx];
                //    m_csOutFileInfo.m_csFileOutGIS3DData.SetCellDataCharacteristic(m_csOutFileInfo.m_csCellCharactor);
                //}

                McGeoDim3MeshTranInfo csDtD3Rcd = null;
                HySCellData[,,] csD3Cells = null;
                McOutD3Record csRcd = null;  // １レコード分のデータ
                //McReceiveCellDataIF csInputCellData = m_InputCellData[0];

                long lDtNum = csCellD3Trn.SetCursorPlus(m_csOutFileInfo.m_csLastINTime);// 最終時刻以後に情報が追加されているか？

                for (long lDtLp = 0; lDtLp < lDtNum; lDtLp++)
                {   // 追加された情報分処理を行う

                    csDtD3Rcd = (McGeoDim3MeshTranInfo)csCellD3Trn.GetCursorData();
                    csD3Cells = csDtD3Rcd.GetMeshData();
                    csRcd = new McOutD3Record(m_csOutFileInfo.m_lDtDimLon, m_csOutFileInfo.m_lDtDimLat, m_csOutFileInfo.m_lDtDimAlt);  // １レコード情報格納クラスの生成
                    for (long lDt = 0; lDt < m_csOutFileInfo.m_lDtDimLon; lDt++)
                    {
                        for (long lDt2 = 0; lDt2 < m_csOutFileInfo.m_lDtDimLat; lDt2++)
                        {
                            for (long lDt3 = 0; lDt3 < m_csOutFileInfo.m_lDtDimAlt; lDt3++)
                            {
                                // １レコード分の情報を　設定する
                                //csRcd.m_dD3DT[lDt, lDt2, lDt3] = csInputCellData.Data(csD3Cells[lDt, lDt2, lDt3], m_csOutFileInfo.m_lOutDataIdx);
                                csRcd.m_dD3DT[lDt, lDt2, lDt3] = csD3Cells[lDt, lDt2, lDt3].m_dData[m_csOutFileInfo.m_lOutDataIdx];
                            }
                        }
                    }
                    csRcd.m_csTime = csDtD3Rcd.GetLastTime();

                    // 読み出した情報を一時保管しておく
                    m_csOutFileInfo.m_csDataList.AddLast(csRcd);
                    m_csOutFileInfo.m_csLastINTime.SetTime(csRcd.m_csTime);

                    csCellD3Trn.MoveCursorNext();
                }
            }
            else
            {
            }

            return 0;
        }

        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McPropertyInfoRoot csPropertyInfo)
        {
            return base.SetProperty(csPropertyInfo);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算状態復元のためのデータクラスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCmnElementOutData csElementOutData = CreateOutData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCmnElementOutData データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCmnElementOutData CreateOutData()
        {
            return new McFileCtlOutData();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルにモデル内情報を全て書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileOUT(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileOUT(HySDataRoot csData)
        {
            if (csData == null || csData as McFileCtlOutData == null)
            {// データ型不一致
                return false;
            }

            ((McFileCtlOutData)(csData)).SetFileOutData(m_csCalInfo);
            ((McFileCtlOutData)(csData)).SetFileName(m_csOutFileNameWithFullPath);
            ((McFileCtlOutData)(csData)).SetOutFile(m_csOutFile);
            ((McFileCtlOutData)(csData)).SetFileOutFlg(m_bFileOutFlg);
            ((McFileCtlOutData)(csData)).SetTimeStep(m_dTimeStep);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルからモデル情報を全て読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileIN(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileIN(HySDataRoot csData)
        {
            if (csData == null || csData as McFileCtlOutData == null)
            {// データ型不一致
                return false;
            }

            // 演算状態の復元
            McCalInfo csCalInfo = ((McFileCtlOutData)(csData)).GetFileOutData();
            if (m_csCalInfo != null)
            {
                m_csCalInfo.CopyInfo(csCalInfo);
            }
            m_csOutFileNameWithFullPath = ((McFileCtlOutData)(csData)).GetFileName();
            m_csOutFile = ((McFileCtlOutData)(csData)).GetOutFile();
            m_bFileOutFlg = ((McFileCtlOutData)(csData)).GetFileOutFlg();
            m_dTimeStep = ((McFileCtlOutData)(csData)).GetTimeStep();

            // 復元後の整合性確保
            if (m_csCalInfo != null)
            {
                if (m_csCalInfo is HySVersionManagement)
                {
                    ((HySVersionManagement)m_csCalInfo).PostDeserialize();
                }
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションデータコンテナの内容を設定する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimDataContainerInfo( csDataContainer )</para>
        /// </example>
        /// <param name="csDataContainer">シミュレーションデータコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetSimDataContainer(HySSimulationDataContainer csDataContainer)
        {
            // 何もしない
        }

    }
}
