﻿// <summary>ソースコード：入力値加算モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McSumForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>入力値加算モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McSumDefine
    {

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID Sum_Factory_ID = new HySID("Sum_Factory");


        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>入力値加算モデル種別</summary>
        public static readonly HySObjectKind Sum_KIND = new HySObjectKind("Sum_Model");
        /// <summary>入力値加算モデル名称</summary>
        public static readonly HySString Sum_NAME = new HySString(Properties.McSumResources.MODEL_SUM_NAME);

        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // 入力値加算モデル用
        // ===============================
        /// <summary>受信：ポイント時系列 </summary>
        public static readonly HySID RECEIVE_PATTERN_D0 = new HySID("ReceiveD0");
        /// <summary>受信：1次元時系列 </summary>
        public static readonly HySID RECEIVE_PATTERN_D1 = new HySID("ReceiveD1");
        /// <summary>受信：2次元時系列 </summary>
        public static readonly HySID RECEIVE_PATTERN_D2 = new HySID("ReceiveD2");
        /// <summary>受信：3次元時系列 </summary>
        public static readonly HySID RECEIVE_PATTERN_D3 = new HySID("ReceiveD3");

        /// <summary>送信：ポイント時系列</summary>
        public static readonly HySID SEND_OUT_PATTERN_D0 = new HySID("SendD0");
        /// <summary>送信：1次元時系列</summary>
        public static readonly HySID SEND_OUT_PATTERN_D1 = new HySID("SendD1");
        /// <summary>送信：2次元時系列</summary>
        public static readonly HySID SEND_OUT_PATTERN_D2 = new HySID("SendD2");
        /// <summary>送信：3次元時系列</summary>
        public static readonly HySID SEND_OUT_PATTERN_D3 = new HySID("SendD3");

    }
}
