﻿// <summary>ソースコード：入力値加算モデル演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.OptionImpl.McSumForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>入力値加算モデル演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McSumCalInfo : McCalInfo
    {
        /// <summary> ポイント変数</summary>
        public double csD0CellData = 0.0;
        /// <summary> １次元配列変数</summary>
        public double[] csD1CellData = null;
        /// <summary> ２次元配列変数</summary>
        public double[,] csD2CellData = null;
        /// <summary> ３次元配列変数</summary>
        public double[,,] csD3CellData = null;

        /// <summary>伝送データ種別 </summary>
        public HySObjectKind m_csCellType = null;
        /// <summary>配列数Dim1の最大値 </summary>
        public long m_lDim1Max = 0;
        /// <summary>配列数Dim2の最大値 </summary>
        public long m_lDim2Max = 0;
        /// <summary>配列数Dim3の最大値 </summary>
        public long m_lDim3Max = 0;


        /// <summary>データの次元数</summary>
        public long m_lDimNum = 0;
        /// <summary>配列数：Ｄｉｍ１ </summary>
        public long m_lDim1 = 0;
        /// <summary>配列数：Ｄｉｍ２ </summary>
        public long m_lDim2 = 0;
        /// <summary>配列数：Ｄｉｍ３ </summary>
        public long m_lDim3 = 0;

        /// <summary> データを出力した演算時刻 </summary>
        public HySTime m_csLastDataOutTime = null;

        /// <summary> データを出力した演算時刻 </summary>
        public double m_dDltTime = 0;



        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McSumCalInfo csRtn = new McSumCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McSumCalInfo csOrdDt = (McSumCalInfo)csOrgInfo;

            
            
            return true;
        }

    }
}
