﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McTestBasin
{
    /// <summary><para>class outline:</para>
    /// <para>モデル定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.2][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McTestBasinDefine
    {

        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("McTestBasin_Factory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        // ToDo 提供するモデルの種別と名称を定義して下さい。
        /// <summary>擬似流量発生モデル</summary>
        public static readonly HySObjectKind BASIN = new HySObjectKind("Basin");
        /// <summary>テスト用モデル名称</summary> 
        public static readonly HySString MODEL_NAME = new HySString(Properties.Resources.MODEL_NAME);

        /// <summary>下流端出力１</summary>
        public static readonly HySID OUT_PATTERN_BOTTOM01 = new HySID("BottomOut01");

        /// <summary>下流端出力２</summary>
        public static readonly HySID OUT_PATTERN_BOTTOM02 = new HySID("BottomOut02");
    }
}
