﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McTestBasin.McTestBasinFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McTestBasin
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McTestBasinFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return McTestBasinDefine.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind == McTestBasinDefine.BASIN)
            {
                csCalModel = new McTestBasinModel();
            }
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }
        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind == McTestBasinDefine.BASIN)
            {
                csCalInfoData = new McTestBasinCallInfo();
            }  
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == McTestBasinDefine.BASIN)
            {   // テスト用流量発生クラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(72); // δT設定 秒

                csRtnCellPrptyDt.AddInfoType("m_dQb", "基底流量Qb", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQb", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQp", "ピーク流量Qp", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQp", 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dCp", "波形パラメータc", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCp", 10.0);
                csRtnCellPrptyDt.AddInfoType("m_dTp", "ピーク流量発生時の経過時間（hr）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dTp", 3.0);

                 // 送信パターンの設定
                {
                    // 第１パターン
                    
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McTestBasinDefine.OUT_PATTERN_BOTTOM01,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.Resources.BOTTOM_OUT_0D /*"下流端流出"*/) as McTranInfoPattern;
                    
                    //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McTestBasinDefine.OUT_PATTERN_BOTTOM02,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.Resources.BOTTOM_OUT_1D /* "流出量" */) as McTranInfoPattern;
                    // セル内変数設定
                    csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }    
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind == McTestBasinDefine.BASIN)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_HYDROLOGICAL_MODELS"), // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    McTestBasinDefine.BASIN, // モデルの識別子
                    McTestBasinDefine.MODEL_NAME  // モデルの名称
            );
            csModelInfo.SetVersionInf("Ver1.0.1");
            csModelInfo.SetSummaryInf(Properties.Resources.MODEL_SUMMARY);
            csModelInfo.SetCreatorInf(Properties.Resources.MODEL_CREATOR);
            csModelInfo.SetIconName("McTestBasin");
            csModelInfo.SetManualFileName(Properties.Resources.MODEL_MANUAL);

            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            return m_csCalModelInforList;
        }

    }
}
