﻿// <summary>ソースコード：河口潮位入力モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYMCO.OptionImpl.McTidalLevelGaugingForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>河口潮位入力モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/13][新規作成]</para>
    /// </remarks>
    public class McTidalLevelGaugingDefine
    {

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID TIDAL_LEVEL_LIB = new HySID("TidalLevelGauging_Factory");


        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>テスト用流域モデル種別</summary>
        public static readonly HySObjectKind TIDAL_LEVEL_KIND = new HySObjectKind("TidalLevelGauging_Model");
        /// <summary>テスト用流域モデル名称</summary>
        public static readonly HySString TIDAL_LEVEL_NAME = new HySString(Properties.Resources.MODEL_NAME /*"潮位入力モデル"*/);


        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // McTidalLevelGauging用
        // ===============================
        /// <summary>送信パターン１ 水位出力</summary>
        public static readonly HySID OUT_PATTERN_0D = new HySID("WATER_LEVEL_0D");
        /// <summary>送信パターン２ 水位出力</summary>
        public static readonly HySID OUT_PATTERN_1D = new HySID("WATER_LEVEL");


        /// <summary>入力ファイルの形式プロパティ：CSV</summary>
        public static readonly string INPUTFILE_TYPE_CSV = "csv";
        /// <summary>入力ファイルの形式プロパティ：Wisef</summary>
        public static readonly string INPUTFILE_TYPE_WSF = "wsf";

    }
}
