﻿// <summary>ソースコード：観測水位入力モデル要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;



namespace CommonMP.HYMCO.OptionImpl.McWaterLevelGaugingForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>観測水位入力モデル要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/12][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McWaterLevelGaugingCalInfo : McCalInfo
    {
        

        /// <summary> 出力数 </summary>
        public long m_lOutPutPortNum = 0;
        /// <summary> データを出力した演算時刻 </summary>
        public HySTime m_csLastDataOutTime = null;

        /// <summary> 入力ファイル名称 </summary>
        public string m_csReadFileNameWithPath = null;

        /// <summary> 読み出したデータ保管場所 </summary>
        public HySCSVFileData m_csReadCSVData = null;

        /// <summary> ファイルタイプ </summary>
        public String m_csFileType = null;

        /// <summary> 観測所時点数 </summary>
        public long m_csSeriesNum = 1;

        /// <summary> 出力地点（0:全て/1～:出力地点） </summary>
        public long m_lOutPoint = 0;

        /// <summary> ポイント時系列の送信パターン数 </summary>
        public long m_lOUT_0D = 0;
        /// <summary> ポイント時系列の送信パターンインデックス </summary>
        public long[] m_lOUT_0D_IDX = null;

        /// <summary> 1次元時系列の送信パターン数 </summary>
        public long m_lOUT_1D = 0;
        /// <summary> 1次元時系列の送信パターンインデックス </summary>
        public long[] m_lOUT_1D_IDX = null;

        /// <summary> シミュレーション開始時刻 </summary>
        public HySTime m_csSimStartTime = null;

        /// <summary> データを出力したインデックス </summary>
        public int m_iLastDataOutIndex = 0;


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McWaterLevelGaugingCalInfo csRtn = new McWaterLevelGaugingCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McWaterLevelGaugingCalInfo csOrgDt = (McWaterLevelGaugingCalInfo)csOrgInfo;

            this.m_lOutPutPortNum = csOrgDt.m_lOutPutPortNum;
            this.m_csLastDataOutTime = csOrgDt.m_csLastDataOutTime.Clone();
            this.m_csReadFileNameWithPath = csOrgDt.m_csReadFileNameWithPath;
            if (csOrgDt.m_csReadCSVData != null)
            {
                this.m_csReadCSVData = (HySCSVFileData)HySDataDuplicate.DupliCateData(csOrgDt.m_csReadCSVData);
            }

            
            return true;
        }

    }
}
