﻿// <summary>ソースコード：観測水位入力モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;


namespace CommonMP.HYMCO.OptionImpl.McWaterLevelGaugingForDevelop   
{
    /// <summary><para>class outline:</para>
    /// <para>観測水位入力モデルクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/12][新規作成]</para>
    /// </remarks>
    public class McWaterLevelGaugingModel : McBasicFileInCtl
    {
        /// <summary> 演算データ（キャスト用） </summary>
        McWaterLevelGaugingCalInfo m_csOWaterLevelInf = null;   // 便利の為、キャスト用に定義しておく
        /// <summary> wisef読み込みクラス </summary>
        CommonControlLibrary.ReadWisefFile m_csReadWise = null;

        //=========================
        // 演算実行前処理関連メソッド
        //=========================

        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;
            if (lOutputDataNum == 0)
            {
                // エラー
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND,
                     Properties.Resources.STATEMENT_NO_SND_PORT );
               // csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND, "No send port.");
                bRtn = false;
                return bRtn;
            }

            
            for (long lP = 0; lP < lOutputDataNum; lP++)
            {   // 出力側接続線数分チェックを行う

                long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);

                //  ポイント次元情報の処理 
                if (McWaterLevelGaugingDefine.OUT_PATTERN_0D.Equals(csOutputCellData[lP].GetSendPatternID()))
                {
                    m_csOWaterLevelInf.m_lOUT_0D++;
                }
                //  １次元次元情報の処理 
                else if (McWaterLevelGaugingDefine.OUT_PATTERN_1D.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {
                    m_csOWaterLevelInf.m_lOUT_1D += 1;

                    if ((m_csOWaterLevelInf.m_lOutPoint == 0 && lD1 < m_csOWaterLevelInf.m_csSeriesNum) ||
                        (m_csOWaterLevelInf.m_lOutPoint > 0 && lD1 < 1))
                    {
                        // エラー
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND ,
                              Properties.Resources.STATEMENT_OBSERVAT_LARGE_SEND_CELL );
                       // csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND
                       //     , " Observation points is larger than number of variables in the send cell.");

                        bRtn = false;
                        return bRtn;

                    }

                }
                else
                {
                    // エラー
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND, 
                          Properties.Resources.STATEMENT_UNEXPECT_SND_DATA_TYPE );
                   // csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND, "Unexpected send data type.");
                    bRtn = false;
                    return bRtn;
                }
            }

            m_csOWaterLevelInf.m_lOUT_0D_IDX = new long[m_csOWaterLevelInf.m_lOUT_0D];
            m_csOWaterLevelInf.m_lOUT_0D = 0;
            m_csOWaterLevelInf.m_lOUT_1D_IDX = new long[m_csOWaterLevelInf.m_lOUT_1D];
            m_csOWaterLevelInf.m_lOUT_1D = 0;

            for (long lP = 0; lP < lOutputDataNum; lP++)
            {   // 出力側接続線数分チェックを行う
                if (McWaterLevelGaugingDefine.OUT_PATTERN_0D.Equals(csOutputCellData[lP].GetSendPatternID()))
                {
                    m_csOWaterLevelInf.m_lOUT_0D_IDX[m_csOWaterLevelInf.m_lOUT_0D] = lP;
                    m_csOWaterLevelInf.m_lOUT_0D++;
                }
                else if (McWaterLevelGaugingDefine.OUT_PATTERN_1D.Equals(csOutputCellData[lP].GetSendPatternID()))
                {
                    m_csOWaterLevelInf.m_lOUT_1D_IDX[m_csOWaterLevelInf.m_lOUT_1D] = lP;
                    m_csOWaterLevelInf.m_lOUT_1D++;
                }
                else
                {
                    // エラー
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND,
                          Properties.Resources.STATEMENT_UNEXPECT_SND_DATA_TYPE );
                   // csErrorInf.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND, "Unexpected send data type.");
                    bRtn = false;
                    return bRtn;
                }
            }

            
            return bRtn;
        }


        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool    bRtn = false;
            string  DispStatement = "";

            try
            {
                m_csOWaterLevelInf.m_csSimStartTime = this.m_csSimTime.Clone();
                
                //ファイル存在チェック
                if (!System.IO.File.Exists(m_csOWaterLevelInf.m_csReadFileNameWithPath))
                {
                    // ver1.5 エラートレース日本語対応
                    DispStatement = Properties.Resources.STATEMENT_FAILED_OPEN + " (" + m_csOWaterLevelInf.m_csReadFileNameWithPath + ")";
                    McLog.DebugOut(this.m_csSimTime, m_csElement.GetID(), "McWaterLevelGaugingModel", "Initialize", DispStatement);

                    return false;
                }

                //ファイルのタイプを判断し、ファイルを読み込む
                if (m_csOWaterLevelInf.m_csFileType == McWaterLevelGaugingDefine.INPUTFILE_TYPE_CSV)
                {

                    m_csOWaterLevelInf.m_csLastDataOutTime = HySTime.DEFAULT_TIME.Clone();
                    
                    // CSV入力データの格納用クラス
                    m_csOWaterLevelInf.m_csReadCSVData = new HySCSVFileData(HySCSVFileData.DATA_KIND.TIME_SERIES_DATA, m_csOWaterLevelInf.m_csSeriesNum);
                    m_csOWaterLevelInf.m_csReadCSVData.SetFileName(m_csOWaterLevelInf.m_csReadFileNameWithPath);
                    if (0 == m_csOWaterLevelInf.m_csReadCSVData.ReadCSVFile())
                    {
                        bRtn = true;
                        long lSeriesNum = m_csOWaterLevelInf.m_csReadCSVData.GetSeriesNum();
                        if (m_csOWaterLevelInf.m_csSeriesNum > lSeriesNum)
                        {   //プロパティで指定された観測所地点数がCSVの観測所数よりも多い
                            bRtn = false;

                            // ver1.5 エラートレース日本語対応
                            DispStatement = Properties.Resources.STATEMENT_INCORRECT;
                            McLog.DebugOut(this.m_csSimTime, m_csElement.GetID(), "McWaterLevelGaugingModel", "Initialize", DispStatement);
                        }
                    }
                    else
                    {
                        m_csOWaterLevelInf.m_csReadCSVData = null;

                        // ver1.5 エラートレース日本語対応
                        DispStatement = Properties.Resources.STATEMENT_FAILED_READ + " (" + m_csOWaterLevelInf.m_csReadFileNameWithPath + ")";
                        McLog.DebugOut(this.m_csSimTime, m_csElement.GetID(), "McWaterLevelGaugingModel", "Initialize", DispStatement);
                    }
                }
                else if (m_csOWaterLevelInf.m_csFileType == McWaterLevelGaugingDefine.INPUTFILE_TYPE_WSF)
                {

                    m_csOWaterLevelInf.m_iLastDataOutIndex = 0;


                    //wisefクラスのインスタンス作成
                    m_csReadWise = new CommonControlLibrary.ReadWisefFile("H", "HU", "HH", "HHA");  //水位
                    //wisef読み込み
                    bRtn = m_csReadWise.ReadWisefMain(m_csOWaterLevelInf.m_csReadFileNameWithPath, m_csOWaterLevelInf.m_csSeriesNum);
                    if (!bRtn)
                    {
                        McLog.DebugOut(this.m_csSimTime, m_csElement.GetID(),
                                "McWaterLevelGaugingModel", "Initialize::ReadWisefMain", m_csReadWise.ErrorMessage);
                    }

                }
            }
            catch
            {
                bRtn = false;

                // ver1.5 エラートレース日本語対応
                DispStatement = Properties.Resources.STATEMENT_FAILED_READ + " (" + m_csOWaterLevelInf.m_csReadFileNameWithPath + ")";
                McLog.DebugOut(this.m_csSimTime, m_csElement.GetID(), "McWaterLevelGaugingModel", "Initialize", DispStatement);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>OnlineInitialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>bool</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool OnlineInitialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            // Do Nothing
            return true;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            long lRtn = 0;
            bool bLclRtn = false;
            HySTime csCursTm = new HySTime(0);
            HySCellData[] csCellData0D = null;
            HySCellData[] csCellData1D = null;


            //ファイルのタイプを判断し、データを転送する
            if (m_csOWaterLevelInf.m_csFileType == McWaterLevelGaugingDefine.INPUTFILE_TYPE_CSV)
            {
                long lNotSendDataNum = 0;
                double[] dData = new double[m_csOWaterLevelInf.m_csSeriesNum];

                if (m_csOWaterLevelInf.m_csLastDataOutTime.Equals(HySTime.DEFAULT_TIME))
                {
                    //最後に送信した時刻が未設定の場合
                    lNotSendDataNum = m_csOWaterLevelInf.m_csReadCSVData.SetCursor(m_csOWaterLevelInf.m_csSimStartTime); // カーソル位置を　シミュレーション開始時刻に合わせる
                }
                else
                {
                    lNotSendDataNum = m_csOWaterLevelInf.m_csReadCSVData.SetCursor(m_csOWaterLevelInf.m_csLastDataOutTime); // カーソル位置を　最後に送信した時刻に合わせる
                }
                for (long lCnt = 0; lCnt < lNotSendDataNum; lCnt++)
                {// 送信していない分データを繰り返す
                    bLclRtn = m_csOWaterLevelInf.m_csReadCSVData.GetCursorTimeSeriesData(ref csCursTm, ref dData, m_csOWaterLevelInf.m_csSeriesNum);
                    if (bLclRtn == true)
                    {
                        if (csCursTm.After(this.m_csTgtTime) == true)
                        {   //取得時刻が　目標時刻より後なら読み込み終了
                            break;
                        }
                        else if (csCursTm.After(this.m_csOWaterLevelInf.m_csLastDataOutTime) == true)
                        {   // 取得時刻が　最後に送信した時刻よりも　新しければ

                            this.m_csOWaterLevelInf.m_csLastDataOutTime.SetTime(csCursTm); // 送信した時刻を設定する

                            // ポイント時系列の処理
                            for (long lP = 0; lP < m_csOWaterLevelInf.m_lOUT_0D; lP++)
                            {
                                csOutputCellData[m_csOWaterLevelInf.m_lOUT_0D_IDX[lP]].SetCurrentTime(csCursTm);// 送信用のレコードを設定する（時刻設定）

                                csCellData0D = csOutputCellData[m_csOWaterLevelInf.m_lOUT_0D_IDX[lP]].PrepareSendCellD1(); // 送信用情報格納セルの準備
                                if (m_csOWaterLevelInf.m_lOutPoint == 0)
                                {
                                    csCellData0D[0].m_dData[0] = dData[0]; // データを設定
                                }
                                else
                                {
                                    //出力地点指定時は、指定地点のみ設定
                                    csCellData0D[0].m_dData[0] = dData[m_csOWaterLevelInf.m_lOutPoint - 1]; // データを設定

                                }
                                m_OutputCellData[lP].SendData();    //設定データの送信

                            }

                            // １次元時系列の処理                            
                            for (long lP = 0; lP < m_csOWaterLevelInf.m_lOUT_1D; lP++)
                            {
                                //  伝送データの種別に応じての処理 
                                long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                                long lCellDim = csOutputCellData[m_csOWaterLevelInf.m_lOUT_1D_IDX[lP]].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);

                                csOutputCellData[m_csOWaterLevelInf.m_lOUT_1D_IDX[lP]].SetCurrentTime(csCursTm);// 送信用のレコードを設定する（時刻設定）

                                csCellData1D = csOutputCellData[m_csOWaterLevelInf.m_lOUT_1D_IDX[lP]].PrepareSendCellD1(); // 送信用情報格納セルの準備
                                for (long lall = 0; lall < Math.Min(m_csOWaterLevelInf.m_csSeriesNum, lD1); lall++)
                                {
                                    if (m_csOWaterLevelInf.m_lOutPoint == 0)
                                    {
                                        csCellData1D[lall].m_dData[0] = dData[lall]; // データを設定
                                    }
                                    else
                                    {
                                        //出力地点指定時は、指定地点のみ設定
                                        csCellData1D[lall].m_dData[0] = dData[m_csOWaterLevelInf.m_lOutPoint - 1]; // データを設定
                                        break;
                                    }
                                }
                                m_OutputCellData[lP].SendData();    //設定データの送信

                            }
                            

                        }
                        m_csOWaterLevelInf.m_csReadCSVData.MoveCursorNext();    // カーソル位置をひとつ進める
                    }
                }

            }
            else if (m_csOWaterLevelInf.m_csFileType == McWaterLevelGaugingDefine.INPUTFILE_TYPE_WSF)
            {

                for (int lCnt = m_csOWaterLevelInf.m_iLastDataOutIndex; lCnt < m_csReadWise.WisefData.Count; lCnt++)
                {
                    m_csOWaterLevelInf.m_iLastDataOutIndex = lCnt;

                    csCursTm = HySCalendar.CreateTime(m_csReadWise.WisefData.Keys[lCnt]);
                    if (csCursTm.After(this.m_csTgtTime) == true)
                    {   //取得時刻が　目標時刻より後なら読み込み終了
                        break;
                    }
                    else if (m_csOWaterLevelInf.m_csSimStartTime.After(csCursTm) == true)
                    {   //取得時刻が　開始時刻より前ならば読み飛ばし（開始時刻が　取得時刻より後ならば読み飛ばし）
                        continue;
                    }

                    // ポイント次元時系列の処理
                    for (long lP = 0; lP < m_csOWaterLevelInf.m_lOUT_0D; lP++)
                    {
                        //  伝送データの種別に応じての処理
                        csOutputCellData[m_csOWaterLevelInf.m_lOUT_0D_IDX[lP]].SetCurrentTime(csCursTm);// 送信用のレコードを設定する（時刻設定）

                        csCellData0D = csOutputCellData[m_csOWaterLevelInf.m_lOUT_0D_IDX[lP]].PrepareSendCellD1(); // 送信用情報格納セルの準備
                        if (m_csOWaterLevelInf.m_lOutPoint == 0)
                        {
                            csCellData0D[0].m_dData[0] = m_csReadWise.WisefData.Values[lCnt][0, 0]; // データを設定
                        }
                        else
                        {
                            //出力地点指定時は、指定地点のみ設定
                            csCellData0D[0].m_dData[0] = m_csReadWise.WisefData.Values[lCnt][m_csOWaterLevelInf.m_lOutPoint - 1, 0]; // データを設定
                        }

                        m_OutputCellData[lP].SendData();    //設定データの送信
                    }

                    // １次元時系列の処理
                    for (long lP = 0; lP < m_csOWaterLevelInf.m_lOUT_1D; lP++)
                    {
                        //  伝送データの種別に応じての処理
                        long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                        long lCellDim = csOutputCellData[m_csOWaterLevelInf.m_lOUT_1D_IDX[lP]].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);

                        csOutputCellData[m_csOWaterLevelInf.m_lOUT_1D_IDX[lP]].SetCurrentTime(csCursTm);// 送信用のレコードを設定する（時刻設定）

                        csCellData1D = csOutputCellData[m_csOWaterLevelInf.m_lOUT_1D_IDX[lP]].PrepareSendCellD1(); // 送信用情報格納セルの準備
                        for (long lall = 0; lall < Math.Min(m_csOWaterLevelInf.m_csSeriesNum, lD1); lall++)
                        {
                            if (m_csOWaterLevelInf.m_lOutPoint == 0)
                            {
                                csCellData1D[lall].m_dData[0] = m_csReadWise.WisefData.Values[lCnt][lall, 0]; // データを設定
                            }
                            else
                            {
                                //出力地点指定時は、指定地点のみ設定
                                csCellData1D[lall].m_dData[0] = m_csReadWise.WisefData.Values[lCnt][m_csOWaterLevelInf.m_lOutPoint - 1, 0]; // データを設定
                                break;
                            }
                        }

                        m_OutputCellData[lP].SendData();    //設定データの送信
                    }
                }

            }
            return lRtn;
        }


        //====================
        // その他必要なメソッド
        //====================

        // Ver1.5 追加（ファイルの有無チェック）引数追加
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetProperty(csCellMdlPropertyInfo, ref csErrorInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <param name="csErrorInfo">エラー情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo, ref McStructErrorInfo csErrorInfo)
        {
            bool bRtn = false;

            // 使用しやすいようにキャストしておく
            m_csOWaterLevelInf = (McWaterLevelGaugingCalInfo)m_csCalInfo;

            McModelPropertyInfo csPropInf = csCellMdlPropertyInfo as McModelPropertyInfo;
            if (csPropInf != null)
            {
                csPropInf.GetInfo("m_csInFileNameWithPath", ref this.m_csOWaterLevelInf.m_csReadFileNameWithPath);
                csPropInf.GetInfo("m_csFileType", ref this.m_csOWaterLevelInf.m_csFileType);
                csPropInf.GetInfo("m_csSerialNum", ref this.m_csOWaterLevelInf.m_csSeriesNum);
                csPropInf.GetInfo("m_lOutPoint", ref this.m_csOWaterLevelInf.m_lOutPoint);

                // m_csInFileNameWithPathがカラだったら
                if (m_csOWaterLevelInf.m_csReadFileNameWithPath == "")
                {
                    m_csOWaterLevelInf.m_csReadFileNameWithPath = this.GetProjectGroupDirectory().ToString() + "\\InputData\\FileIn.csv";
                }
                // m_csInFileNameWithPathに絶対パスまたはプロジェクト・ディレクトリの外のパスが含まれていたら
                else if (m_csOWaterLevelInf.m_csReadFileNameWithPath.IndexOf(":") >= 0 || m_csOWaterLevelInf.m_csReadFileNameWithPath.IndexOf("..") >= 0)
                {
                    // Do nothing.
                }
                // m_csInFileNameWithPathがプロジェクト・ディレクトリ以下のパスならば
                else
                {
                    m_csOWaterLevelInf.m_csReadFileNameWithPath = this.GetProjectGroupDirectory().ToString() + "\\" + m_csOWaterLevelInf.m_csReadFileNameWithPath;
                }

                bRtn = true;

                // Ver1.5 追加（ファイルの有無チェック）
                HySFile csFile = new HySFile(m_csOWaterLevelInf.m_csReadFileNameWithPath);
                if (csFile.Exist() != true)
                {
                   // ver1.5 エラートレース日本語対応
                    csErrorInfo.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND,
                          Properties.Resources.STATEMENT_FILE_NO_OR_INVALID  + m_csOWaterLevelInf.m_csReadFileNameWithPath);
                   // csErrorInfo.AddCheckErrorData(this.GetID(), McWaterLevelGaugingDefine.OWATER_LEVEL_KIND,
                   //      "入力ファイルが未設定です。または不正なファイルです。" + m_csOWaterLevelInf.m_csReadFileNameWithPath);
                    bRtn = false;
                }
            }
            return bRtn;

        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中に　プロパティ情報を変更した場合にコールされる</para>
        /// </remarks>
        public override bool SetOnlineProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // Do Nothing
            return true;
        }

        // Ver1.5 追加（プロジェクトプロパティ画面）
        /// <summary><para>method outline:</para>
        /// <para>モデルが読み込むデータファイル名を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>List csRtnList = GetReadFiles()</para>
        /// </example>
        /// <param name="">なし</param>
        /// <returns> データファイル名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override List<string> GetReadFiles()
        {
            List<string> csRtnList = new List<string>();
            csRtnList.Add(System.IO.Path.GetFileName(m_csOWaterLevelInf.m_csReadFileNameWithPath));
            return csRtnList;
        }
    }
    //
}
