// <summary>\[XR[hFϑʓ̓fpvpeBNX</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;


namespace CommonMP.HYMCO.OptionImpl.McWaterLevelGaugingForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>ϑʓ̓fpvpeBʗp .net ̃tH[</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/12][VK쐬]</para>
    /// <para>remarks:</para>
    /// <para>K@McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIFh̎</para>
    /// </remarks>
    public partial class McWaterLevelGaugingForm :McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {

        /// <summary> ǂݍރt@C̃pX </summary>
        private string m_sFileNamePath = "";

        /// <summary> ϑ_ </summary>
        private long m_lSeriesNum = 1;

        /// <summary> t@C` </summary>
        private string m_sFileType = "";

        /// <summary> o͒n_ </summary>
        private long m_lOutPoint = 0;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ftHgRXgN^</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McWaterLevelGaugingForm csPropertyDetailForm = new McWaterLevelGaugingForm();</para>
        /// </example>
        /// <param name=""></param>
        /// <returns></returns>
        /// <exception cref=""></exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public McWaterLevelGaugingForm()
        {
            InitializeComponent();

            //tH[̊Oݒ
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>vpeB\ҏW</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name=""></param>
        /// <returns></returns>
        /// <exception cref=""></exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public void EditParameter()
        {

            // ʕ\ҏW
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                // ToDo 
                // ʂɕ\鏉񓙂@f̃vpeB񂩂擾
                // ʏ̕iɐݒ肵Ă
                csModelPropertyInfo.GetInfo("m_csInFileNameWithPath", ref m_sFileNamePath);
                csModelPropertyInfo.GetInfo("m_csFileType", ref m_sFileType);
                csModelPropertyInfo.GetInfo("m_csSerialNum", ref m_lSeriesNum);
                csModelPropertyInfo.GetInfo("m_lOutPoint", ref m_lOutPoint);


                FileName.Text = m_sFileNamePath;

                
                //t@C`ݒ
                if (m_sFileType == McWaterLevelGaugingDefine.INPUTFILE_TYPE_CSV)
                {
                    radioButtonCSVFile.Checked = true;
                }
                else if (m_sFileType == McWaterLevelGaugingDefine.INPUTFILE_TYPE_WSF)
                {
                    radioButtonWisefFile.Checked = true;
                }

                textBox_seriserNum.Text = m_lSeriesNum.ToString();

                //o͒n_w
                if (m_lOutPoint == 0)
                {
                    radioButton_OutAll.Checked = true;
                    textBox_OutPoint.Text = "";
                }
                else
                {
                    radioButton_OutPoint.Checked = true;
                    textBox_OutPoint.Text = m_lOutPoint.ToString();
                }
                textBox_OutPoint.Enabled = radioButton_OutPoint.Checked;

            }
        }

        /// <summary><para>method outline:</para>
        /// <para>o͒n_IύX</para>
        /// </summary>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        private void radioButton_OutPoint_CheckedChanged(object sender, EventArgs e)
        {
            textBox_OutPoint.Enabled = radioButton_OutPoint.Checked;
            if (textBox_OutPoint.Enabled && textBox_OutPoint.exIsEmpty)
            {
                textBox_OutPoint.Text = "1";
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>t@C͏</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FileOpen_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns></returns>
        /// <exception cref=""></exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>ut@Ćv{^ꂽ̏Lq</para>
        /// </remarks>
        private void FileOpen_Click(object sender, EventArgs e)
        {
            string sPath = "";      // FileNameeLXg{bNXɓ͂Ă镶
            string sDir = "";       // fBNgEpXit@C܂܂Ȃj
            string sFile = "";      // t@CipX܂܂Ȃj

            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            csModelPropertyInfo.GetInfo("m_csInFileNameWithPath", ref sPath);

            //OpenFileDialogNX̃CX^X쐬
            OpenFileDialog ofd = new OpenFileDialog();

            // ͂߂̃t@Cw肷ꍇ
            McWaterLevelGaugingPropertyScreen csPrptyScreen = this.m_csScreen as McWaterLevelGaugingPropertyScreen;

            // ߂ėvffzuꍇ
            if (sPath == "")
            {
                sDir = csPrptyScreen.GetProjectGroupDirectory().ToString() + "\\InputData";
            }
            // tpXŋLqĂꍇ́Â܂ܓnB
            else if (sPath.IndexOf(":") >= 0)
            {
                sDir = System.IO.Path.GetDirectoryName(sPath);
                sFile = System.IO.Path.GetFileName(sPath);
            }
            // ΃pXŋLqĂꍇÂ܂ܓnivWFNgEfBNg̊Oɓ̓t@CuꍇjB
            else if (sPath.IndexOf("..") >= 0)
            {
                sDir = System.IO.Path.GetDirectoryName(sPath);
                sFile = System.IO.Path.GetFileName(sPath);
            }
            // vWFNgEfBNg̒ɒuĂꍇiftHgj
            else
            {
                sDir = System.IO.Path.GetDirectoryName(csPrptyScreen.GetProjectGroupDirectory().ToString() + "\\" + sPath);
                sFile = System.IO.Path.GetFileName(sPath);
            }
                
            // ͂߂ɕ\fBNgw肷B
            ofd.InitialDirectory = sDir;
            ofd.FileName = sFile;

            //͂߂Ɂut@Cvŕ\镶[t@C̎]ɕ\Iw肷
            if (radioButtonCSVFile.Checked == true)
            {
                ofd.Filter = Properties.Resources.CSV_FILE_FILTER;  // "csvt@C(*.csv)|*.csv|ׂẴt@C(*.*)|*.*";
                if (sPath == "")
                {
                    ofd.FileName = "FileIn.csv";
                }
            }
            else if (radioButtonWisefFile.Checked == true)
            {
                ofd.Filter = Properties.Resources.WISEF_FILE_FILTER; // "wiseft@C(*.wsf)|*.wsf|ׂẴt@C(*.*)|*.*";
                if (sPath == "")
                {
                    ofd.FileName = "FileIn.wsf";
                }
            }

            //[t@C̎]ł͂߂
            ofd.FilterIndex = 1;
            //^Cgݒ肷

            ofd.Title = Properties.Resources.OFD_TITLE; // "Jt@CIĂ";

            // _CAO\
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                // It@C̐΃pXvWFNgEfBNgȉ̑΃pXɒB
                HySString csRelativePath = new HySString("");
                HySString csAbsolutePath = new HySString(ofd.FileName);
                csPrptyScreen.GetRelativePathBasedOnProjectGroup(csAbsolutePath, ref csRelativePath);
                this.FileName.Text = csRelativePath.ToString();
            }

        }


        /// <summary><para>method outline:</para>
        /// <para>ݒ菈</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns></returns>
        /// <exception cref=""></exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>uݒv{^ꂽ̏Lq</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            //----------------------------------------
            //@̓f[^̐`FbNB
            //----------------------------------------
            //̓t@C
            if (FileName.exIsEmpty)
            {
                CommonControlLibrary.CommonLib.ShowInputError(Properties.Resources.FILE_EMPTY_ERROR /*"̓t@Cw肵ĉB"*/);
                FileName.Focus();
                return;
            }
            // ΃pX܂͑΃pXŋLqĂꍇ
            if (this.FileName.Text.IndexOf("..") >= 0 || this.FileName.Text.IndexOf(":") >= 0)
            {
                if (!FileName.exIsFileExists)
                {
                    CommonControlLibrary.CommonLib.ShowInputError("'" + FileName.Text + Properties.Resources.FILE_NOT_EXIST_ERROR /*"'݂͑܂B"*/);
                    FileName.Focus();
                    return;
                }
            }
            else{
                McWaterLevelGaugingPropertyScreen csPrptyScreen = this.m_csScreen as McWaterLevelGaugingPropertyScreen;
                string sFilePath = csPrptyScreen.GetProjectGroupDirectory().ToString() + "\\" + this.FileName.Text;
                if (!System.IO.File.Exists(sFilePath))
                {
                    CommonControlLibrary.CommonLib.ShowInputError("'" + sFilePath + Properties.Resources.FILE_NOT_EXIST_ERROR /*"'݂͑܂B"*/);
                    this.FileName.Focus();
                    return;
                }
            }

            //ϑn_
            if (textBox_seriserNum.exIsEmpty)
            {
                CommonControlLibrary.CommonLib.ShowInputError(Properties.Resources.SERIES_NUM_EMPTY_ERROR /*"ϑn_͂ĉB"*/);
                textBox_seriserNum.Focus();
                return;
            }
            long lSeriserNum = (long)textBox_seriserNum.exValue;

            //[t@C̎]ɕ\Iw肷
            string sType = "";
            if (System.IO.Path.GetExtension(FileName.Text) == ".csv")
            {
                if (!radioButtonCSVFile.Checked)
                {
                    CommonControlLibrary.CommonLib.ShowInputError(Properties.Resources.DIFFERENT_FILE_TYPE_ERROR /*"̓t@Č`w肵t@Č`ƈvĂ܂B"*/);
                    return;
                }
                sType = McWaterLevelGaugingDefine.INPUTFILE_TYPE_CSV;
            }
            else if (System.IO.Path.GetExtension(FileName.Text) == ".wsf")
            {
                if (!radioButtonWisefFile.Checked)
                {
                    CommonControlLibrary.CommonLib.ShowInputError(Properties.Resources.DIFFERENT_FILE_TYPE_ERROR /*"̓t@Č`w肵t@Č`ƈvĂ܂B"*/);
                    return;
                }
                sType = McWaterLevelGaugingDefine.INPUTFILE_TYPE_WSF;
            }

            //o͒n_w
            long lOutPointVal = 0;
            if (radioButton_OutPoint.Checked)
            {
                if (textBox_OutPoint.exIsEmpty)
                {
                    CommonControlLibrary.CommonLib.ShowInputError(Properties.Resources.OBSERVATORY_NUM_EMPTY_ERROR /*"n_w͂ĉB"*/);
                    textBox_OutPoint.Focus();
                    return;
                }
                lOutPointVal = (long)textBox_OutPoint.exValue;
                if (lOutPointVal < 1 || lOutPointVal > lSeriserNum)
                {
                    CommonControlLibrary.CommonLib.ShowInputError(string.Format(Properties.Resources.OBSERVATORY_NUM_INADEQUATE_ERROR /*"n_wɂ1`{0}iϑn_j܂ł͂ĉB"*/, lSeriserNum));
                    textBox_OutPoint.Focus();
                    return;
                }
            }

            //----------------------------------------
            //ȀƕύX邩`FbNB
            //----------------------------------------

            //----------------------------------------
            //B̓f[^̕ۑB
            //----------------------------------------
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;

            csModelPropertyInfo.SetInfo("m_csInFileNameWithPath", FileName.Text);
            csModelPropertyInfo.SetInfo("m_csSerialNum", lSeriserNum);
            csModelPropertyInfo.SetInfo("m_csFileType", sType);
            csModelPropertyInfo.SetInfo("m_lOutPoint", lOutPointVal);

            DialogResult = DialogResult.OK;     // ݒύXꍇ


            //----------------------------------------
            //CʏI
            //----------------------------------------
            Close();

        }
        /// <summary><para>method outline:</para>
        /// <para>LZ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns></returns>
        /// <exception cref=""></exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>uLZv{^ꂽ̏Lq</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        
    }
}