﻿// <summary>ソースコード：テスト用流量発生モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;



namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>テスト用流量発生クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McTestBasin : McForecastModelBase
    {
        /// <summary>流域計算情報</summary>
        McTestBasinCalInfo m_csBasinInfo = null;

        //=========================
        // 演算実行前処理関連メソッド
        //=========================

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            // 使用しやすいようにキャストしておく
            //m_csBasinInfo = (McSampleBasinCalInfo)m_csCalInfo;
            if (csInitialData != null)
            {
                double dDt = 0.0;
                ((McInitialInfo)csInitialData).GetInfo("m_dOutQ0", ref dDt);
                m_csBasinInfo.m_dOutQ = dDt;
            }

            // ver1.5 エラートレース日本語対応
            string DispStatement = Properties.Resources.STATEMENT_INITIAL + m_csBasinInfo.m_dOutQ.ToString();
            McLog.DebugOut(this.m_csSimTime, GetID(), "McTestBasin", "Initialize", DispStatement);
            return true;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;
            if (lInputDataNum > 0)
            {
                // エラー
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.GetID(), McModelSampleDefine.BASIN, 
                    Properties.Resources.STATEMENT_NO_RECEIVE_DATA );
               // csErrorInf.AddCheckErrorData(this.GetID(), McModelSampleDefine.BASIN, "Cannot receive data.");
                bRtn = false;
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;

            if (lOutputDataNum == 0)
            {
                // 警告（エラーではない）
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckWarningData(this.GetID(), McModelSampleDefine.BASIN, 
                     Properties.Resources.STATEMENT_NO_SND_PORT );
               // csErrorInf.AddCheckWarningData(this.GetID(), McModelSampleDefine.BASIN, "No send port.");
            }
            for (long lP = 0; lP < lOutputDataNum; lP++)
            {   // 出力側接続線数分チェックを行う
                long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                if (lCellDim == 1 && lD1==1)
                {   // １次元配列で１セルならば
                    if (lCellDataNum < 1)
                    {   // セル内の変数の数
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), McModelSampleDefine.BASIN,
                            Properties.Resources.STATEMENT_VAL_NUM_SHORT_S + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), McModelSampleDefine.BASIN,
                       //     "Variable number in the Cells is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        bRtn = false;
                    }
                }
                else
                {
                    // エラー
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), McModelSampleDefine.BASIN,
                                            Properties.Resources.STATEMENT_UNEXPECT_DATA_TYPE_S + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                   // csErrorInf.AddCheckErrorData(this.GetID(), McModelSampleDefine.BASIN,
                   //                         "Unexpected send data type. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");

                    bRtn = false;
                }
            }
            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputCellData)</para>
        /// </example>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long Calculate(long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            // this.m_csTotalPassingTime には シミュレーション開始時刻からの経過時間が入っている
            m_csBasinInfo.m_dTau = this.m_csTotalPassingTime.GetTime() / m_csBasinInfo.m_csTp.GetTime();
            

            m_csBasinInfo.m_dOutQ =
                (m_csBasinInfo.m_dQb + (m_csBasinInfo.m_dQp - m_csBasinInfo.m_dQb)
                   * (Math.Pow((m_csBasinInfo.m_dTau * Math.Exp(1.0 - m_csBasinInfo.m_dTau)), m_csBasinInfo.m_dCp)
                     )
                );
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>複数接続があった場合、全て同じ情報が出ることに注意（流量を分配して出しているわけではない）</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            HySCellData[] csSndCellData = null;
            string        DispStatement = "";

            for (long lP = 0; lP < m_lOutputDataNum; lP++)
            {
                csSndCellData = csOutputCellData[lP].PrepareSendCellD1();
                csSndCellData[0].m_dData[0] = m_csBasinInfo.m_dOutQ;

                // ver1.5 エラートレース日本語対応
                DispStatement = " " + Properties.Resources.STATEMENT_OUTVALUE + m_csBasinInfo.m_dOutQ.ToString();
                McLog.DebugOut(this.m_csSimTime, GetID(), "McTestBasin", "DataFusion", DispStatement);
            }
            return 0;
        }
        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // 使用しやすいようにキャストしておく
            m_csBasinInfo = (McTestBasinCalInfo)m_csCalInfo;

            //McPropertyInfo MdlPrtpy = csCellMdlPropertyInfo as McPropertyInfo;
            //string prjID = MdlPrtpy.GetOwnerProjectID();

            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
                // 計算パラメーター
                csPrptyInfo.GetInfo("m_dWidth", ref m_csBasinInfo.m_dWidth);
                csPrptyInfo.GetInfo("m_dQb", ref m_csBasinInfo.m_dQb);
                csPrptyInfo.GetInfo("m_dQp", ref m_csBasinInfo.m_dQp);
                csPrptyInfo.GetInfo("m_dCp", ref m_csBasinInfo.m_dCp);
                csPrptyInfo.GetInfo("m_dOutQ0", ref m_csBasinInfo.m_dOutQ);

                // 出力地点定義
                String sOutPntID = "";
                csPrptyInfo.GetInfo("OutPos", ref sOutPntID);
                long lCellNo = 0;
                csPrptyInfo.GetInfo("OutPosCell", ref lCellNo);
                m_csBasinInfo.m_csOutCellIDMng.SetID(new HySID(sOutPntID), lCellNo, new HySObjectKind(""));

                // 出力データの種別数
                //csPrptyInfo.GetInfo("OutDataKindNum", ref m_csBasinInfo.m_lCellDataDim);
                // 出力データの種別
                //String sOutData = "";
                //csPrptyInfo.GetInfo("OutDataKind", ref sOutData);
                //if (sOutData == "流量：ｍ３／ｓｅｃ")
                //{
                //    m_csBasinInfo.m_csCellDataKind.SetDataKind(1, HySDataKindDefine.QUANTITY_OF_WATER_FLOW);
                //}

                // 演算ステップ時刻設定
                this.m_csDltTime = new HySTime(csPrptyInfo.GetStepTime());
            }
            else
            {
                m_csBasinInfo = (McTestBasinCalInfo)m_csCalInfo;

                m_csBasinInfo.m_dWidth = 200.0; // 
                m_csBasinInfo.m_dQb = 200.0; // m3/s
                m_csBasinInfo.m_dQp = 2000.0; // m3/s
                m_csBasinInfo.m_csTp = new HySTime(12, 0, 0); // 12Hr
                m_csBasinInfo.m_dCp = 10.0; // 
                m_csBasinInfo.m_dOutQ = 0.0; // m3/s
                m_csBasinInfo.m_dTau = 0.0;

                this.m_csDltTime = new HySTime(72); // ７２秒   new HySTime(1, 0, 0);  // １時間
            }
            return true;
        }

    }
}
