﻿// <summary>ソースコード：テスト用３次元ＣＳＶファイル出力データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Tool;


namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>テスト用３次元ＣＳＶファイル出力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestOutD3CSVFileInfo : McCalInfo
    {
        /// <summary> 最終入力時刻 </summary>
        public HySTime m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> データ一時保管 </summary>
        public LinkedList<McTestOutD3Record> m_csDataList = new LinkedList<McTestOutD3Record>();
        /// <summary> 配列数 </summary>
        public long m_lDtDim = 0;
        /// <summary> ファイル出力時間間隔 </summary>
        public HySTime m_csOutTimeLag = new HySTime(2, 0, 0);
        /// <summary> ファイル出力するデータのセル内インデックス（０相対） </summary>
        public long m_lOutDataIdx = 0; // <-- 0固定

        /// <summary>１レコードのデータ配列１</summary>
        public long m_lDim1 = 16;
        /// <summary>１レコードのデータ配列２</summary>
        public long m_lDim2 = 16;
        /// <summary>１レコードのデータ配列２</summary>
        public long m_lDim3 = 16;

        /// <summary> 出力ファイルの名 </summary>
        public string m_sFileName = null;

        /// <summary> 出力の時間 </summary>
        public string m_sOutPutTime = null;




        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McTestOutD3CSVFileInfo csRtn = new McTestOutD3CSVFileInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McTestOutD3CSVFileInfo csOrgDt = (McTestOutD3CSVFileInfo)csOrgInfo;

            this.m_csLastINTime = csOrgDt.m_csLastINTime.Clone();
            this.m_csLastOutTime = csOrgDt.m_csLastOutTime.Clone();
            this.m_lDtDim = csOrgDt.m_lDtDim;
            this.m_csOutTimeLag = csOrgDt.m_csOutTimeLag.Clone();
            this.m_csDataList = csOrgDt.m_csDataList;
            this.m_lOutDataIdx = csOrgDt.m_lOutDataIdx;

            return true;
        }
    }

}
