﻿// <summary>ソースコード：テスト用３次元ＣＳＶファイル出力モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data.FileIO;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>テスト用３次元ＣＳＶファイル出力</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.1.0][2010/10/01][修正]
    /// </para>
    /// <para>remarks:</para>
    /// <para>３次元配列情報をＣＳＶ形式のファイルに出力する：
    /// 　　　　出力する情報は　１変数のみ</para>
    /// </remarks>
    public class McTestOutD3CSVFileModel : McBasicFileOutCtl
    {
        /// <summary> 内部変数 </summary>
        McTestOutD3CSVFileInfo m_csOutFileInfo = null;


        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;

            // 入力端子数のチェック
            if (lInputDataNum == 0)
            {
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND,
                    Properties.Resources.STATEMENT_NO_REC_PORT );
               // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND, "No Receive Port");
                bRtn = false;
            }
            else if (lInputDataNum > 1)
            {
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND,
                     Properties.Resources.STATEMENT_MULTI_REC_PORT );
               // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND, "Too many Receive Ports. (Not support multi-Receive Ports)");
                bRtn = false;
            }
            else if (lInputDataNum == 1)
            {
                long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                long lCellDim = csInputCellData[0].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
                if (lCellDim == 3 && lD1 >= 1 && lD2 >= 1 && lD3 >= 1)
                {   // 3次元のならば
                    // Do nothig
                }
                else
                {
                    bRtn = false;
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND ,
                         Properties.Resources.STATEMENT_UNEXPECT_REC_DATA_TYPE_R  + m_csInputData[0].GetUpperElementID().ToString() + ")");
                   // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND
                   //     , "Unexpected receive data type. (Received from " + m_csInputData[0].GetUpperElementID().ToString() + ")");
                }
            }
            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;
            // 初期化情報
            McInitialInfo csRtnDt = csInitialData as McInitialInfo;
            if (csRtnDt != null)
            {   // 初期化情報あり
                // 出力時間間隔を取得
                double dDt = 0.0;
                csRtnDt.GetInfo("OUTTIME_LAG", ref dDt);
                //m_csOutFileInfo.m_csOutTimeLag = new HySTime(dDt * 3600.0);
                m_csOutFileInfo.m_csOutTimeLag = new HySTime(dDt * 1.0);
            }

            // 情報の初期化
            m_csOutFileInfo.m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
            m_csOutFileInfo.m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();


            McTimeSeriesD3CellArrayTranInfo csCellD3Trn = null;


            if ((csCellD3Trn = m_csInputData[0] as McTimeSeriesD3CellArrayTranInfo) != null)
            {   // セル３次元配列情報ならば
                m_csOutFileInfo.m_lDim1 = csCellD3Trn.GetDimension1();
                m_csOutFileInfo.m_lDim2 = csCellD3Trn.GetDimension2();
                m_csOutFileInfo.m_lDim3 = csCellD3Trn.GetDimension3();

                // 配列数を保持しておく
            }
            else
            {
                m_csOutFileInfo.m_lDtDim = 0;
            }

            // 出力ファイル設定
            m_csOutFile = new HySFile(m_csOutFileInfo.m_sFileName.ToString());

            // 出力ファイル初期生成
            if (m_csOutFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
            {
                // ver1.6 出力ファイル標準フォーマットの英語化
                // [日本語タグ]   →　[英語表記タグ]
                // ・データ区分　　→　DataType
                // ・時系列　　　　→　TimeSeries
                // ・配列数　　　　→　Array
                // ・×　　　　　　→　x

                // ヘッダーを作成
                // ３次元時系列データならば
                m_csOutFile.WriteText("HySCSVFileDim3Data,Ver1.0");  // ヘッダー
                m_csOutFile.WriteText("DataType, TimeSeries");  // ヘッダー

                m_csOutFile.WriteText("Array," + m_csOutFileInfo.m_lDim1.ToString()
                                                + ",x," + m_csOutFileInfo.m_lDim2.ToString()
                                                + ",x," + m_csOutFileInfo.m_lDim3.ToString());  // ヘッダー
                m_csOutFile.WriteText("Time, Data");  // ヘッダー

                m_csOutFile.Close();
            }
            else
            {
                bRtn = false;
            }

            return bRtn;
        }
 
        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData) 
        {
            // データ取得
            this.ReadData( );

            long lDtNum = m_csOutFileInfo.m_csDataList.Count;  // 保管中の情報の数

            LinkedListNode<McTestOutD3Record> csDtNode;

            McTestOutD3Record csData = null;
            HySTime csTm = null;
            string sStr = ",";

            for (int iLp = 0; iLp < lDtNum; iLp++)
            {   // 保管中の情報分繰り返す


                // 保管情報を１レコードづつ取り出す
                csDtNode = m_csOutFileInfo.m_csDataList.First;
                csData = csDtNode.Value;

                csTm = csData.m_csTime; // レコードの時刻

                if ((m_csOutFileInfo.m_csLastOutTime + m_csOutFileInfo.m_csOutTimeLag).After(csTm) == false)
                {   // 出力すべきレコード時刻か？

                    if (m_csOutFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                    {   // 出力ファイルオープン


                        //時刻を取得
                        m_csOutFileInfo.m_sOutPutTime = HySCalendar.GetString(csTm, HySCalendar.FORMAT.lSW_YEAR).ToString();

                        m_csOutFile.WriteText(m_csOutFileInfo.m_sOutPutTime);


                        //CSVファイルの出力形式（行と列逆転）
                        for (long l3 = 0; l3 < m_csOutFileInfo.m_lDim3; l3++)
                        {
                            for (long l2 = 0; l2 < m_csOutFileInfo.m_lDim2; l2++)
                            {
                                //add_s 20100316
                                if (l2 == 0)
                                    sStr += string.Format("Layer{0},", l3 + 1);
                                else
                                    sStr += ",";
                                //add_e 20100316

                                for (long l1 = 0; l1 < m_csOutFileInfo.m_lDim1; l1++)
                                {
                                    sStr += Convert.ToString(csData.m_dD3DT[l1, l2, l3]) + ",";
                                }

                                //文字列最後のカンマを削除
                                sStr = sStr.Substring(0, sStr.Length - 1);

                                m_csOutFile.WriteText(sStr);

                                sStr = ",";

                            }
                        }

                        m_csOutFileInfo.m_csLastOutTime.SetTime(csTm);

                        //McLog.DebugOut(GetSimulationTime(), m_csElement.GetID(), "McTestOutD3CSVFileModel", "DataFusion", " WriteDataNum=" + lDtNum.ToString() + " LastWriteString= " + sStr);

                        // 出力ファイルを閉じる
                        m_csOutFile.Close();
                    }
                }

                // 読み出した情報は一時保管情報から削除する
                m_csOutFileInfo.m_csDataList.RemoveFirst();
            } 
  
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>入力された伝送データの取得し一時保管しておく</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ReadData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long ReadData()
        {
            McTimeSeriesD3CellArrayTranInfo csCellD3Trn = null;

            McD3CellArrayTranInfo csDtD3Rcd = null;

            HySCellData[,,] csD3Cells = null;



            // 入力された伝送情報を読み出す
            if ((csCellD3Trn = m_csInputData[0] as McTimeSeriesD3CellArrayTranInfo) != null)
            {
                McReceiveCellDataIF csInputCellData = m_InputCellData[0];
                McTestOutD3Record   csRcd = null;  // １レコード分のデータ

                long lDim1 = csCellD3Trn.GetDimension1(); // 配列の大きさは？
                long lDim2 = csCellD3Trn.GetDimension2(); // 配列の大きさは？
                long lDim3 = csCellD3Trn.GetDimension3(); // 配列の大きさは？

                long lDtNum = csCellD3Trn.SetCursorPlus(m_csOutFileInfo.m_csLastINTime);// 最終時刻以後に情報が追加されているか？

                for (long lDtLp = 0; lDtLp < lDtNum; lDtLp++)
                {   // 追加された情報分処理を行う

                    csDtD3Rcd = (McD3CellArrayTranInfo)csCellD3Trn.GetCursorData();
                    csD3Cells = csDtD3Rcd.GetCellData();
                    csRcd = new McTestOutD3Record(lDim1, lDim2, lDim3);  // １レコード情報格納クラスの生成

                    for (long l1 = 0; l1 < m_csOutFileInfo.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csOutFileInfo.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csOutFileInfo.m_lDim3; l3++)
                            {
                                csRcd.m_dD3DT[l1, l2, l3] = csInputCellData.Data(csD3Cells[l1, l2, l3], m_csOutFileInfo.m_lOutDataIdx);//セル内の値を取得
                            }
                        }
                    }


                    csRcd.m_csTime = csDtD3Rcd.GetLastTime();

                    //McLog.DebugOut(GetSimulationTime(), m_csElement.GetID(), "McTestOutD3CSVFileModel", "ReadData",
                    //    " ReadDataTime=" + (HySCalendar.GetString( csDtRcd.GetTime(), HySCalendar.FORMAT.lSW_DAY)).ToString() + " Dt[0]= " + csRcd.m_dDT[0].ToString());

                    // 読み出した情報を一時保管しておく
                    m_csOutFileInfo.m_csDataList.AddLast(csRcd);
                    m_csOutFileInfo.m_csLastINTime.SetTime(csRcd.m_csTime);

                    csCellD3Trn.MoveCursorNext();
                }
            }
            else
            {
            }

            return 0;
        }

        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // 使用しやすいようにキャストしておく
            m_csOutFileInfo = (McTestOutD3CSVFileInfo)m_csCalInfo;

            McModelPropertyInfo csPropInf = csCellMdlPropertyInfo as McModelPropertyInfo;
            if (csPropInf != null)
            {   // プロパティ情報あり
                string sVerInf = "";
                csPropInf.GetInfo("sVer", ref sVerInf);
                if (sVerInf != "")
                {   // Ver1.1以後の設定ならば
                    string sOutFileName = "";
                    // 出力ファイルの設定
                    csPropInf.GetInfo("m_csOutFileNameWithPath", ref sOutFileName);

                    // 相対パス設定値を絶対パス化
                    //m_csOutFileNameWithFullPath = this.GetProjectGroupDirectory() + new HySString("\\" + sOutFileName);
                    m_csOutFileInfo.m_sFileName = this.GetProjectGroupDirectory().ToString() + "\\" + sOutFileName;
                }
                else
                {   // Ver1.0 での設定ならば
                    csPropInf.GetInfo(new HySString("m_csOutFileNameWithPath"), ref m_csOutFileInfo.m_sFileName);
                }
                this.m_csOutFileInfo.m_lOutDataIdx = 0; // 0固定
            }

            return true;
        }

    }
}
