﻿// <summary>ソースコード：テストCSVファイル入力データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>テストCSVファイル入力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestReadD2CSVFileInfo : McCalInfo
    {
        /// <summary> 出力数 </summary>
        public long m_lOutPutPortNum = 0;

        /// <summary> 最後にデータを出力した演算時刻 </summary>
        public HySTime m_csLastDataSendTime = null;
        /// <summary>送信したレコード数</summary>
        public long m_lSndRcrdNum = 0;
        /// <summary>次に送信するデータ </summary>
        public HySCSVFileDim2Data.CSVDim2Recorde m_csNextSndRcrd = null;

        /// <summary> 読み出したデータ保管場所 </summary>
        public HySCSVFileDim2Data m_csReadCSVData = null;
        /// <summary> 読み出したレコードの数 </summary>
        public long m_lRecNum = 0;
        /// <summary>１レコードのデータ配列１</summary>
        public long m_lDim1 = 16;
        /// <summary>１レコードのデータ配列２</summary>
        public long m_lDim2 = 16;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McTestReadD2CSVFileInfo csRtn = new McTestReadD2CSVFileInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McTestReadD2CSVFileInfo csOrgDt = (McTestReadD2CSVFileInfo)csOrgInfo;

            this.m_lOutPutPortNum = csOrgDt.m_lOutPutPortNum;
            this.m_csLastDataSendTime = csOrgDt.m_csLastDataSendTime.Clone();
            this.m_lSndRcrdNum = csOrgDt.m_lSndRcrdNum;
            if (csOrgDt.m_csNextSndRcrd != null)
            {
                this.m_csNextSndRcrd = HySDataDuplicate.DupliCateData(csOrgDt.m_csNextSndRcrd) as HySCSVFileDim2Data.CSVDim2Recorde;
            }
            if (csOrgDt.m_csReadCSVData != null)
            {
                this.m_csReadCSVData = HySDataDuplicate.DupliCateData(csOrgDt.m_csReadCSVData) as HySCSVFileDim2Data;
            }
            this.m_lRecNum = csOrgDt.m_lRecNum;
            this.m_lDim1 = csOrgDt.m_lDim1;
            this.m_lDim2 = csOrgDt.m_lDim2;
           
            return true;
        }

    }
}
