﻿// <summary>ソースコード：サンプルプロパティ詳細設定画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.DetailForm
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>CSVファアイル出力要素プロパティ詳細設定画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public partial class McDotNetTestOutCSVModelPropertyForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        /// <summary>変更有り無しフラグ</summary>
        bool m_bChangeFlg = false;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTestOutCSVModelPropertyForm csSamplePropertyDetailForm = new McDotNetTestOutCSVModelPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTestOutCSVModelPropertyForm()
        {
            InitializeComponent();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            // 画面表示情報編集

            // ↓↓↓↓↓サンプルロジック↓↓↓↓↓
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                string sOutFileNameWithPath = "";
                csModelPropertyInfo.GetInfo("m_csOutFileNameWithPath", ref sOutFileNameWithPath);// 現在の設定値の取得
                if (sOutFileNameWithPath == "")
                {   // 何も設定されていないとき
                    McDotNetTestOutCSVModelPropertyScreen csPrptyScreen = this.m_csScreen as McDotNetTestOutCSVModelPropertyScreen;
                    if (csPrptyScreen != null)
                    {   // ｽｸﾘｰﾝｸﾗｽ取得
                        sOutFileNameWithPath =  "OutputData\\";
                    }
                }
                this.SetCsvFileNameTextBox.Text = sOutFileNameWithPath;// 画面初期表示を設定する
            }
            McInitialInfo csInitInfo = this.m_csInitialInfo as McInitialInfo;
            if (csInitInfo != null)
            {
                double dTmLag = 3600.0;
                csInitInfo.GetInfo("OUTTIME_LAG",ref dTmLag);// 現在の設定値の取得
                this.SetTimeLagTextBox.Text = dTmLag.ToString();// 画面初期表示を設定する
            }
            // ↑↑↑↑↑サンプルロジック↑↑↑↑↑
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReadFileButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReadFileButton_Click(object sender, EventArgs e)
        {
            // ファイル入力ボタン押下時の処理を記述する。
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>WriteFileButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WriteFileButton_Click(object sender, EventArgs e)
        {
            // ファイル出力ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OKButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OKButton_Click(object sender, EventArgs e)
        {
            // 設定ボタン押下時の処理を記述する。
            // ①入力データの整合性チェックする。
            // 　入力データに異常があれば異常項目を通知し、メソッド終了（return）
            // ②既存の情報と変更があるかチェックする。
            // ③②で変更があった場合
            // 　入力データの保存をする。
            // 　m_csPropertyInfoおよびm_csInitialInfoへ入力データを保存
            // 　DialogResultへDialogResult.OKをセット
            // ③②で変更が無かった場合
            // 　DialogResultへDialogResult.Cancelをセット
            // ④画面終了（Close）

            if (m_bChangeFlg == true)
            {
                DialogResult = DialogResult.OK;     // 設定変更がある場合
            }
            else
            {
                DialogResult = DialogResult.Cancel; // 設定変更がない場合
            }

            Close();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CancelButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CancelButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>「ファイルセレクト」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SlctButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void SlctButton_Click(object sender, EventArgs e)
        {
            McDotNetTestOutCSVModelPropertyScreen csPrptyScreen = this.m_csScreen as McDotNetTestOutCSVModelPropertyScreen;
            SaveFileDialog csSaveFileDlg = new SaveFileDialog();
            csSaveFileDlg.FileName = ".csv";

            if (csPrptyScreen != null)
            {
                csSaveFileDlg.InitialDirectory = csPrptyScreen.GetProjectGroupDirectory().ToString() + "\\" + this.SetCsvFileNameTextBox.Text;
            }

            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            csSaveFileDlg.Filter = "CSV(*.csv)|*.csv";
            csSaveFileDlg.Title = "CSV出力ファイルの設定";
            csSaveFileDlg.RestoreDirectory = true;  // <-- これが重要
            if (csSaveFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                if (csSaveFileDlg.FileName.Length > 0)
                {  // 名称入力が有る場合
                    if (csPrptyScreen != null)
                    {
                        string sVerInf = "";
                        if (csModelPropertyInfo != null)
                        {
                            csModelPropertyInfo.GetInfo("sVer", ref sVerInf);
                        }
                        HySString csAbsolutePath = new HySString(csSaveFileDlg.FileName);
                        if (sVerInf != "")
                        {
                            // 取得された絶対パスを相対パス化する
                            // ↓↓  データホーム￥プロジェクトグループ位置からの相対パス取得の例    ↓↓
                            HySString csRelativePath = new HySString("");
                            //csPrptyScreen.GetRelativePathBasedOnDataHome(csAbsolutePath, ref csRelativePath);  // <-- データホームを基準とするときには此方を使用する
                            csPrptyScreen.GetRelativePathBasedOnProjectGroup(csAbsolutePath, ref csRelativePath);
                            // ↑↑   データホーム￥プロジェクトグループ位置からの相対パス取得の例   ↑↑

                            if (csModelPropertyInfo != null)
                            {
                                csModelPropertyInfo.SetInfo("m_csOutFileNameWithPath", csRelativePath.ToString());
                                this.SetCsvFileNameTextBox.Text = csRelativePath.ToString();
                            }
                        }
                        else
                        {   // Ver1.0との互換性を保つため
                            string sRelativePath = "";
                            HySCommonInfoHash.DirectoryPathExchange(HySEnvInf.GetHomeDirectory().ToString(), csAbsolutePath.ToString(), ref sRelativePath);
                            csModelPropertyInfo.SetInfo("m_csOutFileNameWithPath", "..\\"+sRelativePath);
                            this.SetCsvFileNameTextBox.Text = "..\\"+sRelativePath;
                        }

                        m_bChangeFlg = true;
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>出力間隔変更通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetOutputTimeLag_Change(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void SetOutputTimeLag_Change(object sender, EventArgs e)
        {
            McInitialInfo csInitInfo = this.m_csInitialInfo as McInitialInfo;
            if (csInitInfo != null)
            {
                double dTmLag = double.Parse(this.SetTimeLagTextBox.Text);
                csInitInfo.SetInfo("OUTTIME_LAG", dTmLag);
            }
            m_bChangeFlg = true;
        }

    }
}
