﻿// <summary>ソースコード：サンプルプロパティ詳細設定画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.DetailForm
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>CSVファアイル出力要素プロパティ詳細設定画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public partial class McDotNetTestReadCSVModelPropertyForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        /// <summary>変更有り無しフラグ</summary>
        bool m_bChangeFlg = false;
        /// <summary>次元 </summary>
        long m_lDimNum = -1;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTestReadCSVModelPropertyForm csSamplePropertyDetailForm = new McDotNetTestReadCSVModelPropertyForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTestReadCSVModelPropertyForm()
        {
            InitializeComponent();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            // 画面表示情報編集

            // ↓↓↓↓↓サンプルロジック↓↓↓↓↓
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                string sInFileNameWithPath = "";
                csModelPropertyInfo.GetInfo("m_csInFileNameWithPath", ref sInFileNameWithPath);// 現在の設定値の取得
                if (sInFileNameWithPath == "")
                {   // 何も設定されていないとき
                    McDotNetTestReadCSVModelPropertyScreen csPrptyScreen = this.m_csScreen as McDotNetTestReadCSVModelPropertyScreen;
                    if (csPrptyScreen != null)
                    {   // ｽｸﾘｰﾝｸﾗｽ取得
                        sInFileNameWithPath = "InputData\\";
                    }
                }
                this.SetCsvFileNameTextBox.Text = sInFileNameWithPath;// 画面初期表示を設定する

                long lDim1 = -1; long lDim2 = -1; long lDim3 = -1;
                csModelPropertyInfo.GetInfo("m_lDim1", ref lDim1);// 現在の設定値の取得
                csModelPropertyInfo.GetInfo("m_lDim2", ref lDim2);// 現在の設定値の取得
                csModelPropertyInfo.GetInfo("m_lDim3", ref lDim3);// 現在の設定値の取得
                if (lDim1 <= 0)
                {
                    csModelPropertyInfo.GetInfo("m_lSeriesNum", ref lDim1);// 現在の設定値の取得
                    if (lDim1 <= 0)
                    {
                        this.SetDim1TextBox.ReadOnly = true;
                    }
                    else
                    {
                        this.SetDim1TextBox.ReadOnly = false;
                        this.SetDim1TextBox.Text = lDim1.ToString();
                        long lIdx=-1;
                        csModelPropertyInfo.GetInfo("m_lOutDataIdx", ref lIdx);// 現在の設定値の取得
                        if (lIdx < 0)
                        {
                            this.OutDataIdxTextBox.ReadOnly = true;
                        }
                        else
                        {
                            this.OutDataIdxTextBox.ReadOnly = false;
                            this.OutDataIdxTextBox.Text = lIdx.ToString();
                            m_lDimNum = 1;
                        }
                    }                 
                }
                else
                {
                    this.SetDim1TextBox.ReadOnly = false;
                    this.SetDim1TextBox.Text = lDim1.ToString();
                }
                if (lDim2 <= 0)
                {
                    this.SetDim2TextBox.ReadOnly = true;
                }
                else
                {
                    this.SetDim2TextBox.ReadOnly = false;
                    this.SetDim2TextBox.Text = lDim2.ToString();
                    m_lDimNum = 2;
                }
                if (lDim3 <= 0)
                {
                    this.SetDim3TextBox.ReadOnly = true;
                }
                else
                {
                    this.SetDim3TextBox.ReadOnly = false;
                    this.SetDim3TextBox.Text = lDim3.ToString();
                    m_lDimNum = 3;
                }
            }
            McInitialInfo csInitInfo = this.m_csInitialInfo as McInitialInfo;
            if (csInitInfo != null)
            {
            }
            // ↑↑↑↑↑サンプルロジック↑↑↑↑↑
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReadFileButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ReadFileButton_Click(object sender, EventArgs e)
        {
            // ファイル入力ボタン押下時の処理を記述する。
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>WriteFileButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WriteFileButton_Click(object sender, EventArgs e)
        {
            // ファイル出力ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OKButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OKButton_Click(object sender, EventArgs e)
        {
            // 設定ボタン押下時の処理を記述する。
            // ①入力データの整合性チェックする。
            // 　入力データに異常があれば異常項目を通知し、メソッド終了（return）
            // ②既存の情報と変更があるかチェックする。
            // ③②で変更があった場合
            // 　入力データの保存をする。
            // 　m_csPropertyInfoおよびm_csInitialInfoへ入力データを保存
            // 　DialogResultへDialogResult.OKをセット
            // ③②で変更が無かった場合
            // 　DialogResultへDialogResult.Cancelをセット
            // ④画面終了（Close）

            if (m_bChangeFlg == true)
            {
                DialogResult = DialogResult.OK;     // 設定変更がある場合
            }
            else
            {
                DialogResult = DialogResult.Cancel; // 設定変更がない場合
            }

            Close();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CancelButton_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CancelButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>「ファイルセレクト」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SlctButton_Click(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void SlctButton_Click(object sender, EventArgs e)
        {
            McDotNetTestReadCSVModelPropertyScreen csPrptyScreen = this.m_csScreen as McDotNetTestReadCSVModelPropertyScreen;
            OpenFileDialog csOpenFileDlg = new OpenFileDialog();
            csOpenFileDlg.FileName = ".csv";
            if (csPrptyScreen != null)
            {
                csOpenFileDlg.InitialDirectory = csPrptyScreen.GetProjectGroupDirectory().ToString() + "\\" + this.SetCsvFileNameTextBox.Text;
            }

            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            csOpenFileDlg.Filter = "CSV(*.csv)|*.csv";
            csOpenFileDlg.Title = "CSV入力ファイルの設定";
            csOpenFileDlg.RestoreDirectory = true;  // <-- これが重要
            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {  // ファイル名入力が完了の場合
                if (csOpenFileDlg.FileName.Length > 0)
                {  // 名称入力が有る場合
                    if (csPrptyScreen != null)
                    {
                        string sVerInf = "";
                        if (csModelPropertyInfo != null)
                        {
                            csModelPropertyInfo.GetInfo("sVer", ref sVerInf);
                        }
                        HySString csAbsolutePath = new HySString(csOpenFileDlg.FileName);
                        if (sVerInf != "")
                        {
                            // 取得された絶対パスを相対パス化する
                            // ↓↓  データホーム￥プロジェクトグループ位置からの相対パス取得の例    ↓↓
                            HySString csRelativePath = new HySString("");
                            //csPrptyScreen.GetRelativePathBasedOnDataHome(csAbsolutePath, ref csRelativePath);  // <-- データホームを基準とするときには此方を使用する
                            csPrptyScreen.GetRelativePathBasedOnProjectGroup(csAbsolutePath, ref csRelativePath);
                            // ↑↑   データホーム￥プロジェクトグループ位置からの相対パス取得の例   ↑↑

                            if (csModelPropertyInfo != null)
                            {
                                csModelPropertyInfo.SetInfo("m_csInFileNameWithPath", csRelativePath.ToString());
                                this.SetCsvFileNameTextBox.Text = csRelativePath.ToString();
                            }
                        }
                        else
                        {   // Ver1.0との互換性を保つため
                            string sRelativePath = "";
                            HySCommonInfoHash.DirectoryPathExchange(HySEnvInf.GetHomeDirectory().ToString(), csAbsolutePath.ToString(), ref sRelativePath);
                            csModelPropertyInfo.SetInfo("m_csInFileNameWithPath", "..\\" + sRelativePath);
                            this.SetCsvFileNameTextBox.Text = "..\\" + sRelativePath;

                        }

                        m_bChangeFlg = true;
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>配列値変更通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDim1_Change(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void SetDim1_Change(object sender, EventArgs e)
        {
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                long lDim1 = long.Parse(this.SetDim1TextBox.Text);
                if (m_lDimNum == 1)
                {
                    csModelPropertyInfo.SetInfo("m_lSeriesNum", lDim1);
                }
                else
                {
                    csModelPropertyInfo.SetInfo("m_lDim1", lDim1);
                }
            }
            m_bChangeFlg = true;
        }
        /// <summary><para>method outline:</para>
        /// <para>配列値変更通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDim2_Change(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void SetDim2_Change(object sender, EventArgs e)
        {
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                long lDim2 = long.Parse(this.SetDim2TextBox.Text);
                csModelPropertyInfo.SetInfo("m_lDim2", lDim2);
            }
            m_bChangeFlg = true;
        }
        /// <summary><para>method outline:</para>
        /// <para>配列値変更通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDim3_Change(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void SetDim3_Change(object sender, EventArgs e)
        {
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                long lDim3 = long.Parse(this.SetDim3TextBox.Text);
                csModelPropertyInfo.SetInfo("m_lDim3", lDim3);
            }
            m_bChangeFlg = true;
        }
        /// <summary><para>method outline:</para>
        /// <para>出力インデクス値変更通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>OutDataIdx_Change(sender,e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        private void OutDataIdx_Change(object sender, EventArgs e)
        {
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                long lIdx = long.Parse(this.OutDataIdxTextBox.Text);
                csModelPropertyInfo.SetInfo("m_lOutDataIdx", lIdx);
            }
            m_bChangeFlg = true;
        }
    }
}
