﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.TestModel
{
    /// <summary><para>class outline:</para>
    /// <para>テストサンプル要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class MyStateCalModelCalInfo : McCalInfo
    {
        //  必要な情報を追加します。

        /// <summary> 入力情報（流量） </summary>
        public double[] m_dQInData = null;
        /// <summary> 出力情報（流量） </summary>
        public double[] m_dQOutData = null;
        /// <summary> 入力情報 (モデルの内部状態（流量）) </summary>
        public double[] m_dQInInternalData = null;
        /// <summary> 出力情報 (モデルの内部状態（流量）) </summary>
        public double[] m_dQOutInternalData = null;
        /// <summary> 現状計算型モデル定数 </summary>
        public double m_dConstant = 0.0;
        /// <summary> 入力数 </summary>
        public long m_lInDataNum = 0;
        /// <summary> 出力数 </summary>
        public long m_lOutDataNum = 0;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MyStateCalModelCalInfo csRtn = new MyStateCalModelCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            MyStateCalModelCalInfo csOrdDt = (MyStateCalModelCalInfo)csOrgInfo;

            // 此処に、追加したメンバ変数をコピーする処理を入れます。

            for (long lLp = 0; lLp < csOrdDt.m_lInDataNum; lLp++)
            {
                this.m_dQInData[lLp] = csOrdDt.m_dQInData[lLp];
                this.m_dQInInternalData[lLp] = csOrdDt.m_dQInInternalData[lLp];
            }
            for (long lLp = 0; lLp < csOrdDt.m_lOutDataNum; lLp++)
            {
                this.m_dQOutData[lLp] = csOrdDt.m_dQOutData[lLp];
                this.m_dQOutInternalData[lLp] = csOrdDt.m_dQOutInternalData[lLp];
            }
            this.m_dConstant = csOrdDt.m_dConstant;
            this.m_lInDataNum = csOrdDt.m_lInDataNum;
            this.m_lOutDataNum = csOrdDt.m_lOutDataNum;

            return true;
        }

    }
}
