// <summary>ソースコード：.net 画面フォーム</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Runtime.InteropServices;
using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;




namespace jp.go.xxx.AddinSysToolTemplate
{
    /// <summary><para>class outline:</para>
    /// <para>.net 画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public partial class AddinSysToolTemplateDotNetForm : HySDotNetAddInBaseForm // : Form
    {
        /// <summary>制御するクリーン </summary>
        protected AddinSysToolTemplateDotNetScreen m_csMyScreen = null;

        /// <summary>
        /// 画面クローズボタン対応用フラグ
        /// 画面の右上　×　クリック時と、OK/NGボタン押下の動作性合成を取る
        /// </summary>
        protected bool m_bClosingNowFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectForm csNewProjectForm = new McDotNetNewProjectForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected AddinSysToolTemplateDotNetForm()
        {
            m_bClosingNowFlg = false;
            InitializeComponent();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HsAddinSampleDotNetForm csNewForm = new HsAddinSampleDotNetForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>HsAddinSampleDotNetForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>★派生クラス側は必ず本コンストラクターを実装する★</para>
        /// </remarks>
        public AddinSysToolTemplateDotNetForm(HySScreen csScreen) : base(csScreen)
        {
            m_bClosingNowFlg = false;
            InitializeComponent();  // <-- 画面を表示させる為に必ず必要 ●必須●
            
            m_csMyScreen = csScreen as AddinSysToolTemplateDotNetScreen; // 便利の為キャストしておく
        }


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // 以下に、画面のアクティブ／非アクティブイベントに関する処理を入れる
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HsAddinToolDotNetForm_Activated( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HsAddinToolDotNetForm_Activated(object sender, EventArgs e)
        {
            //派生クラス独自のイベント処理を行う


            //親クラスのイベントメソッドをコール（必須）
            base.HySDotNetForm_Activated(sender, e);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HsAddinToolDotNetForm_Deactivate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HsAddinToolDotNetForm_Deactivate(object sender, EventArgs e)
        {
            //派生クラス独自のイベント処理を行う


            //親クラスのイベントメソッドをコール（必須）
            base.HySDotNetForm_Deactivate(sender, e);
        }

        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // 以下には、必要な場合には、ショートカットキー入力に対応する処理を入れる
        //　　　必要に応じてショートカットキーイベント通知処理をオーバーライド　　
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeUndoEvent()
        {
            // 任意の処理を実装する
        }
        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeRedoEvent()
        {
            // 任意の処理を実装する
        }
        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent()
        {
            // 任意の処理を実装する
        }
        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent()
        {
            // 任意の処理を実装する
        }
        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent()
        {
            // 任意の処理を実装する
            if (Clipboard.ContainsText())
            {
                //クリップボードに 文字列データがあるときはこれを取得する
                String sCopyText = Clipboard.GetText();
            }

        }
        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent()
        {
            // 任意の処理を実装する
        }
        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent()
        {
            // 任意の処理を実装する
        }


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // 以下に、画面の部品に割り当てられたコールバック処理を入れる
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタン</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OKButton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OKButton_Click(object sender, EventArgs e)
        {
            m_bClosingNowFlg = true; // クローズ処理中
            m_csMyScreen.CloseScreen();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタン</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>NGButton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NGButton_Click(object sender, EventArgs e)
        {
            m_bClosingNowFlg = true; // クローズ処理中
            m_csMyScreen.CloseScreen();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フヘルプボタンクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HelButton_click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelButton_click(object sender, EventArgs e)
        {
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★
            //此処では例として　PDFファイルを表示する。
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★

            HySString csPDFFile = HySEnvInf.GetHomeDirectory() + new HySString("\\ToolManual\\AddinSysToolTemplate\\AddinSysToolTemplateManual.pdf");

            HySFile csFile = new HySFile(csPDFFile);
            if (csFile.Exist() == true)
            {
                Process.Start(csPDFFile.ToString());
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面の右上　×　クリック時の処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HsAddinToolDotNetForm_FormClosing( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HsAddinToolDotNetForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (m_bClosingNowFlg != true)
            {   // クローズ処理中でなければ
                m_bClosingNowFlg = true;
                m_csMyScreen.CloseScreen();
            }
        }


    }
}