﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace jp.go.xxx.AddinSysToolTemplate
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内画面制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class AddinSysToolTemplateViewerJob : HySDotNetAddInBaseJob
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ↓↓↓　下記コードが必須　↓↓↓
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>ツールの起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartTool()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        /// 
        public override void StartTool()
        {
            // To Do　此処で、ツールの立ち上がり処理を行う
            //  型紙としては、画面が表示される
            // ===<本ツールにて複数機能を有する場合>===
            // 画面表示
            HySID csID = null;
            csID = new HySID("AAAA");
            AddinSysToolTemplateDotNetScreen csDotNetScreen
                = this.CmndShowScreen((HySObjectKind)AddinSysToolTemplateDefine.SAMPLE_SCREEN, csID)
                    as AddinSysToolTemplateDotNetScreen;
            if (csDotNetScreen != null)
            {   // 表示に成功ならば
                csDotNetScreen.ActivateForm();  // 表示した画面を最前面に持ってくる
            }
        }
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ↑↑↑　上記コードが必須　↑↑↑
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            // 処理例
            m_bWorkFlg = true; // 処理開始したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            // 処理例
            m_bWorkFlg = false; // 処理終了したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // 処理例
            // 処理中でなければ(m_bWorkFlg==false)、本業務処理はＥｘｉｔしてもＯＫと判断して true を返す
            if (m_bWorkFlg == true)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

    }
}
