﻿// <summary>ビューア内業務処理生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// ↓↓↓　下記コードが必須　↓↓↓
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
namespace CommonMP.HYSSOP._SYSTEM_
{
    public class HYSSOP_USRVIEWERJOB_FACTORY_CREATOR_IMPLE : HYSSOP_USRVIEWERJOB_FACTORY_CREATOR
    {
        public CommonMP.HYSSOP.Interface.HSViewer.HySViewerJobFactory CreateFactory()
        {
            // ToDo 自作の画面ファクトリ（ネームスペース付き）を new して下さい。
            return new jp.go.yyyy.MySysToolSample.MyToolSampleViewerJobFactory();
        }
    }
}
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// ↑↑↑　上記コードが必須　↑↑↑
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

namespace jp.go.yyyy.MySysToolSample
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内制御ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class MyToolSampleViewerJobFactory : HySDotNetAddInBaseJobFactory
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetViewerJobFactory csFactory = new McDotNetViewerJobFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public MyToolSampleViewerJobFactory()
        {
            // ToDo 独自のファクトリＩＤを設定して下さい。
            //    コンストラクター－内で　ファクトリＩＤを設定する
            SetFactoryID(MyToolSampleDefine.BUSINESS_KIND);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySKind GetSimKind()
        {
            // ToDo シミュレーション（業務ＩＤ）を取得する
            return MyToolSampleDefine.BUSINESS_KIND;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean EqualSimKind(HySKind csSimKindID)
        {
            // ToDo シミュレーション（業務ＩＤ）が同じか否かを判断する
            return MyToolSampleDefine.BUSINESS_KIND.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内画面制御クラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ビューア内画面制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySViewerJob CreateViewerJob()
        {
            // ToDo 独自の HySViewerJob 派生クラスを生成してください
            return new MyToolSampleViewerJob();
        }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ↓↓↓　下記コードが必須　↓↓↓
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>アドインツール情報生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySUserToolInfoData csAddinInf = CreateToolInf(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySUserToolInfoData アドイン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySUserToolInfoData CreateToolInf()
        {
            HySString csToolName;
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // ↓↓↓　多言語対応　↓↓↓
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // ランチャー画面に表示されるツール名称をOS設定に応じて表示切替
            if (System.Threading.Thread.CurrentThread.CurrentUICulture.Name.StartsWith("ja") == true)
            {
                // OS設定が日本語の場合
                csToolName = new HySString("演算結果表示ツール");
            }
            else
            {
                // OS設定が日本語以外の場合
                csToolName = new HySString("Simulation Results Monitor Tool");
            }
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // ↑↑↑　多言語対応　↑↑↑
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            //                              ユニークな値にして下さい。　ランチャーに表示される名称です。  ランチャーに表示されるアイコンです。
            //                                                   ↓　　　　　　　↓　　　　　　　　　　　　　　　↓   
            return new HySUserToolInfoData(MyToolSampleDefine.BUSINESS_KIND, csToolName, new HySString("MySysToolSample.ico"));
        }
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ↑↑↑　上記コードが必須　↑↑↑
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
    }
}
