﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace jp.go.nilim.HyetoHydroGraph_H26
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　グラフ設定画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class McGraphSetForm : Form
    {

        /// <summary>
        /// プロパティ：ハイエト(上)軸ラベル
        /// </summary>
        public string AxisLabelHyeto
        {
            get
            {
                return txtAxisLabelRain.Text;
            }
            set
            {
                txtAxisLabelRain.Text = value;
            }
        }
        /// <summary>
        /// プロパティ：ハイドロ(下)左軸ラベル
        /// </summary>
        public string AxisLabelHydroLeft
        {
            get
            {
                return txtAxisLabelLevel.Text;
            }
            set
            {
                txtAxisLabelLevel.Text = value;
            }
        }
        /// <summary>
        /// プロパティ：ハイドロ(下)右軸ラベル
        /// </summary>
        public string AxisLabelHydroRight
        {
            get
            {
                return txtAxisLabelFlow.Text;
            }
            set
            {
                txtAxisLabelFlow.Text = value;
            }
        }

        /// <summary>
        /// プロパティ：ハイドロ(下)左軸 表示目盛
        /// </summary>
        public float AxisRateHydroLeft
        {
            get
            {
                float fVal = 0;
                float.TryParse(txtAxisRateLevel.Text, out fVal);
                return fVal;
            }
            set
            {
                if(value == 0)
                    txtAxisRateLevel.Text = "";
                else
                    txtAxisRateLevel.Text = value.ToString();
            }
        }
        /// <summary>
        /// プロパティ：ハイドロ(下)右軸 表示目盛
        /// </summary>
        public float AxisRateHydroRight
        {
            get
            {
                float fVal = 0;
                float.TryParse(txtAxisRateFlow.Text, out fVal);
                return fVal;
            }
            set
            {
                if (value == 0)
                    txtAxisRateFlow.Text = "";
                else
                    txtAxisRateFlow.Text = value.ToString();
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphSetForm csHySEvSetForm = new McGraphSetForm() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphSetForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>btnSetGraph_Click(sender, e) </para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            try
            {
                //------------------------------------------------------------
                // 入力チェック
                //------------------------------------------------------------
                //雨量 最大値
                if(!InputCheckNum(txtRainfall_MaxY, lblRainfall_MaxY.Text))
                    return;
                //雨量 最小値
                if (!InputCheckNum(txtRainfall_MinY, lblRainfall_MinY.Text))
                    return;

                //水位 表示目盛
                if (!InputCheckNum(txtAxisRateLevel, lblAxisRateLevel.Text))
                    return;
                //水位 最大値
                if (!InputCheckNum(txtWaterLevel_MaxY, lblWaterLevel_MaxY.Text))
                    return;
                //水位 最小値
                if (!InputCheckNum(txtWaterLevel_MinY, lblWaterLevel_MinY.Text))
                    return;

                //流量 表示目盛
                if (!InputCheckNum(txtAxisRateFlow, lblAxisRateFlow.Text))
                    return;
                //流量 最大値
                if (!InputCheckNum(txtFlowMeter_MaxY, lblFlowMeter_MaxY.Text))
                    return;
                //流量 最小値
                if (!InputCheckNum(txtFlowMeter_MinY, lblFlowMeter_MinY.Text))
                    return;

                //フォントサイズ[2013.02.05]
                if (!InputCheckNum(txtFontSize, lblFontSize.Text))
                    return;

                //------------------------------------------------------------
                //雨量
                if (txtRainfall_MaxY.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_Rainfall_MaxY = Convert.ToSingle(txtRainfall_MaxY.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_Rainfall_MaxY = McGraphViewDefine.g_InvalidValue;
                }
                if (txtRainfall_MinY.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_Rainfall_MinY = Convert.ToSingle(txtRainfall_MinY.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_Rainfall_MinY = McGraphViewDefine.g_InvalidValue;
                }

                //水位
                if (txtWaterLevel_MaxY.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_WaterLevel_MaxY = Convert.ToSingle(txtWaterLevel_MaxY.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_WaterLevel_MaxY = McGraphViewDefine.g_InvalidValue;
                }
                if (txtWaterLevel_MinY.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_WaterLevel_MinY = Convert.ToSingle(txtWaterLevel_MinY.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_WaterLevel_MinY = McGraphViewDefine.g_InvalidValue;
                }

                //流量
                if (txtFlowMeter_MaxY.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_FlowMeter_MaxY = Convert.ToSingle(txtFlowMeter_MaxY.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_FlowMeter_MaxY = McGraphViewDefine.g_InvalidValue;
                }
                if (txtFlowMeter_MinY.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_FlowMeter_MinY = Convert.ToSingle(txtFlowMeter_MinY.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_FlowMeter_MinY = McGraphViewDefine.g_InvalidValue;
                }

                //フォントサイズ[2013.02.05]
                if (txtFontSize.Text.Trim().Length > 0)
                {
                    McGraphViewDefine.g_FontSize = Convert.ToSingle(txtFontSize.Text.Trim());
                }
                else
                {
                    McGraphViewDefine.g_FontSize = McGraphViewDefine.g_InvalidValue;
                }

                this.DialogResult = DialogResult.OK;
                this.Close();
                //this.Dispose();
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphSetForm_Load(sender, e) </para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphSetForm_Load(object sender, EventArgs e)
        {
            //雨量
            if (McGraphViewDefine.g_Rainfall_MaxY != McGraphViewDefine.g_InvalidValue)
            {
                txtRainfall_MaxY.Text = McGraphViewDefine.g_Rainfall_MaxY.ToString();
            }
            if (McGraphViewDefine.g_Rainfall_MinY != McGraphViewDefine.g_InvalidValue)
            {
                txtRainfall_MinY.Text = McGraphViewDefine.g_Rainfall_MinY.ToString();
            }

            //水位
            if (McGraphViewDefine.g_WaterLevel_MaxY != McGraphViewDefine.g_InvalidValue)
            {
                txtWaterLevel_MaxY.Text = McGraphViewDefine.g_WaterLevel_MaxY.ToString();
            }
            if (McGraphViewDefine.g_WaterLevel_MinY != McGraphViewDefine.g_InvalidValue)
            {
                txtWaterLevel_MinY.Text = McGraphViewDefine.g_WaterLevel_MinY.ToString();
            }

            //流量
            if (McGraphViewDefine.g_FlowMeter_MaxY != McGraphViewDefine.g_InvalidValue)
            {
                txtFlowMeter_MaxY.Text = McGraphViewDefine.g_FlowMeter_MaxY.ToString();
            }
            if (McGraphViewDefine.g_FlowMeter_MinY != McGraphViewDefine.g_InvalidValue)
            {
                txtFlowMeter_MinY.Text = McGraphViewDefine.g_FlowMeter_MinY.ToString();
            }

            //文字サイズ[2013.02.05]
            if (McGraphViewDefine.g_FontSize != McGraphViewDefine.g_InvalidValue)
            {
                txtFontSize.Text = McGraphViewDefine.g_FontSize.ToString();
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = InputCheckNum(txt, sCaption) </para>
        /// </example>
        /// <param name="txt">TextBox</param>
        /// <param name="sCaption">項目名</param>
        /// <returns>true=正常/false=入力エラーあり</returns>
        private bool InputCheckNum(TextBox txt, string sCaption)
        {
            if (!string.IsNullOrEmpty(txt.Text) && txt.Text.Trim().Length != 0)
            {   //入力あり
                float fVal = 0;
                if (!float.TryParse(txt.Text.Trim(), out fVal))
                {
                    //{0}には数値を入力して下さい。
                    MessageBox.Show(string.Format(Properties.HysAddinHydroHyetoGraphResources.MSG_ERROR_INPUT_NUMERICAL_VALUE, sCaption),
                        Properties.HysAddinHydroHyetoGraphResources.CAPTION_INPUT_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txt.Focus();
                    return false;
                }
            }
            return true;
        }

    }
}
