// <summary>ソースコード：グラフ表示モジュール　メイン画面フォーム</summary>
// <author>CommonMP</author>
using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using System.Runtime.InteropServices;   //[2013.01.05]
using System.Reflection;                //[2013.01.05]

namespace jp.go.nilim.HyetoHydroGraph_H26
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　メイン画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class McGraphViewDotNetForm : HySDotNetAddInBaseForm //[2013.01.18]パッケージ化
    {
        /// <summary> 制御するクリーン </summary>
        protected McGraphViewDotNetScreen m_csGraphViewScreen = null;
        /// <summary> 雨量データフォルダ </summary>
        private String m_Folder_Rainfall = "";
        /// <summary> 水位データフォルダ </summary>
        private String m_Folder_WaterLevel = "";
        /// <summary> 流量データフォルダ </summary>
        private String m_Folder_FlowMeter = "";
        /// <summary> 断面図データフォルダ </summary>
        private String m_Folder_Danmen = "";

        /// <summary> 期間開始 </summary>
        public DateTime m_DtStart;
        /// <summary> 期間終了 </summary>
        public DateTime m_DtEnd;
        /// <summary> グラフ縦軸数 </summary>
        private int m_X_Num = 0;

        /// <summary> 雨量データリスト </summary>
        public McGraphViewRainfallItems[] m_RainfallItems = null;
        /// <summary> 雨量グラフY軸の最大値 </summary>
        private float m_RainfallMaxY = 10.0F;	// グラフY軸の最大値
        /// <summary> 雨量グラフY軸の最小値 </summary>
        private float m_RainfallMinY = 10.0F;	// グラフY軸の最小値
        /// <summary> 雨量グラフY軸のセパレート値 </summary>
        private float m_RainfallSepY = 2.0F;	// グラフY軸のセパレート値

        /// <summary> 水位データリスト </summary>
        public McGraphViewWaterLevelItems[] m_WaterLevelItems = null;
        /// <summary> 水位グラフY軸の最大値 </summary>
        private float m_WaterLevelMaxY = 5.0F;	// グラフY軸の最大値
        /// <summary> 水位グラフY軸の最大値 </summary>
        private float m_WaterLevelMinY = -5.0F;	// グラフY軸の最大値
        /// <summary> 水位グラフY軸のセパレート値 </summary>
        private float m_WaterLevelSepY = 1.0F;	// グラフY軸のセパレート値

        /// <summary> 基準水位数 </summary>
        private int m_BaseWaterLevelNum = 0;        //基準水位
        /// <summary> 基準水位リスト（名称） </summary>
        private String[] m_sBaseWaterLevel = null;  //基準水位
        /// <summary> 基準水位リスト </summary>
        private float[] m_fBaseWaterLevel = null;   //基準水位
        /// <summary> 断面図リスト数 </summary>
        private int m_DanmenListNum = 0;
        /// <summary> 断面図X、Yリスト </summary>
        private float[,] m_DanmenList = null;

        /// <summary> 断面図グラフY軸の最大値 </summary>
        private float m_DanmenMaxY = 0.0F;	// グラフY軸の最大値
        /// <summary> 断面図グラフY軸の最大値 </summary>
        private float m_DanmenMinY = 0.0F;	// グラフY軸の最大値
        /// <summary> 断面図グラフX軸の最大値 </summary>
        private float m_DanmenMaxX = 0.0F;	// グラフX軸の最大値
        /// <summary> 断面図グラフX軸の最大値 </summary>
        private float m_DanmenMinX = 0.0F;	// グラフX軸の最大値

        /// <summary> 流量データリスト </summary>
        public McGraphViewFlowMeterItems[] m_FlowMeterItems = null;
        /// <summary> 流量グラフY軸の最大値 </summary>
        private float m_FlowMeterMaxY = 50.0F;	// グラフY軸の最大値
        /// <summary> 流量グラフY軸の最大値 </summary>
        private float m_FlowMeterMinY = 0.0F;	// グラフY軸の最大値
        
        
        /// <summary> 水位グラフY軸の表示目盛掛け率 </summary>
        private float m_WaterLevelRateY = 0.0F;     //add 2011.03.08
        /// <summary> 流量グラフY軸の表示目盛掛け率 </summary>
        private float m_FlowMeterRateY = 0.0F;      //add 2011.03.08
      

        /// <summary> グラフ自動調整表示の有無 </summary>
        private bool m_IsAutoFit = true;    //[2010.06.03]

// start of 印刷機能追加
        //印刷用・領域取得関数のインポート
        [System.Runtime.InteropServices.DllImport(@"C:\WINDOWS\system32\gdi32.dll")]
        private static extern int BitBlt(IntPtr hDestDC, int x, int y, int nWidth, int nHeight,
                                         IntPtr hSrcDC, int xSrc, int ySrc, int dwRop);

        /// <summary>印刷用ビットマップ</summary>
        private Bitmap m_bit_img = null;//印刷用ビットマップ

        /// <summary>印刷用プリントドキュメント</summary>
        private System.Drawing.Printing.PrintDocument m_pd = null;
// end of 印刷機能追加

        /// <summary> 描画設定ファイル（絶対パス） </summary>
        private string m_RestoreDrawFileName = "";

        #region 内部メソッド

        #region "相対パス取得"
        private string _getRelativePath(string h_fileName)
        {
            /*
            Uri a_targetPath = new Uri(McGraphViewDefine.g_uriCommonMP_Path, h_fileName);
            string a_relativePath = McGraphViewDefine.g_uriCommonMP_Path.MakeRelativeUri(a_targetPath).ToString();
             */
            // add 150708
            // 設定ファイルを起点とした相対パスに変換する。
            Uri a_RestoreDrawFile_Path = new Uri(m_RestoreDrawFileName);
            Uri a_targetPath = new Uri(a_RestoreDrawFile_Path, h_fileName);
            string a_relativePath = a_RestoreDrawFile_Path.MakeRelativeUri(a_targetPath).ToString();
            // end add 150708

            //URLデコードして、'/'を'\'に変更する
            a_relativePath = System.Web.HttpUtility.UrlDecode(a_relativePath).Replace('/', '\\');

            return a_relativePath;
        }
        #endregion
        #region "絶対パス取得"
        private string _getLocalPath(string h_fileName)
        {
            // add 150708
            Uri a_targetPath;
            // ファイルの相対パスがツール実行形式を起点とする相対パスで書かれている場合
            if(h_fileName.IndexOf("CommonMPData") > -1)
            {
                a_targetPath = new Uri(McGraphViewDefine.g_uriCommonMP_Path, h_fileName);
                //string a_localPath = System.Web.HttpUtility.UrlDecode(a_targetPath.LocalPath.ToString()).Replace('/', '\\');
                //return a_localPath;
            }
            // ファイルの相対パスがグラフ設定ファイルを起点とする相対パスで書かれている場合
            else
            {
                a_targetPath = new Uri(new Uri(m_RestoreDrawFileName), h_fileName);
                //string a_localPath = System.Web.HttpUtility.UrlDecode(a_targetPath.LocalPath.ToString()).Replace('/', '\\');
                //return a_localPath;
            }
            // end add 150708

            return a_targetPath.LocalPath;
        }
        #endregion

        #region 最大値調整[2013.01.24]
        private float _adjustMaxVal(float h_max)
        {
            float a_fRet = h_max;
            a_fRet = (float)Math.Ceiling(h_max);
            /*
            if (h_max >= 0)
                a_fRet = (float)Math.Ceiling(h_max);
            else
                a_fRet = (float)Math.Floor(h_max);
            */

            return a_fRet;
        }
        #endregion
        #region 最小値調整[2013.01.24]
        private float _adjustMinVal(float h_min)
        {
            float a_fRet = h_min;
            a_fRet = (float)Math.Floor(h_min);
            /*
            if (h_min >= 0)
                a_fRet = (float)Math.Ceiling(h_min);
            else
                a_fRet = (float)Math.Floor(h_min);
            */

            return a_fRet;
        }
        #endregion

        #region フォルダ選択
        /// <summary><para>method outline:</para>
        /// <para>フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_selectFolder(ref h_folder, h_textBox);</para>
        /// </example>
        /// <param name="h_folder">フォルダ名</param>
        /// <param name="h_textBox">フォルダ名格納テキストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _selectFolder(
            ref String h_folder,
            System.Windows.Forms.TextBox h_textBox
            )
        {
            try
            {
                //FolderBrowserDialogクラスのインスタンスを作成
                FolderBrowserDialog a_fbd = new FolderBrowserDialog();

                //上部に表示する説明テキストを指定する
                //フォルダを指定してください。
                a_fbd.Description = Properties.HysAddinHydroHyetoGraphResources.MSG_INFO_SPECIFY_FOLDER;
                //ルートフォルダを指定する
                //デフォルトでDesktop
                //a_fbd.RootFolder = Environment.SpecialFolder.Desktop;
                //a_fbd.RootFolder = Environment.SpecialFolder.Desktop;
                //最初に選択するフォルダを指定する
                //RootFolder以下にあるフォルダである必要がある
                a_fbd.SelectedPath = System.IO.Directory.GetCurrentDirectory();
                //a_fbd.SelectedPath = @"C:\Windows";
                //ユーザーが新しいフォルダを作成できるようにする
                //デフォルトでTrue
                a_fbd.ShowNewFolderButton = true;

                //ダイアログを表示する
                if (a_fbd.ShowDialog(this) == DialogResult.OK)
                {
                    //選択されたフォルダを表示する
                    h_folder = a_fbd.SelectedPath.Trim();
                    h_textBox.Text = h_folder;
                    //Console.WriteLine(a_fbd.SelectedPath);
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region ファイル選択
        /// <summary><para>method outline:</para>
        /// <para>ファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_selectFile(ref h_folder, h_textBox);</para>
        /// </example>
        /// <param name="h_folder">フォルダ名</param>
        /// <param name="h_textBox">フォルダ名格納テキストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _selectFile(
            System.Windows.Forms.TextBox h_textBox
            )
        {
            try
            {
                //OpenFileDialogクラスのインスタンスを作成
                OpenFileDialog a_ofd = new OpenFileDialog();

                //はじめのファイル名を指定する
                //はじめに「ファイル名」で表示される文字列を指定する
                //a_ofd.FileName = "default.csv";
                //はじめに表示されるフォルダを指定する
                //指定しない（空の文字列）の時は、現在のディレクトリが表示される
                //a_ofd.InitialDirectory = Properties.HysAddinHydroHyetoGraphResources.MSG_INFO_SPECIFY_FOLDER;
                //[ファイルの種類]に表示される選択肢を指定する
                //指定しないとすべてのファイルが表示される
                //a_ofd.Filter =
                //    "csvファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*";
                a_ofd.Filter = Properties.Resources.STRING_OPENFILEDIALOG_FILTER;            // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_ofd.FilterIndex = 1;
                //タイトルを設定する
                //a_ofd.Title = "開くファイルを選択してください";
                a_ofd.Title = Properties.Resources.STRING_OPENFILEDIALOG_TITLE;              // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_ofd.InitialDirectory = McGraphViewDefine.g_sCommonMPData_Path;
                //a_ofd.RestoreDirectory = true;
                //存在しないファイルの名前が指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckFileExists = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_ofd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_ofd.FileName);
                    // add 150708
                    //h_textBox.Text = _getRelativePath(a_ofd.FileName);  //[2013.02.05]
                    h_textBox.Text = a_ofd.FileName; // 相対パスから絶対パスに変更
                    // end add 150708
                    h_textBox.SelectionStart = h_textBox.Text.Length;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region ファイルリストの設定（チェックリストボックス）
        /// <summary><para>method outline:</para>
        /// <para>ファイルリストの設定（チェックリストボックス）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setFileCheckListBoxByFolder(ref h_folder, h_clb);</para>
        /// </example>
        /// <param name="h_folder">フォルダ</param>
        /// <param name="h_clb">チェックリストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setFileCheckListBoxByFolder(
            String h_folder,
            System.Windows.Forms.CheckedListBox h_clb
            )
        {
            try{
                h_clb.Items.Clear();

                //String a_currentPath = System.IO.Directory.GetCurrentDirectory();

                //System.IO.Directory.SetCurrentDirectory(h_folder);

                //"C:\My Documents"以下のファイルをすべて取得
                string[] a_files = System.IO.Directory.GetFiles(
                    h_folder, "*.csv", System.IO.SearchOption.TopDirectoryOnly);

                for(int a_iCnt = 1; a_iCnt <= a_files.Length; a_iCnt++){
                    a_files[a_iCnt - 1] = a_files[a_iCnt - 1].Replace(h_folder,"").Replace("\\","");
                }

                //ListBox1に結果を表示する
                h_clb.Items.AddRange(a_files);

                //System.IO.Directory.SetCurrentDirectory(a_currentPath);
            }
            catch(Exception exp){
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region ファイルリストの設定（リストボックス）
        /// <summary><para>method outline:</para>
        /// <para>ファイルリストの設定（リストボックス）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setFileListBoxByFolder(ref h_folder, h_lb);</para>
        /// </example>
        /// <param name="h_folder">フォルダ名</param>
        /// <param name="h_lb">リストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setFileListBoxByFolder(
            String h_folder,
            System.Windows.Forms.ListBox h_lb
            )
        {
            try
            {
                h_lb.Items.Clear();

                //String a_currentPath = System.IO.Directory.GetCurrentDirectory();

                //System.IO.Directory.SetCurrentDirectory(h_folder);

                //"C:\My Documents"以下のファイルをすべて取得
                string[] a_files = System.IO.Directory.GetFiles(
                    h_folder, "*.csv", System.IO.SearchOption.TopDirectoryOnly);

                for (int a_iCnt = 1; a_iCnt <= a_files.Length; a_iCnt++)
                {
                    a_files[a_iCnt - 1] = a_files[a_iCnt - 1].Replace(h_folder, "").Replace("\\", "");
                }

                //ListBox1に結果を表示する
                h_lb.Items.AddRange(a_files);

                //System.IO.Directory.SetCurrentDirectory(a_currentPath);
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 雨量実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>雨量実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readRainfallCSVFile(ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_items">McGraphViewRainfallItems：雨量データリスト</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readRainfallCSVFile(
            ref McGraphViewRainfallItems h_items,
            string h_fname
            )
        {
            try
            {
                //h_items.Clear();
                //m_RainfallMaxY = 0;
                //m_RainfallMaxX = -1;
                /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                Boolean a_IsFound = false;
                String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fname), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_RainfallMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().Length > 0)   //[2013.02.04]不当なデータを無視
                        {
                            //********** 速度改善他対応 2011.03.04 add_s **************************************************
                            DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                            decimal fValue = decimal.Parse(a_split[1].Trim());         //Data0


                            if (cs_DTChange > m_DtEnd)
                                break;      //期間終了を超えたら読込み終了
                            if (cs_DTChange < m_DtStart)
                                continue;   //期間開始に達していない場合は読み飛ばし

                            string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");


                            while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                            {   //格納する時刻インデックスまで進める
                                iDataIdx++;
                            }
                            if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                            {   //時刻が一致するなら格納
                                h_items[iDataIdx].Rainfall = fValue;
                                h_items[iDataIdx].IsData = true;    //[2013.02.04]

                                //最小・最大値セット
                                if (fValue != (decimal)McGraphViewDefine.g_InvalidValue)
                                {   //欠測値以外なら最小・最大値セット
                                    if (iTargetCnt == 0)
                                    {   //最初の対象となるデータの場合、最小・最大値を初期化
                                        m_RainfallMaxY = (float)fValue;
                                    }
                                    m_RainfallMaxY = Math.Max(m_RainfallMaxY, (float)fValue);

                                    iTargetCnt++;
                                }
                            }
                            //********** 速度改善他対応 2011.03.04 add_e **************************************************

                            /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                            //雨量は水位よりも１つ分少なくなる。
                            for (int a_iCnt = 0; a_iCnt < m_X_Num; a_iCnt++)
                            {
                                //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                                if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart)>=0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd)<=0))
                                {
                                    if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm")) == true)
                                    {
                                        if (a_IsFound == false)
                                        {
                                            m_RainfallMaxY = McGraphViewDefine.g_InvalidValue;
                                            a_IsFound = true;
                                        }

                                        h_items[a_iCnt].Rainfall = Convert.ToSingle(a_split[1].Trim());

                                        //[2010.06.01]bug-fixed.↓
                                        if (h_items[a_iCnt].Rainfall != McGraphViewDefine.g_InvalidValue)
                                        {
                                            if (h_items[a_iCnt].Rainfall > m_RainfallMaxY)
                                            {
                                                m_RainfallMaxY = h_items[a_iCnt].Rainfall;
                                            }
                                        }
                                        //[2010.06.01]bug-fixed.↑

                                        break;
                                    }
                                }
                            }
                            //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                        }
                    }
                }

                //[2010.06.02]↓
                //[2010.06.02]↑

                //[2013.01.23]---↓
                //雨量データの補正（学術的？）
                DateTime a_dateVal;
                decimal a_dVal = 0;
                for (int a_i = h_items.Count - 1; a_i >= 0; a_i--)
                {
                    if (a_i == (h_items.Count - 1))
                    {   //最後のデータ
                        a_dateVal = DateTime.Parse(h_items[h_items.Count - 1].sTimeOrDay);
                        a_dVal = h_items[a_i].Rainfall;
                    }
                    else
                    {
                        if ((h_items[a_i].Rainfall == 0)
                            || (h_items[a_i].Rainfall == (decimal)McGraphViewDefine.g_InvalidValue2))
                        {   //データなし
                            h_items[a_i].Rainfall = a_dVal;
                        }
                        else
                        {   //データあり
                            a_dateVal = DateTime.Parse(h_items[h_items.Count - 1].sTimeOrDay);
                            a_dVal = h_items[a_i].Rainfall;
                        }

                        //時刻を退避
                        /*
                        DateTime a_dtChk = DateTime.Parse(h_items[a_i].sTimeOrDay);
                        //正時かどうか判定
                        if (a_dtChk.Minute == 0)
                        {   //正時
                            if (h_items[a_i].Rainfall == (decimal)McGraphViewDefine.g_InvalidValue2)
                            {   //データなし
                                h_items[a_i].Rainfall = a_dVal;
                            }
                            else
                            {   //データあり
                                a_dateVal = DateTime.Parse(h_items[h_items.Count - 1].sTimeOrDay);
                                a_dVal = h_items[a_i].Rainfall;
                            }
                        }
                        else
                        {
                            //正時でない
                            if (h_items[a_i].Rainfall == (decimal)McGraphViewDefine.g_InvalidValue2)
                            {   //データなし
                                h_items[a_i].Rainfall = a_dVal;
                            }
                            else
                            {   //データあり
                                a_dateVal = DateTime.Parse(h_items[h_items.Count - 1].sTimeOrDay);
                                a_dVal = h_items[a_i].Rainfall;
                            }
                        }
                        */ 
                    }
                }
                //[2013.01.23]---↑
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 水位実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>水位実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readWaterLevelCSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McGraphViewWaterLevelItems：水位データリスト</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readWaterLevelCSVFile(
            int h_idx,  //[2010.05.07]
            ref McGraphViewWaterLevelItems h_items,
            string h_fname
            )
        {
            try
            {
                //h_items.Clear();
                //m_WaterLevelMaxY = 0;
                //m_WaterLevelMinY = 0;
                //m_WaterLevelMaxX = -1;
                /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                Boolean a_IsFound = false;
                String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fname), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().Length > 0)   //[2013.02.04]不当なデータを無視
                        {
                            //********** 速度改善他対応 2011.03.04 add_s **************************************************
                            DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                            decimal fValue = decimal.Parse(a_split[1].Trim());         //Data0
                            if (m_WaterLevelRateY != 0 && fValue != (decimal)McGraphViewDefine.g_InvalidValue)
                            {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                                fValue *= (decimal)m_WaterLevelRateY;
                            }

                            if (cs_DTChange > m_DtEnd)
                                break;      //期間終了を超えたら読込み終了
                            if (cs_DTChange < m_DtStart)
                                continue;   //期間開始に達していない場合は読み飛ばし

                            string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                            while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                            {   //格納する時刻インデックスまで進める
                                iDataIdx++;
                            }
                            if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                            {   //時刻が一致するなら格納
                                h_items[iDataIdx].WaterLevel = fValue;

                                //最小・最大値セット
                                if (fValue != (decimal)McGraphViewDefine.g_InvalidValue)
                                {   //欠測値以外なら最小・最大値セット
                                    if (h_idx == 0 && iTargetCnt == 0)
                                    {   //最初の対象となるデータの場合、最小・最大値を初期化
                                        m_WaterLevelMinY = (float)fValue;
                                        m_WaterLevelMaxY = (float)fValue;
                                    }
                                    m_WaterLevelMinY = Math.Min(m_WaterLevelMinY, (float)fValue);
                                    m_WaterLevelMaxY = Math.Max(m_WaterLevelMaxY, (float)fValue);

                                    iTargetCnt++;
                                }
                            }
                            //********** 速度改善他対応 2011.03.04 add_e **************************************************

                            /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                            for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                            {
                                //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                                if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                                {
                                    if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm")) == true)
                                    {
                                        if (a_IsFound == false)
                                        {
                                            if (h_idx == 0) //[2010.05.07]
                                            {
                                                m_WaterLevelMaxY = 0;   // McGraphViewDefine.g_InvalidValue;
                                                m_WaterLevelMinY = 0;   // McGraphViewDefine.g_InvalidValue;
                                            }
                                            a_IsFound = true;
                                        }

                                        h_items[a_iCnt].WaterLevel = Convert.ToSingle(a_split[1].Trim());

                                        //[2010.06.01]bug-fixed.↓
                                        if (h_items[a_iCnt].WaterLevel != McGraphViewDefine.g_InvalidValue)
                                        {
                                            if (h_items[a_iCnt].WaterLevel > m_WaterLevelMaxY)
                                            {
                                                m_WaterLevelMaxY = h_items[a_iCnt].WaterLevel;
                                            }
                                            if (h_items[a_iCnt].WaterLevel < m_WaterLevelMinY)
                                            {
                                                m_WaterLevelMinY = h_items[a_iCnt].WaterLevel;
                                            }
                                        }
                                        //[2010.06.01]bug-fixed.↑

                                        break;
                                    }
                                }
                            }
                            //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                        }
                    }
                }

                if (m_WaterLevelMaxY == 0.0F)
                {
                    m_WaterLevelMaxY = 5.0F;
                }

                m_WaterLevelMaxY = Convert.ToSingle(Math.Ceiling(m_WaterLevelMaxY));

                float a_fTmp = Math.Abs(m_WaterLevelMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_WaterLevelMinY < 0)
                {
                    m_WaterLevelMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 流量実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>流量実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readWaterLevelCSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McGraphViewFlowMeterItems：流量データリスト</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readFlowMeterCSVFile(
            int h_idx,  //[2010.05.07]
            ref McGraphViewFlowMeterItems h_items,
            string h_fname
            )
        {
            try
            {
                //h_items.Clear();
                //m_FlowMeterMaxY = 0;
                //m_FlowMeterMinY = 0;
                //m_FlowMeterMaxX = -1;
                /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                Boolean a_IsFound = false;
                String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fname), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_FlowMeterMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().Length > 0)   //[2013.02.04]不当なデータを無視
                        {
                            //********** 速度改善他対応 2011.03.04 add_s **************************************************
                            DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                            decimal fValue = decimal.Parse(a_split[1].Trim());         //Data0
                            if (m_FlowMeterRateY != 0 && fValue != (decimal)McGraphViewDefine.g_InvalidValue)
                            {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                                fValue *= (decimal)m_FlowMeterRateY;
                            }

                            if (cs_DTChange > m_DtEnd)
                                break;      //期間終了を超えたら読込み終了
                            if (cs_DTChange < m_DtStart)
                                continue;   //期間開始に達していない場合は読み飛ばし

                            string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                            while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                            {   //格納する時刻インデックスまで進める
                                iDataIdx++;
                            }
                            if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                            {   //時刻が一致するなら格納
                                h_items[iDataIdx].FlowMeter = fValue;

                                //最小・最大値セット
                                if (fValue != (decimal)McGraphViewDefine.g_InvalidValue)
                                {   //欠測値以外なら最小・最大値セット
                                    if (h_idx == 0 && iTargetCnt == 0)
                                    {   //最初の対象となるデータの場合、最小・最大値を初期化
                                        m_FlowMeterMinY = (float)fValue;
                                        m_FlowMeterMaxY = (float)fValue;
                                    }
                                    m_FlowMeterMinY = Math.Min(m_FlowMeterMinY, (float)fValue);
                                    m_FlowMeterMaxY = Math.Max(m_FlowMeterMaxY, (float)fValue);

                                    iTargetCnt++;
                                }
                            }
                            //********** 速度改善他対応 2011.03.04 add_e **************************************************

                            /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                            for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                            {
                                //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                                if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                                {
                                    if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm")) == true)
                                    {
                                        if (a_IsFound == false)
                                        {
                                            if (h_idx == 0) //[2010.05.07]
                                            {
                                                m_FlowMeterMaxY = 0;    // McGraphViewDefine.g_InvalidValue;
                                                m_FlowMeterMinY = 0;    // McGraphViewDefine.g_InvalidValue;
                                            }
                                            a_IsFound = true;
                                        }

                                        h_items[a_iCnt].FlowMeter = Convert.ToSingle(a_split[1].Trim());

                                        //[2010.06.01]bug-fixed.↓
                                        if (h_items[a_iCnt].FlowMeter != McGraphViewDefine.g_InvalidValue)
                                        {
                                            if (h_items[a_iCnt].FlowMeter > m_FlowMeterMaxY)
                                            {
                                                m_FlowMeterMaxY = h_items[a_iCnt].FlowMeter;
                                            }
                                            if (h_items[a_iCnt].FlowMeter < m_FlowMeterMinY)
                                            {
                                                m_FlowMeterMinY = h_items[a_iCnt].FlowMeter;
                                            }
                                        }
                                        //[2010.06.01]bug-fixed.↑

                                        break;
                                    }
                                }
                            }
                            //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                        }
                    }
                }

                if (m_FlowMeterMaxY == 0.0F)
                {
                    m_FlowMeterMaxY = 50.0F;
                }

                m_FlowMeterMaxY = Convert.ToSingle(Math.Ceiling(m_FlowMeterMaxY));

                float a_fTmp = Math.Abs(m_FlowMeterMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_FlowMeterMinY < 0)
                {
                    m_FlowMeterMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 断面データの読み込み
        /// <summary><para>method outline:</para>
        /// <para>断面データの読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDanmenCSVFile(h_fname);</para>
        /// </example>
        /// <param name="h_fname">ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDanmenCSVFile(
            string h_fname
            )
        {
            try
            {
                m_BaseWaterLevelNum = 0;
                m_sBaseWaterLevel = null;
                m_fBaseWaterLevel = null;   
                m_DanmenListNum = 0;
                m_DanmenList = null;
                m_DanmenMaxY = 0;
                m_DanmenMinY = 0;
                m_DanmenMaxX = 0;
                m_DanmenMinX = 0;

                int a_iCnt = 0;

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fname), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //1行目：基準水位タイトル
                    a_sLine = a_sr.ReadLine();
                    //2行目：基準水位の数
                    a_sLine = a_sr.ReadLine();
                    m_BaseWaterLevelNum = Convert.ToInt32(a_sLine);
                    m_sBaseWaterLevel = new String[m_BaseWaterLevelNum];
                    m_fBaseWaterLevel = new float[m_BaseWaterLevelNum];
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        a_split = a_sLine.Split(a_delimiter);
                        m_sBaseWaterLevel[a_iCnt] = a_split[0];
                        m_fBaseWaterLevel[a_iCnt] = Convert.ToSingle(a_split[1]);
                        a_iCnt++;
                        if (a_iCnt >= m_BaseWaterLevelNum)
                        {
                            break;
                        }
                    }

                    //1行目：断面タイトル
                    a_sLine = a_sr.ReadLine();
                    //2行目：断面の数
                    a_sLine = a_sr.ReadLine();
                    m_DanmenList = new float[Convert.ToInt32(a_sLine.Trim()), 2];
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //0：X、1：Y
                        a_split = a_sLine.Split(a_delimiter);

                        m_DanmenList[m_DanmenListNum, 0] = Convert.ToSingle(a_split[0]);
                        //m_DanmenList[m_DanmenListNum, 0] = m_DanmenListNum;
                        m_DanmenList[m_DanmenListNum, 1] = Convert.ToSingle(a_split[1]);

                        //X軸
                        if (m_DanmenList[m_DanmenListNum, 0] > m_DanmenMaxX)
                        {
                            m_DanmenMaxX = m_DanmenList[m_DanmenListNum, 0];
                        }
                        if (m_DanmenList[m_DanmenListNum, 0] < m_DanmenMinX)
                        {
                            m_DanmenMinX = m_DanmenList[m_DanmenListNum, 0];
                        }
                        //Y軸
                        if (m_DanmenList[m_DanmenListNum, 1] > m_DanmenMaxY)
                        {
                            m_DanmenMaxY = m_DanmenList[m_DanmenListNum, 1];
                        }
                        if (m_DanmenList[m_DanmenListNum, 1] < m_DanmenMinY)
                        {
                            m_DanmenMinY = m_DanmenList[m_DanmenListNum, 1];
                        }

                        m_DanmenListNum++;
                    }
                }

                m_DanmenMaxY = Convert.ToSingle(Math.Ceiling(m_DanmenMaxY));
                float a_fTmp = Math.Abs(m_DanmenMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_DanmenMinY < 0)
                {
                    m_DanmenMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 雨量描画
        /// <summary><para>method outline:</para>
        /// <para>雨量描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawRainfall();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawRainfall()
        {
            try
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iX_Num = m_X_Num;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************
                m_RainfallMaxY = 10.0F;	// グラフY軸の最大値
                m_RainfallMinY = 0.0F;	// グラフY軸の最小値
                m_RainfallSepY = 2.0F;	// グラフY軸のセパレート値

                //McGraphViewRainfallItems[] a_items = null;
                m_RainfallItems = null;

                int a_idx = 0;
                m_RainfallItems = new McGraphViewRainfallItems[lbRainfall.SelectedItems.Count];
                foreach (string a_sVal in lbRainfall.SelectedItems)
                {
                    m_RainfallItems[a_idx] = new McGraphViewRainfallItems();
                    m_RainfallItems[a_idx].FileName = a_sVal;

                    //凡例リストから色を取得
                    m_RainfallItems[a_idx].LineColor = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION, a_sVal);    //雨量


                    /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                    //雨量は水位よりも１個分少なくなる
                    //[2010.03.07]
                    for (int a_iCnt = 1; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        McGraphViewRainfallItem a_item = new McGraphViewRainfallItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt*10).ToString("yyyy/MM/dd HH:mm");
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            //a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                        }
                        a_item.TimeOrDay = a_iCnt - 1;  //雨量は水位よりも１個分少なくなる。
                        a_item.Rainfall = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.Rainfall = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_RainfallItems[a_idx].Add(a_item);	// Listに追加
                    }
                    //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                    //********** 速度改善他対応 2011.03.04 add_s **************************************************
                    //入力データ間隔を調べる
                    int iTimeStep = 60;     //雨量データ間隔(分)
                    string sLine = null;
                    int iLine = 0;
                    DateTime[] dteTime = {m_DtStart, m_DtStart};
                    //using (StreamReader reader = new StreamReader(m_Folder_Rainfall + "\\" + a_sVal, System.Text.Encoding.GetEncoding(932)))  //[2013.01.04]
                    using (StreamReader reader = new StreamReader(
                        _getLocalPath(a_sVal), System.Text.Encoding.GetEncoding(932)))   //[2013.02.05]
                    {
                        while ((sLine = reader.ReadLine()) != null)
                        {
                            iLine++;
                            if (iLine <= 3)
                            {
                                continue;  //ヘッダー3行読み飛ばし
                            }
                            else if (iLine <= 5)
                            {
                                string[] cols = sLine.Split(',');
                                dteTime[iLine - 4] = DateTime.Parse(cols[0].Trim());
                                if ((iLine - 4) == 1)
                                {   //2件データを読んだら、間隔を調べる
                                    TimeSpan tsDlt = dteTime[1] - dteTime[0];
                                    iTimeStep = Convert.ToInt32(tsDlt.TotalMinutes);
                                    break;
                                }
                            }
                        }
                    }

                    //雨量は「分単位/時間単位」の選択にかかわらず、入力データ間隔を優先
                    TimeSpan ts = m_DtEnd - m_DtStart;
                    iX_Num = Convert.ToInt32(ts.TotalMinutes / iTimeStep);
                    for (int a_iCnt = 1; a_iCnt <= iX_Num; a_iCnt++)
                    {
                        McGraphViewRainfallItem a_item = new McGraphViewRainfallItem();
                        a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt * iTimeStep).ToString("yyyy/MM/dd HH:mm");
                        a_item.TimeOrDay = a_iCnt - 1;                          //雨量は水位よりも１個分少なくなる。
                        a_item.Rainfall = (decimal)McGraphViewDefine.g_InvalidValue2;
                        m_RainfallItems[a_idx].Add(a_item);	                    // Listに追加
                    }
                    //********** 速度改善他対応 2011.03.04 add_e **************************************************

                    _readRainfallCSVFile(
                        ref m_RainfallItems[a_idx],
                        a_sVal //m_Folder_Rainfall + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }

                //[2010.06.02]↓
                //Y軸最大値
                if (McGraphViewDefine.g_Rainfall_MaxY == McGraphViewDefine.g_InvalidValue)
                {
                    if (m_RainfallMaxY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_RainfallMaxY = 10.0F;
                    }
                }
                else
                {
                    m_RainfallMaxY = McGraphViewDefine.g_Rainfall_MaxY;
                }
                //Y軸最小値
                if (McGraphViewDefine.g_Rainfall_MinY == McGraphViewDefine.g_InvalidValue)
                {
                    //m_RainfallMinY = 0.0F;
                }
                else
                {
                    m_RainfallMinY = McGraphViewDefine.g_Rainfall_MinY;
                }

                //[2013.01.24]---↓
                if (McGraphViewDefine.g_Rainfall_MaxY == McGraphViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_RainfallMaxY = _adjustMaxVal(m_RainfallMaxY);
                }
                else
                {   //最大値の指定がある場合
                }

                if (McGraphViewDefine.g_Rainfall_MinY == McGraphViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_RainfallMinY = _adjustMinVal(m_RainfallMinY);
                }
                else
                {   //最小値の指定がある場合
                }
                m_RainfallSepY = (m_RainfallMaxY - m_RainfallMinY) / McGraphViewDefine.g_Rainfall_SepNumY;

                /*
                double a_dLen = Math.Ceiling(m_RainfallMaxY - m_RainfallMinY);
                int a_iLen = 0;
                if (a_dLen > 5)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 5);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                m_RainfallSepY = a_iLen;

                if ((Math.Abs(m_RainfallMaxY) % m_RainfallSepY) != 0)
                {
                    m_RainfallMaxY += (m_RainfallSepY - (Math.Abs(m_RainfallMaxY) % m_RainfallSepY));
                }
                if ((Math.Abs(m_RainfallMinY) % m_RainfallSepY) != 0)
                {
                    m_RainfallMinY -= (m_RainfallSepY - (Math.Abs(m_RainfallMinY) % m_RainfallSepY));
                }
                */
                //[2013.01.24]---↑
                //[2010.06.02]↑

                McGraphViewRainfall a_gw = new McGraphViewRainfall();

                a_gw.m_sep_bottom = 10;
                a_gw.m_sep_left = 40;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2010.03.07]
                a_gw.m_sep_top = 20;    //[2013.01.24]

                a_gw.ImageWidth = this.picRainfall.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picRainfall.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = McGraphViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_RainfallMaxY;	// グラフY軸の最大値
                a_gw.GraphMinY = m_RainfallMinY;	// グラフY軸の最小値
                a_gw.GraphSepY = m_RainfallSepY;	// グラフY軸のセパレート値
                a_gw.SepNumY = McGraphViewDefine.g_Rainfall_SepNumY;   //[2013.01.24] 
                a_gw.GraphMeasureYFormat = "###,###,##0";  //[2013.01.24]
                //********** 速度改善他対応 2011.03.04 mod_s **************************************************
                //a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMaxX = iX_Num;		// グラフX軸の最大値
                //********** 速度改善他対応 2011.03.04 mod_e **************************************************
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;   //[2010.03.07]

                /*
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_gw.GraphSepX = 1;
                    //a_gw.GraphSepX = 6F;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_gw.GraphSepX = 1;
                }
                 */
 
                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = true;	// Y軸の反転

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                /*
                if (m_RainfallItems.Count > 0)
                {
                    a_gw.GraphHasMeasureX = true;   // X軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                }
                 **/
                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                /*
                if (m_RainfallItems.Count > 0)
                {
                    a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureY = false;   // Y軸の目盛表示
                }
                 */
                //a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式[2013.01.24]
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                //[2013.02.05]フォントサイズ---↓
                if (McGraphViewDefine.g_FontSize != McGraphViewDefine.g_InvalidValue)
                {
                    a_gw.m_font1 = new Font(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_NAME,
                                    McGraphViewDefine.g_FontSize);
                }
                else
                {
                    a_gw.m_font1 = new Font(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_NAME,
                                    float.Parse(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_SIZE));
                }
                //[2013.02.05]フォントサイズ---↑

                int a_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_mode = 1;
                }
                a_gw.InitGraph(m_DtStart, m_DtEnd, a_mode);	//[2010.03.07] グラフの初期化

                if (m_RainfallItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_RainfallItems.Length; a_iCnt++)
                    {
                        a_gw.SetRainfallItems(m_RainfallItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                a_gw.DrawGraphBackGround();	// グラフの初期化

                this.picRainfall.Image = a_gw.m_bm;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 水位描画
        /// <summary><para>method outline:</para>
        /// <para>水位描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawWaterLevel();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawWaterLevel()
        {
            try
            {
                m_WaterLevelMaxY = 5.0F;	// グラフY軸の最大値
                m_WaterLevelMinY = -5.0F;	// グラフY軸の最大値
                m_WaterLevelSepY = 1.0F;	// グラフY軸のセパレート値
                m_FlowMeterMaxY = 50.0F;	// グラフY軸の最大値
                m_FlowMeterMinY = 0.0F;	// グラフY軸の最大値

                // 断面
                m_DanmenListNum = 0;
                m_DanmenList = null;
                m_DanmenMaxY = 0;
                m_DanmenMinY = 0;

                foreach (string a_sVal in lbDanmen.SelectedItems)
                {
                    _readDanmenCSVFile(
                        a_sVal  //m_Folder_Danmen + "\\" + a_sVal[2013.01.04]
                        );
                }

                // 水位
                //McGraphViewWaterLevelItems[] a_items = null;
                m_WaterLevelItems = null;

                int a_idx = 0;
                m_WaterLevelItems = new McGraphViewWaterLevelItems[clbWaterLevel.CheckedItems.Count];
                foreach (string a_sVal in clbWaterLevel.CheckedItems)
                {
                    m_WaterLevelItems[a_idx] = new McGraphViewWaterLevelItems();
                    m_WaterLevelItems[a_idx].FileName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    m_WaterLevelItems[a_idx].LineColor = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL,  //水位
                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint);
                    m_WaterLevelItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_WaterLevelItems[a_idx].LineSize = fLineSize;
                    m_WaterLevelItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine)  m_WaterLevelItems[a_idx].PlotKind = enumPlotKind.Line;
                    if (bDrawPoint) m_WaterLevelItems[a_idx].PlotForm = enumPlotForm.FillCircle;


                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        McGraphViewWaterLevelItem a_item = new McGraphViewWaterLevelItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt * 10).ToString("yyyy/MM/dd HH:mm");

                            //a_item.WaterLevel = McGraphViewDefine.g_InvalidValue2;   //[2010.06.02]
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            //a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");

                            //a_item.WaterLevel = McGraphViewDefine.g_InvalidValue;   //[2010.06.02]
                        }
                        a_item.TimeOrDay = a_iCnt;
                        a_item.WaterLevel = (decimal)McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.WaterLevel = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_WaterLevelItems[a_idx].Add(a_item);	// Listに追加
                    }
                    _readWaterLevelCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_WaterLevelItems[a_idx],
                        a_sVal  //m_Folder_WaterLevel + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }

                if (m_WaterLevelMaxY < m_DanmenMaxY)
                {
                    m_WaterLevelMaxY = m_DanmenMaxY;
                }
                if (m_WaterLevelMinY > m_DanmenMinY)
                {
                    m_WaterLevelMinY = m_DanmenMinY;
                }

                //[2010.03.07]
                //Y軸最大値
                if (McGraphViewDefine.g_WaterLevel_MaxY == McGraphViewDefine.g_InvalidValue)
                {
                    if (m_WaterLevelMaxY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_WaterLevelMaxY = 5.0F;
                    }
                }
                else
                {
                    m_WaterLevelMaxY = McGraphViewDefine.g_WaterLevel_MaxY;
                }
                //Y軸最小値
                if (McGraphViewDefine.g_WaterLevel_MinY == McGraphViewDefine.g_InvalidValue)
                {
                    if (m_WaterLevelMinY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_WaterLevelMinY = -5.0F;
                    }
                }
                else
                {
                    m_WaterLevelMinY = McGraphViewDefine.g_WaterLevel_MinY;
                }

                //[2013.01.24]---↓
                if (McGraphViewDefine.g_WaterLevel_MaxY == McGraphViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_WaterLevelMaxY = _adjustMaxVal(m_WaterLevelMaxY);
                }
                else
                {   //最大値の指定がある場合
                }

                if (McGraphViewDefine.g_WaterLevel_MinY == McGraphViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_WaterLevelMinY = _adjustMinVal(m_WaterLevelMinY);
                }
                else
                {   //最小値の指定がある場合
                }
                m_WaterLevelSepY = (m_WaterLevelMaxY - m_WaterLevelMinY) / McGraphViewDefine.g_WaterLevel_SepNumY;

                /*
                double a_dLen = Math.Ceiling(m_WaterLevelMaxY - m_WaterLevelMinY);
                int a_iLen = 0;

                //[2013.01.17]bug-fixed.
                if (a_dLen > 10)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 10);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                //[2013.01.17]bug-fixed.
                m_WaterLevelSepY = a_iLen;

                if ((Math.Abs(m_WaterLevelMaxY) % m_WaterLevelSepY) != 0)
                {
                    m_WaterLevelMaxY += (m_WaterLevelSepY - (Math.Abs(m_WaterLevelMaxY) % m_WaterLevelSepY));
                }
                if ((Math.Abs(m_WaterLevelMinY) % m_WaterLevelSepY) != 0)
                {
                    m_WaterLevelMinY -= (m_WaterLevelSepY - (Math.Abs(m_WaterLevelMinY) % m_WaterLevelSepY));
                }
                */
                //[2013.01.24]---↑

                /*
                double a_mod = m_WaterLevelMaxY % 1;
                //double a_mod = m_WaterLevelMaxY % 1;
                if (a_mod != 0)
                {
                    m_WaterLevelMaxY++;
                }
                m_WaterLevelSepY = Convert.ToSingle(Math.Ceiling(m_WaterLevelMaxY / 5));
                a_mod = m_WaterLevelSepY % 1;
                //a_mod = m_WaterLevelSepY % 2;
                if (a_mod != 0)
                {
                    m_WaterLevelSepY++;
                }
                a_mod = m_WaterLevelMaxY % m_WaterLevelSepY;
                if (a_mod != 0)
                {
                    m_WaterLevelMaxY = ((m_WaterLevelMaxY / m_WaterLevelSepY) + 1) * m_WaterLevelSepY;
                }
                */

                //m_WaterLevelSepY = 10;

                // 流量
                //McGraphViewFlowMeterItems[] a_items2 = null;
                m_FlowMeterItems = null;

                a_idx = 0;
                m_FlowMeterItems = new McGraphViewFlowMeterItems[clbFlowMeter.CheckedItems.Count];
                foreach (string a_sVal in clbFlowMeter.CheckedItems)
                {
                    m_FlowMeterItems[a_idx] = new McGraphViewFlowMeterItems();
                    m_FlowMeterItems[a_idx].FileName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    m_FlowMeterItems[a_idx].LineColor = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE, a_sVal,    //流量
                        out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint);
                    m_FlowMeterItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_FlowMeterItems[a_idx].LineSize = fLineSize;
                    m_FlowMeterItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine)  m_FlowMeterItems[a_idx].PlotKind = enumPlotKind.Line;
                    if (bDrawPoint) m_FlowMeterItems[a_idx].PlotForm = enumPlotForm.FillCircle;

                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        McGraphViewFlowMeterItem a_item2 = new McGraphViewFlowMeterItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item2.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item2.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt * 10).ToString("yyyy/MM/dd HH:mm");
                            
                            //a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue2;  //[2010.06.02]
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item2.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            //a_item2.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            
                            //a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue;   //[2010.06.02]
                        }
                        a_item2.TimeOrDay = a_iCnt;
                        a_item2.FlowMeter = (decimal)McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_FlowMeterItems[a_idx].Add(a_item2);	// Listに追加
                    }
                    _readFlowMeterCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_FlowMeterItems[a_idx],
                        a_sVal  //m_Folder_FlowMeter + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }

                McGraphViewWaterLevel a_gw = new McGraphViewWaterLevel();

                //a_gw.m_sep_bottom = 0;
                a_gw.m_sep_left = 40;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2010.03.07]
                a_gw.m_sep_top = 20;    //[2013.01.24]

                //m_WaterLevelMaxY = 100;
                //m_WaterLevelMinY = 0;
                //m_WaterLevelSepY = 1;

                /*
                float a_fTmp = (this.picWaterLevel.Height - (a_gw.m_sep_top + a_gw.m_sep_bottom)) / (m_WaterLevelMaxY - m_WaterLevelMinY);
                if ((a_fTmp * m_WaterLevelSepY) < (a_gw.m_font1.Size*2))
                {
                    m_WaterLevelSepY = Convert.ToInt32((a_gw.m_font1.Size * 2) / a_fTmp);
                }
                else
                {
                }
                 */ 

                a_gw.ImageWidth = this.picWaterLevel.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picWaterLevel.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = McGraphViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_WaterLevelMaxY;	// グラフY軸の最大値
                a_gw.GraphMinY = m_WaterLevelMinY;	// グラフY軸の最小値
                a_gw.GraphSepY = m_WaterLevelSepY;	// グラフY軸のセパレート値
                a_gw.SepNumY = McGraphViewDefine.g_WaterLevel_SepNumY;   //[2013.01.24] 
                a_gw.GraphMeasureYFormat = "###,###,##0";  //[2013.01.24]
                a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;       //[2010.03.07]

                /*
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_gw.GraphSepX = 1;
                    //a_gw.GraphSepX = 6F;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_gw.GraphSepX = 1;
                }
                 */
                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = false;	// Y軸の反転
                a_gw.StartTime = m_DtStart; //[2010.03.07]

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                /*
                if (m_WaterLevelItems.Count > 0)
                {
                    a_gw.GraphHasMeasureX = true;   // X軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                }
                 */
                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                /*
                if (m_WaterLevelItems.Count > 0)
                {
                    a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureY = false;   // Y軸の目盛表示
                }
                 */ 
                //a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式[2013.01.24]
                a_gw.GraphMeasureYFormat = "0.0"; // Y軸のメモリ書式 add 150708
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                //[2013.02.05]フォントサイズ---↓
                if (McGraphViewDefine.g_FontSize != McGraphViewDefine.g_InvalidValue)
                {
                    a_gw.m_font1 = new Font(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_NAME,
                                    McGraphViewDefine.g_FontSize);
                }
                else
                {
                    a_gw.m_font1 = new Font(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_NAME,
                                    float.Parse(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_SIZE));
                }
                //[2013.02.05]フォントサイズ---↑

                int a_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_mode = 1;
                }

                //[2010.03.07]
                //Y軸最大値
                if (McGraphViewDefine.g_FlowMeter_MaxY == McGraphViewDefine.g_InvalidValue)
                {
                    /*
                    if (m_FlowMeterMaxY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_FlowMeterMaxY = 5.0F;
                    }
                     */ 
                }
                else
                {
                    m_FlowMeterMaxY = McGraphViewDefine.g_FlowMeter_MaxY;
                }
                //Y軸最小値
                if (McGraphViewDefine.g_FlowMeter_MinY == McGraphViewDefine.g_InvalidValue)
                {
                    /*
                    if (m_FlowMeterMinY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_FlowMeterMinY = -5.0F;
                    }
                     */ 
                }
                else
                {
                    m_FlowMeterMinY = McGraphViewDefine.g_FlowMeter_MinY;
                }
                //[2013.01.24]---↓
                if (McGraphViewDefine.g_FlowMeter_MaxY == McGraphViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_FlowMeterMaxY = _adjustMaxVal(m_FlowMeterMaxY);
                }
                else
                {   //最大値の指定がある場合
                }
                if (McGraphViewDefine.g_FlowMeter_MinY == McGraphViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_FlowMeterMinY = _adjustMinVal(m_FlowMeterMinY);
                }
                else
                {   //最小値の指定がある場合
                }
                //[2013.01.24]---↑
                a_gw.InitGraph(m_DtStart, m_DtEnd, a_mode, ref m_FlowMeterMinY, ref m_FlowMeterMaxY);	//[2010.03.07] グラフの初期化
                /*
                // 水面の描画
                a_gw.DrawWaterSection(Color.Aquamarine, 4.5);

                // 断面の描画
                float[,] a_dList = new float[5, 2];
                a_dList[0, 0] = 0;
                a_dList[0, 1] = 4.8F;
                a_dList[1, 0] = 1;
                a_dList[1, 1] = 2.8F;
                a_dList[2, 0] = 2;
                a_dList[2, 1] = 1.8F;
                a_dList[3, 0] = 3;
                a_dList[3, 1] = 3.8F;
                a_dList[4, 0] = 4;
                a_dList[4, 1] = 4.8F;

                a_gw.DrawCrossSection(Color.LightSalmon, "", 5, a_dList);
                */

                // 断面の描画
                a_gw.DrawCrossSection(
                    Color.Wheat,
                    "",
                    m_DanmenListNum,
                    m_DanmenList,
                    m_DanmenMinX,
                    m_DanmenMaxX
                    );
                //a_gw.DrawCrossSection(Color.LightSalmon, "", m_DanmenListNum, m_DanmenList);

                a_gw.DrawGraphBackGround();	// グラフの初期化

                //基準水位の描画
		        Pen a_pen = new Pen(Color.Black,1.5F);
		        SolidBrush a_brush = new SolidBrush(Color.Black);
                //float a_pyv = 0;
                Font a_font = new Font(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_NAME,
                    float.Parse(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_SIZE));
                for (int a_iCnt = 0; a_iCnt < m_BaseWaterLevelNum; a_iCnt++)
                {
                    a_gw.PlotGraphValue(
                        a_pen,
                        a_brush,
                        0,
                        m_fBaseWaterLevel[a_iCnt],
                        m_X_Num,
                        ref m_fBaseWaterLevel[a_iCnt],
                        enumPlotKind.Line,
                        enumPlotForm.Nothing
                        );

                    float a_x = 0;
                    if ((a_iCnt % 2) == 0)
                    {
                        a_x = a_gw.m_sep_left + 4;
                    }
                    else
                    {
                        a_x = a_gw.ImageWidth - a_gw.m_sep_right - 120;
                    }
                    a_gw.m_g.DrawString(
                        Properties.HysAddinHydroHyetoGraphResources.SYMBOL_WATER_LEVEL + m_sBaseWaterLevel[a_iCnt],
                        a_font,
                        Brushes.Black,
                        new PointF(a_x, a_gw.ImageHeight - (a_gw.m_sep_bottom + ((m_fBaseWaterLevel[a_iCnt] - a_gw.m_min_y_val) * a_gw.m_sep_y_graph)) - 12)
                        );
                }

                //水位の描画
                if (m_WaterLevelItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_WaterLevelItems.Length; a_iCnt++)
                    {
                        a_gw.SetWaterLevelItems(m_WaterLevelItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                //流量の描画
                if (m_FlowMeterItems != null)
                {
                    //a_gw.GraphMaxY = m_FlowMeterMaxY;	// グラフY軸の最大値
                    //a_gw.GraphMinY = m_FlowMeterMinY;	// グラフY軸の最小値
                    //a_gw.InitializeSeparate();

                    for (int a_iCnt = 0; a_iCnt < m_FlowMeterItems.Length; a_iCnt++)
                    {
                        a_gw.SetFlowMeterItems(m_FlowMeterItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                this.picWaterLevel.Image = a_gw.m_bm;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        
        #region 再描画
        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_redraw(h_hour_st,h_minute_st,h_hour_ed,h_minute_ed);</para>
        /// </example>
        /// <param name="h_hour_st">表示開始時刻（時間）</param>
        /// <param name="h_minute_st">表示開始時刻（分）</param>
        /// <param name="h_hour_ed">表示終了時刻（時間）</param>
        /// <param name="h_minute_ed">表示終了時刻（分）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _redraw(
            int h_hour_st,
            int h_minute_st,
            int h_hour_ed,
            int h_minute_ed
            )
        {
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                m_DtStart = new DateTime(
                    dtpStart.Value.Year,
                    dtpStart.Value.Month,
                    dtpStart.Value.Day,
                    h_hour_st,  //Convert.ToInt32(cmbHourStart.SelectedValue),
                    h_minute_st,  //Convert.ToInt32(cmbMinuteStart.SelectedValue),
                    0
                    );
                m_DtEnd = new DateTime(
                    dtpEnd.Value.Year,
                    dtpEnd.Value.Month,
                    dtpEnd.Value.Day,
                    h_hour_ed, //Convert.ToInt32(cmbHourEnd.SelectedValue),
                    h_minute_ed,  //Convert.ToInt32(cmbMinuteEnd.SelectedValue),
                    0
                    );

                TimeSpan a_ts = m_DtEnd - m_DtStart;

                if (rdoByMinute.Checked == true)
                {   //分単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalMinutes));
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalHours));
                }

                //[2010.03.07]日時範囲の計算
                /*
                TimeSpan a_tTmp = m_DtEnd - m_DtStart;
                if (a_tTmp.Days < 7)
                {   //1週間以内
                    if (m_DtEnd.Day > m_DtStart.Day)
                    {   //日付が異なる
                        //2日分とする。
                        m_X_Num = 24 * (a_tTmp.Days + 1);
                        switch (a_tTmp.Days)
                        {
                            case 1:
                                m_X_Sep = 2;
                                break;
                            case 2:
                                m_X_Sep = 2;
                                break;
                            case 3:
                                m_X_Sep = 4;
                                break;
                            case 4:
                                m_X_Sep = 4;
                                break;
                            case 5:
                                m_X_Sep = 4;
                                break;
                            case 6:
                                m_X_Sep = 6;
                                break;
                            //case 7:
                            //    m_X_Sep = 6;
                            //    break;
                        }
                    }
                    else
                    {   //日付が同じ
                        //該当日分とする。
                        m_X_Num = 24;
                        m_X_Sep = 1;
                    }
                }
                else if(a_tTmp.Days < 31)
                {   //1週間～１ヶ月以内
                    m_X_Num = 24 * (a_tTmp.Days + 1);
                    if (a_tTmp.Days == 7)
                    {
                        m_X_Sep = 8;
                    }else if((a_tTmp.Days>=8) && (a_tTmp.Days<=15)){
                            m_X_Sep = 12;
                    }else if((a_tTmp.Days>=16) && (a_tTmp.Days<=30)){
                        m_X_Sep = 24;
                    }
                }
                else if (a_tTmp.Days < 366)
                {   //1ヶ月から1年以内
                    m_X_Num = 24 * (a_tTmp.Days + 1);
                    if (a_tTmp.Days == 31)
                    {
                        m_X_Sep = 24;
                    }
                    else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 365))
                    {
                        m_X_Sep = 24 * 30;
                    }
                }
                else
                {   //1年越え
                    m_X_Num = 24 * (a_tTmp.Days + 1);
                    m_X_Sep = 24 * 366;
                }

                m_DtStart2 = new DateTime(
                    dtpStart.Value.Year,
                    dtpStart.Value.Month,
                    dtpStart.Value.Day,
                    0,
                    0,
                    0
                    );
                m_DtEnd2 = new DateTime(
                    dtpEnd.Value.Year,
                    dtpEnd.Value.Month,
                    dtpEnd.Value.Day,
                    23,
                    59,
                    0
                    );
                if (rdoByMinute.Checked == true)
                {   //分単位
                    m_X_Num *= 60;
                    m_X_Sep *= 60;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                }
                */

                _drawRainfall();
                _drawWaterLevel();
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion
        
        #region 開始・終了時刻再設定
        /// <summary><para>method outline:</para>
        /// <para>開始・終了時刻再設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_getTimeStampAll();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _getTimeStampAll()
        {
            String a_sStart = "";
            String a_sEnd = "";
            //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
            //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");

            String a_sTmp = "";
            String a_sTmp1 = "";
            String a_sTmp2 = "";
            String a_sTmp3 = "";

            //雨量の開始・終了時刻を取得
            foreach (string a_sVal in lbRainfall.SelectedItems)
            {
                _getTimeStampParts(
                    ref a_sStart,
                    ref a_sEnd,
                    a_sVal  //m_Folder_Rainfall + "\\" + a_sVal[2013.01.04]
                    );
            }

            //水位の開始・終了時刻を取得
            foreach (string a_sVal in clbWaterLevel.CheckedItems)
            {
                _getTimeStampParts(
                    ref a_sStart,
                    ref a_sEnd,
                    a_sVal  //m_Folder_WaterLevel + "\\" + a_sVal[2013.01.04]
                    );
            }

            //流量の開始・終了時刻を取得
            foreach (string a_sVal in clbFlowMeter.CheckedItems)
            {
                _getTimeStampParts(
                    ref a_sStart,
                    ref a_sEnd,
                    a_sVal  //m_Folder_FlowMeter + "\\" + a_sVal[2013.01.04]
                    );
            }

            if (a_sStart.Length > 0)
            {
                a_sTmp = DateTime.Parse(a_sStart).ToString("yyyy/MM/dd HH:mm");
                a_sTmp1 = DateTime.Parse(a_sStart).ToString("yyyy/MM/dd");
                a_sTmp2 = DateTime.Parse(a_sStart).ToString("HH");
                a_sTmp3 = DateTime.Parse(a_sStart).ToString("mm");

                dtpStart.Text = a_sTmp1;
                cmbHourStart.Text = a_sTmp2;
                cmbMinuteStart.Text = a_sTmp3;
            }

            if (a_sEnd.Length > 0)
            {
                a_sTmp = DateTime.Parse(a_sEnd).ToString("yyyy/MM/dd HH:mm");
                a_sTmp1 = DateTime.Parse(a_sEnd).ToString("yyyy/MM/dd");
                a_sTmp2 = DateTime.Parse(a_sEnd).ToString("HH");
                a_sTmp3 = DateTime.Parse(a_sEnd).ToString("mm");

                dtpEnd.Text = a_sTmp1;
                cmbHourEnd.Text = a_sTmp2;
                cmbMinuteEnd.Text = a_sTmp3;
            }
        }
        #endregion
        #region 開始・終了時刻再設定
        /// <summary><para>method outline:</para>
        /// <para>開始・終了時刻再設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_getTimeStampParts(h_sStart,h_sEnd,h_fname);</para>
        /// </example>
        /// <param name="h_sStart">開始時刻</param>
        /// <param name="h_sEnd">終了時刻</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _getTimeStampParts(
            ref String h_sStart,
            ref String h_sEnd,
            String h_fname
            )
        {
            Boolean a_IsFirst = false;

            String a_sStart = "";
            String a_sEnd = "";

            try
            {   //[2013.01.23]
                if (h_sStart.Length > 0)
                {
                    a_sStart = DateTime.Parse(h_sStart).ToString("yyyy/MM/dd HH:mm");
                }
                if (h_sEnd.Length > 0)
                {
                    a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                }

                //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fname), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    String a_sTmp = "";
                    //String a_sTmp1 = "";
                    //String a_sTmp2 = "";
                    //String a_sTmp3 = "";

                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();

                    a_IsFirst = true;
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_RainfallMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        //[2013.02.06]bug-fixed.---↓
                        if (a_split[0].Trim().Length > 0)
                        {
                            a_sTmp = DateTime.Parse(a_split[0].Trim()).ToString("yyyy/MM/dd HH:mm");
                            //a_sTmp1 = DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd");
                            //a_sTmp2 = DateTime.Parse(a_split[0]).ToString("HH");
                            //a_sTmp3 = DateTime.Parse(a_split[0]).ToString("mm");

                            //開始時刻
                            if (a_IsFirst == true)
                            {
                                if (h_sStart.Length == 0)
                                {
                                    h_sStart = a_split[0];
                                }
                                else
                                {
                                    if (a_sTmp.CompareTo(a_sStart) < 0)
                                    {
                                        h_sStart = a_sTmp;
                                    }
                                }
                                a_IsFirst = false;
                            }

                            //終了時刻
                            if (h_sEnd.Length == 0)
                            {
                                h_sEnd = a_split[0];
                                a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                            }
                            else
                            {
                                if (a_sTmp.CompareTo(a_sEnd) > 0)
                                {
                                    h_sEnd = a_sTmp;
                                    a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                                }
                            }
                        }
                        //[2013.02.06]bug-fixed.---↑
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 表示期間書込み
        /// <summary><para>method outline:</para>
        /// <para>表示期間書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawPeriod(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawPeriod(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            try
            {
                h_sw.WriteLine("表示期間,年（開始）,月（開始）,日（開始）,時（開始）,分（開始）,年（終了）,月（終了）,日（終了）,時（終了）,分（終了）");
                h_sw.WriteLine(
                    "," + 
                    dtpStart.Value.Year.ToString() + "," + dtpStart.Value.Month.ToString() + "," + dtpStart.Value.Day.ToString() + "," +
                    cmbHourStart.SelectedItem.ToString() + "," + cmbMinuteStart.SelectedItem.ToString() + "," +
                    dtpEnd.Value.Year.ToString() + "," + dtpEnd.Value.Month.ToString() + "," + dtpEnd.Value.Day.ToString() + "," +
                    cmbHourEnd.SelectedItem.ToString() + "," + cmbMinuteEnd.SelectedItem.ToString()
                    );
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 表示対象書込み
        /// <summary><para>method outline:</para>
        /// <para>表示対象書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawTarget(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawTarget(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            int a_iMax = 0;
            int a_iCnt = 0;
            //int a_iCnt2 = 0;
            int a_iVal = 0;

            try
            {
                //雨量
                h_sw.WriteLine("表示対象（雨量）,ファイル名,選択状態");
                a_iMax = this.lbRainfall.Items.Count;
                h_sw.Write(a_iMax.ToString());
                for (a_iCnt = 0; a_iCnt < a_iMax; a_iCnt++)
                {
                    if (a_iCnt == this.lbRainfall.SelectedIndex)
                    {
                        a_iVal = 1;
                    }
                    else
                    {
                        a_iVal = 0;
                    }
                    // add 150708
                    string sRainFilePath = _getRelativePath(this.lbRainfall.Items[a_iCnt].ToString());
                    h_sw.WriteLine("," + sRainFilePath + "," + a_iVal.ToString());
                    //h_sw.WriteLine("," + this.lbRainfall.Items[a_iCnt].ToString() + "," + a_iVal.ToString());
                    // end add 150708
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //水位
                h_sw.WriteLine("表示対象（水位）,ファイル名,選択状態");
                a_iMax = this.clbWaterLevel.Items.Count;
                h_sw.Write(a_iMax.ToString());
                for (a_iCnt = 0; a_iCnt < a_iMax; a_iCnt++)
                {
                    a_iVal = 0;
                    foreach (string a_s in this.clbWaterLevel.CheckedItems)
                    {
                        if (a_s.Equals(this.clbWaterLevel.Items[a_iCnt].ToString()) == true)
                        {
                            a_iVal = 1;
                            break;
                        }
                    }
                    // add 150708
                    string sWLFilePath = _getRelativePath(this.clbWaterLevel.Items[a_iCnt].ToString());
                    h_sw.WriteLine("," + sWLFilePath + "," + a_iVal.ToString());
                    //h_sw.WriteLine("," + this.clbWaterLevel.Items[a_iCnt].ToString() + "," + a_iVal.ToString());
                    // end add 150708
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //流量
                h_sw.WriteLine("表示対象（流量）,ファイル名,選択状態");
                a_iMax = this.clbFlowMeter.Items.Count;
                h_sw.Write(a_iMax.ToString());
                for (a_iCnt = 0; a_iCnt < a_iMax; a_iCnt++)
                {
                    a_iVal = 0;
                    foreach (string a_s in this.clbFlowMeter.CheckedItems)
                    {
                        if (a_s.Equals(this.clbFlowMeter.Items[a_iCnt].ToString()) == true)
                        {
                            a_iVal = 1;
                            break;
                        }
                    }
                    // add 150708
                    string sFMFilePath = _getRelativePath(this.clbFlowMeter.Items[a_iCnt].ToString());
                    h_sw.WriteLine("," + sFMFilePath + "," + a_iVal.ToString());
                    //h_sw.WriteLine("," + this.clbFlowMeter.Items[a_iCnt].ToString() + "," + a_iVal.ToString());
                    // end add 150708
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //断面
                h_sw.WriteLine("表示対象（断面）,ファイル名,選択状態");
                a_iMax = this.lbDanmen.Items.Count;
                h_sw.Write(a_iMax.ToString());
                for (a_iCnt = 0; a_iCnt < a_iMax; a_iCnt++)
                {
                    if (a_iCnt == this.lbDanmen.SelectedIndex)
                    {
                        a_iVal = 1;
                    }
                    else
                    {
                        a_iVal = 0;
                    }
                    // add 150708
                    string sDanmenFilePath = _getRelativePath(this.lbDanmen.Items[a_iCnt].ToString());
                    h_sw.WriteLine("," + sDanmenFilePath + "," + a_iVal.ToString());
                    //h_sw.WriteLine("," + this.lbDanmen.Items[a_iCnt].ToString() + "," + a_iVal.ToString());
                    // end add 150708
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 凡例書込み
        /// <summary><para>method outline:</para>
        /// <para>凡例書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawLegend(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawLegend(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            //int a_iCnt = 0;
            int a_iMax = 0;
            //int a_iVal = 0;
            System.Drawing.Color a_color;
            string a_sLineStyle = "";
            float a_fLineSize = 0;
            float a_fMarkSize = 0;
            bool a_bDrawLine = true;
            bool a_bDrawPoint = true;

            try
            {
                //雨量
                h_sw.WriteLine("凡例（雨量）,ファイル名,線色");
                //[2013.01.17]bug-fixed.---↓
                bool a_bIsFound = false;
                a_iMax = this.lbRainfall.SelectedItems.Count;
                foreach (string a_s in this.lbRainfall.SelectedItems)
                {
                    int a_iRet = legendList1.SearchRow(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION, a_s);
                    if (a_iRet != -1)
                    {
                        h_sw.Write("1");
                        a_color = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION, a_s);
                        // add 150708
                        //h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString());
                        string sRainFilePath = _getRelativePath(a_s);
                        h_sw.WriteLine("," + sRainFilePath + "," + a_color.ToArgb().ToString());
                        // end add 150708
                        a_bIsFound = true;
                        break;
                    }
                }
                if (a_bIsFound == false)
                {
                    h_sw.Write("0,,");
                }
                //[2013.01.17]bug-fixed.---↑
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //水位
                h_sw.WriteLine("凡例（水位）,ファイル名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画");
                a_iMax = this.clbWaterLevel.CheckedItems.Count;
                h_sw.Write(a_iMax.ToString());
                foreach (string a_s in this.clbWaterLevel.CheckedItems)
                {
                    a_color = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL,
                            a_s, out a_sLineStyle, out a_fLineSize, out a_fMarkSize, out a_bDrawLine, out a_bDrawPoint); ;
                    // add 150708
                    //h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString() + "," +
                    //    a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," + Convert.ToInt32(a_bDrawPoint).ToString() );
                    string sWLFilePath = _getRelativePath(a_s);
                    h_sw.WriteLine("," + sWLFilePath + "," + a_color.ToArgb().ToString() + "," +
                        a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," +Convert.ToInt32(a_bDrawLine).ToString() + "," + Convert.ToInt32(a_bDrawPoint).ToString());
                    // end add 150708
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //流量
                h_sw.WriteLine("凡例（流量）,ファイル名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画");
                a_iMax = this.clbFlowMeter.CheckedItems.Count;
                h_sw.Write(a_iMax.ToString());
                foreach (string a_s in this.clbFlowMeter.CheckedItems)
                {
                    a_color = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE,
                            a_s, out a_sLineStyle, out a_fLineSize, out a_fMarkSize, out a_bDrawLine, out a_bDrawPoint); ;
                    // add 150708
                    //h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString() + "," +
                    //    a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," + Convert.ToInt32(a_bDrawPoint).ToString());
                    string sFMFilePath = _getRelativePath(a_s);
                    h_sw.WriteLine("," + sFMFilePath + "," + a_color.ToArgb().ToString() + "," +
                        a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," + Convert.ToInt32(a_bDrawPoint).ToString());
                    // end add 150708
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region グラフ設定書込み
        /// <summary><para>method outline:</para>
        /// <para>グラフ設定書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawGraphSet(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawGraphSet(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            try
            {
                //雨量
                h_sw.WriteLine("グラフ設定（雨量）,軸ラベル,Y軸最大,Y軸最小");
                h_sw.WriteLine("," + labelAxisRain.Text + "," + McGraphViewDefine.g_Rainfall_MaxY.ToString() + "," + McGraphViewDefine.g_Rainfall_MinY.ToString());

                //水位
                h_sw.WriteLine("グラフ設定（水位）,軸ラベル,表示目盛,Y軸最大,Y軸最小");
                h_sw.WriteLine("," + labelAxisLevel.Text + "," + m_WaterLevelRateY.ToString() + "," + McGraphViewDefine.g_WaterLevel_MaxY.ToString() + "," + McGraphViewDefine.g_WaterLevel_MinY.ToString());

                //流量
                h_sw.WriteLine("グラフ設定（流量）,軸ラベル,表示目盛,Y軸最大,Y軸最小");
                h_sw.WriteLine("," + labelAxisFlow.Text + "," + m_FlowMeterRateY.ToString() + "," + McGraphViewDefine.g_FlowMeter_MaxY.ToString() + "," + McGraphViewDefine.g_FlowMeter_MinY.ToString());

                //その他[2013.02.05]
                h_sw.WriteLine("グラフ設定（その他）,文字サイズ");
                h_sw.WriteLine("," + McGraphViewDefine.g_FontSize.ToString());
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 表示期間読込み
        /// <summary><para>method outline:</para>
        /// <para>表示期間読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawPeriod(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawPeriod(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = {','};
            DateTime a_dt;

            try
            {
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目：表示期間,年（開始）,月（開始）,日（開始）,時（開始）,分（開始）,年（終了）,月（終了）,日（終了）,時（終了）,分（終了）
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);

                a_dt = new DateTime(int.Parse(a_sSplit[1]), int.Parse(a_sSplit[2]), int.Parse(a_sSplit[3]));
                dtpStart.Value = a_dt;
                cmbHourStart.SelectedItem = a_sSplit[4];
                cmbMinuteStart.SelectedItem = a_sSplit[5];
                a_dt = new DateTime(int.Parse(a_sSplit[6]), int.Parse(a_sSplit[7]), int.Parse(a_sSplit[8]));
                dtpEnd.Value = a_dt;
                cmbHourEnd.SelectedItem = a_sSplit[9];
                cmbMinuteEnd.SelectedItem = a_sSplit[10];
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 表示対象読込み
        /// <summary><para>method outline:</para>
        /// <para>表示対象読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawTarget(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawTarget(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = { ',' };

            int a_iMax = 0;
            int a_iCnt = 0;

            try
            {
                //雨量
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（雨量）,ファイル名,選択状態
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    this.lbRainfall.Items.Add(a_sSplit[1]);

                    if (a_sSplit[2].Equals("1") == true)
                    {
                        this.lbRainfall.SelectedIndex = this.lbRainfall.Items.Count - 1;
                        //legendList1.AddList(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION, a_sSplit[1]);
                    }
                }

                //水位
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（水位）,ファイル名,選択状態
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    this.clbWaterLevel.Items.Add(a_sSplit[1]);

                    if (a_sSplit[2].Equals("1") == true)
                    {
                        this.clbWaterLevel.SetItemChecked(this.clbWaterLevel.Items.Count - 1,true);
                        this.clbWaterLevel.SetSelected(this.clbWaterLevel.Items.Count - 1, true);
                        //legendList1.AddList(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL, a_sSplit[1]);
                    }
                }

                //流量
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（流量）,ファイル名,選択状態
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    this.clbFlowMeter.Items.Add(a_sSplit[1]);

                    if (a_sSplit[2].Equals("1") == true)
                    {
                        this.clbFlowMeter.SetItemChecked(this.clbFlowMeter.Items.Count - 1, true);
                        this.clbFlowMeter.SetSelected(this.clbFlowMeter.Items.Count - 1, true);
                        //legendList1.AddList(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE, a_sSplit[1]);
                    }
                }

                //断面
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（断面）,ファイル名,選択状態
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    this.lbDanmen.Items.Add(a_sSplit[1]);

                    if (a_sSplit[2].Equals("1") == true)
                    {
                        this.lbDanmen.SelectedIndex = this.lbDanmen.Items.Count - 1;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 凡例読込み
        /// <summary><para>method outline:</para>
        /// <para>凡例読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawLegend(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawLegend(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = { ',' };

            int a_iCnt = 0;
            int a_iMax = 0;
            //int a_iVal = 0;
            //System.Drawing.Color a_color;
            //string a_sLineStyle = "";
            //float a_fLineSize = 0;
            //float a_fMarkSize = 0;
            bool a_bDrawLine = true;
            bool a_bDrawPoint = true;

            try
            {
                //雨量
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：凡例（雨量）,ファイル名,線色
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax =int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    legendList1.SetLegend(
                        Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION,
                        a_sSplit[1],
                        Color.FromArgb(int.Parse(a_sSplit[2]))
                        );
                }

                //水位
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：凡例（水位）,ファイル名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    if (int.Parse(a_sSplit[6]) == 1)
                    {
                        a_bDrawLine = true;
                    }
                    else
                    {
                        a_bDrawLine = false;
                    }

                    if (int.Parse(a_sSplit[7]) == 1)
                    {
                        a_bDrawPoint = true;
                    }
                    else
                    {
                        a_bDrawPoint = false;
                    }
                    
                    legendList1.SetLegend(
                        Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL,
                        a_sSplit[1],
                        Color.FromArgb(int.Parse(a_sSplit[2])),
                        a_sSplit[3],
                        float.Parse(a_sSplit[4]),
                        float.Parse(a_sSplit[5]),
                        a_bDrawLine,
                        a_bDrawPoint
                        );
                }

                //流量
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：凡例（流量）,ファイル名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    if (int.Parse(a_sSplit[6]) == 1)
                    {
                        a_bDrawLine = true;
                    }
                    else
                    {
                        a_bDrawLine = false;
                    }

                    if (int.Parse(a_sSplit[7]) == 1)
                    {
                        a_bDrawPoint = true;
                    }
                    else
                    {
                        a_bDrawPoint = false;
                    }

                    legendList1.SetLegend(
                        Properties.HysAddinHydroHyetoGraphResources.DISCHARGE,
                        a_sSplit[1],
                        Color.FromArgb(int.Parse(a_sSplit[2])),
                        a_sSplit[3],
                        float.Parse(a_sSplit[4]),
                        float.Parse(a_sSplit[5]),
                        a_bDrawLine,
                        a_bDrawPoint
                        );
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region グラフ設定読込み
        /// <summary><para>method outline:</para>
        /// <para>グラフ設定読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawGraphSet(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawGraphSet(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = { ',' };

            try
            {
                //雨量
                //1行目は読み飛ばし：グラフ設定（雨量）,軸ラベル,Y軸最大,Y軸最小
                a_sLine = h_sr.ReadLine();
                //2行目以降
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                labelAxisRain.Text = a_sSplit[1];
                McGraphViewDefine.g_Rainfall_MaxY = float.Parse(a_sSplit[2]);
                McGraphViewDefine.g_Rainfall_MinY = float.Parse(a_sSplit[3]);

                //水位
                //1行目は読み飛ばし：グラフ設定（水位）,軸ラベル,表示目盛,Y軸最大,Y軸最小
                a_sLine = h_sr.ReadLine();
                //2行目以降
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                labelAxisLevel.Text = a_sSplit[1];
                m_WaterLevelRateY = float.Parse(a_sSplit[2]);
                McGraphViewDefine.g_WaterLevel_MaxY = float.Parse(a_sSplit[3]);
                McGraphViewDefine.g_WaterLevel_MinY = float.Parse(a_sSplit[4]);

                //流量
                //1行目は読み飛ばし：グラフ設定（流量）,軸ラベル,表示目盛,Y軸最大,Y軸最小
                a_sLine = h_sr.ReadLine();
                //2行目以降
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                labelAxisFlow.Text = a_sSplit[1];
                m_FlowMeterRateY = float.Parse(a_sSplit[2]);
                McGraphViewDefine.g_FlowMeter_MaxY = float.Parse(a_sSplit[3]);
                McGraphViewDefine.g_FlowMeter_MinY = float.Parse(a_sSplit[4]);

                //その[2013.02.05]
                //1行目は読み飛ばし：グラフ設定（その他）
                a_sLine = h_sr.ReadLine();
                //2行目以降
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                McGraphViewDefine.g_FontSize = float.Parse(a_sSplit[1]);
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region ハイエトデータ書込み
        /// <summary><para>method outline:</para>
        /// <para>ハイエトデータ書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeOutDrawHyeto(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeOutDrawHyeto(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.05]
            int a_R = 0;
            int a_G = 0;
            int a_B = 0;

            int a_DataSum = 0;  //[2013.02.05]
            int a_iCnt = 0; //[2013.02.05]
            DateTime a_dt1; //[2013.02.05]

            try
            {
                //----------------------------------------------------------
                //描画データ書込み
                //----------------------------------------------------------
                //[2013.02.06]---↓
                string a_sMax = "";
                string a_sMin = "";
                if (McGraphViewDefine.g_Rainfall_MaxY != McGraphViewDefine.g_InvalidValue)
                    a_sMax = McGraphViewDefine.g_Rainfall_MaxY.ToString();
                if (McGraphViewDefine.g_Rainfall_MinY != McGraphViewDefine.g_InvalidValue)
                    a_sMin = McGraphViewDefine.g_Rainfall_MinY.ToString();
                //[2013.02.06]---↑

                if (m_RainfallItems.Length > 0)
                {
                    a_R = (int)m_RainfallItems[0].LineColor.R;
                    a_G = (int)m_RainfallItems[0].LineColor.G;
                    a_B = (int)m_RainfallItems[0].LineColor.B;

                    //[2013.02.05]---↓
                    a_DataSum = m_RainfallItems[0].Count;
                    a_dt1 = DateTime.Parse(m_RainfallItems[0][0].sTimeOrDay);
                    if (a_dt1 != m_DtStart)
                    {
                        a_DataSum++;
                    }
                    a_dt1 = DateTime.Parse(m_RainfallItems[0][m_RainfallItems[0].Count-1].sTimeOrDay);
                    if (a_dt1 != m_DtEnd)
                    {
                        a_DataSum++;
                    }
                    //[2013.02.05]---↑

                    h_sw.WriteLine(labelAxisRain.Text + "\t" + a_sMax + "\t" + a_sMin + "\t" + a_DataSum.ToString() + "\t" +
                        a_R.ToString() + "#" + a_G.ToString() + "#" + a_B.ToString() +"\t" +
                        m_DtEnd.ToString("yyyy/MM/ss HH:mm") + "\t" + m_DtStart.ToString("yyyy/MM/ss HH:mm")
                        );

                    h_sw.WriteLine("時間\t雨量");
                    for (a_iCnt = 0; a_iCnt < m_RainfallItems[0].Count; a_iCnt++)
                    {
                        string a_sTmp = "";

                        //[2013.02.05]---↓
                        if (a_iCnt == 0)
                        {   //最初のレコード
                            a_dt1 = DateTime.Parse(m_RainfallItems[0][a_iCnt].sTimeOrDay);
                            if (a_dt1 != m_DtStart)
                            {
                                h_sw.WriteLine(m_DtStart.ToString("yyyy/MM/dd HH:mm") + "\t");
                            }
                        }
                        //[2013.02.05]---↑

                        if ((m_RainfallItems[0][a_iCnt].Rainfall != (decimal)McGraphViewDefine.g_InvalidValue2)
                            && (m_RainfallItems[0][a_iCnt].Rainfall != (decimal)McGraphViewDefine.g_InvalidValue))
                        {
                            a_sTmp = m_RainfallItems[0][a_iCnt].Rainfall.ToString();
                        }
                        h_sw.WriteLine(m_RainfallItems[0][a_iCnt].sTimeOrDay + "\t" + a_sTmp);
                    }

                    //[2013.02.05]---↓
                    //最後のレコード
                    a_dt1 = DateTime.Parse(m_RainfallItems[0][a_iCnt-1].sTimeOrDay);
                    if (a_dt1 != m_DtEnd)
                    {
                        h_sw.WriteLine(m_DtEnd.ToString("yyyy/MM/dd HH:mm") + "\t");
                    }
                    //[2013.02.05]---↑
                }
                else
                {
                    //[2013.02.06]
                    h_sw.WriteLine(labelAxisRain.Text + "\t" + a_sMax + "\t" + a_sMin + "\t" + a_DataSum.ToString() + "\t" +
                        a_R.ToString() + "#" + a_G.ToString() + "#" + a_B.ToString() + "\t" +
                        m_DtEnd.ToString("yyyy/MM/ss HH:mm") + "\t" + m_DtStart.ToString("yyyy/MM/ss HH:mm")
                        );
                    h_sw.WriteLine("時間\t雨量");
                }

            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region ハイドロデータ書込み
        /// <summary><para>method outline:</para>
        /// <para>ハイドロデータ書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeOutDrawHydro(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeOutDrawHydro(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.05]
            int a_iPlotNum = 0;
            int a_R = 0;
            int a_G = 0;
            int a_B = 0;
            bool a_bFirst = true;

            //int a_iDataSum = 0; //[2013.02.07]
            DateTime a_dt1 = DateTime.Parse("2013/02/05"); //[2013.02.05]
            bool a_IsData = false;  //[2013.02.05]
            //bool a_IsTime = false;  //[2013.02.07]

            try
            {

                a_iPlotNum = m_WaterLevelItems.Length + m_FlowMeterItems.Length;

                //--------------------------------------------------------------
                //断面
                //--------------------------------------------------------------

                //--------------------------------------------------------------
                //描画データ書込み：タイトル等
                //--------------------------------------------------------------
                string a_sMaxP = "";
                string a_sMinP = "";
                string a_sMaxS = "";
                string a_sMinS = "";
                if (McGraphViewDefine.g_WaterLevel_MaxY != McGraphViewDefine.g_InvalidValue)
                    a_sMaxP = McGraphViewDefine.g_WaterLevel_MaxY.ToString();
                if (McGraphViewDefine.g_WaterLevel_MinY != McGraphViewDefine.g_InvalidValue)
                    a_sMinP = McGraphViewDefine.g_WaterLevel_MinY.ToString();
                if (McGraphViewDefine.g_FlowMeter_MaxY != McGraphViewDefine.g_InvalidValue)
                    a_sMaxS = McGraphViewDefine.g_FlowMeter_MaxY.ToString();
                if (McGraphViewDefine.g_FlowMeter_MinY != McGraphViewDefine.g_InvalidValue)
                    a_sMinS = McGraphViewDefine.g_FlowMeter_MinY.ToString();

                h_sw.WriteLine(labelAxisLevel.Text + "\t" + a_sMaxP + "\t" + a_sMinP +
                    "\t" + labelAxisFlow.Text + "\t" + a_sMaxS + "\t" + a_sMinS +
                    "\t" + (m_X_Num + 1).ToString() + "\t" + a_iPlotNum.ToString() +
                    "\t" + m_DtEnd.ToString("yyyy/MM/dd HH:mm") +
                    "\t" + m_DtStart.ToString("yyyy/MM/dd HH:mm") 
                    );

                //--------------------------------------------------------------
                //描画データ書込み：
                //軸の種類（1：主軸、2：2軸）
                //ラインありなし（-1：断面、0：なし、1：あり）→
                //マーカーありなし（0：なし、1：あり）→
                //線の種類（1：実線、2：ドット、3：ダッシュ、4：ダッシュドット）→
                //線の色→
                //線の太さ→
                //--------------------------------------------------------------
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    h_sw.Write("水位" + a_iCnt.ToString());
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    h_sw.Write("流量" + a_iCnt.ToString());
                }
                h_sw.WriteLine("");

                //軸の種類（1：主軸、2：2軸）
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    h_sw.Write("1");
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    h_sw.Write("2");
                }
                h_sw.WriteLine("");

                //ラインありなし（-1：断面、0：なし、1：あり）
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    if (m_WaterLevelItems[a_iCnt - 1].PlotKind != enumPlotKind.Nothing)
                        h_sw.Write("1");
                    else
                        h_sw.Write("0");
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    if (m_FlowMeterItems[a_iCnt - 1].PlotKind != enumPlotKind.Nothing)
                        h_sw.Write("1");
                    else
                        h_sw.Write("0");
                }
                h_sw.WriteLine("");

                //マーカーありなし（0：なし、1：あり）
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    if (m_WaterLevelItems[a_iCnt - 1].PlotForm != enumPlotForm.Nothing)
                        h_sw.Write("1");
                    else
                        h_sw.Write("0");
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    if (m_FlowMeterItems[a_iCnt - 1].PlotForm != enumPlotForm.Nothing)
                        h_sw.Write("1");
                    else
                        h_sw.Write("0");
                }
                h_sw.WriteLine("");

                //線の種類（1：実線、2：ドット、3：ダッシュ、4：ダッシュドット）
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    switch (m_WaterLevelItems[a_iCnt - 1].LineStyle)
                    {
                        case System.Drawing.Drawing2D.DashStyle.Solid:
                            h_sw.Write("1");
                            break;
                        case System.Drawing.Drawing2D.DashStyle.Dot:
                            h_sw.Write("2");
                            break;
                        case System.Drawing.Drawing2D.DashStyle.Dash:
                            h_sw.Write("3");
                            break;
                        case System.Drawing.Drawing2D.DashStyle.DashDot:
                            h_sw.Write("4");
                            break;
                    }
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    switch (m_FlowMeterItems[a_iCnt - 1].LineStyle)
                    {
                        case System.Drawing.Drawing2D.DashStyle.Solid:
                            h_sw.Write("1");
                            break;
                        case System.Drawing.Drawing2D.DashStyle.Dot:
                            h_sw.Write("2");
                            break;
                        case System.Drawing.Drawing2D.DashStyle.Dash:
                            h_sw.Write("3");
                            break;
                        case System.Drawing.Drawing2D.DashStyle.DashDot:
                            h_sw.Write("4");
                            break;
                    }
                }
                h_sw.WriteLine("");

                //線の色
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    a_R = m_WaterLevelItems[a_iCnt - 1].LineColor.R;
                    a_G = m_WaterLevelItems[a_iCnt - 1].LineColor.G;
                    a_B = m_WaterLevelItems[a_iCnt - 1].LineColor.B;
                    h_sw.Write(a_R.ToString() + "#" + a_G.ToString() + "#" + a_B.ToString());
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    a_R = m_FlowMeterItems[a_iCnt - 1].LineColor.R;
                    a_G = m_FlowMeterItems[a_iCnt - 1].LineColor.G;
                    a_B = m_FlowMeterItems[a_iCnt - 1].LineColor.B;
                    h_sw.Write(a_R.ToString() + "#" + a_G.ToString() + "#" + a_B.ToString());
                }
                h_sw.WriteLine("");

                //線の太さ
                a_bFirst = true;
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    h_sw.Write(m_WaterLevelItems[a_iCnt - 1].LineSize.ToString());
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    if (a_bFirst == true)
                        a_bFirst = false;
                    else
                        h_sw.Write("\t");
                    h_sw.Write(m_FlowMeterItems[a_iCnt - 1].LineSize.ToString());
                }
                h_sw.WriteLine("");

                //--------------------------------------------------------------
                //描画データ書込み：データ⇒全面変更[2013.02.07]
                //--------------------------------------------------------------
                string a_sTmp = "";
                //水位
                for (int a_iCnt2 = 0; a_iCnt2 < m_WaterLevelItems.Length; a_iCnt2++)
                {
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        if (a_iCnt == 0)
                        {   //最初のレコード
                            h_sw.WriteLine("時間\t水位" + (a_iCnt2 + 1).ToString());
                        }
                        a_IsData = false;
                        if ((m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue2)
                            && (m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue))
                        {
                            a_IsData = true;    
                            a_sTmp = m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel.ToString();
                            h_sw.WriteLine(m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm") + "\t" + a_sTmp);
                        }
                        if (a_iCnt == 0)
                        {   //最初のレコード
                            if (a_IsData == false)
                            {
                                h_sw.WriteLine(m_DtStart.ToString("yyyy/MM/dd HH:mm") + "\t");
                            }
                        }
                        if (a_iCnt == m_X_Num)
                        {   //最後のレコード
                            if (a_IsData == false)
                            {
                                h_sw.WriteLine(m_DtEnd.ToString("yyyy/MM/dd HH:mm") + "\t");
                            }
                        }
                    }
                }
                //流量
                for (int a_iCnt2 = 0; a_iCnt2 < m_FlowMeterItems.Length; a_iCnt2++)
                {
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        if (a_iCnt == 0)
                        {   //最初のレコード
                            h_sw.WriteLine("時間\t流量" + (a_iCnt2 + 1).ToString());
                        }
                        a_IsData = false;
                        if ((m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue2)
                            && (m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue))
                        {
                            a_IsData = true;
                            a_sTmp = m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter.ToString();
                            h_sw.WriteLine(m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm") + "\t" + a_sTmp);
                        }
                        if (a_iCnt == 0)
                        {   //最初のレコード
                            if (a_IsData == false)
                            {
                                h_sw.WriteLine(m_DtStart.ToString("yyyy/MM/dd HH:mm") + "\t");
                            }
                        }
                        if (a_iCnt == m_X_Num)
                        {   //最後のレコード
                            if (a_IsData == false)
                            {
                                h_sw.WriteLine(m_DtEnd.ToString("yyyy/MM/dd HH:mm") + "\t");
                            }
                        }
                    }
                }

                /*[2013.02.07]comment-out---↓
                h_sw.Write("時間");
                for (int a_iCnt = 1; a_iCnt <= m_WaterLevelItems.Length; a_iCnt++)
                {
                    h_sw.Write("\t水位" + a_iCnt.ToString());
                }
                for (int a_iCnt = 1; a_iCnt <= m_FlowMeterItems.Length; a_iCnt++)
                {
                    h_sw.Write("\t流量" + a_iCnt.ToString());
                }
                h_sw.WriteLine("");

                for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                {
                    a_IsData = false;
                    a_IsTime = false;

                    //---------------------------------------------------------
                    //水位にデータがあるかチェックする。
                    for (int a_iCnt2 = 0; a_iCnt2 < m_WaterLevelItems.Length; a_iCnt2++)
                    {
                        if ((m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue2)
                            && (m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue))
                        {
                            a_IsData = true;
                            break;
                        }
                    }
                    //流量にデータがあるかどうかチェックする。
                    if (a_IsData == false)
                    {
                        for (int a_iCnt2 = 0; a_iCnt2 < m_FlowMeterItems.Length; a_iCnt2++)
                        {
                            if ((m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue2)
                                && (m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue))
                            {
                                a_IsData = true;
                                break;
                            }
                        }
                    }
                    //---------------------------------------------------------

                    //---------------------------------------------------------
                    if (a_IsData == true)
                    {
                        //水位データの書き出し
                        for (int a_iCnt2 = 0; a_iCnt2 < m_WaterLevelItems.Length; a_iCnt2++)
                        {
                            string a_sTmp = "";
                            if ((m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue2)
                                && (m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue))
                            {
                                a_sTmp = m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel.ToString();
                                if (a_IsTime == false)
                                {
                                    h_sw.Write(m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm"));
                                    a_dt1 = m_DtStart.AddMinutes(a_iCnt);
                                    a_IsTime = true;
                                }
                                h_sw.Write("\t" + a_sTmp);
                            }
                        }
                        //流量データの書き出し
                        for (int a_iCnt2 = 0; a_iCnt2 < m_FlowMeterItems.Length; a_iCnt2++)
                        {
                            string a_sTmp = "";
                            if ((m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue2)
                                && (m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue))
                            {
                                a_sTmp = m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter.ToString();
                                if (a_IsTime == false)
                                {
                                    h_sw.Write(m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm"));
                                    a_dt1 = m_DtStart.AddMinutes(a_iCnt);
                                    a_IsTime = true;
                                }
                                h_sw.Write("\t" + a_sTmp);
                            }
                        }
                        h_sw.WriteLine("");
                        a_iDataSum++;
                    }

                    if (a_iCnt == 0)
                    {   //最初のレコード
                        if (a_IsData == false){
                            if (a_iPlotNum > 0)
                            {   //[2013.02.06]
                                h_sw.WriteLine(m_DtStart.ToString("yyyy/MM/dd HH:mm") + "\t");
                                a_iDataSum++;
                            }
                        }
                        else
                        {
                            if (a_dt1 != m_DtStart)
                            {
                                if (a_iPlotNum > 0)
                                {   //[2013.02.06]
                                    h_sw.WriteLine(m_DtStart.ToString("yyyy/MM/dd HH:mm") + "\t");
                                    a_iDataSum++;
                                }
                            }
                        }
                    }
                    //[2013.02.05]---↑

                    //---------------------------------------------------------

                    //[2013.02.05]comment-out---↓
                    ////if (a_IsExist == true)
                    ////{
                    //    //時間
                    //    if (rdoByMinute.Checked == true)
                    //    {   //分単位
                    //        h_sw.Write(m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm"));
                    //    }
                    //    else if (rdoByHour.Checked == true)
                    //    {   //時間単位
                    //        h_sw.Write(m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00"));
                    //    }

                    //    //水位
                    //    for (int a_iCnt2 = 0; a_iCnt2 < m_WaterLevelItems.Length; a_iCnt2++)
                    //    {
                    //        string a_sTmp = "";
                    //        if ((m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue2)
                    //            && (m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel != (decimal)McGraphViewDefine.g_InvalidValue))
                    //        {
                    //            a_sTmp = m_WaterLevelItems[a_iCnt2][a_iCnt].WaterLevel.ToString();
                    //        }
                    //        h_sw.Write("\t" + a_sTmp);
                    //    }
                    //    //流量
                    //    for (int a_iCnt2 = 0; a_iCnt2 < m_FlowMeterItems.Length; a_iCnt2++)
                    //    {
                    //        string a_sTmp = "";
                    //        if ((m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue2)
                    //            && (m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter != (decimal)McGraphViewDefine.g_InvalidValue))
                    //        {
                    //            a_sTmp = m_FlowMeterItems[a_iCnt2][a_iCnt].FlowMeter.ToString();
                    //        }
                    //        h_sw.Write("\t" + a_sTmp);
                    //    }
                    //    h_sw.WriteLine("");
                    ////}
                    //[2013.02.05]comment-out---↑
                }
                //[2013.02.05]---↓
                //最後のレコード
                if (a_IsData == false)
                {
                    if (a_iPlotNum > 0)
                    {   //[2013.02.06]
                        h_sw.WriteLine(m_DtEnd.ToString("yyyy/MM/dd HH:mm") + "\t");
                        a_iDataSum++;
                    }
                }
                else
                {
                    if (a_dt1 != m_DtEnd)
                    {
                        if (a_iPlotNum > 0)
                        {   //[2013.02.06]
                            h_sw.WriteLine(m_DtStart.ToString("yyyy/MM/dd HH:mm") + "\t");
                            a_iDataSum++;
                        }
                    }
                }
                //[2013.02.05]---↑
                */
                //[2013.02.07]comment-out---↑
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region "雨量ファイル選択"
        /*
        private void _selectedRainfall(bool h_bIsSelected, string h_sFileName)
        {   //[2013.02.04]
            try
            {
                //選択ファイルを凡例一覧に追加
                string sGroup = Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION; //雨量
                if (h_bIsSelected == true)
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, h_sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, h_sFileName);
                }

                //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
                //[2010.06.03]
                if (m_IsAutoFit == true)
                {
                    _getTimeStampAll();
                }
                _redraw(
                    Convert.ToInt32(cmbHourStart.SelectedItem),
                    Convert.ToInt32(cmbMinuteStart.SelectedItem),
                    Convert.ToInt32(cmbHourEnd.SelectedItem),
                    Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                    );
                //_drawRainfall();
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        */
        #endregion

        /// <summary>
        /// COMオブジェクトへの参照を作成および取得します
        /// </summary>
        /// <param name="progId">作成するオブジェクトのプログラムID</param>
        /// <param name="serverName">
        /// オブジェクトが作成されるネットワークサーバー名
        /// </param>
        /// <returns>作成されたCOMオブジェクト</returns>
        public static object CreateObject(string progId, string serverName)
        {
            //[2013.01.05]
            Type t;
            if (serverName == null || serverName.Length == 0)
                t = Type.GetTypeFromProgID(progId);
            else
                t = Type.GetTypeFromProgID(progId, serverName, true);
            return Activator.CreateInstance(t);
        }
 
        /// <summary>
        /// COMオブジェクトへの参照を作成および取得します
        /// </summary>
        /// <param name="progId">作成するオブジェクトのプログラムID</param>
        /// <returns>作成されたCOMオブジェクト</returns>
        public static object CreateObject(string progId)
        {
            //[2013.01.05]
            return CreateObject(progId, null);
        }
        
        #endregion

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewDotNetForm csNewProjectForm = new McGraphViewDotNetForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McGraphViewDotNetForm()
        {
            InitializeComponent();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewDotNetForm csNewProjectForm = new McGraphViewDotNetForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphViewDotNetForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csGraphViewScreen = csScreen as McGraphViewDotNetScreen; // 便利の為

            //凡例の色･線種変更時イベント割付
            legendList1.LegendStyleChanged += new EventHandler(legendList1_LegendStyleChanged);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じた時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphViewDotNetForm_FormClosed( sender, e )：フォームを閉じた時のイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphViewDotNetForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_csGraphViewScreen.CloseScreen();  //⇒★[2010.01.29]
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じようとした時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphViewDotNetForm_FormClosing( sender, e )：フォームが閉じようとしたときのイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphViewDotNetForm_FormClosing(object sender, FormClosingEventArgs e)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphViewDotNetForm_Load( sender, e )：フォームがロードされたときのイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphViewDotNetForm_Load(object sender, EventArgs e)
        {
            //[2013.02.05]CommonMPDataのパスを取得---↓
            McGraphViewDefine.g_sCommonMPData_Path = HySEnvInf.GetDataHomeDirectory().ToString() + "\\";   //[2013.02.07]
            McGraphViewDefine.g_sCommonMP_Path = HySEnvInf.GetHomeDirectory().ToString() + "\\";   //[2013.02.07]
            McGraphViewDefine.g_uriCommonMP_Path = new Uri(HySEnvInf.GetHomeDirectory().ToString() + "\\");    //[2013.02.07]
            //[2013.02.05]CommonMPDataのパスを取得---↑

            //[2013.02.06]自身業務パス---↓
            HySString a_csHomedir = HySEnvInf.GetHomeDirectory();
            //HySString csPath; // 実行環境及びツール開発環境で動作させる例
            if (a_csHomedir.ToString().EndsWith("Execute"))
            {
                // 実行環境(Execute\bin)で動作する場合
                McGraphViewDefine.g_MyGyomuPath = a_csHomedir.ToString() + "\\..\\Source\\HYSSOP\\AddinSysTools\\" + McGraphViewDefine.MCLSPVIEW_ID + "\\";
            }
            else
            {
                // ツール開発環境(Source\HYSSOP\AddInSysTools\DeveloperTestMain\bin)で動作する場合
                McGraphViewDefine.g_MyGyomuPath = a_csHomedir.ToString() + "\\..\\..\\" + McGraphViewDefine.MCLSPVIEW_ID + "\\";
                // add 150708
                McGraphViewDefine.g_sCommonMP_Path = HySEnvInf.GetDataHomeDirectory().ToString().Replace("CommonMPData\\", "") + "Execute\\";
                McGraphViewDefine.g_uriCommonMP_Path = new Uri(HySEnvInf.GetDataHomeDirectory().ToString().Replace("CommonMPData\\", "") + "Execute\\");
                // end add 150708
            }
            //[2013.02.06]---↑

            //[2013.02.07]---↓
            if (System.Threading.Thread.CurrentThread.CurrentUICulture.Name.StartsWith("ja") == true)
            {
                // OS設定が日本語の場合
            }
            else
            {
                // OS設定が日本語以外の場合
                cmbTargetData.Items.Clear();
                cmbTargetData.Items.Add("Rainfall Data");
                cmbTargetData.Items.Add("WaterLevel Data");
                cmbTargetData.Items.Add("Discharge Data");  //[2013.02.08]
                cmbTargetData.Items.Add("Cross Section Data");
            }
            //[2013.02.07]---↑

            cmbHourStart.SelectedIndex = 0;
            cmbHourEnd.SelectedIndex = 23;
            cmbMinuteStart.SelectedIndex = 0;
            cmbMinuteEnd.SelectedIndex = 00;

            cmbTargetData.SelectedIndex = 0;

            _redraw(0,0,23,0);

        }

        /// <summary><para>method outline:</para>
        /// <para>雨量フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFolder_Rainfall_Click( sender, e )：（雨量フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFolder_Rainfall_Click(object sender, EventArgs e)
        {
            //_selectFolder(ref m_Folder_Rainfall, txtFolder_Rainfall);
            _setFileListBoxByFolder(m_Folder_Rainfall, lbRainfall);

            //凡例から削除
            legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION);   //雨量
        }
        /// <summary><para>method outline:</para>
        /// <para>水位フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFolder_WaterLevel_Click( sender, e )：（水位フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFolder_WaterLevel_Click(object sender, EventArgs e)
        {
            //_selectFolder(ref m_Folder_WaterLevel, txtFolder_WaterLevel);
            _setFileCheckListBoxByFolder(m_Folder_WaterLevel, clbWaterLevel);

            //凡例から削除
            legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL);   //水位
        }
        /// <summary><para>method outline:</para>
        /// <para>流量フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFloder_FlowMeter_Click( sender, e )：（流量フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFloder_FlowMeter_Click(object sender, EventArgs e)
        {
            //_selectFolder(ref m_Folder_FlowMeter, txtFolder_FlowMeter);
            _setFileCheckListBoxByFolder(m_Folder_FlowMeter, clbFlowMeter);

            //凡例から削除
            legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE);   //流量
        }
        /// <summary><para>method outline:</para>
        /// <para>断面フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFolder_Danmen_Click( sender, e )：（断面フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFolder_Danmen_Click(object sender, EventArgs e)
        {
            _selectFolder(ref m_Folder_Danmen, txtFileName);
            _setFileListBoxByFolder(m_Folder_Danmen, lbDanmen);
        }

        /// <summary><para>method outline:</para>
        /// <para>表示対象コンボボックス変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> cmbTargetData_SelectedIndexChanged( sender, e )：表示対象コンボボックス変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmbTargetData_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                lbRainfall.Visible = false;
                clbWaterLevel.Visible = false;
                clbFlowMeter.Visible = false;
                lbDanmen.Visible = false;

                switch (cmbTargetData.SelectedIndex)
                {
                    case 0:     //雨量データ
                        lbRainfall.Visible = true;
                        break;
                    case 1:     //水位データ
                        clbWaterLevel.Visible = true;
                        break;
                    case 2:     //流量データ
                        clbFlowMeter.Visible = true;
                        break;
                    case 3:     //断面データ
                        lbDanmen.Visible = true;
                        break;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>水位データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> clbWaterLevel_SelectedIndexChanged( sender, e )：水位データチェック変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void clbWaterLevel_SelectedIndexChanged(object sender, EventArgs e)
        {
            //選択ファイルを凡例一覧に追加
            string sGroup = Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL; //水位
            for (int i = 0; i < clbWaterLevel.Items.Count; i++)
            {
                string sFileName = clbWaterLevel.Items[i].ToString();
                if (clbWaterLevel.CheckedIndices.Contains(i))
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sFileName);
                }
            }

            //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
            //[2010.06.03]
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawWaterLevel();
        }

        /// <summary><para>method outline:</para>
        /// <para>流量データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> clbFlowMeter_SelectedIndexChanged( sender, e )：流量データチェック変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void clbFlowMeter_SelectedIndexChanged(object sender, EventArgs e)
        {
            //選択ファイルを凡例一覧に追加
            string sGroup = Properties.HysAddinHydroHyetoGraphResources.DISCHARGE; //流量
            for (int i = 0; i < clbFlowMeter.Items.Count; i++)
            {
                string sFileName = clbFlowMeter.Items[i].ToString();
                if (clbFlowMeter.CheckedIndices.Contains(i))
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sFileName);
                }
            }

            //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
            //[2010.06.03]
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawWaterLevel();
        }

        /// <summary><para>method outline:</para>
        /// <para>雨量データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> lbRainfall_SelectedIndexChanged( sender, e )：雨量データ選択変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void lbRainfall_SelectedIndexChanged(object sender, EventArgs e)
        {
            //[2013.02.04]---↓
            /*
            for (int i = 0; i < lbRainfall.Items.Count; i++)
            {
                string sFileName = lbRainfall.Items[i].ToString();
                if (i == lbRainfall.SelectedIndex)
                {   //選択されている場合、凡例に追加
                    _selectedRainfall(true, sFileName);    //[2013.02.04]
                }
                else
                {   //選択されていない場合、凡例から削除
                    _selectedRainfall(false , sFileName);    //[2013.02.04]
                }
            }
            */
            //[2013.02.04]---↑

            //[2013.02.04]---↓
            //選択ファイルを凡例一覧に追加
            string sGroup = Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION; //雨量
            for (int i = 0; i < lbRainfall.Items.Count; i++)
            {
                string sFileName = lbRainfall.Items[i].ToString();
                if (i == lbRainfall.SelectedIndex)
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sFileName);
                }
            }

            //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
            //[2010.06.03]
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawRainfall();
        }

        /// <summary><para>method outline:</para>
        /// <para>断面データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> lbDanmen_SelectedIndexChanged( sender, e )：断面データ選択変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void lbDanmen_SelectedIndexChanged(object sender, EventArgs e)
        {
            _drawWaterLevel();
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例の色･線種変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> legendList1_LegendStyleChanged( sender, e )：凡例の変更フォームのOKボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void legendList1_LegendStyleChanged(object sender, EventArgs e)
        {
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }

        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnRedraw_Click( sender, e )：（再描画ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnRedraw_Click(object sender, EventArgs e)
        {
            m_IsAutoFit = false;    //[2010.06.03]
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnSetGraph_Click( sender, e )：（グラフ設定ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            McGraphSetForm a_frm = null;

            try
            {
                a_frm = new McGraphSetForm();
                a_frm.AxisLabelHyeto = labelAxisRain.Text;
                a_frm.AxisLabelHydroLeft = labelAxisLevel.Text;
                a_frm.AxisLabelHydroRight = labelAxisFlow.Text;
                a_frm.AxisRateHydroLeft = m_WaterLevelRateY;
                a_frm.AxisRateHydroRight = m_FlowMeterRateY;

                if (a_frm.ShowDialog(this) == DialogResult.OK)
                {
                    labelAxisRain.Text = a_frm.AxisLabelHyeto;
                    labelAxisLevel.Text = a_frm.AxisLabelHydroLeft;
                    labelAxisFlow.Text = a_frm.AxisLabelHydroRight;
                    m_WaterLevelRateY = a_frm.AxisRateHydroLeft;
                    m_FlowMeterRateY = a_frm.AxisRateHydroRight;
                }
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_frm != null)
                    a_frm.Dispose();
                a_frm = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>描画リセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnResetDraw_Click( sender, e )：（リセットボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnResetDraw_Click(object sender, EventArgs e)
        {
            //[2010.06.03]ファイルの内容から開始・終了時刻を再設定する。
            m_IsAutoFit = true;
            _getTimeStampAll();
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawRainfall();
        }
// start of 印刷機能追加
        /// <summary><para>method outline:</para>
        /// <para>取得領域ビットマップ化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap btmp = CaptureControl( ctrl )</para>
        /// </example>
        /// <param name="ctrl">ウインドウ部品（コントロール）</param>
        /// <returns>Bitmap : 取得領域内の画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Bitmap CaptureControl(Control ctrl)
        {
            Graphics g = ctrl.CreateGraphics();
            //ctrl（panel）の大きさのBitmapを生成
            Bitmap b_img = new Bitmap(ctrl.ClientRectangle.Width, ctrl.ClientRectangle.Height, g);
            Graphics memg = Graphics.FromImage(b_img);
            //BitBltの引数の用意
            IntPtr dc1 = g.GetHdc();
            IntPtr dc2 = memg.GetHdc();
            const int SRCCOPY = 0xCC0020;
            //Bitmap取得
            BitBlt(dc2, 0, 0, b_img.Width, b_img.Height, dc1, 0, 0, SRCCOPY);
            //解放処理
            g.ReleaseHdc(dc1);
            memg.ReleaseHdc(dc2);
            memg.Dispose();
            g.Dispose();
            return b_img;
        }

        /// <summary><para>method outline:</para>
        /// <para>プリントイベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> pd_PrintPage += new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">プリントイベント(PrintPageEvent)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void pd_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            //画像を描画する
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //e.Graphics.DrawImage(m_bit_img, 0, 0);
            e.Graphics.DrawImage(m_bit_img, 60, 60);
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //印刷の次のページがないこと
            e.HasMorePages = false;
            
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> print_button_Click( sender, e )：（印刷ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void print_button_Click(object sender, EventArgs e)
        {
            //印刷用ビットマップの取得
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //m_bit_img = (CaptureControl(panel1));
            m_bit_img = CreateGraphForPrint();
            //********** 速度改善他対応 2011.03.04 mod_e **************************************************

            //プリントドキュメントの生成
            m_pd = new System.Drawing.Printing.PrintDocument();

            //PrintPageイベントハンドラの追加
            m_pd.PrintPage +=
                new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

            //プリントダイアログの生成
            PrintDialog pdlg = new PrintDialog();
            pdlg.UseEXDialog = true;
            //PrintDocumentを指定
            pdlg.Document = m_pd;
            //印刷の選択ダイアログを表示する
            if (pdlg.ShowDialog() == DialogResult.OK)
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                //プリンター設定
                m_pd.PrinterSettings = pdlg.PrinterSettings;

                //ページ設定
                foreach (System.Drawing.Printing.PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    if (ps.Kind == System.Drawing.Printing.PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;    //横
                        break;
                    }
                }
                //********** 速度改善他対応 2011.03.04 add_s **************************************************

                //OKがクリックされた時は印刷する
                m_pd.Print();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷プレビュー表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Preview_button_Click( sender, e )：（印刷ﾌﾟﾚﾋﾞｭｰボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Preview_button_Click(object sender, EventArgs e)
        {
            // start of 印刷プレビュー処理修正
            try
            {
                //印刷用ビットマップの取得
                //********** 速度改善他対応 2011.03.04 mod_s **************************************************
                //m_bit_img = (CaptureControl(panel1));
                m_bit_img = CreateGraphForPrint();
                //********** 速度改善他対応 2011.03.04 mod_e **************************************************

                //プリントドキュメントの生成
                m_pd = new System.Drawing.Printing.PrintDocument();

                //PrintPageイベントハンドラの追加
                m_pd.PrintPage +=
                    new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

                //プレビューフォームのインスタンス生成
                PrintPreviewDialog ppd = new PrintPreviewDialog();
                //プレビューするPrintDocumentを設定
                ppd.Document = m_pd;

                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                //プリンター設定
                m_pd.PrinterSettings = ppd.Document.PrinterSettings;

                //ページ設定
                foreach (System.Drawing.Printing.PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    if (ps.Kind == System.Drawing.Printing.PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;    //横
                        break;
                    }
                }
                //********** 速度改善他対応 2011.03.04 add_s **************************************************

                //印刷プレビューダイアログを表示する
                ppd.ShowDialog();
                //bitmap解放
                m_bit_img.Dispose();
            }
            catch(Exception exp)
            {
                // 例外を此処で捕捉して任意処理実施
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            // end of 印刷プレビュー処理修正
        }

        // end of 印刷機能追加

        //********** 速度改善他対応 2011.03.04 add_s **************************************************
        /// <summary><para>method outline:</para>
        /// <para>画像保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveImage_button_Click( sender, e )：（画像保存クリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveImage_button_Click(object sender, EventArgs e)
        {
            //--------------------------------------------------
            // 保存先選択ダイアログ表示
            //--------------------------------------------------
            SaveFileDialog sfd = new SaveFileDialog();
            //タイトルを設定する
            sfd.Title = Properties.Resources.STRING_SAVEFILEDIALOG_TITLE;                  // 多言語対応
            //はじめのファイル名を指定する
            sfd.FileName = "graph1.png";
            //[2013.02.05]
            sfd.InitialDirectory = McGraphViewDefine.g_sCommonMPData_Path;
            //sfd.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString();
            sfd.Filter = string.Format(Properties.HysAddinHydroHyetoGraphResources.FILE_DLG_FILTER_ANY, "png");
            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
            sfd.RestoreDirectory = true;
            
            //ダイアログを表示する
            if (sfd.ShowDialog() != DialogResult.OK)
            {   //キャンセルボタンがクリックされたとき
                return;  
            }

            //--------------------------------------------------
            // 保存用画像作成
            //--------------------------------------------------
            using (Bitmap bmp = CreateGraphForPrint())
            {
                //保存
                bmp.Save(sfd.FileName, System.Drawing.Imaging.ImageFormat.Png);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例を付け足した画像作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap bmp = CreateGraphForPrint()</para>
        /// </example>
        /// <returns>凡例付き画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Bitmap CreateGraphForPrint()
        {
            Graphics g = null;
            Bitmap bmpLeg = null;
            try
            {
                int iLegendWidth = 0;
                if (chkPrintLegend.Checked)
                {
                    //凡例を付け足す
                    legendList1.DrawLegend(ref bmpLeg, chkPrintFileName.Checked);

                    //凡例のサイズ
                    iLegendWidth = bmpLeg.Width + 10;
                }

                Bitmap bmp = new Bitmap(panel1.Width + iLegendWidth + 10, panel1.Height + 10);
                
                //Graphicsオブジェクトを取得
                g = Graphics.FromImage(bmp);
                //背景を白色にする
                g.FillRectangle(Brushes.White, 0, 0, bmp.Width, bmp.Height);

                //グラフを合成
                g.DrawImage(picRainfall.Image, 0, 0);                          //ハイエトグラフ描画[2013.01.25]
                g.DrawImage(picWaterLevel.Image, 0, picRainfall.Height + 5);   //ハイドログラフ描画[2013.01.25]

                //ラベル描画
                using (SolidBrush bs = new SolidBrush(Color.Black))
                {
                    Font ft = labelAxisRain.Font;
                    g.DrawString(labelAxisRain.Text, ft, bs, 40, 5);    //[2013.01.25]
                    g.DrawString(labelAxisLevel.Text, ft, bs, 40, picRainfall.Height + 10); //[2013.01.25]
                    //右軸ラベルは右寄せ
                    RectangleF rect = new RectangleF(0, picRainfall.Height + 10, panel1.Width - 50, 18); //[2013.01.25]
                    StringFormat sformat = new StringFormat();
                    sformat.Alignment = StringAlignment.Far;
                    g.DrawString(labelAxisFlow.Text, ft, bs, rect, sformat);
                }

                if (bmpLeg != null)
                {   //凡例を合成
                    int iLegeTop = Math.Max((panel1.Height - bmpLeg.Height - 50), 5);
                    g.DrawImage(bmpLeg, picWaterLevel.Image.Width + 10, iLegeTop);
                }

                return bmp;
            }
            finally
            {
                if (bmpLeg != null)
                {
                    bmpLeg.Dispose();
                    bmpLeg = null;
                }
                if (g != null)
                {
                    g.Dispose();
                    g = null;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFileName_Click( sender, e )：（ファイル選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFileName_Click(object sender, EventArgs e)
        {
            //[2013.01.04]
            try
            {
                _selectFile(txtFileName);

                if (this.txtFileName.Text.Length > 0)
                {
                    switch (this.cmbTargetData.SelectedIndex)
                    {
                        case 0: //雨量
                            this.lbRainfall.Items.Add(this.txtFileName.Text);
                            this.lbRainfall.SelectedIndex = this.lbRainfall.Items.Count - 1;    //[2013.02.04]
                            //凡例から削除
                            //legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION);   //雨量
                            break;
                        case 1: //水位
                            this.clbWaterLevel.Items.Add(this.txtFileName.Text);
                            this.clbWaterLevel.SetItemChecked(this.clbWaterLevel.Items.Count - 1,true);  //[2013.02.07]
                            this.clbWaterLevel.SelectedIndex = this.clbWaterLevel.Items.Count - 1;    //[2013.02.07]
                            break;
                        case 2: //流量
                            this.clbFlowMeter.Items.Add(this.txtFileName.Text);
                            this.clbFlowMeter.SetItemChecked(this.clbFlowMeter.Items.Count - 1,true);    //[2013.02.07]
                            this.clbFlowMeter.SelectedIndex = this.clbFlowMeter.Items.Count - 1;    //[2013.02.07]
                            break;
                        case 3: //断面
                            this.lbDanmen.Items.Add(this.txtFileName.Text);
                            this.lbDanmen.SelectedIndex = this.lbDanmen.Items.Count - 1;    //[2013.02.04]
                            break;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnDelFile_Click( sender, e )：（ファイル削除ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnDelFile_Click(object sender, EventArgs e)
        {
            //[2013.01.04]
            string a_sVal = "";
            string a_sFileName = "";    //[2013.02.08]
            int a_iCnt = 0;
            int a_iMax = 0;

            try
            {
                switch (this.cmbTargetData.SelectedIndex)
                {
                    case 0: //雨量
                        a_sFileName = this.lbRainfall.Items[this.lbRainfall.SelectedIndex].ToString();
                        this.lbRainfall.Items.RemoveAt(this.lbRainfall.SelectedIndex);
                        a_sVal = Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION;
                        break;
                    case 1: //水位
                        a_iMax = this.clbWaterLevel.Items.Count - 1;
                        for (a_iCnt = a_iMax; a_iCnt >= 0; a_iCnt--)
                        {
                            foreach (string a in this.clbWaterLevel.SelectedItems)  //[2013.02.07]
                            {
                                //Console.WriteLine(a);
                                if (a.Equals(this.clbWaterLevel.Items[a_iCnt].ToString()) == true)
                                {
                                    a_sFileName = this.clbWaterLevel.Items[a_iCnt].ToString();
                                    this.clbWaterLevel.Items.RemoveAt(a_iCnt);
                                    break;
                                }
                            }
                        }
                        a_sVal = Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL;
                        break;
                    case 2: //流量
                        a_iMax = this.clbFlowMeter.Items.Count - 1;
                        for (a_iCnt = a_iMax; a_iCnt >= 0; a_iCnt--)
                        {
                            foreach (string a in this.clbFlowMeter.SelectedItems)   //[2013.02.07]
                            {
                                //Console.WriteLine(a);
                                if (a.Equals(this.clbFlowMeter.Items[a_iCnt].ToString()) == true)
                                {
                                    a_sFileName = this.clbFlowMeter.Items[a_iCnt].ToString();
                                    this.clbFlowMeter.Items.RemoveAt(a_iCnt);
                                    break;
                                }
                            }
                        }
                        a_sVal = Properties.HysAddinHydroHyetoGraphResources.DISCHARGE;
                        break;
                    case 3: //断面
                        a_sFileName = this.lbDanmen.Items[this.lbDanmen.SelectedIndex].ToString();
                        this.lbDanmen.Items.RemoveAt(this.lbDanmen.SelectedIndex);
                        break;
                }
                //凡例から削除
                legendList1.DelList(a_sVal,a_sFileName);   //[2013.02.08]
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnSaveDrawStatus_Click( sender, e )：（描画状態の保存ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSaveDrawStatus_Click(object sender, EventArgs e)
        {
            //[2013.01.04]
            Cursor a_preCursor = Cursor.Current;
            System.IO.Stream a_stream = null;
            System.IO.StreamWriter a_sw = null;

            try
            {
                //SaveFileDialogクラスのインスタンスを作成
                SaveFileDialog a_sfd = new SaveFileDialog();

                //はじめのファイル名を指定する
                //a_sfd.FileName = "新しいファイル.html";
                //はじめに表示されるフォルダを指定する
                //a_sfd.InitialDirectory = @"C:\";
                //[ファイルの種類]に表示される選択肢を指定する
                //a_sfd.Filter =
                //    "csvファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*";
                a_sfd.Filter = Properties.Resources.STRING_SAVEFILEDIALOG_FILTER_CSV;         // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_sfd.FilterIndex = 1;
                //タイトルを設定する
                //a_sfd.Title = "保存先のファイルを指定してください";
                a_sfd.Title = Properties.Resources.STRING_SAVEFILEDIALOG_TITLE;               // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_sfd.InitialDirectory = McGraphViewDefine.g_sCommonMPData_Path;
                //a_sfd.RestoreDirectory = true;
                //既に存在するファイル名を指定したとき警告する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.OverwritePrompt = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_sfd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_sfd.FileName);
                    Cursor.Current = Cursors.WaitCursor;
                    a_stream = a_sfd.OpenFile();
                    if (a_stream != null)
                    {
                        //ファイルに書き込む
                        a_sw = new System.IO.StreamWriter(a_stream, System.Text.Encoding.GetEncoding("shift_jis"));
                        m_RestoreDrawFileName = a_sfd.FileName.ToString();  // add 150708
                        _writeDrawGraphSet(ref a_sw); //グラフ設定
                        _writeDrawPeriod(ref a_sw); //表示期間
                        _writeDrawTarget(ref a_sw); //表示対象
                        _writeDrawLegend(ref a_sw); //凡例

                        btnOverwriteDrawStatus.Enabled = false; //[2013.01.23]
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sw != null)
                {
                    a_sw.Close();
                    a_sw = null;
                }
                if (a_stream != null)
                {
                    a_stream.Close();
                    a_stream = null;
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnRestoreDraw_Click( sender, e )：（グラフ描画の復元ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnRestoreDraw_Click(object sender, EventArgs e)
        {
            //[2013.01.05]
            Cursor a_preCursor = Cursor.Current;
            System.IO.StreamReader a_sr = null;

            try
            {
                //OpenFileDialogクラスのインスタンスを作成
                OpenFileDialog a_ofd = new OpenFileDialog();

                //はじめのファイル名を指定する
                //はじめに「ファイル名」で表示される文字列を指定する
                //a_ofd.FileName = "default.csv";
                //はじめに表示されるフォルダを指定する
                //指定しない（空の文字列）の時は、現在のディレクトリが表示される
                //a_ofd.InitialDirectory = Properties.HysAddinHydroHyetoGraphResources.MSG_INFO_SPECIFY_FOLDER;
                //[ファイルの種類]に表示される選択肢を指定する
                //指定しないとすべてのファイルが表示される
                //a_ofd.Filter =
                //    "csvファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*";
                a_ofd.Filter = Properties.Resources.STRING_OPENFILEDIALOG_FILTER;            // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_ofd.FilterIndex = 1;
                //タイトルを設定する
                //a_ofd.Title = "開くファイルを選択してください";
                a_ofd.Title = Properties.Resources.STRING_OPENFILEDIALOG_TITLE;              // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_ofd.InitialDirectory = McGraphViewDefine.g_sCommonMPData_Path;
                //a_ofd.RestoreDirectory = true;
                //存在しないファイルの名前が指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckFileExists = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_ofd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_ofd.FileName);
                    Cursor.Current = Cursors.WaitCursor;

                    //表示対象・凡例を初期化
                    this.lbRainfall.Items.Clear();
                    this.clbWaterLevel.Items.Clear();
                    this.clbFlowMeter.Items.Clear();
                    this.lbDanmen.Items.Clear();
                    this.legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION);
                    this.legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL);
                    this.legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE);

                    m_RestoreDrawFileName = a_ofd.FileName; //[2013.01.23]

                    //ファイルを読み込む
                    a_sr = new System.IO.StreamReader(a_ofd.FileName, System.Text.Encoding.GetEncoding("shift_jis"));
                    _readDrawGraphSet(ref a_sr); //グラフ設定
                    _readDrawPeriod(ref a_sr); //表示期間
                    _readDrawTarget(ref a_sr); //表示対象
                    _readDrawLegend(ref a_sr); //凡例

                    btnOverwriteDrawStatus.Enabled = true;  //[2013.01.23]
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sr != null)
                {
                    a_sr.Close();
                    a_sr = null;
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnOutDrawData_Click( sender, e )：（描画データ出力ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnOutDrawData_Click(object sender, EventArgs e)
        {
            //[2013.01.05]
            Cursor a_preCursor = Cursor.Current;
            string a_sTmpFile = "";
            System.IO.StreamWriter a_sw = null;

            try
            {
                //SaveFileDialogクラスのインスタンスを作成
                SaveFileDialog a_sfd = new SaveFileDialog();

                //はじめのファイル名を指定する
                //a_sfd.FileName = "新しいファイル.html";
                //はじめに表示されるフォルダを指定する
                //a_sfd.InitialDirectory = @"C:\";
                //[ファイルの種類]に表示される選択肢を指定する
                //a_sfd.Filter =
                //    "Excelファイル(*.xls)|*.xls";
                a_sfd.Filter = Properties.Resources.STRING_SAVEFILEDIALOG_FILTER_EXCEL;       // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_sfd.FilterIndex = 1;
                //タイトルを設定する
                //a_sfd.Title = "保存先のファイルを指定してください";
                a_sfd.Title = Properties.Resources.STRING_SAVEFILEDIALOG_TITLE;               // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_sfd.InitialDirectory = McGraphViewDefine.g_sCommonMPData_Path;
                //a_sfd.RestoreDirectory = true;
                //既に存在するファイル名を指定したとき警告する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.OverwritePrompt = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_sfd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_sfd.FileName);
                    Cursor.Current = Cursors.WaitCursor;
                    a_sTmpFile = System.IO.Path.GetTempFileName();
                    a_sw = new System.IO.StreamWriter(a_sTmpFile, false, System.Text.Encoding.GetEncoding("shift_jis"));
                    //ファイルに書き込む
                    _writeOutDrawHyeto(ref a_sw); //雨量
                    _writeOutDrawHydro(ref a_sw);  //断面・水位・流量
                    a_sw.Close();
                    a_sw = null;

                    //Excelマクロファイルパス[2013.02.06]
                    string strMacroPath = McGraphViewDefine.g_MyGyomuPath + @"\" + McGraphViewDefine.MCLSPVIEW_ID + ".xls";
                    //string strMacroPath = HySEnvInf.GetHomeDirectory().ToString() + @"\jp.go.nilim.HyetoHydroGraph_H26.xls";
                    // Excel操作用COMオブジェクトを生成する
                    object oExcel = CreateObject("Excel.Application");
                    //ワークブックコレクションオブジェクトを生成する。
                    object oBooks = oExcel.GetType().InvokeMember("Workbooks", BindingFlags.GetProperty, null, oExcel, null);

                    //Excelファイルのオープン
                    object oBook = oBooks.GetType().InvokeMember(
                                          "Open", BindingFlags.InvokeMethod, null,
                                          oBooks, new object[] { 
                                                       strMacroPath
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing 
                                                     });

                    // Excelファイルの表示
                    oExcel.GetType().InvokeMember("Visible", BindingFlags.SetProperty, null, oExcel, new object[] { true });

                    //マクロ実行(Testというサブプロシージャを実行する)
                    //oExcel.Run("Test");
                    //oExcel.GetType().InvokeMember("Save", System.Reflection.BindingFlags.InvokeMethod, null, oExcel, new object[] { a_sfd.FileName });
                    oExcel.GetType().InvokeMember("Run", BindingFlags.InvokeMethod, null, oExcel, new object[] { "OutDrawData", a_sfd.FileName, a_sTmpFile });

                    //保存
                    //oExcel.GetType().InvokeMember("Save", System.Reflection.BindingFlags.InvokeMethod, null, oExcel, new object[] { a_sfd.FileName });
                    //閉じる
                    oExcel.GetType().InvokeMember("Quit", System.Reflection.BindingFlags.InvokeMethod, null, oExcel, null);
                    //COM解放
                    System.Runtime.InteropServices.Marshal.FinalReleaseComObject(oBook);
                    System.Runtime.InteropServices.Marshal.FinalReleaseComObject(oBooks);
                    System.Runtime.InteropServices.Marshal.FinalReleaseComObject(oExcel);
                    oBook = null;
                    oBooks = null;
                    oExcel = null;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sw != null)
                {
                    a_sw.Close();
                }
                if (a_sTmpFile.Length > 0)
                {
                    File.Delete(a_sTmpFile);
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例を追加チェック時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> chkPrintLegend_CheckedChanged( sender, e )：（凡例を追加チェック時イベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void chkPrintLegend_CheckedChanged(object sender, EventArgs e)
        {
            if (chkPrintLegend.Checked == true)
            {
                chkPrintFileName.Enabled = true;
            }
            else
            {
                chkPrintFileName.Enabled = false;
                chkPrintFileName.Checked = false;
            }
        }

        private void btnOverwriteDrawStatus_Click(object sender, EventArgs e)
        {
            Cursor a_preCursor = Cursor.Current;
            System.IO.StreamWriter a_sw = null;

            try
            {
                Cursor.Current = Cursors.WaitCursor;
                //ファイルに書き込む
                a_sw = new System.IO.StreamWriter(m_RestoreDrawFileName, false, System.Text.Encoding.GetEncoding("shift_jis"));
                _writeDrawGraphSet(ref a_sw); //グラフ設定
                _writeDrawPeriod(ref a_sw); //表示期間
                _writeDrawTarget(ref a_sw); //表示対象
                _writeDrawLegend(ref a_sw); //凡例
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sw != null)
                {
                    a_sw.Close();
                    a_sw = null;
                }
                Cursor.Current = a_preCursor;
            }
        }

        private void McGraphViewDotNetForm_HelpButtonClicked(object sender, CancelEventArgs e)
        {
            try
            {
                System.Diagnostics.Process.Start(McGraphViewDefine.g_sCommonMP_Path + "ToolManual\\" + McGraphViewDefine.MCLSPVIEW_ID + "\\" + McGraphViewDefine.MCLSPVIEW_ID + ".pdf");
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.HysAddinHydroHyetoGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //********** 速度改善他対応 2011.03.04 add_s **************************************************

    }
}