﻿//using System;
//using System.Collections.Generic;
//using System.Text;
using System;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;

namespace jp.go.nilim.HyetoHydroGraph_H26
{
    /// <summary><para>class outline:</para>
    /// <para>水位・流量データグラフ表示</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public class McGraphViewWaterLevel : McGraphViewImageLib
    {
		/**********************************************************************
		 * 定数の定義
		**********************************************************************/
        /// <summary> 水位描画色：ペン </summary>
		private Pen m_pen_WaterLevel = new Pen(Color.Indigo,1.5F);
        /// <summary> 水位描画色：塗りつぶし </summary>
        private SolidBrush m_brush_WaterLevel = new SolidBrush(Color.Indigo);
        /// <summary> 流量描画色：ペン </summary>
        private Pen m_pen_FlowMeter = new Pen(Color.DarkGreen, 1.5F);
        /// <summary> 流量描画色：塗りつぶし </summary>
        private SolidBrush m_brush_FlowMeter = new SolidBrush(Color.DarkGreen);

        /*
        private Pen m_pen_WaterLevel = new Pen(Color.Crimson, 0.5F);
        private SolidBrush m_brush_WaterLevel = new SolidBrush(Color.Crimson);
        */

		/**********************************************************************
		 * 変数の定義
		**********************************************************************/
        /// <summary> 対象年（西暦4桁） </summary>
        private string m_Year;		// 対象年（西暦4桁）
        /// <summary> 対象月 </summary>
        private string m_Month;		// 対象月
        /// <summary> 対象日 </summary>
        private string m_Day;		// 対象日
        /// <summary> 対象時間 </summary>
        private string m_Hour;		// 対象時間
		//private clsCommon m_clsCommon = new clsCommon();

        /// <summary> 流量Y軸セパレート値 </summary>
        private float m_FlowMeter_sep_y_val = 0;
        /// <summary> 流量Y軸セパレート値 </summary>
        private float m_FlowMeterSepY = 0;
        /// <summary> 流量Y軸最小値 </summary>
        private float m_FlowMeterMinY = 0;
        /// <summary> 流量X軸：一つ前の値 </summary>
        private float m_FlowMeterPrevX = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
        /// <summary> 流量Y軸：一つ前の値 </summary>
        private float m_FlowMeterPrevY = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]

		/**********************************************************************
		 * プロパティの定義
		**********************************************************************/
        /// <summary>
        /// 対象年（西暦4桁）
        /// </summary>
		public string Year	// 対象年（西暦4桁）
		{
			set
			{
				m_Year = value;
			}
			get
			{
				return m_Year;
			}
		}
        /// <summary>
        /// 対象月
        /// </summary>
		public string Month	// 対象月
		{
			set
			{
				m_Month = value;
			}
			get
			{
				return m_Month;
			}
		}
        /// <summary>
        /// 対象日
        /// </summary>
		public string Day	// 対象日
		{
			set
			{
				m_Day = value;
			}
			get
			{
				return m_Day;
			}
		}
        /// <summary>
        /// 対象時間
        /// </summary>
		public string Hour	// 対象時間
		{
			set
			{
				m_Hour = value;
			}
			get
			{
				return m_Hour;
			}
		}
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public McGraphViewWaterLevel()
		{
			
		}

		//*********************************************************************
		// @(f)
		// 機能      : グラフの初期化
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitGraph(h_stTime, h_edTime, h_mode, ref h_FlowMeterMinY, ref h_FlowMeterMaxY)</para>
        /// </example>
        /// <param name="h_stTime">開始時刻</param>
        /// <param name="h_edTime">終了時刻</param>
        /// <param name="h_mode">0：分単位、1：時間単位</param>
        /// <param name="h_FlowMeterMinY">流量Y軸最小値</param>
        /// <param name="h_FlowMeterMaxY">流量Y軸最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void InitGraph(
            DateTime h_stTime,
            DateTime h_edTime,
            int h_mode,  //0：分単位、1：時間単位
            ref float h_FlowMeterMinY,
            ref float h_FlowMeterMaxY
            )
		{
            /*
            DateTime a_stTime = h_stTime;
            DateTime a_edTime = h_edTime;

            //[2010.03.07]X軸の調整
            TimeSpan a_ts = h_stTime - h_edTime;
            float a_fTmpX = (ImageWidth - (m_sep_left + m_sep_right)) / (GraphMaxX - GraphMinX);
            if ((a_fTmpX * GraphSepX) < (m_font1.Size * 2))
            {
                GraphSepX = Convert.ToInt32((m_font1.Size * 2) / a_fTmpX);
            }
            else
            {
            }
             */

            //Y軸の調整
            float a_fTmpY = (ImageHeight - (m_sep_top + m_sep_bottom)) / (GraphMaxY - GraphMinY);
            if ((a_fTmpY * GraphSepY) < (m_font1.Size * 2))
            {
                GraphSepY = Convert.ToInt32((m_font1.Size * 2) / a_fTmpY);
            }
            else
            {
            }

			InitializeGraph();
			_drawGraphBackGround();

            //-----------------------------------------------------------------
            //流量のY軸調整
            //-----------------------------------------------------------------
/*
            //★[2010.06.02]
            int a_FMinY = Convert.ToInt32(Math.Floor(h_FlowMeterMinY)); //最小値を整数に変換
            int a_FMaxY = Convert.ToInt32(Math.Ceiling(h_FlowMeterMaxY)); //最大値を整数に変換
            int a_FSep = 1;                //流量の分割値を算出
            int a_FKeta = 0;         //分割値の桁を算出

            int a_FV10_1_1 = 0;
            int a_FV10_1_2 = 0;
            int a_FV10_2_1 = 0;
            //int a_FV10_2_2 = 0;

            int a_FTmp1 = 0;

            //-----------------------------------------------------------------
            //最小値の調整
            a_FKeta = a_FMinY.ToString().Replace("-","").Length;
            if (a_FKeta > 1)
            {
                a_FV10_1_1 = a_FMinY / Convert.ToInt32(Math.Pow(10, (a_FKeta - 1)));        //分割値を10の倍数で割る
                a_FV10_1_2 = a_FMinY - (a_FV10_1_1 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 1))));           //分割値から10の倍数を減算
            }

            if (a_FKeta > 2)
            {
                a_FV10_2_1 = a_FV10_1_2 / Convert.ToInt32(Math.Pow(10, (a_FKeta - 2)));    //分割値の余りを10の倍数で割る
            }
            else
            {
                a_FV10_2_1 = a_FV10_1_2;
            }

            //分割単位を、5*10　の倍数とする
            if (a_FKeta > 1)
            {
                a_FTmp1 = a_FMinY;

                a_FMinY = (a_FV10_1_1 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 1))));

                if (a_FV10_2_1 != 0)
                {
                    if (a_FKeta > 2)
                    {
                        a_FMinY -= (5 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 2))));

                        if (a_FTmp1 < a_FMinY)
                        {
                            a_FMinY -= (5 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 2))));
                        }
                    }
                    else
                    {
                        a_FMinY -= 5;
                        if (a_FTmp1 < a_FMinY)
                        {
                            a_FMinY -= 5;
                        }
                    }
                }
            }
            else
            {
                if (a_FMinY >= 0)
                {
                    a_FMinY = 0;
                }
                else
                {
                    a_FMinY = -10;
                }
            }
            //-----------------------------------------------------------------

            a_FSep = 1;                //流量の分割値を算出
            a_FKeta = 0;         //分割値の桁を算出

            a_FV10_1_1 = 0;
            a_FV10_1_2 = 0;
            a_FV10_2_1 = 0;
            //int a_FV10_2_2 = 0;

            //-----------------------------------------------------------------
            //最大値の調整
            a_FKeta = a_FMaxY.ToString().Replace("-", "").Length;
            if (a_FKeta > 1)
            {
                a_FV10_1_1 = a_FMaxY / Convert.ToInt32(Math.Pow(10, (a_FKeta - 1)));        //分割値を10の倍数で割る
                a_FV10_1_2 = a_FMaxY - (a_FV10_1_1 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 1))));           //分割値から10の倍数を減算
            }

            if (a_FKeta > 2)
            {
                a_FV10_2_1 = a_FV10_1_2 / Convert.ToInt32(Math.Pow(10, (a_FKeta - 2)));    //分割値の余りを10の倍数で割る
            }
            else
            {
                a_FV10_2_1 = a_FV10_1_2;
            }

            //分割単位を、5*10　の倍数とする
            if (a_FKeta > 1)
            {
                a_FTmp1 = a_FMaxY;

                a_FMaxY = (a_FV10_1_1 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 1))));

                if (a_FV10_2_1 != 0)
                {
                    if (a_FKeta > 2)
                    {
                        a_FMaxY += (5 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 2))));

                        if (a_FTmp1 > a_FMaxY)
                        {
                            a_FMaxY += (5 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 2))));
                        }
                    }
                    else
                    {
                        a_FMaxY += 5;

                        if (a_FTmp1 > a_FMaxY)
                        {
                            a_FMaxY += 5;
                        }
                    }
                }

            }
            else
            {
                a_FMaxY = 10;
            }
            //-----------------------------------------------------------------

            int a_FDiv = a_FMaxY - a_FMinY;                 //最大値－最小値
            a_FSep = a_FDiv / Convert.ToInt32(m_num_y_graph);                //流量の分割値を算出
            a_FKeta = a_FSep.ToString().Replace("-", "").Length;         //分割値の桁を算出

            if (a_FSep == 0)
            {
                a_FSep = 1;
            }

            a_FV10_1_1 = a_FSep;
            a_FV10_1_2 = a_FSep;
            a_FV10_2_1 = a_FSep;

            if(a_FKeta > 1){
                a_FV10_1_1 = a_FSep / Convert.ToInt32(Math.Pow(10,(a_FKeta - 1)));        //分割値を10の倍数で割る
                a_FV10_1_2 = a_FSep - (a_FV10_1_1 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 1))));           //分割値から10の倍数を減算
            }

            if (a_FKeta > 2)
            {
                a_FV10_2_1 = a_FV10_1_2 / Convert.ToInt32(Math.Pow(10, (a_FKeta - 2)));    //分割値の余りを10の倍数で割る
            }
            else
            {
                a_FV10_2_1 = a_FV10_1_2;
            }

            //分割単位を、5*10　の倍数とする
            if (a_FKeta > 1)
            {

                a_FSep = (a_FV10_1_1 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 1))));

                if (a_FV10_2_1 != 0)
                {
                    if (a_FKeta > 2)
                    {
                        a_FSep += (5 * Convert.ToInt32(Math.Pow(10, (a_FKeta - 2))));
                    }
                    else
                    {
                        a_FSep += 5;
                    }
                }
            }
            else
            {
                a_FSep = 5;
            }

            //最小値を求める。
            h_FlowMeterMinY = a_FMinY;
            if ((Math.Abs(a_FMinY) % a_FSep) > 0)
            {
                h_FlowMeterMinY = (a_FSep * Convert.ToInt32(a_FMinY / a_FSep)) - a_FSep;
            }

            //最大値を求める。
            h_FlowMeterMaxY = a_FMaxY;
            if ((Math.Abs(a_FMaxY) % a_FSep) > 0)
            {
                h_FlowMeterMaxY = (a_FSep * Convert.ToInt32(a_FMaxY / a_FSep)) + a_FSep;
            }
*/
            //********** Y軸目盛不具合対応 2011.03.04 add_s **************************************************
            //[2013.01.24]---↓
            m_FlowMeterSepY =(h_FlowMeterMaxY - h_FlowMeterMinY) / m_num_y_graph;   //切り上げ
            //m_FlowMeterSepY = Convert.ToInt32(Math.Ceiling((h_FlowMeterMaxY - h_FlowMeterMinY) / m_num_y_graph));   //切り上げ
            //h_FlowMeterMaxY = h_FlowMeterMinY + (m_FlowMeterSepY * m_num_y_graph);
            //[2013.01.23]---↑
            //********** Y軸目盛不具合対応 2011.03.04 add_e **************************************************
            /* //********** Y軸目盛不具合対応 2011.03.04 del_s **************************************************
            if ((h_FlowMeterMaxY % 50) != 0)
            {
                h_FlowMeterMaxY += 50 - (Convert.ToInt32(h_FlowMeterMaxY % 50));
            }

            int a_fFTmpY = Convert.ToInt32((h_FlowMeterMaxY - h_FlowMeterMinY) % m_num_y_graph);
            if(a_fFTmpY !=0){
                //余りあり
                a_fFTmpY = m_num_y_graph - a_fFTmpY;
                h_FlowMeterMaxY += 50 - a_fFTmpY;
            }

            m_FlowMeterSepY = Convert.ToInt32((h_FlowMeterMaxY - h_FlowMeterMinY) / m_num_y_graph);
            //********** Y軸目盛不具合対応 2011.03.04 del_e ************************************************** */

            m_FlowMeter_sep_y_val = (ImageHeight - (m_sep_top + m_sep_bottom)) / (h_FlowMeterMaxY - h_FlowMeterMinY);
            m_FlowMeterMinY = h_FlowMeterMinY;
            //流量のY軸目盛表示
            for (int a_iCnt=0; a_iCnt <= m_num_y_graph; a_iCnt++)
            {
                DrawYMeasureString2(
                    (a_iCnt*m_FlowMeterSepY + h_FlowMeterMinY).ToString("###,###,##0"), //[2013.01.24]
                    ImageWidth - m_sep_right + 5,   //Y軸目盛不具合対応 2011.03.04 文字が欠けているので+2->+5に変更
                    ImageHeight - m_sep_bottom - ((a_iCnt * m_FlowMeterSepY) * m_FlowMeter_sep_y_val) - m_font1.Size/2
                    );
            }
            //-----------------------------------------------------------------

            //X軸の目盛表示
            //[2010.03.07]日時範囲の計算
            DateTime a_stTime = h_stTime;
            TimeSpan a_tTmp = h_edTime - h_stTime;
            int a_Xnum = 0;
            int a_Xsep = 0;
            int a_disp = 0; //1：時間表示、2：日表示、3：月表示、4：年表示
            if (a_tTmp.Days < 7)
            {   //1週間以内
                a_disp = 1;
                if (h_edTime.Day > h_stTime.Day)
                {   //日付が異なる
                    //2日分とする。
                    a_Xnum = 24 * (a_tTmp.Days + 1);
                    switch (a_tTmp.Days)
                    {
                        case 0:
                            a_Xsep = 1;
                            break;
                        case 1:
                            a_Xsep = 2;
                            break;
                        case 2:
                            a_Xsep = 2;
                            break;
                        case 3:
                            a_Xsep = 4;
                            break;
                        case 4:
                            a_Xsep = 4;
                            break;
                        case 5:
                            a_Xsep = 4;
                            break;
                        case 6:
                            a_Xsep = 6;
                            break;
                        //case 7:
                        //    a_Xsep = 6;
                        //    break;
                    }
                }
                else
                {   //日付が同じ
                    //該当日分とする。
                    a_Xnum = 24;
                    a_Xsep = 1;
                }
            }
            else if (a_tTmp.Days < 31)
            {   //1週間～１ヶ月以内
                a_Xnum = 24 * (a_tTmp.Days + 1);
                if (a_tTmp.Days == 7)
                {
                    a_disp = 1;
                    a_Xsep = 8;
                }
                else if ((a_tTmp.Days >= 8) && (a_tTmp.Days <= 15))
                {
                    a_disp = 1;
                    a_Xsep = 12;
                }
                else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 30))
                {
                    a_disp = 2;
                    a_Xsep = 24;
                }
            }
            else if (a_tTmp.Days < 366)
            {   //1ヶ月から1年以内
                a_Xnum = 24 * (a_tTmp.Days + 1);
                if (a_tTmp.Days == 31)
                {
                    a_disp = 2;
                    a_Xsep = 24;
                }
                else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 365))
                {
                    a_disp = 3;
                    a_Xsep = 24 * 30;
                }
            }
            else
            {   //1年越え
                a_disp = 4;
                a_Xnum = 24 * (a_tTmp.Days + 1);
                a_Xsep = 24 * 366;
            }

            if (h_mode == 0)
            {   //分単位
                a_Xnum *= 60;
                a_Xsep *= 60;
            }

            Pen m_pen2 = new Pen(Color.LightGray, 0.5f);
            m_pen2.DashStyle = System.Drawing.Drawing2D.DashStyle.Dash;

            string a_day = "";  // h_stTime.ToString("yyyy/MM/dd");
            for (int a_iCnt = 1; a_iCnt <= GraphMaxX + 1; a_iCnt+=Convert.ToInt32(GraphSepX))
            {
                string a_sVal = "";
                string a_sValXM = "";
                string a_sValXM2 = "";
                string a_sValXM3 = "";
                string a_sValXM4 = "";
                string a_sValXyear = "";
                string a_sValXmonth = "";
                string a_sValXday = "";

                if (((a_iCnt - 1) % a_Xsep) == 0)
                {
                    if (h_mode == 0)
                    {   //分単位
                        a_stTime = h_stTime.AddMinutes((a_iCnt - 1));
                    }
                    else
                    {   //時間単位
                        a_stTime = h_stTime.AddHours((a_iCnt - 1));
                    }

                    switch (a_disp)
                    {
                        case 1:     //時間表示
                            a_sValXM = string.Format("({0})", Properties.HysAddinHydroHyetoGraphResources.HOUR);   //(時)
                            a_sValXM2 = Properties.HysAddinHydroHyetoGraphResources.DAY;   //日
                            a_sValXM3 = Properties.HysAddinHydroHyetoGraphResources.MONTH;   //月
                            a_sValXM4 = Properties.HysAddinHydroHyetoGraphResources.YEAR;   //年
                            a_sVal = a_stTime.ToString("HH");
                            a_sValXday = a_stTime.ToString("dd");
                            a_sValXmonth = a_stTime.ToString("MM");
                            a_sValXyear = a_stTime.ToString("yyyy");
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(8, 2).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                                if (a_day.Substring(5, 2).Equals(a_sValXmonth) == true)
                                {
                                    a_sValXmonth = "";
                                }
                                if (a_day.Substring(0, 4).Equals(a_sValXyear) == true)
                                {
                                    a_sValXyear = "";
                                }
                            }
                            break;
                        case 2:     //日表示
                            a_sValXM = string.Format("({0})", Properties.HysAddinHydroHyetoGraphResources.DAY); ;  //(日)
                            a_sValXM2 = Properties.HysAddinHydroHyetoGraphResources.MONTH;   //月
                            a_sValXM3 = Properties.HysAddinHydroHyetoGraphResources.YEAR;   //年
                            a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("dd");
                            a_sValXday = a_stTime.ToString("MM");
                            a_sValXmonth = a_stTime.ToString("yyyy");
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(5, 2).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                                if (a_day.Substring(0, 4).Equals(a_sValXmonth) == true)
                                {
                                    a_sValXmonth = "";
                                }
                            }
                            break;
                        case 3:     //月表示
                            a_sValXM = string.Format("({0})", Properties.HysAddinHydroHyetoGraphResources.MONTH);  //(月)
                            a_sValXM2 = Properties.HysAddinHydroHyetoGraphResources.YEAR;
                            a_sValXM3 = "";
                            a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("MM");
                            a_sValXday = a_stTime.ToString("yyyy");
                            a_sValXmonth = "";
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(0, 4).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                            }
                            break;
                        case 4:     //年表示
                            a_sValXM = string.Format("({0})", Properties.HysAddinHydroHyetoGraphResources.YEAR);  //(年)
                            a_sValXM2 = "";
                            a_sValXM3 = "";
                            a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("yyyy");
                            a_sValXday = "";
                            a_sValXmonth = "";
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                            }
                            break;
                    }
                }

                /*
                switch (h_mode)
                {
                    case 0: //10分単位
                        a_stTime = h_stTime.AddMinutes((a_iCnt - 1));
                        if (GraphSepX < 60)
                        {   //1目盛が60分以内
                            a_sVal = a_stTime.ToString("mm");
                            a_sValXM = "(分)";
                            a_sValXyear = a_stTime.ToString("yyyy");
                            a_sValXmonth = a_stTime.ToString("MM");
                            a_sValXday = a_stTime.ToString("dd");
                        }
                        else if (GraphSepX < (60 * 24))
                        {   //1目盛が1日以内
                            a_sVal = a_stTime.ToString("HH");
                            a_sValXM = "(時)";
                            a_sValXyear = a_stTime.ToString("yyyy");
                            a_sValXmonth = a_stTime.ToString("MM");
                            a_sValXday = a_stTime.ToString("dd");
                        }
                        break;
                    case 1: //時間単位
                        a_stTime = h_stTime.AddHours((a_iCnt - 1));
                        a_sVal = a_stTime.ToString("HH");
                        a_sValXM = "(時)";
                        a_sValXyear = a_stTime.ToString("yyyy");
                        a_sValXmonth = a_stTime.ToString("MM");
                        a_sValXday = a_stTime.ToString("dd");
                        break;
                }
                 */ 

                //タイトル
                m_g.DrawString(
                    a_sValXM,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX  * m_sep_x_graph + Convert.ToSingle(m_font1.Size*2.5) - 5,
                        ImageHeight - m_sep_bottom + m_font1.Size / 2)
                    );
                m_g.DrawString(
                    a_sValXM2,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0) - 5,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 1.8))
                    );
                m_g.DrawString(
                    a_sValXM3,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0) - 5,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 3))
                    );
                m_g.DrawString(
                    a_sValXM4,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0) - 5,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 4.3))
                    );

                //X値
                m_g.DrawString(
                    a_sVal,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + m_font1.Size / 2)
                    );

                //if (a_day.Equals(a_stTime.ToString("yyyy/MM/dd")) == false)
                //{
                    m_g.DrawString(
                        a_sValXday,
                        m_font1,
                        Brushes.Black,
                        new PointF(
                            m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,
                            ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size*1.8))
                        );
                    m_g.DrawString(
                        a_sValXmonth,
                        m_font1,
                        Brushes.Black,
                        new PointF(
                            m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  // + m_font1.Size / 2,
                            ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 3))
                        );
                    m_g.DrawString(
                        a_sValXyear,
                        m_font1,
                        Brushes.Black,
                        new PointF(
                            m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  // + m_font1.Size / 2,
                            ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 4.3))
                        );
                    a_day = a_stTime.ToString("yyyy/MM/dd");
                //}

                if (a_sVal.Length > 0)
                {   //表示あり
                    if ((a_iCnt > 1) && (a_iCnt <= GraphMaxX))
                    {
                        m_g.DrawLine(
                            m_pen2,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_Height - m_sep_bottom,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_sep_top
                            );
                    }
                }
            }
		}

		//*********************************************************************
		// @(f)
		// 機能      : 水位の値設定
		//
        // 引数      : ARG1 - McGraphViewWaterLevelItemsオブジェクト
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>水位の値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetWaterLevelItems(val)</para>
        /// </example>
        /// <param name="val">McGraphViewWaterLevelItems: 水位データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetWaterLevelItems(McGraphViewWaterLevelItems val)
		{
			_setGraphValue(val);
		}

		//*********************************************************************
		// @(f)
		// 機能      : グラフの描画実行
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /*/// <summary><para>method outline:</para>
        /// <para>グラフの描画実行</para>
        /// </summary>
        public void MakeGraph()
		{
            MakeImageFile();
		}*/

		//*********************************************************************
		// @(f)
		// 機能      : グラフの背景描画
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの背景描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawGraphBackGround()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		private void _drawGraphBackGround()
		{
            //string a_strTmp = "";
			//string a_strTmp2 = "";

			//-----------------------------------------------------------------
			// 凡例の描画
			//-----------------------------------------------------------------
            /*
			DrawLegend(
				m_pen_WaterLevel,
				m_brush_WaterLevel,
				"水位",
				1,
                enumPlotKind.Line,
                enumPlotForm.FillTriangle
				);
            */
			//-----------------------------------------------------------------
			// タイトル文字の描画
			//-----------------------------------------------------------------
			// Y軸
            /*
			DrawYUnitString(
				"(m)"
				);
             */

            /*[2010.03.07]
            DrawYTitleStringVertical(
				"水位",
                ""
				);
            m_g.DrawString(
                "(m)",
                m_font1, Brushes.Black,
                new PointF(0, m_sep_top)
                );
            DrawYTitleStringVertical2(
                "流量",
                ""
                );
            m_g.DrawString(
                "(m3/s)",
                m_font1, Brushes.Black,
                new PointF(ImageWidth - Convert.ToSingle(m_font1.Size * 4.5), m_sep_top + m_font1.Size)
                );
             */

			// X軸
			// タイトル文字の描画
            /*
			if (GraphKind == enumGraphKind.IsTime)
			{
				a_strTmp = "(時)";
				a_strTmp2 = "時刻";
			}
			else if (GraphKind == enumGraphKind.IsDay)
			{
				a_strTmp = "(日)";
				a_strTmp2 = "日";
			}
             */
            /*
			DrawXUnitString(
				a_strTmp
				);
             */ 
            /*
			DrawXTitleString(
				a_strTmp2
				);
            */
		}	

		//*********************************************************************
		// @(f)
		// 機能      : グラフの水位の値描画
		//
        // 引数      : ARG1 - McGraphViewWaterLevelItemsオブジェクト
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの水位の値描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setGraphValue(val)</para>
        /// </example>
        /// <param name="val">McGraphViewWaterLevelItems: 水位データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setGraphValue(McGraphViewWaterLevelItems val)
		{
            try
            {
                //[2010.03.07]
                enumPlotKind a_pk = enumPlotKind.Nothing;
                enumPlotForm a_pf = enumPlotForm.Nothing;

                if (McGraphViewDefine.g_IsLine == true)
                {
                    a_pk = enumPlotKind.Line;
                }

                if (McGraphViewDefine.g_IsPoint == true)
                {
                    a_pf = enumPlotForm.FillCircle;
                }

                int a_iListCount = val.Count;	// リスト数を取得
                float a_prev_WaterLevel = InvalidValue;
                float a_prev_X = 0;

                m_PrevX = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                m_PrevY = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]


                m_brush_WaterLevel.Color = val.LineColor;   //色変更
                m_pen_WaterLevel.Color = val.LineColor;     //色変更
                m_pen_WaterLevel.DashStyle = val.LineStyle; //線種変更
                m_pen_WaterLevel.Width = val.LineSize;      //線の太さ変更
                this.m_size_Legend = val.MarkSize;          //ポイントの大きさ変更
                a_pk = val.PlotKind;                        //ライン描画
                a_pf = val.PlotForm;                        //ポイント描画

                for (int a_iCnt = 1; a_iCnt <= a_iListCount; a_iCnt++)
                {
                    //-------------------------------------------------------------
                    // 水位表示
                    //-------------------------------------------------------------
                    PlotGraphValue(
                        m_pen_WaterLevel,
                        m_brush_WaterLevel,
                        val[a_iCnt - 1].TimeOrDay,
                        (float)val[a_iCnt - 1].WaterLevel,
                        a_prev_X,
                        ref a_prev_WaterLevel,
                        //a_iCnt,
                        a_pk,
                        a_pf
                        );

                    a_prev_X = val[a_iCnt - 1].TimeOrDay;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
	
        //*********************************************************************
        // @(f)
        // 機能      : グラフの水面のブラシ描画
        //
        // 引数      : ARG1 - Color値（ブラシ）
        //             ARG2 - 水位値(m)
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /*/// <summary><para>method outline:</para>
        /// <para>グラフの水面のブラシ描画</para>
        /// </summary>
        /// <param name="h_color">Color値（ブラシ）</param>
        /// <param name="h_suii">水位値(m)</param>
        public void DrawWaterSection(
            Color h_color,
            double h_suii
            )
        {
            try
            {
                SolidBrush a_brush = new SolidBrush(Color.FromArgb(128, h_color));
                m_g.FillRectangle(
                    a_brush,
                    m_sep_left,
                    m_Height - Convert.ToSingle((m_sep_bottom + ((m_Height - m_sep_bottom - m_sep_top) / (GraphMaxY - GraphMinY) * (h_suii - GraphMinY)))),
                    Convert.ToSingle((m_sep_x_val * m_num_x_graph) * m_sep_x_graph),
                    Convert.ToSingle((m_Height - m_sep_bottom - m_sep_top) / (GraphMaxY - GraphMinY) * (h_suii - GraphMinY))
                    );
            }
            catch(Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        */
        //*********************************************************************
        // @(f)
        // 機能      : グラフの断面のブラシ描画
        //
        // 引数      : ARG1 - Color値（ブラシ）
        //             ARG2 - 観測地点識別子
        //             ARG3 - DB接続プロバイダ
        //             ARG4 - DB接続文字列
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの断面のブラシ描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DrawCrossSection(h_color, h_observe_id, h_dNum, h_dList, h_min_x, h_max_x)</para>
        /// </example>
        /// <param name="h_color">Color値（ブラシ）</param>
        /// <param name="h_observe_id">観測地点識別子</param>
        /// <param name="h_dNum">断面リスト数</param>
        /// <param name="h_dList">断面リスト</param>
        /// <param name="h_max_x">X軸最小値</param>
        /// <param name="h_min_x">X軸最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DrawCrossSection(
            Color h_color,
            String h_observe_id,
            int h_dNum,
            float[,] h_dList,
            float h_min_x,
            float h_max_x
            )
        {
            try
            {
                //X軸のセパレート値を計算
                float a_x_sep = (m_sep_x_val * GraphMaxX) / (h_max_x - h_min_x);

                SolidBrush a_brush = new SolidBrush(Color.FromArgb(255, h_color));
                PointF[] a_points = new PointF[h_dNum + 2];
                int a_cnt = 0;
                double a_minx  = 9999999999;
                double a_maxx = 0;

                for (a_cnt = 0; a_cnt < h_dNum; a_cnt++)
                {
                        a_points[a_cnt] = new PointF(
                            h_dList[a_cnt,0],
                            h_dList[a_cnt,1]
                            );

                        if (a_points[a_cnt].X < a_minx)
                        {
                            a_minx = a_points[a_cnt].X;
                        }
                        if (a_points[a_cnt].X > a_maxx)
                        {
                            a_maxx = a_points[a_cnt].X;
                        }
                    }

                //細部
                for(a_cnt = 0; a_cnt <= a_points.Length - 1;a_cnt++){
                    a_points[a_cnt].X = Convert.ToSingle(m_sep_left + (((m_sep_x_val * m_num_x_graph) * m_sep_x_graph) / (a_maxx - a_minx)) * a_points[a_cnt].X);
                    a_points[a_cnt].Y = m_Height - (m_sep_bottom + ((m_Height - m_sep_bottom - m_sep_top) / (GraphMaxY - GraphMinY) * (a_points[a_cnt].Y - GraphMinY)));
                }
                //右下
                a_points[a_points.Length - 2] = new PointF(m_sep_left + (m_sep_x_val * m_num_x_graph) * m_sep_x_graph, m_Height - m_sep_bottom);
                //左下
                a_points[a_points.Length - 1] = new PointF(m_sep_left, m_Height - m_sep_bottom);

                m_g.FillPolygon(a_brush, a_points);
            }
            catch(Exception e){
                Console.WriteLine(e.Message);
            }
        }

        //*********************************************************************
        // @(f)
        // 機能      : 流量の値設定
        //
        // 引数      : ARG1 - McGraphViewFlowMeterItemsオブジェクト
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>流量の値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFlowMeterItems(val)</para>
        /// </example>
        /// <param name="val">McGraphViewFlowMeterItems: 流量データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFlowMeterItems(McGraphViewFlowMeterItems val)
        {
            _setGraphValueFlowMeter(val);
        }
        //*********************************************************************
        // @(f)
        // 機能      : グラフの流量の値描画
        //
        // 引数      : ARG1 - McGraphViewFlowMeterItemsオブジェクト
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの流量の値描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setGraphValueFlowMeter(val)</para>
        /// </example>
        /// <param name="val">McGraphViewFlowMeterItems: 流量データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setGraphValueFlowMeter(McGraphViewFlowMeterItems val)
        {
            try
            {
                //[2010.03.07]
                enumPlotKind a_pk = enumPlotKind.Nothing;
                enumPlotForm a_pf = enumPlotForm.Nothing;

                if (McGraphViewDefine.g_IsLine == true)
                {
                    a_pk = enumPlotKind.Line;
                }

                if (McGraphViewDefine.g_IsPoint == true)
                {
                    a_pf = enumPlotForm.FillCircle;
                }

                int a_iListCount = val.Count;	// リスト数を取得
                float a_prev_FlowMeter = InvalidValue;
                float a_prev_X = 0;

                m_FlowMeterPrevX = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                m_FlowMeterPrevY = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]


                m_brush_FlowMeter.Color = val.LineColor;    //色変更
                m_pen_FlowMeter.Color = val.LineColor;      //色変更
                m_pen_FlowMeter.DashStyle = val.LineStyle;  //線種変更
                m_pen_FlowMeter.Width = val.LineSize;       //線の太さ変更
                this.m_size_Legend = val.MarkSize;          //ポイントの大きさ変更
                a_pk = val.PlotKind;                        //ライン描画
                a_pf = val.PlotForm;                        //ポイント描画

                for (int a_iCnt = 1; a_iCnt <= a_iListCount; a_iCnt++)
                {
                    //-------------------------------------------------------------
                    // 流量表示
                    //-------------------------------------------------------------
                    _plotGraphValue2(
                        m_pen_FlowMeter,
                        m_brush_FlowMeter,
                        val[a_iCnt - 1].TimeOrDay,
                        (float)val[a_iCnt - 1].FlowMeter,
                        a_prev_X,
                        ref a_prev_FlowMeter,
                        //a_iCnt,
                        a_pk,
                        a_pf
                        );

                    a_prev_X = val[a_iCnt - 1].TimeOrDay;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        
        //*********************************************************************
        // @(f)
        // 機能      : グラフの流量の値描画
        //
        // 引数      : ARG1 - McGraphViewFlowMeterItemsオブジェクト
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの流量の値描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_plotGraphValue2(p, b, xv, yv, pxv, pyv, gk, pk)</para>
        /// </example>
        /// <param name="p">描画色：ペン</param>
        /// <param name="b">描画色：塗りつぶし</param>
        /// <param name="xv">X値：現在値</param>
        /// <param name="yv">Y値：現在値</param>
        /// <param name="pxv">X値：一つ前</param>
        /// <param name="pyv">Y値：一つ前</param>
        /// <param name="gk">グラフプロット種別：enumPlotKind</param>
        /// <param name="pk">グラフプロット型：enumPlotForm</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _plotGraphValue2(
			Pen p,
			Brush b,
			float xv,
			float yv,
			float pxv,
			ref float pyv,
			//int i,
            enumPlotKind gk,
            enumPlotForm pk
			)
		{
			float a_fTmp = yv;
			float a_fxTmp = 0;
			float a_fxTmp2 = 0;
			float a_fxTmp3 = 0;
			float a_fyTmp1 = 0;
			float a_fyTmp2 = 0;

			a_fxTmp2 = m_sep_left + (m_sep_x_graph * (xv - GraphMinX));

            //[2010.06.02]↓
            if (pyv > McGraphViewDefine.g_InvalidValue2)
            {
                m_FlowMeterPrevX = pxv;
            }
            //[2010.06.02]↑
            a_fxTmp3 = m_sep_left + (m_sep_x_graph * (m_FlowMeterPrevX - GraphMinX));  //[2010.06.02]
            //a_fxTmp3 = m_sep_left + (m_sep_x_graph * (pxv - GraphMinX));  //[2010.06.02]

            if (gk == enumPlotKind.Line)
            {
                //[2010.02.18]
                if (pyv > InvalidValue)  //(pyv != m_InvalidValue)
                {
                    //[2010.02.18]
                    if (a_fTmp > InvalidValue)   //(a_fTmp != m_InvalidValue)
                    {
                        //[2010.06.02]↓
                        if (pyv != McGraphViewDefine.g_InvalidValue2)
                        {
                            m_FlowMeterPrevY = pyv;
                        }

                        if ((m_FlowMeterPrevY != McGraphViewDefine.g_InvalidValue2) &&
                            (a_fTmp != McGraphViewDefine.g_InvalidValue2))
                        {
                            a_fyTmp1 = m_Height - (m_sep_bottom + ((m_FlowMeterPrevY - m_FlowMeterMinY) * m_FlowMeter_sep_y_val));
                            //a_fyTmp1 = m_Height - (m_sep_bottom + ((pyv - m_FlowMeterMinY) * m_FlowMeter_sep_y_val)); //[2010.06.02]
                            a_fyTmp2 = m_Height - (m_sep_bottom + ((a_fTmp - m_FlowMeterMinY) * m_FlowMeter_sep_y_val));

                            m_g.DrawLine(
                                p,
                                a_fxTmp3 + a_fxTmp,
                                a_fyTmp1,
                                a_fxTmp2 + a_fxTmp,
                                a_fyTmp2
                                );

                            //[2010.03.22]bug-fixed.
                            if (pk == enumPlotForm.FillCircle)
                            {
                                float a_size_Legend = m_size_Legend;
                                m_g.FillEllipse(
                                    b,
                                    a_fxTmp3 + a_fxTmp - (a_size_Legend / 2),
                                    a_fyTmp1 - (a_size_Legend / 2),
                                    a_size_Legend,
                                    a_size_Legend
                                    );
                            }
                        }
                        //[2010.06.02]↑
                    }
                }
                else
                {   //[2010.06.02]
                    m_FlowMeterPrevY = McGraphViewDefine.g_InvalidValue2;
                }
            }

			a_fyTmp1 = m_Height - (m_sep_bottom + ((a_fTmp - m_FlowMeterMinY) * m_FlowMeter_sep_y_val));

            //[2010.02.18]
            if (a_fTmp > InvalidValue)   //(a_fTmp != m_InvalidValue)
			{
                //[2010.03.22]bug-fixed.
                if (pk == enumPlotForm.FillCircle)
                {
                    float a_size_Legend = m_size_Legend;
                    m_g.FillEllipse(
                        b,
                        a_fxTmp2 + a_fxTmp - (a_size_Legend / 2),
                        a_fyTmp1 - (a_size_Legend / 2),
                        a_size_Legend,
                        a_size_Legend
                        );
                }
            }

			pyv = a_fTmp;
        }

    }
}
