﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace jp.go.nilim.HyetoHydroGraph_H26
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアジョブクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McGraphViewViewerJob : HySDotNetAddInBaseJob   //[2013.01.18]パッケージ化
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // [2013.01.18]パッケージ化↓
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>ツールの起動</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartTool()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void StartTool()
        {
            //long lRtn = 0;
            HySID csID = null;
            HySScreen csScreen = null;

            csID = new HySID("ArbitraryCode");  // 画面が一枚の時にはこのようにユニークな値を一意に設定
            // 同じ種類の画面を同時に表示したいときには
            //csID = new HySID(m_lPrmNo.ToString()); // 左記を生かして下さい。　例えば左記の通り、ＩＤを変更すると、異なる画面が表示される
            m_lPrmNo += 1;
            //
            // 注意：csID は　画面の種別によらずユニークである必要がある。(異なる種類画面であっても、ＩＤが同じは許されない)

            // 画面表示
            csScreen = this.CmndShowScreen((HySObjectKind)McGraphViewDefine.MCGRAPHVIEW_SCREEN, csID);

            /*
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "MyToolSampleViewerJob", "StartTool", "画面表示開始"); // 必要に応じてログ出力

            HySID csID = null;
            csID = new HySID("ArbitraryCode");  // 画面には ユニークな値を一意に設定

            // 画面表示
            HySDotNetAddInBaseScreen csDotNetScreen = this.CmndShowScreen((HySObjectKind)MyToolSampleDefine.SAMPLE_SCREEN, csID) as HySDotNetAddInBaseScreen;
            if (csDotNetScreen != null)
            {   // 表示に成功ならば
                csDotNetScreen.ActivateForm();  // 表示した画面を最前面に持ってくる
            }
            */
        }
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // [2013.01.18]パッケージ化↑
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetViewerJob csViewerJob = new McDotNetViewerJob( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetViewerJob 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphViewViewerJob()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            HySID csID = null;
            HySScreen csScreen = null;

            if (lCallBackNo == McGraphViewDefine.MCGRAPHVIEW_DO_SOMETHING)
            {   // 何らかの処理
                lRtn = this.DoSomething();
            }
            else if (lCallBackNo == McGraphViewDefine.MCGRAPHVIEW_DISP_SCREEN)
            {   // サンプル画面表示開始

                csID = new HySID("ArbitraryCode");  // 画面が一枚の時にはこのようにユニークな値を一意に設定
                // 同じ種類の画面を同時に表示したいときには
                //csID = new HySID(m_lPrmNo.ToString()); // 左記を生かして下さい。　例えば左記の通り、ＩＤを変更すると、異なる画面が表示される
                m_lPrmNo += 1;
                //
                // 注意：csID は　画面の種別によらずユニークである必要がある。(異なる種類画面であっても、ＩＤが同じは許されない)

                // 画面表示
                csScreen = this.CmndShowScreen((HySObjectKind)McGraphViewDefine.MCGRAPHVIEW_SCREEN, csID);

            }     
            else
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            m_bWorkFlg = true;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            m_bWorkFlg = false;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            // 全スクリーンの終了処理を実行
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    csScreen.Terminate();
                    csScreen = null;
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            if (m_bWorkFlg)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン生成ファクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySScreenFactory スクリーンファクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySScreenFactory GetScreenFactory() //[2013.01.18]パッケージ化
        { 
            return this.m_csScreenFactory;
        }

        // ★★
        // ToDo　コールバックに対応する処理が必要な場合に処理を追加する
        // ★★

        /// <summary><para>method outline:</para>
        /// <para>例）何らかの処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = DoSomething( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サンプルメソッド</para>
        /// </remarks>
        protected virtual long DoSomething()
        {
            // 何らかの処理を行う　業務固有メソッド
            return 0;
        }

        /// <summary>一貫番号 </summary>
        static protected long m_lPrmNo = 0;
    }
}
