﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　グラフ設定画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class McGraphSetForm : Form
    {

        /// <summary>
        /// プロパティ：主軸ラベル
        /// </summary>
        public string AxisLabelKPP
        {
            get
            {
                return txtAxisLabelP.Text;
            }
            set
            {
                txtAxisLabelP.Text = value;
            }
        }
        /// <summary>
        /// プロパティ：ハイドロ(下)左軸 表示目盛
        /// </summary>
        public float AxisRateKPLeft
        {
            get
            {
                float fVal = 0;
                float.TryParse(txtAxisRateKP.Text, out fVal);
                return fVal;
            }
            set
            {
                if(value == 0)
                    txtAxisRateKP.Text = "";
                else
                    txtAxisRateKP.Text = value.ToString();
            }
        }

        /// <summary>
        /// プロパティ：２軸ラベル
        /// </summary>
        public string AxisLabelKPS
        {
            get
            {
                return txtAxisLabelS.Text;
            }
            set
            {
                txtAxisLabelS.Text = value;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphSetForm csHySEvSetForm = new McGraphSetForm() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphSetForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>btnSetGraph_Click(sender, e) </para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            try
            {
                //------------------------------------------------------------
                // 入力チェック
                //------------------------------------------------------------
                //主軸 表示目盛
                if (!InputCheckNum(txtAxisRateKP, lblAxisRateLevel.Text))
                    return;
                //主軸 最大値
                if (!InputCheckNum(txtKP_MaxYP, lblWaterLevel_MaxYP.Text))
                    return;
                //主軸 最小値
                if (!InputCheckNum(txtKP_MinYP, lblWaterLevel_MinYP.Text))
                    return;

                //２軸 表示目盛
                //if (!InputCheckNum(txtAxisRateKP, lblAxisRateLevel.Text))
                //    return;
                //２軸 最大値
                if (!InputCheckNum(txtKP_MaxYS, lblWaterLevel_MaxYS.Text))
                    return;
                //２軸 最小値
                if (!InputCheckNum(txtKP_MinYS, lblWaterLevel_MinYS.Text))
                    return;

                //フォントサイズ[2013.02.05]
                if (!InputCheckNum(txtFontSize, lblFontSize.Text))
                    return;
                //X軸間隔[2013.02.05]
                if (!InputCheckNum(txtXAxisPitch, lblXAxisPitch.Text))
                    return;

                //------------------------------------------------------------
                //主軸
                if (txtKP_MaxYP.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_KP_MaxYP = Convert.ToSingle(txtKP_MaxYP.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_KP_MaxYP = McLspViewDefine.g_InvalidValue;
                }
                if (txtKP_MinYP.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_KP_MinYP = Convert.ToSingle(txtKP_MinYP.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_KP_MinYP = McLspViewDefine.g_InvalidValue;
                }

                //２軸
                if (txtKP_MaxYS.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_KP_MaxYS = Convert.ToSingle(txtKP_MaxYS.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_KP_MaxYS = McLspViewDefine.g_InvalidValue;
                }
                if (txtKP_MinYS.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_KP_MinYS = Convert.ToSingle(txtKP_MinYS.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_KP_MinYS = McLspViewDefine.g_InvalidValue;
                }

                //フォントサイズ[2013.02.05]
                if (txtFontSize.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_FontSize = Convert.ToSingle(txtFontSize.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_FontSize = McLspViewDefine.g_InvalidValue;
                }
                //X軸間隔[2013.02.05]
                if (txtXAxisPitch.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_XAxisPitch = Convert.ToSingle(txtXAxisPitch.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_XAxisPitch = McLspViewDefine.g_InvalidValue;
                }

                this.DialogResult = DialogResult.OK;
                this.Close();
                //this.Dispose();
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphSetForm_Load(sender, e) </para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphSetForm_Load(object sender, EventArgs e)
        {
            //主軸
            if (McLspViewDefine.g_KP_MaxYP != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MaxYP.Text = McLspViewDefine.g_KP_MaxYP.ToString();
            }
            if (McLspViewDefine.g_KP_MinYP != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MinYP.Text = McLspViewDefine.g_KP_MinYP.ToString();
            }

            //２軸
            if (McLspViewDefine.g_KP_MaxYS != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MaxYS.Text = McLspViewDefine.g_KP_MaxYS.ToString();
            }
            if (McLspViewDefine.g_KP_MinYS != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MinYS.Text = McLspViewDefine.g_KP_MinYS.ToString();
            }

            //文字サイズ[2013.02.05]
            if (McLspViewDefine.g_FontSize != McLspViewDefine.g_InvalidValue)
            {
                txtFontSize.Text = McLspViewDefine.g_FontSize.ToString();
            }
            //X軸間隔
            if (McLspViewDefine.g_XAxisPitch != McLspViewDefine.g_InvalidValue)
            {
                txtXAxisPitch.Text = McLspViewDefine.g_XAxisPitch.ToString();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = InputCheckNum(txt, sCaption) </para>
        /// </example>
        /// <param name="txt">TextBox</param>
        /// <param name="sCaption">項目名</param>
        /// <returns>true=正常/false=入力エラーあり</returns>
        private bool InputCheckNum(TextBox txt, string sCaption)
        {
            if (!string.IsNullOrEmpty(txt.Text) && txt.Text.Trim().Length != 0)
            {   //入力あり
                float fVal = 0;
                if (!float.TryParse(txt.Text.Trim(), out fVal))
                {
                    //{0}には数値を入力して下さい。
                    MessageBox.Show(string.Format(Properties.LongitudinalSectionGraphResources.MSG_ERROR_INPUT_NUMERICAL_VALUE, sCaption),
                        Properties.LongitudinalSectionGraphResources.CAPTION_INPUT_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txt.Focus();
                    return false;
                }
            }
            return true;
        }

    }
}
