// <summary>ソースコード：グラフ表示モジュール　メイン画面フォーム</summary>
// <author>CommonMP</author>
using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using System.Runtime.InteropServices;   //[2013.01.05]
using System.Reflection;                //[2013.01.05]
using System.Timers;    //[2013.01.15]

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　メイン画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class McLspViewDotNetForm : HySDotNetAddInBaseForm //[2013.01.18]パッケージ化
    {
        /// <summary> 制御するクリーン </summary>
        protected McLspViewDotNetScreen m_csGraphViewScreen = null;

        /// <summary> KP開始 </summary>
        public int m_KPStart = 0; //[2013.02.12]
        /// <summary> KP終了 </summary>
        public int m_KPEnd = 10;  //[2013.02.12]
        /// <summary> KPオフセット </summary>
        public int m_KPOffset = 0;  //[2015.08.05]
        /// <summary> グラフ縦軸数 </summary>
        private int m_X_Num = 0;

        /// <summary> 累加距離リスト </summary>
        //public McLspViewKPItems m_BaseDistance = null;
        /// <summary> 縦断データリスト </summary>
        public McLspViewKPItems[] m_LongitudinalItems = null;
        /// <summary> 計算結果データリスト </summary>
        public McLspViewKPItems[] m_KPItems = null;
        /// <summary> 時間データリスト </summary>
        public McLspViewTimeItems m_TimeItems = null;

        /// <summary> KPグラフY軸の最大値(主軸) </summary>
        private float m_KPMaxYP = 5.0F;	// グラフY軸の最大値
        /// <summary> KPグラフY軸の最大値(主軸) </summary>
        private float m_KPMinYP = -5.0F;	// グラフY軸の最大値
        /// <summary> KPグラフY軸のセパレート値(主軸) </summary>
        private float m_KPSepYP = 1.0F;	// グラフY軸のセパレート値
        /// <summary> KPグラフY軸の最大値(２軸) </summary>
        private float m_KPMaxYS = 5.0F;	// グラフY軸の最大値
        /// <summary> KPグラフY軸の最大値(２軸) </summary>
        private float m_KPMinYS = -5.0F;	// グラフY軸の最大値
        ///// <summary> KPグラフY軸のセパレート値(２軸) </summary>
        //private float m_KPSepYS = 1.0F;	// グラフY軸のセパレート値

        /// <summary> ２軸の有無 </summary>
        private bool m_IsKPYS = false;
        /// <summary> 最初の主軸 </summary>
        private bool m_IsFirstKPYP = true;
        /// <summary> 最初の２軸 </summary>
        private bool m_IsFirstKPYS = true;

        /// <summary> KPグラフY軸の表示目盛掛け率(主軸) </summary>
        public float m_KPRateYP = 0.0F;     //add 2011.03.08
        /// <summary> KPグラフY軸の表示目盛掛け率(２軸) </summary>
        public float m_KPRateYS = 0.0F;     //add 2011.03.08

        /// <summary> グラフ自動調整表示の有無 </summary>
        private bool m_IsAutoFit = true;    //[2010.06.03]

        /// <summary> データ表示対象行数（対象時刻） </summary>
        private int m_iDataRow = 1;
        /// <summary> タイマー種別（1：Forward、2：Backward） </summary>
        private int m_timerKind = 1;
        /// <summary> ツールチップ </summary>
        private ToolTip m_toolTip = null;
        /// <summary> 画像領域 </summary>
        private Rectangle m_displayRectahgle;

        //private System.Timers.Timer m_myTimer;

// start of 印刷機能追加
        //印刷用・領域取得関数のインポート
        [System.Runtime.InteropServices.DllImport(@"C:\WINDOWS\system32\gdi32.dll")]
        private static extern int BitBlt(IntPtr hDestDC, int x, int y, int nWidth, int nHeight,
                                         IntPtr hSrcDC, int xSrc, int ySrc, int dwRop);

        /// <summary>印刷用ビットマップ</summary>
        private Bitmap m_bit_img = null;//印刷用ビットマップ

        /// <summary>印刷用プリントドキュメント</summary>
        private System.Drawing.Printing.PrintDocument m_pd = null;
// end of 印刷機能追加

        /// <summary> 描画設定ファイル </summary>
        private string m_RestoreDrawFileName = "";

        /// <summary> 経時変化グラフ画面 </summary>
        public McLspViewTimeGraph m_TimeFrm = null;

        #region 内部メソッド

        #region "相対パス取得"
        private string _getRelativePath(string h_fileName)
        {
            Uri a_targetPath = new Uri(McLspViewDefine.g_uriCommonMP_Path, h_fileName);
            string a_relativePath = McLspViewDefine.g_uriCommonMP_Path.MakeRelativeUri(a_targetPath).ToString();
            //URLデコードして、'/'を'\'に変更する
            a_relativePath = System.Web.HttpUtility.UrlDecode(a_relativePath).Replace('/', '\\');

            return a_relativePath;
        }
        #endregion
        #region "絶対パス取得"
        private string _getLocalPath(string h_fileName)
        {
            Uri a_targetPath = new Uri(McLspViewDefine.g_uriCommonMP_Path, h_fileName);
            //string a_localPath = System.Web.HttpUtility.UrlDecode(a_targetPath.LocalPath.ToString()).Replace('/', '\\');
            //return a_localPath;

            return a_targetPath.LocalPath;
        }
        #endregion

        #region 最大値調整[2013.01.24]
        private float _adjustMaxVal(float h_max)
        {
            float a_fRet = h_max;
            a_fRet = (float)Math.Ceiling(h_max);
            /*
            if (h_max >= 0)
                a_fRet = (float)Math.Ceiling(h_max);
            else
                a_fRet = (float)Math.Floor(h_max);
            */

            return a_fRet;
        }
        #endregion
        #region 最小値調整[2013.01.24]
        private float _adjustMinVal(float h_min)
        {
            float a_fRet = h_min;
            a_fRet = (float)Math.Floor(h_min);
            /*
            if (h_min >= 0)
                a_fRet = (float)Math.Ceiling(h_min);
            else
                a_fRet = (float)Math.Floor(h_min);
            */

            return a_fRet;
        }
        #endregion

        #region ファイル選択
        /// <summary><para>method outline:</para>
        /// <para>ファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_selectFile(ref h_folder, h_textBox);</para>
        /// </example>
        /// <param name="h_folder">フォルダ名</param>
        /// <param name="h_textBox">フォルダ名格納テキストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _selectFile(
            System.Windows.Forms.TextBox h_textBox
            )
        {
            try
            {
                //OpenFileDialogクラスのインスタンスを作成
                OpenFileDialog a_ofd = new OpenFileDialog();

                //はじめのファイル名を指定する
                //はじめに「ファイル名」で表示される文字列を指定する
                //a_ofd.FileName = "default.csv";
                //はじめに表示されるフォルダを指定する
                //指定しない（空の文字列）の時は、現在のディレクトリが表示される
                //a_ofd.InitialDirectory = Properties.LongitudinalSectionGraphResources.MSG_INFO_SPECIFY_FOLDER;
                //[ファイルの種類]に表示される選択肢を指定する
                //指定しないとすべてのファイルが表示される
                //a_ofd.Filter =
                //    "csvファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*";
                a_ofd.Filter = Properties.Resources.STRING_OPENFILEDIALOG_FILTER;           // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_ofd.FilterIndex = 1;
                //タイトルを設定する
                //a_ofd.Title = "開くファイルを選択してください";
                a_ofd.Title = Properties.Resources.STRING_OPENFILEDIALOG_TITLE;             // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_ofd.InitialDirectory = McLspViewDefine.g_sCommonMPData_Path;
                //a_ofd.RestoreDirectory = true;
                //存在しないファイルの名前が指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckFileExists = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_ofd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_ofd.FileName);
                    h_textBox.Text = _getRelativePath(a_ofd.FileName);  //[2013.02.05]相対パスに変換する
                    h_textBox.SelectionStart = h_textBox.Text.Length;
//Nishi 2015/1/7 PATHを変更する
                    McLspViewDefine.g_sCommonMPData_Path = System.IO.Path.GetDirectoryName(a_ofd.FileName);
//Nishi 2015/1/7 PATHを変更する
                }
//Nishi 2014/12/22
//OKでない場合も帰ってきてしまう
//上位にも影響を及ぼすため直さない
//                else
//                {
//                    h_textBox.Text = "";
//                    h_textBox.SelectionStart = h_textBox.Text.Length;
//                }
//Nishi
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 縦断データ項目設定
        /// <summary><para>method outline:</para>
        /// <para>縦断データ項目設定の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setXItemNamesLongitudinal();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setXItemNamesLongitudinal(string h_fName)
        {

            //[2013.01.08]
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                //--------------------------------------------------------------
                //項目名の取得
                //--------------------------------------------------------------
                /*
                m_X_Num = 0;    //[2013.02.12]
                m_BaseDistance = null;
                m_BaseDistance = new McLspViewKPItems();   //[2013.02.12]
                */

                m_KPStart = 0;
                m_KPEnd = 12;
                m_KPOffset = 0;
                m_iDataRow = 1;
                clbLsp2.Items.Clear();
                legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.LONGITUDINAL);

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fName), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;

                    //1行目の5列以降が項目名
                    a_sLine = a_sr.ReadLine();
                    a_split = a_sLine.Split(a_delimiter);
                    foreach (string a_s in a_split)
                    {
                        if (a_iCnt >= 5)
                        {
                            clbLsp2.Items.Add(a_s.Trim());
                        }

                        a_iCnt++;
                    }

                    //3行読み飛ばし
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //5行目からKP取得
                    a_iCnt = 1;
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        a_split = a_sLine.Split(a_delimiter);
                            
                        if (a_split[0].Trim().ToLower().Equals("[end]") == true)
                        {
                            break;
                        }

                        //[2013.02.12]---↓
                        /*
                        if (a_iCnt == 1)
                        {
                            m_KPStart = float.Parse(a_split[3].Trim());
                            m_KPEnd = float.Parse(a_split[3].Trim());
                        }
                        else
                        {
                            m_KPEnd = float.Parse(a_split[3].Trim());
                        }
                        McLspViewKPItem a_item = new McLspViewKPItem();
                        a_item.Distance = decimal.Parse(a_split[3].Trim());
                        m_BaseDistance.Add(a_item);
                        m_X_Num++;
                        */
                        /*以前のソース---↓*/
                        if (a_iCnt == 1)
                        {
                            m_KPStart = (int)Math.Floor(double.Parse(a_split[3].Trim()));   //[2013.02.12]
                            //m_KPStart = int.Parse(a_split[3].Trim());
                            m_KPOffset = (int)Math.Floor(double.Parse(a_split[3].Trim()));  //[2015.08.05]
                            m_KPStart = 0;  //[2015.08.05]
                        }
                        else
                        {
                            m_KPEnd = (int)Math.Ceiling(double.Parse(a_split[3].Trim()));   //[2013.02.12]
                            //m_KPEnd = int.Parse(a_split[3].Trim());
                            m_KPEnd = (int)Math.Ceiling(double.Parse(a_split[3].Trim())) - m_KPOffset;  //[2015.08.05]
                        }
                        /**/
                        //[2013.02.12]---↑
                        a_iCnt++;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion
        #region 計算結果項目1設定
        /// <summary><para>method outline:</para>
        /// <para>計算結果項目1設定の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setXItemNamesCalcResult1();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setXItemNamesCalcResult1(string h_fName)
        {
            //[2013.01.08]
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                //--------------------------------------------------------------
                //項目名の取得
                //--------------------------------------------------------------
                m_KPStart = 0;
                m_KPEnd = 12;
                m_iDataRow = 1;
                clbLsp1.Items.Clear();
                legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.RESULT_CALC);

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fName), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;

                    //2行読み飛ばし
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();

                    //3行目の2列以降が項目名
                    a_sLine = a_sr.ReadLine();
                    a_split = a_sLine.Split(a_delimiter);
                    foreach (string a_s in a_split)
                    {
                        if (a_iCnt >= 1)
                        {
                            clbLsp1.Items.Add(a_s.Trim());
                        }

                        a_iCnt++;
                    }

                    //4行目から時刻取得
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion
        #region 計算結果項目2設定
        /// <summary><para>method outline:</para>
        /// <para>計算結果項目2設定の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setXItemNamesCalcResult2();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setXItemNamesCalcResult2(string h_fName)
        {
            //[2013.01.08]
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                //--------------------------------------------------------------
                //項目名の取得
                //--------------------------------------------------------------
                /*
                m_X_Num = 0;    //[2013.02.12]
                m_BaseDistance = null;
                m_BaseDistance = new McLspViewKPItems();   //[2013.02.12]
                */

                m_KPStart = 0;
                m_KPEnd = 12;
                m_iDataRow = 1;
                clbLsp1.Items.Clear();
                legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.RESULT_CALC);

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fName), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;

                    //1行目の5列以降が項目名
                    a_sLine = a_sr.ReadLine();
                    a_split = a_sLine.Split(a_delimiter);
                    foreach (string a_s in a_split)
                    {
                        if (a_iCnt >= 4)
                        {
                            clbLsp1.Items.Add(a_s.Trim());
                        }

                        a_iCnt++;
                    }

                    //3行読み飛ばし
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //5行目からKP取得
                    a_iCnt = 1;
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().ToLower().Equals("[end]") == true)
                        {
                            break;
                        }

                        //[2013.02.12]---↓
                        /*
                        if (a_iCnt == 1)
                        {
                            m_KPStart = float.Parse(a_split[3].Trim());
                            m_KPEnd = float.Parse(a_split[3].Trim());
                        }
                        else
                        {
                            m_KPEnd = float.Parse(a_split[3].Trim());
                        }
                        McLspViewKPItem a_item = new McLspViewKPItem();
                        a_item.Distance = decimal.Parse(a_split[3].Trim());
                        m_BaseDistance.Add(a_item);
                        m_X_Num++;
                        */

                        /*以前のソース---↓*/
                        if (a_iCnt == 1)
                        {
                            //m_KPStart = (int)Math.Floor(double.Parse(a_split[3].Trim()));   //[2013.02.12]
                            //m_KPStart = int.Parse(a_split[3].Trim());
                            m_KPStart = 0;   //[2015.08.05]
                            m_KPOffset = (int)Math.Floor(double.Parse(a_split[3].Trim()));   //[2015.08.05]
                        }
                        else
                        {
                            //m_KPEnd = (int)Math.Ceiling(double.Parse(a_split[3].Trim()));   //[2013.02.12]
                            //m_KPEnd = int.Parse(a_split[3].Trim());
                            m_KPEnd = (int)Math.Ceiling(double.Parse(a_split[3].Trim())) - m_KPOffset;   //[2013.02.12]
                        }
                        /**/
                        //[2013.02.12]---↑
                        a_iCnt++;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion
        #region 計算結果項目1設定
        /// <summary><para>method outline:</para>
        /// <para>計算結果項目1設定の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setXItemNamesLsp1();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setXItemNamesLsp1()
        {
            //[2013.01.08]
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                //--------------------------------------------------------------
                //項目名の取得
                //--------------------------------------------------------------
                m_KPStart = 0;
                m_KPEnd = 12;
                m_iDataRow = 1;
                clbLsp1.Items.Clear();
                legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.RESULT_CALC);

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(txtFileNameCalcResult.Text) , System.Text.Encoding.GetEncoding(932)))  //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;

                    //1行目の5列以降が項目名
                    a_sLine = a_sr.ReadLine();
                    a_split = a_sLine.Split(a_delimiter);
                    foreach (string a_s in a_split)
                    {
                        if (a_iCnt >= 4)
                        {
                            clbLsp1.Items.Add(a_s.Trim());
                        }

                        a_iCnt++;
                    }

                    //--------------------------------------------------------------
                    //対象距離の取得
                    //--------------------------------------------------------------
                    //3行読み飛ばし
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //5行目からKP取得
                    a_iCnt = 1;
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().ToLower().Equals("[end]") == true)
                        {
                            break;
                        }

                        if (a_iCnt == 1)
                        {
                            m_KPStart = int.Parse(a_split[3].Trim());
                            m_KPStart = 0; //[2015.08.05]
                            m_KPOffset = int.Parse(a_split[3].Trim()); //[2015.08.05]
                        }
                        else
                        {
                            m_KPEnd = int.Parse(a_split[3].Trim());
                            m_KPEnd = int.Parse(a_split[3].Trim()) - m_KPOffset; //[2015.08.05]
                        }
                        a_iCnt++;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion

        #region 縦断実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>縦断実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readLongitudinalCSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McLspViewKPItems：KPデータリスト</param>
        /// <param name="h_itemName">項目名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readLongitudinalCSVFile(
            int h_idx,  //[2010.05.07]
            ref McLspViewKPItems h_items,
            string h_itemName
            )
        {
            try
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                int iTargetCnt2 = 0;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(txtFileNameLsp.Text), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;
                    int a_iTidx = 0;
                    //1行目から項目名を検索
                    a_sLine = a_sr.ReadLine();
                    a_split = a_sLine.Split(a_delimiter);
                    foreach (string a_s in a_split)
                    {
                        if (a_iCnt >= 4)
                        {
                            if (h_itemName.Equals(a_s.Trim()) == true)
                            {
                                a_iTidx = a_iCnt;
                                break;
                            }
                        }
                        a_iCnt++;
                    }
                    //4行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().ToLower().Equals("[end]") == true)
                        {
                            break;
                        }

                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                        //decimal fDistance = decimal.Parse(a_split[3].Trim());   //KP
                        decimal fDistance = decimal.Parse(a_split[3].Trim()) - m_KPOffset;   //KP //[2015.08.05]
                        decimal fValue = (decimal)McLspViewDefine.g_InvalidValue;
                        //[2013.01.17]bug-fixed.---↓
                        //string a_sVal = a_split[a_iTidx].Trim();
                        if (a_split.Length > a_iTidx)
                        {
                            string a_sVal = a_split[a_iTidx].Trim();
                            if (a_sVal.Length > 0)
                            {
                                fValue = decimal.Parse(a_sVal);         //Data0
                            }
                        }
                        //[2013.01.17]bug-fixed.---↑

                        if (m_KPRateYP != 0 && fValue != (decimal)McLspViewDefine.g_InvalidValue)
                        {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                            fValue *= (decimal)m_KPRateYP;
                        }

                        if (fDistance > (decimal)m_KPEnd)   //[2013.02.12]
                            break;      //期間終了を超えたら読込み終了
                        if (fDistance < (decimal)m_KPStart) //[2013.02.12]
                            continue;   //期間開始に達していない場合は読み飛ばし

                        int a_iVal = (int)Math.Ceiling(fDistance);  //[2013.02.12]
                        while (h_items[iDataIdx].Distance.CompareTo(a_iVal) < 0)    //[2013.02.12]
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }

                        if (h_items[iDataIdx].Distance.Equals(a_iVal))  //[2013.02.12]
                        {   //KPが一致するなら格納
                            h_items[iDataIdx].DataVal = fValue;
                            h_items[iDataIdx].sSectionID = a_split[2].Trim().ToLower();
                            iTargetCnt2++;

                            //最小・最大値セット
                            if (fValue != (decimal)McLspViewDefine.g_InvalidValue)
                            {   //欠測値以外なら最小・最大値セット
                                //最初の対象となるデータの場合、最小・最大値を初期化
                                if (h_items.AxisKind == 1)
                                {
                                    if (m_IsFirstKPYP == true)
                                    {
                                        m_KPMinYP = (float)fValue;
                                        m_KPMaxYP = (float)fValue;
                                        m_IsFirstKPYP = false;
                                    }
                                    m_KPMinYP = Math.Min(m_KPMinYP, (float)fValue);
                                    m_KPMaxYP = Math.Max(m_KPMaxYP, (float)fValue);
                                }
                                else
                                {
                                    if (m_IsFirstKPYS == true)
                                    {
                                        m_KPMinYS = (float)fValue;  //[2013.01.24]
                                        m_KPMaxYS = (float)fValue;  //[2013.01.24]
                                        m_IsFirstKPYS = false;
                                    }
                                    m_KPMinYS = Math.Min(m_KPMinYS, (float)fValue); //[2013.01.24]
                                    m_KPMaxYS = Math.Max(m_KPMaxYS, (float)fValue); //[2013.01.24]
                                }
                                iTargetCnt++;
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 add_e **************************************************
                    }

                    h_items.XNum = iTargetCnt2;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 計算結果1実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>計算結果1実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readCalcResult1CSVFile_Ready(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McLspViewKPItems：KPデータリスト</param>
        /// <param name="h_fileName">ファイル名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readCalcResult1CSVFile_Ready(
            int h_idx,  //[2010.05.07]
            ref McLspViewKPItems h_items,
            string h_fileName
            )
        {
            try
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                //int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                int iTargetCnt2 = 0;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************
                
                //最初に縦断図を読込み距離情報を設定
                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(txtFileNameLsp.Text), System.Text.Encoding.GetEncoding(932))) //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //int a_iCnt = 0;
                    //int a_iTidx = 0;
                    //4行読み飛ばし
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //5行目以降
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().ToLower().Equals("[end]") == true)
                        {
                            break;
                        }

                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                        //decimal fDistance = decimal.Parse(a_split[3].Trim());   //KP
                        decimal fDistance = decimal.Parse(a_split[3].Trim()) - m_KPOffset;   //KP //[2015.08.05]

                        if (fDistance > (decimal)m_KPEnd)   //[2013.02.12]
                            break;      //期間終了を超えたら読込み終了
                        if (fDistance < (decimal)m_KPStart) //[2013.02.12]
                            continue;   //期間開始に達していない場合は読み飛ばし

                        int a_iVal = (int)Math.Ceiling(fDistance);  //[2013.02.12]
                        while (h_items[iDataIdx].Distance.CompareTo(a_iVal) < 0)    //[2013.02.12]
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }

                        if (h_items[iDataIdx].Distance.Equals(a_iVal))  //[2013.02.12]
                        {   //KPが一致するなら格納
                            h_items[iDataIdx].sSectionID = a_split[2].Trim().ToLower();
                            iTargetCnt2++;
                        }
                        //********** 速度改善他対応 2011.03.04 add_e **************************************************
                    }

                    h_items.XNum = iTargetCnt2;
                }
                

                //次に計算結果を取得
                iDataIdx = 0;       //格納するデータリストのインデックス
                //iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                iTargetCnt2 = 1;
                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fileName), System.Text.Encoding.GetEncoding(932)))  //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //int a_iCnt = 0;
                    //int a_iTidx = 1;
                    bool a_isOK = false;
                    int a_inIdx = 0;

                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //4行目からデータを取得
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().Length > 0)
                        {   //[2013.02.04]
                            //時刻を設定
                            a_isOK = true;
                            a_inIdx = 0;
                            DateTime a_dTime = DateTime.Parse(a_split[0].Trim());
                            for (int a_i = 0; a_i < m_TimeItems.Count; a_i++)
                            {
                                if (m_TimeItems[a_i].dTimeOrDay.Equals(a_dTime) == true)
                                {
                                    a_isOK = false;
                                    break;
                                }
                                else
                                {
                                    if (m_TimeItems[a_i].dTimeOrDay.CompareTo(a_dTime) < 0)
                                    {
                                        a_inIdx = a_i + 1;
                                    }
                                }
                            }
                            if (a_isOK == true)
                            {
                                McLspViewTimeItem a_tItem = new McLspViewTimeItem();
                                a_tItem.dTimeOrDay = a_dTime;
                                m_TimeItems.Insert(a_inIdx, a_tItem);
                            }
                        }
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 計算結果1実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>計算結果1実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readCalcResult1CSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McLspViewKPItems：KPデータリスト</param>
        /// <param name="h_fileName">ファイル名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readCalcResult1CSVFile(
            int h_idx,  //[2010.05.07]
            ref McLspViewKPItems h_items,
            string h_fileName
            )
        {
            try
            {
                //対象時刻を検出
                DateTime a_TargetTime = m_TimeItems[m_iDataRow - 1].dTimeOrDay;

                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                int iTargetCnt2 = 0;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************


                //次に計算結果を取得
                iDataIdx = 0;       //格納するデータリストのインデックス
                iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                iTargetCnt2 = 1;
                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fileName), System.Text.Encoding.GetEncoding(932)))  //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;
                    //int a_iTidx = 1;
                    //bool a_isOK = false;
                    //int a_inIdx = 0;

                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //4行目からデータを取得
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().Length > 0)
                        {   //[2013.02.04]
                            //時刻を設定
                            //a_isOK = true;
                            //a_inIdx = 0;
                            DateTime a_dTime = DateTime.Parse(a_split[0].Trim());

                            if (a_dTime == a_TargetTime)
                            {   //対象時刻
                                a_iCnt = 0;
                                foreach (string a_sData in a_split)
                                {
                                    if (a_iCnt > 0)
                                    {
                                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                                        decimal fValue = (decimal)McLspViewDefine.g_InvalidValue;
                                        string a_sVal = a_sData.Trim();
                                        if (a_sVal.Length > 0)
                                        {
                                            fValue = decimal.Parse(a_sVal);         //Data0
                                        }

                                        if (m_KPRateYP != 0 && fValue != (decimal)McLspViewDefine.g_InvalidValue)
                                        {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                                            fValue *= (decimal)m_KPRateYP;
                                        }

                                        while (h_items[iDataIdx].sSectionID.Length <= 0)
                                        {   //格納する時刻インデックスまで進める
                                            iDataIdx++;
                                        }

                                        h_items[iDataIdx].DataVal = fValue;
                                        h_items[iDataIdx].CalcIndex = iTargetCnt2;
                                        //h_items[iDataIdx].sSectionID = a_split[2].Trim().ToLower();
                                        iTargetCnt2++;

                                        //最小・最大値セット
                                        if (fValue != (decimal)McLspViewDefine.g_InvalidValue)
                                        {   //欠測値以外なら最小・最大値セット
                                            //最初の対象となるデータの場合、最小・最大値を初期化
                                            if (h_items.AxisKind == 1)
                                            {
                                                if (m_IsFirstKPYP == true)
                                                {
                                                    m_KPMinYP = (float)fValue;
                                                    m_KPMaxYP = (float)fValue;
                                                    m_IsFirstKPYP = false;
                                                }
                                                m_KPMinYP = Math.Min(m_KPMinYP, (float)fValue);
                                                m_KPMaxYP = Math.Max(m_KPMaxYP, (float)fValue);
                                            }
                                            else
                                            {
                                                if (m_IsFirstKPYS == true)
                                                {
                                                    m_KPMinYS = (float)fValue;  //[2013.01.24]
                                                    m_KPMaxYS = (float)fValue;  //[2013.01.24]
                                                    m_IsFirstKPYS = false;
                                                }
                                                m_KPMinYS = Math.Min(m_KPMinYS, (float)fValue); //[2013.01.24]
                                                m_KPMaxYS = Math.Max(m_KPMaxYS, (float)fValue); //[2013.01.24]
                                            }
                                            iTargetCnt++;
                                        }
                                        iDataIdx++;
                                    }
                                    a_iCnt++;
                                }
                            }
                            else
                            {   //対象時刻でない
                            }
                        }
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 計算結果2実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>計算結果2実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readCalcResult2CSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McLspViewKPItems：KPデータリスト</param>
        /// <param name="h_itemName">項目名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readCalcResult2CSVFile(
            int h_idx,  //[2010.05.07]
            ref McLspViewKPItems h_items,
            string h_itemName
            )
        {
            try
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                int iTargetCnt2 = 0;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(txtFileNameCalcResult.Text), System.Text.Encoding.GetEncoding(932)))  //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    int a_iCnt = 0;
                    int a_iTidx = 0;
                    //1行目から項目名を検索
                    a_sLine = a_sr.ReadLine();
                    a_split = a_sLine.Split(a_delimiter);
                    foreach (string a_s in a_split)
                    {
                        if (a_iCnt >= 3)
                        {
                            if (h_itemName.Equals(a_s.Trim()) == true)
                            {
                                a_iTidx = a_iCnt;
                                break;
                            }
                        }
                        a_iCnt++;
                    }
                    //4行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        if (a_split[0].Trim().ToLower().Equals("[end]") == true)
                        {
                            break;
                        }

                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                        //decimal fDistance = decimal.Parse(a_split[3].Trim());   //KP
                        decimal fDistance = decimal.Parse(a_split[3].Trim()) - m_KPOffset;   //KP  //[2015.08.05]
                        decimal fValue = (decimal)McLspViewDefine.g_InvalidValue;
                        //[2013.01.17]bug-fixed.---↓
                        //string a_sVal = a_split[a_iTidx].Trim();
                        if (a_split.Length > a_iTidx)
                        {
                            string a_sVal = a_split[a_iTidx].Trim();
                            if (a_sVal.Length > 0)
                            {
                                fValue = decimal.Parse(a_sVal);         //Data0
                            }
                        }
                        //[2013.01.17]bug-fixed.---↑

                        if (m_KPRateYP != 0 && fValue != (decimal)McLspViewDefine.g_InvalidValue)
                        {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                            fValue *= (decimal)m_KPRateYP;
                        }

                        if (fDistance > (decimal)m_KPEnd)   //[2013.02.12]
                            break;      //期間終了を超えたら読込み終了
                        if (fDistance < (decimal)m_KPStart) //[2013.02.12]
                            continue;   //期間開始に達していない場合は読み飛ばし

                        int a_iVal = (int)Math.Ceiling(fDistance);  //[2013.02.12]
                        while (h_items[iDataIdx].Distance.CompareTo(a_iVal) < 0)    //[2013.02.12]
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }

                        if (h_items[iDataIdx].Distance.Equals(a_iVal))  //[2013.02.12]
                        {   //KPが一致するなら格納
                            h_items[iDataIdx].DataVal = fValue;
                            h_items[iDataIdx].sSectionID = a_split[2].Trim().ToLower();
                            iTargetCnt2++;

                            //最小・最大値セット
                            if (fValue != (decimal)McLspViewDefine.g_InvalidValue)
                            {   //欠測値以外なら最小・最大値セット
                                //最初の対象となるデータの場合、最小・最大値を初期化
                                if (h_items.AxisKind == 1)
                                {
                                    if (m_IsFirstKPYP == true)
                                    {
                                        m_KPMinYP = (float)fValue;
                                        m_KPMaxYP = (float)fValue;
                                        m_IsFirstKPYP = false;
                                    }
                                    m_KPMinYP = Math.Min(m_KPMinYP, (float)fValue);
                                    m_KPMaxYP = Math.Max(m_KPMaxYP, (float)fValue);
                                }
                                else
                                {
                                    if (m_IsFirstKPYS == true)
                                    {
                                        m_KPMinYS = (float)fValue;  //[2013.01.24]
                                        m_KPMaxYS = (float)fValue;  //[2013.01.24]
                                        m_IsFirstKPYS = false;
                                    }
                                    m_KPMinYS = Math.Min(m_KPMinYS, (float)fValue); //[2013.01.24]
                                    m_KPMaxYS = Math.Max(m_KPMaxYS, (float)fValue); //[2013.01.24]
                                }
                                iTargetCnt++;
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 add_e **************************************************
                    }

                    h_items.XNum = iTargetCnt2;
                }

            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 縦断描画
        /// <summary><para>method outline:</para>
        /// <para>縦断描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawLongitudinal();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawLongitudinal()
        {
            try
            {
                m_LongitudinalItems = null;

                int a_idx = 0;
                m_LongitudinalItems = new McLspViewKPItems[clbLsp2.CheckedItems.Count];

                foreach (string a_sVal in clbLsp2.CheckedItems)
                {
                    m_LongitudinalItems[a_idx] = new McLspViewKPItems();
                    m_LongitudinalItems[a_idx].ItemName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    int a_iAxis;
//Nishi
                    enumPlotForm a_MarkerPnt;
                    m_LongitudinalItems[a_idx].LineColor = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.LONGITUDINAL,  //縦断
                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis, out a_MarkerPnt);
//                    m_LongitudinalItems[a_idx].LineColor = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.LONGITUDINAL,  //縦断
//                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis);
//Nishi
                    m_LongitudinalItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_LongitudinalItems[a_idx].LineSize = fLineSize;
                    m_LongitudinalItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine) m_LongitudinalItems[a_idx].PlotKind = enumPlotKind.Line;
//Nishi
//                    if (bDrawPoint) m_LongitudinalItems[a_idx].PlotForm = enumPlotForm.FillCircle;  //1
                    if (bDrawPoint) m_LongitudinalItems[a_idx].PlotForm = a_MarkerPnt;// a_MarkerPnt;  //1
//Nishi
                    m_LongitudinalItems[a_idx].AxisKind = a_iAxis;  //[2013.01.24]
                    if (a_iAxis == 2)
                        m_IsKPYS = true;

                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)    //[2013.02.12]
                    {
                        McLspViewKPItem a_item = new McLspViewKPItem();
                        //a_item.sSectionID = a_item.SectionID.ToString();

                        a_item.Distance = m_KPStart + a_iCnt; //[2013.02.12]
                        /*
                        a_item.Distance = m_BaseDistance[a_iCnt].Distance;  //[2013.02.12]
                        */ 
                        a_item.DataVal = (decimal)McLspViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.KP = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_LongitudinalItems[a_idx].Add(a_item);	// Listに追加
                    }

                    _readLongitudinalCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_LongitudinalItems[a_idx],
                        a_sVal  //m_Folder_KP + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 計算結果1描画
        /// <summary><para>method outline:</para>
        /// <para>計算結果1描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawCalcResult1();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawCalcResult1()
        {
            try
            {
                m_KPItems = null;
                m_TimeItems = null;

                int a_idx = 0;
                m_KPItems = new McLspViewKPItems[clbLsp1.CheckedItems.Count];
                m_TimeItems = new McLspViewTimeItems();

                foreach (string a_sVal in clbLsp1.CheckedItems)
                {
                    m_KPItems[a_idx] = new McLspViewKPItems();
                    m_KPItems[a_idx].ItemName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    int a_iAxis;
//Nishi
//                    m_KPItems[a_idx].LineColor = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
//                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis);
                    enumPlotForm enumMarkerPnt;
                    m_KPItems[a_idx].LineColor = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis, out enumMarkerPnt);
//Nishi
                    m_KPItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_KPItems[a_idx].LineSize = fLineSize;
                    m_KPItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine) m_KPItems[a_idx].PlotKind = enumPlotKind.Line;
//Nishi 2014/12/22
//                    if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumPlotForm.FillCircle;
                    if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumMarkerPnt;
//Nishi
                    m_KPItems[a_idx].AxisKind = a_iAxis;  //[2013.01.24]
                    if (a_iAxis == 2)
                        m_IsKPYS = true;

                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)    //[2013.02.12]
                    {
                        McLspViewKPItem a_item = new McLspViewKPItem();
                        //a_item.sSectionID = a_item.SectionID.ToString();

                        a_item.Distance = m_KPStart + a_iCnt; //[2013.02.12]
                        /*
                        a_item.Distance = m_BaseDistance[a_iCnt].Distance;  //[2013.02.12]
                        */ 
                        a_item.DataVal = (decimal)McLspViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.KP = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_KPItems[a_idx].Add(a_item);	// Listに追加
                    }

                    //[2013.02.04]bug-fixed.
                    _readCalcResult1CSVFile_Ready(
                        a_idx,  //[2010.05.07]
                        ref m_KPItems[a_idx],
                        a_sVal  //m_Folder_KP + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }

                //[2013.02.04]bug-fixed.---↓
                a_idx = 0;
                foreach (string a_sVal in clbLsp1.CheckedItems)
                {
                    _readCalcResult1CSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_KPItems[a_idx],
                        a_sVal  //m_Folder_KP + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }
                //[2013.02.04]bug-fixed.---↑
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 計算結果2描画
        /// <summary><para>method outline:</para>
        /// <para>計算結果2描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawCalcResult2();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawCalcResult2()
        {
            try
            {
                m_KPItems = null;

                int a_idx = 0;
                m_KPItems = new McLspViewKPItems[clbLsp1.CheckedItems.Count];

                foreach (string a_sVal in clbLsp1.CheckedItems)
                {
                    m_KPItems[a_idx] = new McLspViewKPItems();
                    m_KPItems[a_idx].ItemName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    int a_iAxis;
//Nishi
//                    m_KPItems[a_idx].LineColor = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
//                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis);
                    enumPlotForm enumMarkerPnt;
                    m_KPItems[a_idx].LineColor = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis, out enumMarkerPnt);
//Nishi
                    m_KPItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_KPItems[a_idx].LineSize = fLineSize;
                    m_KPItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine) m_KPItems[a_idx].PlotKind = enumPlotKind.Line;
                    if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumPlotForm.FillCircle;
//Nishi 2015/1/5
//                    if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumPlotForm.FillCircle;
                    if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumMarkerPnt;
//Nishi 2015/1/5
                    m_KPItems[a_idx].AxisKind = a_iAxis;  //[2013.01.24]
                    if (a_iAxis == 2)
                        m_IsKPYS = true;

                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)    //[2013.02.12]
                    {
                        McLspViewKPItem a_item = new McLspViewKPItem();
                        //a_item.sSectionID = a_item.SectionID.ToString();

                        a_item.Distance = m_KPStart + a_iCnt; //[2013.02.12]
                        /*
                        a_item.Distance = m_BaseDistance[a_iCnt].Distance;  //[2013.02.12]
                        */
                        a_item.DataVal = (decimal)McLspViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.KP = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_KPItems[a_idx].Add(a_item);	// Listに追加
                    }

                    _readCalcResult2CSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_KPItems[a_idx],
                        a_sVal  //m_Folder_KP + "\\" + a_sVal[2013.01.04]
                        );
                    a_idx++;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        
        #region 再描画
        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_redraw();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _redraw()
        {
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;
                /*
                if (m_BaseDistance == null)
                {
                   //int a_ts = m_KPEnd - m_KPStart;   //[2013.02.12]
                    m_X_Num = 12; //a_ts;   //[2013.02.12]
                }
                */
                int a_ts = m_KPEnd - m_KPStart;   //[2013.02.12]
                m_X_Num = a_ts;   //[2013.02.12]

                m_KPMaxYP = 5.0F;	// グラフY軸の最大値
                m_KPMinYP = -5.0F;	// グラフY軸の最大値
                m_KPSepYP = 1.0F;	// グラフY軸のセパレート値

                m_KPMaxYS = 5.0F;	// グラフY軸の最大値
                m_KPMinYS = -5.0F;	// グラフY軸の最大値

                m_IsKPYS = false;    //２軸の有無
                m_IsFirstKPYP = true;
                m_IsFirstKPYS = true;

                switch (cmbTargetData.SelectedIndex)
                {
                    case 0: //一次元時系列情報
                        _drawLongitudinal();    //縦断
                        _drawCalcResult1();
                        trackBar1.Minimum = 1;
                        //trackBar1.Maximum = 1;
                        if (m_TimeItems.Count > 0)
                        {
                            trackBar1.Maximum = m_TimeItems.Count;
                        }
                        break;
                    case 1: //準二次元不等流計算結果
                        _drawLongitudinal();    //縦断[2013.01.24]
                        _drawCalcResult2();
                        break;
                }

                if (m_KPMaxYP == 0.0F)
                {
                    m_KPMaxYP = 5.0F;
                }

                /*[2013.01.24]
                m_KPMaxYP = Convert.ToSingle(Math.Ceiling(m_KPMaxYP));

                float a_fTmp = Math.Abs(m_KPMinYP);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_KPMinYP < 0)
                {
                    m_KPMinYP = -a_fTmp;
                }
                */

                //主軸[2010.03.07]
                //Y軸最大値
                if (McLspViewDefine.g_KP_MaxYP == McLspViewDefine.g_InvalidValue)
                {
                    if (m_KPMaxYP == McLspViewDefine.g_InvalidValue)
                    {
                        m_KPMaxYP = 5.0F;
                    }
                }
                else
                {
                    m_KPMaxYP = McLspViewDefine.g_KP_MaxYP;
                }
                //Y軸最小値
                if (McLspViewDefine.g_KP_MinYP == McLspViewDefine.g_InvalidValue)
                {
                    if (m_KPMinYP == McLspViewDefine.g_InvalidValue)
                    {
                        m_KPMinYP = -5.0F;
                    }
                }
                else
                {
                    m_KPMinYP = McLspViewDefine.g_KP_MinYP;
                }

                //[2013.01.24]---↓
                if (McLspViewDefine.g_KP_MaxYP == McLspViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_KPMaxYP = _adjustMaxVal(m_KPMaxYP);
                }
                else
                {   //最大値の指定がある場合
                }

                if (McLspViewDefine.g_KP_MinYP == McLspViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_KPMinYP = _adjustMinVal(m_KPMinYP);
                }
                else
                {   //最小値の指定がある場合
                }
                m_KPSepYP = (m_KPMaxYP - m_KPMinYP) / McLspViewDefine.g_KP_SepNumY;
                
                /*
                //double a_dLen = Math.Floor(m_KPMaxY - m_KPMinY);
                double a_dLen = Math.Ceiling(m_KPMaxY - m_KPMinY);
                int a_iLen = 0;
                if (a_dLen > 10)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 10);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                m_KPSepY = a_iLen;

                if (m_KPItems.Length > 0)
                {
                    if (m_KPMinY + (a_dLen / a_iLen) * a_iLen >= m_KPMaxY)
                    {
                        m_KPMaxY += m_KPSepY;
                        m_KPMinY -= m_KPSepY;
                    }
                }
                */
                //[2013.01.24]---↑

                //m_KPMaxY += (m_KPSepY - (Math.Abs(m_KPMaxY) % m_KPSepY));
                //m_KPMinY -= (m_KPSepY - (Math.Abs(m_KPMinY) % m_KPSepY));

                /*
                if ((Math.Abs(m_KPMaxY) % m_KPSepY) != 0)
                {
                    m_KPMaxY += m_KPSepY;
                }

                if ((Math.Abs(m_KPMinY) % m_KPSepY) != 0)
                {
                    m_KPMinY -= m_KPSepY;
                }
                */

                //[2013.01.24]
                /*
                if (m_KPMaxYP == m_KPMinYP)
                {
                    m_KPMaxYP += m_KPSepYP;
                    m_KPMinYP -= m_KPSepYP;
                }
                */

                //２軸[2013.01.24]---↓
                //Y軸最大値
                if (McLspViewDefine.g_KP_MaxYS == McLspViewDefine.g_InvalidValue)
                {
                }
                else
                {
                    m_KPMaxYS = McLspViewDefine.g_KP_MaxYS;
                }
                //Y軸最小値
                if (McLspViewDefine.g_KP_MinYS == McLspViewDefine.g_InvalidValue)
                {
                }
                else
                {
                    m_KPMinYS = McLspViewDefine.g_KP_MinYS;
                }
                if (McLspViewDefine.g_KP_MaxYS == McLspViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_KPMaxYS = _adjustMaxVal(m_KPMaxYS);
                }
                else
                {   //最大値の指定がある場合
                }
                if (McLspViewDefine.g_KP_MinYS == McLspViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_KPMinYS = _adjustMinVal(m_KPMinYS);
                }
                else
                {   //最小値の指定がある場合
                }

                if (m_IsKPYS == false)
                {
                    m_KPMinYS = McLspViewDefine.g_InvalidValue2;
                    m_KPMaxYS = McLspViewDefine.g_InvalidValue2;
                }
                //[2013.01.24]---↑

                McLspViewKP a_gw = new McLspViewKP();

                //a_gw.m_sep_bottom = 0;
                a_gw.m_sep_left = 50;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2013.01.15]
                a_gw.m_sep_top = 20;
                a_gw.m_sep_bottom = 20; //[2013.01.15]

                a_gw.ImageWidth = this.picKP.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picKP.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = McLspViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_KPMaxYP;	// グラフY軸の最大値
                a_gw.GraphMinY = m_KPMinYP;	// グラフY軸の最小値
                a_gw.GraphSepY = m_KPSepYP;	// グラフY軸のセパレート値
                a_gw.SepNumY = McLspViewDefine.g_KP_SepNumY;   //[2013.01.24] 
                a_gw.GraphMeasureYFormat = "###,###,##0.0";  //[2014.10.29]小数点１桁表示対応
//                a_gw.GraphMeasureYFormat = "###,###,##0.###";  //[2013.01.24]
                a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値[2013.02.12]
                //a_gw.GraphMaxX = (float)m_BaseDistance[m_BaseDistance.Count-1].Distance;		// グラフX軸の最大値[2013.02.12]
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                //a_gw.GraphMinX = (float)m_BaseDistance[0].Distance;		//[2010.03.07] グラフX軸の最小値[2013.02.12]
                a_gw.GraphSepX = 1;       //[2010.03.07]

                a_gw.GraphXKind = enumXKind.IsNumeric;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = false;	// Y軸の反転
                //a_gw.StartTime = m_DtStart; //[2010.03.07]

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                //a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式[2013.01.24]
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                //[2013.02.05]フォントサイズ---↓
                if (McLspViewDefine.g_FontSize != McLspViewDefine.g_InvalidValue)
                {
                    a_gw.m_font1 = new Font(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_NAME,
                                    McLspViewDefine.g_FontSize);
                }
                else
                {
                    a_gw.m_font1 = new Font(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_NAME,
                                    float.Parse(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_SIZE));
                }
                //[2013.02.05]フォントサイズ---↑

                bool    a_bIsDraw = false;
                //[2013.01.24]
                if ((m_KPItems.Length > 0) || (m_LongitudinalItems.Length > 0))
                {
                    a_bIsDraw = true;
                }
                /*
                switch (cmbTargetData.SelectedIndex)
                {
                    case 0: //準二次元
                        if ((m_KPItems.Length > 0) || (m_LongitudinalItems.Length>0))
                        {
                            a_bIsDraw = true;
                        }
                        break;
                    case 1: //一次元不定流
                        if (m_KPItems.Length > 0)
                        {
                            a_bIsDraw = true;
                        }
                        break;
                }
                */
                if (a_bIsDraw == true)
                {
                    if (m_LongitudinalItems.Length > 0)
                    {
                        a_gw.InitGraph(m_KPStart, m_KPEnd, m_LongitudinalItems[0], ref m_KPMinYS, ref m_KPMaxYS);	//[2010.03.07] グラフの初期化
                    }
                    else
                    {
                        a_gw.InitGraph(m_KPStart, m_KPEnd, m_KPItems[0], ref m_KPMinYS, ref m_KPMaxYS);	//[2010.03.07] グラフの初期化
                    }
                }
                else
                {
                    a_gw.InitGraph(m_KPStart, m_KPEnd, null, ref m_KPMinYS, ref m_KPMaxYS);	//[2010.03.07] グラフの初期化
                }
                a_gw.DrawGraphBackGround();	// グラフの初期化

                //縦断の描画
                if (m_LongitudinalItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_LongitudinalItems.Length; a_iCnt++)
                    {
                        a_gw.SetKPItems(true, m_LongitudinalItems[a_iCnt]);	// X,Y値のプロット
                    }
                }
                //計算結果の描画
                if (m_KPItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_KPItems.Length; a_iCnt++)
                    {
                        a_gw.SetKPItems(true, m_KPItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                this.picKP.Image = a_gw.m_bm;

                switch (cmbTargetData.SelectedIndex)
                {
                    case 0: //一次元時系列情報
                        if (m_TimeItems.Count > 0)
                        {
                            lblTime.Text = m_TimeItems[m_iDataRow - 1].dTimeOrDay.ToString("yyyy/MM/dd HH:mm");
                        }
                        break;
                    case 1: //準二次元不等流計算結果
                        lblTime.Text = "";
                        break;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion

        #region タイマー
        /*
        private void _newTimer()
        {
            m_myTimer = new System.Timers.Timer();
            m_myTimer.Enabled = false;   //true;
            m_myTimer.AutoReset = true;
            m_myTimer.Interval = 5000;  //秒
            m_myTimer.Elapsed += new ElapsedEventHandler(OnTimerEvent);
        }
        private void OnTimerEvent(object source, ElapsedEventArgs e)
        {
            if (m_iDataRow < m_TimeItems.Count)
            {
                m_iDataRow++;
                trackBar1.Value = m_iDataRow;
            }
        }
        */
        #endregion

        #region 表示対象書込み
        /// <summary><para>method outline:</para>
        /// <para>表示対象書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawTarget(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawTarget(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            int a_iMax = 0;
            int a_iCnt = 0;
            //int a_iCnt2 = 0;
            int a_iVal = 0;

            try
            {
                //対象種別
                h_sw.WriteLine("表示対象（縦断図）,種別（0：準二次元 1：一次元不定流）");
                h_sw.WriteLine("," + this.cmbTargetData.SelectedIndex.ToString());

                //縦断ファイル
                h_sw.WriteLine("表示対象（縦断）,読込ファイル名");
                h_sw.WriteLine("," + this.txtFileNameLsp.Text.Trim());

                //縦断データ
                h_sw.WriteLine("表示対象（縦断）,項目名,選択状態");
                a_iMax = this.clbLsp2.Items.Count;
                h_sw.Write(a_iMax.ToString());
                for (a_iCnt = 0; a_iCnt < a_iMax; a_iCnt++)
                {
                    a_iVal = 0;
                    foreach (string a_s in this.clbLsp2.CheckedItems)
                    {
                        if (a_s.Equals(this.clbLsp2.Items[a_iCnt].ToString()) == true)
                        {
                            a_iVal = 1;
                            break;
                        }
                    }
                    h_sw.WriteLine("," + this.clbLsp2.Items[a_iCnt].ToString() + "," + a_iVal.ToString());
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //計算結果ファイル
                h_sw.WriteLine("表示対象（計算結果）,読込ファイル名");
                h_sw.WriteLine("," + this.txtFileNameCalcResult.Text.Trim());

                //計算結果データ
                h_sw.WriteLine("表示対象（計算結果）,ファイル名or項目名,選択状態");
                a_iMax = this.clbLsp1.Items.Count;
                h_sw.Write(a_iMax.ToString());
                for (a_iCnt = 0; a_iCnt < a_iMax; a_iCnt++)
                {
                    a_iVal = 0;
                    foreach (string a_s in this.clbLsp1.CheckedItems)
                    {
                        if (a_s.Equals(this.clbLsp1.Items[a_iCnt].ToString()) == true)
                        {
                            a_iVal = 1;
                            break;
                        }
                    }
                    h_sw.WriteLine("," + this.clbLsp1.Items[a_iCnt].ToString() + "," + a_iVal.ToString());
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 凡例書込み
        /// <summary><para>method outline:</para>
        /// <para>凡例書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawLegend(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawLegend(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            //int a_iCnt = 0;
            int a_iMax = 0;
            //int a_iVal = 0;
            System.Drawing.Color a_color;
            string a_sLineStyle = "";
            float a_fLineSize = 0;
            float a_fMarkSize = 0;
            bool a_bDrawLine = true;
            bool a_bDrawPoint = true;
            int a_iAxis = 1;
//Nishi
            enumPlotForm enumMarkerPnt = enumPlotForm.FillCircle;
//Nishi

            try
            {
                //縦断
                h_sw.WriteLine("凡例（縦断）,項目名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画,軸,ポイント種別");
                a_iMax = this.clbLsp2.CheckedItems.Count;
                h_sw.Write(a_iMax.ToString());
                foreach (string a_s in this.clbLsp2.CheckedItems)
                {
//Nishi
//                    a_color = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.LONGITUDINAL,
//                            a_s, out a_sLineStyle, out a_fLineSize, out a_fMarkSize, out a_bDrawLine, out a_bDrawPoint, out a_iAxis); ;
                    a_color = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.LONGITUDINAL,
                            a_s, out a_sLineStyle, out a_fLineSize, out a_fMarkSize, out a_bDrawLine, out a_bDrawPoint, out a_iAxis, out enumMarkerPnt); ;
//Nishi
//Nishi 2014/12/22
//                    h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString() + "," +
//                        a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," + Convert.ToInt32(a_bDrawPoint).ToString() + "," + a_iAxis.ToString()); //[2013.01.23]
                    h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString() + "," +
                        a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," +
                        Convert.ToInt32(a_bDrawPoint).ToString() + "," + a_iAxis.ToString() + "," + enumMarkerPnt.ToString());
//Nishi
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }

                //計算結果
                h_sw.WriteLine("凡例（計算結果）,ファイル名or項目名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画,軸,ポイント種別");
                a_iMax = this.clbLsp1.CheckedItems.Count;
                h_sw.Write(a_iMax.ToString());
                foreach (string a_s in this.clbLsp1.CheckedItems)
                {
//Nishi
//                    a_color = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,
//                            a_s, out a_sLineStyle, out a_fLineSize, out a_fMarkSize, out a_bDrawLine, out a_bDrawPoint, out a_iAxis); ;
                    a_color = legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,
                            a_s, out a_sLineStyle, out a_fLineSize, out a_fMarkSize, out a_bDrawLine, out a_bDrawPoint, out a_iAxis, out enumMarkerPnt); ;
//Nishi
//Nishi
//                    h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString() + "," +
//                        a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," + Convert.ToInt32(a_bDrawPoint).ToString() + "," + a_iAxis.ToString()); //[2013.01.23]
                    h_sw.WriteLine("," + a_s + "," + a_color.ToArgb().ToString() + "," +
                        a_sLineStyle.ToString() + "," + a_fLineSize.ToString() + "," + a_fMarkSize.ToString() + "," + Convert.ToInt32(a_bDrawLine).ToString() + "," +
                        Convert.ToInt32(a_bDrawPoint).ToString() + "," + a_iAxis.ToString() + "," + enumMarkerPnt.ToString());
//Nishi
                }
                if (a_iMax <= 0)
                {
                    h_sw.WriteLine("");
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region グラフ設定書込み
        /// <summary><para>method outline:</para>
        /// <para>グラフ設定書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeDrawGraphSet(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeDrawGraphSet(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.04]
            try
            {
                //KP
                //[2013.02.05]
                h_sw.WriteLine("グラフ設定（縦断図）,軸ラベル(主軸),Y軸最大(主軸),Y軸最小(主軸),軸ラベル(２軸),Y軸最大(２軸),Y軸最小(２軸),文字サイズ,X軸間隔");
                //[2013.02.05]
                h_sw.WriteLine("," + labelAxisKPP.Text  + "," + McLspViewDefine.g_KP_MaxYP.ToString() + "," + McLspViewDefine.g_KP_MinYP.ToString() + "," + labelAxisKPS.Text + "," + McLspViewDefine.g_KP_MaxYS.ToString() + "," + McLspViewDefine.g_KP_MinYS.ToString() +
                    "," + McLspViewDefine.g_FontSize.ToString() + "," + McLspViewDefine.g_XAxisPitch.ToString());
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region 表示対象読込み
        /// <summary><para>method outline:</para>
        /// <para>表示対象読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawTarget(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawTarget(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = { ',' };

            int a_iMax = 0;
            int a_iCnt = 0;
            int a_iTarget = 0;

            try
            {
                //対象種別
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（縦断図）,種別（0：準二次元 1：一次元不定流）
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iTarget = int.Parse(a_sSplit[1]);
                this.cmbTargetData.SelectedIndex = a_iTarget;

                //縦断ファイル
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（縦断）,読込ファイル名
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                this.txtFileNameLsp.Text = a_sSplit[1];

                _setXItemNamesLongitudinal(this.txtFileNameLsp.Text);   //一度読込処理
                clbLsp2.Items.Clear();  //一度クリア

                //縦断データ
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（縦断）,項目名,選択状態
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    this.clbLsp2.Items.Add(a_sSplit[1]);

                    if (a_sSplit[2].Equals("1") == true)
                    {
                        this.clbLsp2.SetItemChecked(this.clbLsp2.Items.Count - 1, true);
                        this.clbLsp2.SetSelected(this.clbLsp2.Items.Count - 1, true);
                        //legendList1.AddList(Properties.LongitudinalSectionGraphResources.WATER_LEVEL, a_sSplit[1]);
                    }
                }

                //計算結果ファイル
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（計算結果）,読込ファイル名
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                this.txtFileNameCalcResult.Text = a_sSplit[1];
                switch (cmbTargetData.SelectedIndex)
                {
                    case 0:     //一次元時系列情報
                        //clbLsp1.Items.Add(txtFileNameCalcResult.Text.Trim());
                        //計算結果データを読込みclbLsp1にリストを反映
                        //_setXItemNamesCalcResult1(txtFileNameCalcResult.Text.Trim());
                        break;
                    case 1:     //準二次元不等流計算結果
                        //計算結果データを読込みclbLsp1にリストを反映
                        _setXItemNamesCalcResult2(txtFileNameCalcResult.Text.Trim());
                        clbLsp1.Items.Clear();  //一度クリア
                        break;
                }

                //計算結果データ
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：表示対象（縦断図）,ファイル名,選択状態
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    this.clbLsp1.Items.Add(a_sSplit[1]);

                    if (a_sSplit[2].Equals("1") == true)
                    {
                        this.clbLsp1.SetItemChecked(this.clbLsp1.Items.Count - 1,true);
                        this.clbLsp1.SetSelected(this.clbLsp1.Items.Count - 1, true);
                        //legendList1.AddList(Properties.LongitudinalSectionGraphResources.WATER_LEVEL, a_sSplit[1]);
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region 凡例読込み
        /// <summary><para>method outline:</para>
        /// <para>凡例読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawLegend(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawLegend(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = { ',' };

            int a_iCnt = 0;
            int a_iMax = 0;
            //int a_iVal = 0;
            //System.Drawing.Color a_color;
            //string a_sLineStyle = "";
            //float a_fLineSize = 0;
            //float a_fMarkSize = 0;
            bool a_bDrawLine = true;
            bool a_bDrawPoint = true;
            int a_iAxis = 1;
//NISHI
            enumPlotForm enumMarkerPnt = enumPlotForm.FillCircle;
//NISHI

            try
            {
                //縦断
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：凡例（縦断）,項目名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画,軸
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    if (int.Parse(a_sSplit[6]) == 1)
                    {
                        a_bDrawLine = true;
                    }
                    else
                    {
                        a_bDrawLine = false;
                    }

                    if (int.Parse(a_sSplit[7]) == 1)
                    {
                        a_bDrawPoint = true;
                    }
                    else
                    {
                        a_bDrawPoint = false;
                    }

                    if (int.Parse(a_sSplit[8]) == 1)
                    {
                        a_iAxis = 1;
                    }
                    else
                    {
                        a_iAxis = 2;
                    }
//NISHI 2014/12/22
                    switch (a_sSplit[9])
                    {
                        case "Circle":                              //塗り潰しなしの円
                            enumMarkerPnt = enumPlotForm.Circle;
                            break;
                        case "FillCircle":                          //塗り潰しありの円
                            enumMarkerPnt = enumPlotForm.FillCircle;
                            break;
                        case "Rectangle":                           //塗り潰しなしの四角形
                            enumMarkerPnt = enumPlotForm.Rectangle;
                            break;
                        case "FillRectangle":                       //塗り潰しありの四角形
                            enumMarkerPnt = enumPlotForm.FillRectangle;
                            break;
                        case "Triangle":                            //塗り潰しなしの三角形
                            enumMarkerPnt = enumPlotForm.Triangle;
                            break;
                        case "FillTriangle":                        //塗り潰しありの三角形
                            enumMarkerPnt = enumPlotForm.FillTriangle;
                            break;
                        case "Rhombus":                             //塗り潰しなしの菱形
                            enumMarkerPnt = enumPlotForm.Rhombus;
                            break;
                        case "FillRhombus":                         //塗り潰しありの菱形
                            enumMarkerPnt = enumPlotForm.FillRhombus;
                            break;
                        default:
                            enumMarkerPnt = enumPlotForm.Nothing;
                            break;
                    }
//NISHI

//NISHI
//                    legendList1.SetLegend(
//                        Properties.LongitudinalSectionGraphResources.LONGITUDINAL,
//                        a_sSplit[1],
//                        Color.FromArgb(int.Parse(a_sSplit[2])),
//                        a_sSplit[3],
//                        float.Parse(a_sSplit[4]),
//                        float.Parse(a_sSplit[5]),
//                        a_bDrawLine,
//                        a_bDrawPoint,
//                        a_iAxis
//                        );
                    legendList1.SetLegend(
                        Properties.LongitudinalSectionGraphResources.LONGITUDINAL,
                        a_sSplit[1],
                        Color.FromArgb(int.Parse(a_sSplit[2])),
                        a_sSplit[3],
                        float.Parse(a_sSplit[4]),
                        float.Parse(a_sSplit[5]),
                        a_bDrawLine,
                        a_bDrawPoint,
                        a_iAxis,
                        enumMarkerPnt
                        );
//NISHI
                }

                //計算結果
                //1行目は読み飛ばし
                a_sLine = h_sr.ReadLine();
                //2行目以降：凡例（縦断図）,ファイル名or項目名,線色,線種,線サイズ,ポイントサイズ,線描画,ポイント描画,軸
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                a_iMax = int.Parse(a_sSplit[0]);
                for (a_iCnt = 1; a_iCnt <= a_iMax; a_iCnt++)
                {
                    if (a_iCnt > 1)
                    {
                        a_sLine = h_sr.ReadLine();
                        a_sSplit = a_sLine.Split(a_delimiterChars);
                    }

                    if (int.Parse(a_sSplit[6]) == 1)
                    {
                        a_bDrawLine = true;
                    }
                    else
                    {
                        a_bDrawLine = false;
                    }

                    if (int.Parse(a_sSplit[7]) == 1)
                    {
                        a_bDrawPoint = true;
                    }
                    else
                    {
                        a_bDrawPoint = false;
                    }

                    if (int.Parse(a_sSplit[8]) == 1)
                    {
                        a_iAxis = 1;
                    }
                    else
                    {
                        a_iAxis = 2;
                    }
//NISHI 2014/12/22
                    switch (a_sSplit[9])
                    {
                        case "Circle":                              //塗り潰しなしの円
                            enumMarkerPnt = enumPlotForm.Circle;
                            break;
                        case "FillCircle":                          //塗り潰しありの円
                            enumMarkerPnt = enumPlotForm.FillCircle;
                            break;
                        case "Rectangle":                           //塗り潰しなしの四角形
                            enumMarkerPnt = enumPlotForm.Rectangle;
                            break;
                        case "FillRectangle":                       //塗り潰しありの四角形
                            enumMarkerPnt = enumPlotForm.FillRectangle;
                            break;
                        case "Triangle":                            //塗り潰しなしの三角形
                            enumMarkerPnt = enumPlotForm.Triangle;
                            break;
                        case "FillTriangle":                        //塗り潰しありの三角形
                            enumMarkerPnt = enumPlotForm.FillTriangle;
                            break;
                        case "Rhombus":                             //塗り潰しなしの菱形
                            enumMarkerPnt = enumPlotForm.Rhombus;
                            break;
                        case "FillRhombus":                         //塗り潰しありの菱形
                            enumMarkerPnt = enumPlotForm.FillRhombus;
                            break;
                        default:
                            enumMarkerPnt = enumPlotForm.Nothing;
                            break;
                    }
//NISHI

//NISHI
//                    legendList1.SetLegend(
//                        Properties.LongitudinalSectionGraphResources.RESULT_CALC,
//                        a_sSplit[1],
//                        Color.FromArgb(int.Parse(a_sSplit[2])),
//                        a_sSplit[3],
//                        float.Parse(a_sSplit[4]),
//                        float.Parse(a_sSplit[5]),
//                        a_bDrawLine,
//                        a_bDrawPoint,
//                        a_iAxis
//                        );
                    legendList1.SetLegend(
                        Properties.LongitudinalSectionGraphResources.RESULT_CALC,
                        a_sSplit[1],
                        Color.FromArgb(int.Parse(a_sSplit[2])),
                        a_sSplit[3],
                        float.Parse(a_sSplit[4]),
                        float.Parse(a_sSplit[5]),
                        a_bDrawLine,
                        a_bDrawPoint,
                        a_iAxis,
                        enumMarkerPnt
                        );
//NISHI
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion
        #region グラフ設定読込み
        /// <summary><para>method outline:</para>
        /// <para>グラフ設定読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDrawGraphSet(h_sr);</para>
        /// </example>
        /// <param name="h_sr">StreamReader</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDrawGraphSet(
            ref System.IO.StreamReader h_sr
            )
        {
            //[2013.01.05]
            string a_sLine = "";
            string[] a_sSplit = null;
            char[] a_delimiterChars = { ',' };

            try
            {
                //1行目は読み飛ばし：グラフ設定（縦断図）,軸ラベル(主軸),Y軸最大(主軸),Y軸最小(主軸),軸ラベル(２軸),Y軸最大(２軸),Y軸最小(２軸),文字サイズ,X軸間隔
                a_sLine = h_sr.ReadLine();
                //2行目以降
                a_sLine = h_sr.ReadLine();
                a_sSplit = a_sLine.Split(a_delimiterChars);
                labelAxisKPP.Text = a_sSplit[1];
                //m_KPRateY = float.Parse(a_sSplit[2]);
                McLspViewDefine.g_KP_MaxYP = float.Parse(a_sSplit[2]);
                McLspViewDefine.g_KP_MinYP = float.Parse(a_sSplit[3]);
                labelAxisKPS.Text = a_sSplit[4];
                McLspViewDefine.g_KP_MaxYS = float.Parse(a_sSplit[5]);
                McLspViewDefine.g_KP_MinYS = float.Parse(a_sSplit[6]);

                McLspViewDefine.g_FontSize = float.Parse(a_sSplit[7]);      //[2013.02.05]
                McLspViewDefine.g_XAxisPitch = float.Parse(a_sSplit[8]);    //[2013.02.05]
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        #region KPデータ書込み
        /// <summary><para>method outline:</para>
        /// <para>KPデータ書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_writeOutDrawKP(h_sw);</para>
        /// </example>
        /// <param name="h_sw">StreamWriter</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _writeOutDrawKP(
            ref System.IO.StreamWriter h_sw
            )
        {
            //[2013.01.05]
            int a_X_Num = 0;
            int a_iPlotNum = 0;
            int a_R = 0;
            int a_G = 0;
            int a_B = 0;
            bool a_bFirst = true;

            try
            {
                //[2013.02.06]---↓
                string a_sMaxYP = "";
                string a_sMinYP = "";
                string a_sMaxYS = "";
                string a_sMinYS = "";
                if (McLspViewDefine.g_KP_MaxYP != McLspViewDefine.g_InvalidValue)
                    a_sMaxYP = McLspViewDefine.g_KP_MaxYP.ToString();
                if (McLspViewDefine.g_KP_MinYP != McLspViewDefine.g_InvalidValue)
                    a_sMinYP = McLspViewDefine.g_KP_MinYP.ToString();
                if (McLspViewDefine.g_KP_MaxYS != McLspViewDefine.g_InvalidValue)
                    a_sMaxYS = McLspViewDefine.g_KP_MaxYS.ToString();
                if (McLspViewDefine.g_KP_MinYS != McLspViewDefine.g_InvalidValue)
                    a_sMinYS = McLspViewDefine.g_KP_MinYS.ToString();
                //[2013.02.06]---↑

                a_iPlotNum = m_LongitudinalItems.Length + m_KPItems.Length;

                if (a_iPlotNum > 0)
                {
                    if (m_LongitudinalItems != null)
                    {
                        foreach (McLspViewKPItem a_item in m_LongitudinalItems[0])
                        {
                            if (a_item.sSectionID.Length > 0)
                            {
                                a_X_Num++;
                            }
                        }
                    }
                    else
                    {
                        foreach (McLspViewKPItem a_item in m_KPItems[0])
                        {
                            if (a_item.sSectionID.Length > 0)
                            {
                                a_X_Num++;
                            }
                        }
                    }

                    //--------------------------------------------------------------
                    //描画データ書込み：Y軸ラベル(主軸),Y軸最大値(主軸),Y軸最小値(主軸),Y軸ラベル(２軸),Y軸最大値(２軸),Y軸最小値(２軸),X軸数,プロット数
                    //--------------------------------------------------------------

                    h_sw.WriteLine(labelAxisKPP.Text + "\t" + a_sMaxYP + "\t" + a_sMinYP +
                        "\t" + labelAxisKPS.Text + "\t" + a_sMaxYS + "\t" + a_sMinYS +
                        "\t" + (a_X_Num).ToString() + "\t" + a_iPlotNum.ToString());

                    //--------------------------------------------------------------
                    //描画データ書込み：
                    //軸の種類（1：主軸、2：2軸）
                    //ラインありなし（-1：断面、0：なし、1：あり）→
                    //マーカーありなし（0：なし、1：あり）→
                    //線の種類（1：実線、2：ドット、3：ダッシュ、4：ダッシュドット）→
                    //線の色→
                    //線の太さ→
                    //--------------------------------------------------------------
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        h_sw.Write(m_LongitudinalItems[a_iCnt - 1].ItemName);
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        h_sw.Write("Data" + a_iCnt.ToString());
                    }
                    h_sw.WriteLine("");

                    //軸の種類（1：主軸、2：2軸）
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");

                        h_sw.Write(m_LongitudinalItems[a_iCnt - 1].AxisKind.ToString());
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");

                        h_sw.Write(m_KPItems[a_iCnt - 1].AxisKind.ToString());
                    }
                    h_sw.WriteLine("");

                    //ラインありなし（-1：断面、0：なし、1：あり）
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        if (m_LongitudinalItems[a_iCnt - 1].PlotKind != enumPlotKind.Nothing)
                            h_sw.Write("1");
                        else
                            h_sw.Write("0");
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        if (m_KPItems[a_iCnt - 1].PlotKind != enumPlotKind.Nothing)
                            h_sw.Write("1");
                        else
                            h_sw.Write("0");
                    }
                    h_sw.WriteLine("");

                    //マーカーありなし（0：なし、1：あり）
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        if (m_LongitudinalItems[a_iCnt - 1].PlotForm != enumPlotForm.Nothing)
//Nishi 2015/1/5
                        {
                            switch (m_LongitudinalItems[a_iCnt - 1].PlotForm){
                                case enumPlotForm.Circle:
                                    h_sw.Write("8");
                                    break;
                                case enumPlotForm.Triangle:
                                    h_sw.Write("3");
                                    break;
                                case enumPlotForm.Rectangle:
                                    h_sw.Write("1");
                                    break;
                                case enumPlotForm.Rhombus:
                                    h_sw.Write("2");
                                    break;
                                case enumPlotForm.FillCircle:
                                    h_sw.Write("18");
                                    break;
                                case enumPlotForm.FillTriangle:
                                    h_sw.Write("13");
                                    break;
                                case enumPlotForm.FillRectangle:
                                    h_sw.Write("11");
                                    break;
                                case enumPlotForm.FillRhombus:
                                    h_sw.Write("12");
                                    break;
                            }
//                            h_sw.Write("1");
                        }
//nishi
                        else
                            h_sw.Write("0");
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        if (m_KPItems[a_iCnt - 1].PlotForm != enumPlotForm.Nothing)
//Nishi 2015/1/5
                        {
                            switch (m_KPItems[a_iCnt - 1].PlotForm)
                            {
                                case enumPlotForm.Circle:
                                    h_sw.Write("8");
                                    break;
                                case enumPlotForm.Triangle:
                                    h_sw.Write("3");
                                    break;
                                case enumPlotForm.Rectangle:
                                    h_sw.Write("1");
                                    break;
                                case enumPlotForm.Rhombus:
                                    h_sw.Write("2");
                                    break;
                                case enumPlotForm.FillCircle:
                                    h_sw.Write("18");
                                    break;
                                case enumPlotForm.FillTriangle:
                                    h_sw.Write("13");
                                    break;
                                case enumPlotForm.FillRectangle:
                                    h_sw.Write("11");
                                    break;
                                case enumPlotForm.FillRhombus:
                                    h_sw.Write("12");
                                    break;
                            }
//                            h_sw.Write("1");
                        }
//nishi
                        else
                            h_sw.Write("0");
                    }
                    h_sw.WriteLine("");

                    //線の種類（1：実線、2：ドット、3：ダッシュ、4：ダッシュドット）
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        switch (m_LongitudinalItems[a_iCnt - 1].LineStyle)
                        {
                            case System.Drawing.Drawing2D.DashStyle.Solid:
                                h_sw.Write("1");
                                break;
                            case System.Drawing.Drawing2D.DashStyle.Dot:
                                h_sw.Write("2");
                                break;
                            case System.Drawing.Drawing2D.DashStyle.Dash:
                                h_sw.Write("3");
                                break;
                            case System.Drawing.Drawing2D.DashStyle.DashDot:
                                h_sw.Write("4");
                                break;
                        }
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        switch (m_KPItems[a_iCnt - 1].LineStyle)
                        {
                            case System.Drawing.Drawing2D.DashStyle.Solid:
                                h_sw.Write("1");
                                break;
                            case System.Drawing.Drawing2D.DashStyle.Dot:
                                h_sw.Write("2");
                                break;
                            case System.Drawing.Drawing2D.DashStyle.Dash:
                                h_sw.Write("3");
                                break;
                            case System.Drawing.Drawing2D.DashStyle.DashDot:
                                h_sw.Write("4");
                                break;
                        }
                    }
                    h_sw.WriteLine("");

                    //線の色
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        a_R = m_LongitudinalItems[a_iCnt - 1].LineColor.R;
                        a_G = m_LongitudinalItems[a_iCnt - 1].LineColor.G;
                        a_B = m_LongitudinalItems[a_iCnt - 1].LineColor.B;
                        h_sw.Write(a_R.ToString() + "#" + a_G.ToString() + "#" + a_B.ToString());
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        a_R = m_KPItems[a_iCnt - 1].LineColor.R;
                        a_G = m_KPItems[a_iCnt - 1].LineColor.G;
                        a_B = m_KPItems[a_iCnt - 1].LineColor.B;
                        h_sw.Write(a_R.ToString() + "#" + a_G.ToString() + "#" + a_B.ToString());
                    }
                    h_sw.WriteLine("");

                    //線の太さ
                    a_bFirst = true;
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        h_sw.Write(m_LongitudinalItems[a_iCnt - 1].LineSize.ToString());
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        if (a_bFirst == true)
                            a_bFirst = false;
                        else
                            h_sw.Write("\t");
                        h_sw.Write(m_KPItems[a_iCnt - 1].LineSize.ToString());
                    }
                    h_sw.WriteLine("");

                    //--------------------------------------------------------------
                    //描画データ書込み：データ
                    //--------------------------------------------------------------
                    h_sw.Write("KP");
                    for (int a_iCnt = 1; a_iCnt <= m_LongitudinalItems.Length; a_iCnt++)
                    {
                        h_sw.Write("\t" + m_LongitudinalItems[a_iCnt - 1].ItemName);
                    }
                    for (int a_iCnt = 1; a_iCnt <= m_KPItems.Length; a_iCnt++)
                    {
                        h_sw.Write("\tData" + a_iCnt.ToString());
                    }
                    h_sw.WriteLine("");

                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)    //[2013.02.12]
                    {
                        string a_sTmp = "";

                        //[2013.02.06]---↓
                        if (m_LongitudinalItems != null)
                        {
                            a_sTmp = m_LongitudinalItems[0][a_iCnt].sSectionID;
                        }
                        else
                        {
                            a_sTmp = m_KPItems[0][a_iCnt].sSectionID;
                        }
                        //[2013.02.06]---↑

                        if (a_sTmp.Length > 0)  //[2013.02.06]if (m_KPItems[0][a_iCnt].sSectionID.Length>0)
                        {
                            //a_sTmp = m_KPItems[0][a_iCnt].sSectionID; //[2013.02.06]
                            h_sw.Write(a_sTmp);

                            //KP
                            for (int a_iCnt2 = 0; a_iCnt2 < m_LongitudinalItems.Length; a_iCnt2++)
                            {

                                a_sTmp = "";
                                if ((m_LongitudinalItems[a_iCnt2][a_iCnt].DataVal != (decimal)McLspViewDefine.g_InvalidValue2)
                                    && (m_LongitudinalItems[a_iCnt2][a_iCnt].DataVal != (decimal)McLspViewDefine.g_InvalidValue))
                                {
                                    a_sTmp = m_LongitudinalItems[a_iCnt2][a_iCnt].DataVal.ToString();
                                }
                                h_sw.Write("\t" + a_sTmp);
                            }
                            for (int a_iCnt2 = 0; a_iCnt2 < m_KPItems.Length; a_iCnt2++)
                            {

                                a_sTmp = "";
                                if ((m_KPItems[a_iCnt2][a_iCnt].DataVal != (decimal)McLspViewDefine.g_InvalidValue2)
                                    && (m_KPItems[a_iCnt2][a_iCnt].DataVal != (decimal)McLspViewDefine.g_InvalidValue))
                                {
                                    a_sTmp = m_KPItems[a_iCnt2][a_iCnt].DataVal.ToString();
                                }
                                h_sw.Write("\t" + a_sTmp);
                            }
                            h_sw.WriteLine("");
                        }
                    }
                }
                else
                {
                    //[2013.02.06]
                    h_sw.WriteLine(labelAxisKPP.Text + "\t" + a_sMaxYP + "\t" + a_sMinYP +
                        "\t" + labelAxisKPS.Text + "\t" + a_sMaxYS + "\t" + a_sMinYS +
                        "\t" + (a_X_Num).ToString() + "\t" + a_iPlotNum.ToString());
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        #endregion

        /// <summary>
        /// COMオブジェクトへの参照を作成および取得します
        /// </summary>
        /// <param name="progId">作成するオブジェクトのプログラムID</param>
        /// <param name="serverName">
        /// オブジェクトが作成されるネットワークサーバー名
        /// </param>
        /// <returns>作成されたCOMオブジェクト</returns>
        public static object CreateObject(string progId, string serverName)
        {
            //[2013.01.05]
            Type t;
            if (serverName == null || serverName.Length == 0)
                t = Type.GetTypeFromProgID(progId);
            else
                t = Type.GetTypeFromProgID(progId, serverName, true);
            return Activator.CreateInstance(t);
        }
 
        /// <summary>
        /// COMオブジェクトへの参照を作成および取得します
        /// </summary>
        /// <param name="progId">作成するオブジェクトのプログラムID</param>
        /// <returns>作成されたCOMオブジェクト</returns>
        public static object CreateObject(string progId)
        {
            //[2013.01.05]
            return CreateObject(progId, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = InputCheckNum(txt, sCaption) </para>
        /// </example>
        /// <param name="txt">TextBox</param>
        /// <param name="sCaption">項目名</param>
        /// <returns>true=正常/false=入力エラーあり</returns>
        private bool InputCheckNum(TextBox txt, string sCaption)
        {
            if (!string.IsNullOrEmpty(txt.Text) && txt.Text.Trim().Length != 0)
            {   //入力あり
                float fVal = 0;
                if (!float.TryParse(txt.Text.Trim(), out fVal))
                {
                    //{0}には数値を入力して下さい。
                    MessageBox.Show(string.Format(Properties.LongitudinalSectionGraphResources.MSG_ERROR_INPUT_NUMERICAL_VALUE, sCaption),
                        Properties.LongitudinalSectionGraphResources.CAPTION_INPUT_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txt.Focus();
                    return false;
                }
            }
            return true;
        }

        #region 後処理
        private void _terminate()
        {
            if (m_TimeFrm != null)
            {
                m_TimeFrm.Dispose();
            }
        }
        #endregion
        #endregion

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLspViewDotNetForm csNewProjectForm = new McLspViewDotNetForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McLspViewDotNetForm()
        {
            InitializeComponent();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLspViewDotNetForm csNewProjectForm = new McLspViewDotNetForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLspViewDotNetForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csGraphViewScreen = csScreen as McLspViewDotNetScreen; // 便利の為

            //凡例の色･線種変更時イベント割付
            legendList1.LegendStyleChanged += new EventHandler(legendList1_LegendStyleChanged);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じた時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLspViewDotNetForm_FormClosed( sender, e )：フォームを閉じた時のイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McLspViewDotNetForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_csGraphViewScreen.CloseScreen();  //⇒★[2010.01.29]
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じようとした時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLspViewDotNetForm_FormClosing( sender, e )：フォームが閉じようとしたときのイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McLspViewDotNetForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            _terminate();   //[2013.01.24]
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLspViewDotNetForm_Load( sender, e )：フォームがロードされたときのイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McLspViewDotNetForm_Load(object sender, EventArgs e)
        {
            //[2013.02.05]CommonMPDataのパスを取得---↓
            McLspViewDefine.g_sCommonMPData_Path = HySEnvInf.GetDataHomeDirectory().ToString() + "\\"; //[2013.02.07]
            McLspViewDefine.g_sCommonMP_Path = HySEnvInf.GetHomeDirectory().ToString() + "\\"; //[2013.02.07]
            McLspViewDefine.g_uriCommonMP_Path = new Uri(HySEnvInf.GetHomeDirectory().ToString() + "\\");  //[2013.02.07]
            //[2013.02.05]CommonMPDataのパスを取得---↑

            //[2013.02.06]自身業務パス---↓
            HySString a_csHomedir = HySEnvInf.GetHomeDirectory();
            //HySString csPath; // 実行環境及びツール開発環境で動作させる例
            if(a_csHomedir.ToString().EndsWith("Execute"))
            {
              // 実行環境(Execute\bin)で動作する場合
                McLspViewDefine.g_MyGyomuPath = a_csHomedir.ToString() + "\\..\\Source\\HYSSOP\\AddinSysTools\\" + McLspViewDefine.MCLSPVIEW_ID + "\\";
            }
            else
            {
              // ツール開発環境(Source\HYSSOP\AddInSysTools\DeveloperTestMain\bin)で動作する場合
                McLspViewDefine.g_MyGyomuPath = a_csHomedir.ToString() + "\\..\\..\\"  + McLspViewDefine.MCLSPVIEW_ID + "\\";
            }
            //[2013.02.06]---↑
            
            //[2013.02.07]---↓
            if (System.Threading.Thread.CurrentThread.CurrentUICulture.Name.StartsWith("ja") == true)
            {
                // OS設定が日本語の場合
                btnSaveDrawStatus.Text = "描画設定の\r\n新規保存";         //[2013.02.12]
                btnOverwriteDrawStatus.Text = "描画設定の\r\n上書保存";    //[2013.02.12]
                btnRestoreDraw.Text = "描画設定ﾌｧｲﾙを\r\n開く";            //[2013.02.12]
            }
            else
            {
                // OS設定が日本語以外の場合
                cmbTargetData.Items.Clear();
                cmbTargetData.Items.Add("Quasi Two-Dimensional");
                cmbTargetData.Items.Add("One-Dimensional Unsteady Flow");
            }
            //[2013.02.07]---↑

            //cmbHourStart.SelectedIndex = 0;
            //cmbHourEnd.SelectedIndex = 23;
            //cmbMinuteStart.SelectedIndex = 0;
            //cmbMinuteEnd.SelectedIndex = 00;

            cmbTargetData.SelectedIndex = 0;

            _redraw();

            //trackBar1.Enabled = false;
            lblTime.Text = "";

            m_toolTip = new ToolTip();
            m_displayRectahgle = new Rectangle(0, 0, picKP.Width, picKP.Height);

            //_newTimer();    //[2013.01.15]

            //decimal a_sVal = 2.341484431m;
            //decimal a_sVal2 = 2.3m;

        }

        /// <summary><para>method outline:</para>
        /// <para>表示対象コンボボックス変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> cmbTargetData_SelectedIndexChanged( sender, e )：表示対象コンボボックス変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmbTargetData_SelectedIndexChanged(object sender, EventArgs e)
        {
            //[2013.01.08]
            try
            {
                txtFileNameLsp.Enabled = false;
                btnFileNameLsp.Enabled = false;

                //clbLsp1.Visible = false;
                //clbLsp2.Visible = false;

                switch (cmbTargetData.SelectedIndex)
                {
                    case 0:     //一次元時系列情報
                        txtFileNameLsp.Enabled = true;
                        btnFileNameLsp.Enabled = true;
                        clbLsp2.Enabled = true;
                        btnDelFile2.Enabled = false;

                        //clbLsp2.Visible = true;
                        trackBar1.Enabled = true;

                        picForward.Enabled = true;
                        picStop.Enabled = true;
                        picBackward.Enabled = true;
                        picPause.Enabled = true;

                        break;
                    case 1:     //準二次元不等流計算結果
                        txtFileNameLsp.Enabled = true;  //[2013.01.24]
                        btnFileNameLsp.Enabled = true;  //[2013.01.24]
                        clbLsp2.Enabled = true;         //[2013.01.24]
                        btnDelFile2.Enabled = false;

                        //clbLsp1.Visible = true;
                        trackBar1.Enabled = false;

                        picForward.Enabled = false;
                        picStop.Enabled = false;
                        picBackward.Enabled = false;
                        picPause.Enabled = false;

                        break;
                }

                m_KPStart = 0;
                m_KPEnd = 12;
                m_iDataRow = 1;
                clbLsp2.Items.Clear();
                clbLsp1.Items.Clear();
                legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.LONGITUDINAL);
                legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.RESULT_CALC);
                txtFileNameLsp.Text = "";
                txtFileNameCalcResult.Text = "";

                _redraw();
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例の色･線種変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> legendList1_LegendStyleChanged( sender, e )：凡例の変更フォームのOKボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void legendList1_LegendStyleChanged(object sender, EventArgs e)
        {
            if (m_IsAutoFit == true)
            {
                //_getTimeStampAll();
            }
            /*
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
             */ 
        }

        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnRedraw_Click( sender, e )：（再描画ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnRedraw_Click(object sender, EventArgs e)
        {
            m_IsAutoFit = false;    //[2010.06.03]

            _redraw();
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnSetGraph_Click( sender, e )：（グラフ設定ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            McGraphSetForm a_frm = null;

            try
            {
                a_frm = new McGraphSetForm();
                a_frm.AxisLabelKPP = labelAxisKPP.Text;
                a_frm.AxisRateKPLeft = m_KPRateYP;

                a_frm.AxisLabelKPS = labelAxisKPS.Text;

                if (a_frm.ShowDialog(this) == DialogResult.OK)
                {
                    labelAxisKPP.Text = a_frm.AxisLabelKPP;
                    m_KPRateYP = a_frm.AxisRateKPLeft;

                    labelAxisKPS.Text = a_frm.AxisLabelKPS;
                }
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_frm != null)
                    a_frm.Dispose();
                a_frm = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>描画リセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnResetDraw_Click( sender, e )：（リセットボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnResetDraw_Click(object sender, EventArgs e)
        {
            //[2010.06.03]ファイルの内容から開始・終了時刻を再設定する。
            m_IsAutoFit = true;
            //_getTimeStampAll();
            /*
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
             */ 
            //_drawRainfall();
        }
// start of 印刷機能追加
        /// <summary><para>method outline:</para>
        /// <para>取得領域ビットマップ化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap btmp = CaptureControl( ctrl )</para>
        /// </example>
        /// <param name="ctrl">ウインドウ部品（コントロール）</param>
        /// <returns>Bitmap : 取得領域内の画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Bitmap CaptureControl(Control ctrl)
        {
            Graphics g = ctrl.CreateGraphics();
            //ctrl（panel）の大きさのBitmapを生成
            Bitmap b_img = new Bitmap(ctrl.ClientRectangle.Width, ctrl.ClientRectangle.Height, g);
            Graphics memg = Graphics.FromImage(b_img);
            //BitBltの引数の用意
            IntPtr dc1 = g.GetHdc();
            IntPtr dc2 = memg.GetHdc();
            const int SRCCOPY = 0xCC0020;
            //Bitmap取得
            BitBlt(dc2, 0, 0, b_img.Width, b_img.Height, dc1, 0, 0, SRCCOPY);
            //解放処理
            g.ReleaseHdc(dc1);
            memg.ReleaseHdc(dc2);
            memg.Dispose();
            g.Dispose();
            return b_img;
        }

        /// <summary><para>method outline:</para>
        /// <para>プリントイベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> pd_PrintPage += new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">プリントイベント(PrintPageEvent)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void pd_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            //画像を描画する
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //e.Graphics.DrawImage(m_bit_img, 0, 0);
            e.Graphics.DrawImage(m_bit_img, 60, 60);
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //印刷の次のページがないこと
            e.HasMorePages = false;
            
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> print_button_Click( sender, e )：（印刷ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void print_button_Click(object sender, EventArgs e)
        {
            //印刷用ビットマップの取得
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //m_bit_img = (CaptureControl(panel1));
            m_bit_img = CreateGraphForPrint();
            //********** 速度改善他対応 2011.03.04 mod_e **************************************************


            //プリントドキュメントの生成
            m_pd = new System.Drawing.Printing.PrintDocument();

            //PrintPageイベントハンドラの追加
            m_pd.PrintPage +=
                new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

            //プリントダイアログの生成
            PrintDialog pdlg = new PrintDialog();
            pdlg.UseEXDialog = true;

            //PrintDocumentを指定
            pdlg.Document = m_pd;
            //印刷の選択ダイアログを表示する
            if (pdlg.ShowDialog() == DialogResult.OK)
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                //プリンター設定
                m_pd.PrinterSettings = pdlg.PrinterSettings;

                //ページ設定
                foreach (System.Drawing.Printing.PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    if (ps.Kind == System.Drawing.Printing.PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;    //横
                        break;
                    }
                }
                //********** 速度改善他対応 2011.03.04 add_s **************************************************

                //OKがクリックされた時は印刷する
                m_pd.Print();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷プレビュー表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Preview_button_Click( sender, e )：（印刷ﾌﾟﾚﾋﾞｭｰボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Preview_button_Click(object sender, EventArgs e)
        {

            // start of 印刷プレビュー処理修正
            try
            {
                //印刷用ビットマップの取得
                //********** 速度改善他対応 2011.03.04 mod_s **************************************************
                //m_bit_img = (CaptureControl(panel1));
                m_bit_img = CreateGraphForPrint();
                //********** 速度改善他対応 2011.03.04 mod_e **************************************************

                //プリントドキュメントの生成
                m_pd = new System.Drawing.Printing.PrintDocument();

                //PrintPageイベントハンドラの追加
                m_pd.PrintPage +=
                    new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

                //プレビューフォームのインスタンス生成
                PrintPreviewDialog ppd = new PrintPreviewDialog();
                //プレビューするPrintDocumentを設定
                ppd.Document = m_pd;

                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                //プリンター設定
                m_pd.PrinterSettings = ppd.Document.PrinterSettings;

                //ページ設定
                foreach (System.Drawing.Printing.PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    if (ps.Kind == System.Drawing.Printing.PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;    //横
                        break;
                    }
                }
                //********** 速度改善他対応 2011.03.04 add_s **************************************************

                //印刷プレビューダイアログを表示する
                ppd.ShowDialog();
                //bitmap解放
                m_bit_img.Dispose();
            }
            catch(Exception exp)
            {
                // 例外を此処で捕捉して任意処理実施
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            // end of 印刷プレビュー処理修正
        }

        // end of 印刷機能追加

        //********** 速度改善他対応 2011.03.04 add_s **************************************************
        /// <summary><para>method outline:</para>
        /// <para>画像保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveImage_button_Click( sender, e )：（画像保存クリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveImage_button_Click(object sender, EventArgs e)
        {
            //--------------------------------------------------
            // 保存先選択ダイアログ表示
            //--------------------------------------------------
            SaveFileDialog sfd = new SaveFileDialog();
            //はじめのファイル名を指定する
            sfd.FileName = "graph1.png";
            //[2013.02.05]
            sfd.InitialDirectory = McLspViewDefine.g_sCommonMPData_Path;
            //sfd.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString();
            sfd.Filter = string.Format(Properties.LongitudinalSectionGraphResources.FILE_DLG_FILTER_ANY, "png");
            //タイトルを設定する
            sfd.Title = Properties.Resources.STRING_SAVEFILEDIALOG_TITLE;              // 多言語対応
            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
            sfd.RestoreDirectory = true;
            
            //ダイアログを表示する
            if (sfd.ShowDialog() != DialogResult.OK)
            {   //キャンセルボタンがクリックされたとき
                return;  
            }

            //--------------------------------------------------
            // 保存用画像作成
            //--------------------------------------------------
            using (Bitmap bmp = CreateGraphForPrint())
            {
                //保存
                bmp.Save(sfd.FileName, System.Drawing.Imaging.ImageFormat.Png);
//Nishi 2015/1/7 PATHを変更する
                McLspViewDefine.g_sCommonMPData_Path = System.IO.Path.GetDirectoryName(sfd.FileName);
//Nishi 2015/1/7 PATHを変更する
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例を付け足した画像作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap bmp = CreateGraphForPrint()</para>
        /// </example>
        /// <returns>凡例付き画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Bitmap CreateGraphForPrint()
        {
            Graphics g = null;
            Bitmap bmpLeg = null;
            try
            {
                int iLegendWidth = 0;
                if (chkPrintLegend.Checked)
                {
                    //凡例を付け足す
//NISHI
//                    legendList1.DrawLegend(ref bmpLeg, chkPrintFileName.Checked);
                    legendList1.DrawLegend2(ref bmpLeg, chkPrintFileName.Checked);
//NISHI

                    //凡例のサイズ
                    iLegendWidth = bmpLeg.Width + 10;
                }

                Bitmap bmp = new Bitmap(panel1.Width + iLegendWidth + 10, panel1.Height + 10);
                
                //Graphicsオブジェクトを取得
                g = Graphics.FromImage(bmp);
                //背景を白色にする
                g.FillRectangle(Brushes.White, 0, 0, bmp.Width, bmp.Height);

                //グラフを合成
                g.DrawImage(picKP.Image, 0, 0);                          //縦断描画[2013.01.25]

                //ラベル描画
                using (SolidBrush bs = new SolidBrush(Color.Black))
                {
                    Font ft = labelAxisKPP.Font;
                    g.DrawString(labelAxisKPP.Text, ft, bs, 40, 5); //[2013.01.25]
                    //g.DrawString(labelAxisX.Text, ft, bs, 30, picRainfall.Height + 20);
                    //右軸ラベルは右寄せ
                    RectangleF rect = new RectangleF(0, 5, panel1.Width - 50, 18);  //[2013.01.25]
                    StringFormat sformat = new StringFormat();
                    sformat.Alignment = StringAlignment.Far;
                    g.DrawString(labelAxisKPS.Text, ft, bs, rect, sformat);
                }

                if (bmpLeg != null)
                {   //凡例を合成
                    int iLegeTop = Math.Max((panel1.Height - bmpLeg.Height - 50), 5);
                    g.DrawImage(bmpLeg, picKP.Image.Width + 10, iLegeTop);
                }

                return bmp;
            }
            finally
            {
                if (bmpLeg != null)
                {
                    bmpLeg.Dispose();
                    bmpLeg = null;
                }
                if (g != null)
                {
                    g.Dispose();
                    g = null;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>描画状態の保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnSaveDrawStatus_Click( sender, e )：（描画状態の保存ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSaveDrawStatus_Click(object sender, EventArgs e)
        {
            //[2013.01.04]
            Cursor a_preCursor = Cursor.Current;
            System.IO.Stream a_stream = null;
            System.IO.StreamWriter a_sw = null;

            try
            {
                //SaveFileDialogクラスのインスタンスを作成
                SaveFileDialog a_sfd = new SaveFileDialog();

                //はじめのファイル名を指定する
                //a_sfd.FileName = "新しいファイル.html";
                //はじめに表示されるフォルダを指定する
                //a_sfd.InitialDirectory = @"C:\";
                //[ファイルの種類]に表示される選択肢を指定する
                //a_sfd.Filter =
                //    "csvファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*";
                a_sfd.Filter = Properties.Resources.STRING_SAVEFILEDIALOG_FILTER_CSV;    // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_sfd.FilterIndex = 1;
                //タイトルを設定する
                //a_sfd.Title = "保存先のファイルを指定してください";
                a_sfd.Title = Properties.Resources.STRING_SAVEFILEDIALOG_TITLE;          // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_sfd.InitialDirectory = McLspViewDefine.g_sCommonMPData_Path;
                //a_sfd.RestoreDirectory = true;
                //既に存在するファイル名を指定したとき警告する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.OverwritePrompt = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_sfd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_sfd.FileName);
                    Cursor.Current = Cursors.WaitCursor;
                    a_stream = a_sfd.OpenFile();
                    if (a_stream != null)
                    {
                        //ファイルに書き込む
                        a_sw = new System.IO.StreamWriter(a_stream, System.Text.Encoding.GetEncoding("shift_jis"));
                        _writeDrawGraphSet(ref a_sw);   //グラフ設定
                        _writeDrawTarget(ref a_sw);     //表示対象
                        _writeDrawLegend(ref a_sw);     //凡例

                        btnOverwriteDrawStatus.Enabled = false; //[2013.01.23]
//Nishi 2015/1/7 PATHを変更する
                        McLspViewDefine.g_sCommonMPData_Path = System.IO.Path.GetDirectoryName(a_sfd.FileName);
//Nishi 2015/1/7 PATHを変更する
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sw != null)
                {
                    a_sw.Close();
                }
                if (a_stream != null)
                {
                    a_stream.Close();
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ描画の復元</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnRestoreDraw_Click( sender, e )：（グラフ描画の復元ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnRestoreDraw_Click(object sender, EventArgs e)
        {
            //[2013.01.05]
            Cursor a_preCursor = Cursor.Current;
            System.IO.StreamReader a_sr = null;

            try
            {
                //OpenFileDialogクラスのインスタンスを作成
                OpenFileDialog a_ofd = new OpenFileDialog();

                //はじめのファイル名を指定する
                //はじめに「ファイル名」で表示される文字列を指定する
                //a_ofd.FileName = "default.csv";
                //はじめに表示されるフォルダを指定する
                //指定しない（空の文字列）の時は、現在のディレクトリが表示される
                //a_ofd.InitialDirectory = Properties.LongitudinalSectionGraphResources.MSG_INFO_SPECIFY_FOLDER;
                //[ファイルの種類]に表示される選択肢を指定する
                //指定しないとすべてのファイルが表示される
                //a_ofd.Filter =
                //    "csvファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*";
                a_ofd.Filter = Properties.Resources.STRING_OPENFILEDIALOG_FILTER;            // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_ofd.FilterIndex = 1;
                //タイトルを設定する
                //a_ofd.Title = "開くファイルを選択してください";
                a_ofd.Title = Properties.Resources.STRING_OPENFILEDIALOG_TITLE;              // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_ofd.InitialDirectory = McLspViewDefine.g_sCommonMPData_Path;
                //a_ofd.RestoreDirectory = true;
                //存在しないファイルの名前が指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckFileExists = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_ofd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_ofd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_ofd.FileName);
                    Cursor.Current = Cursors.WaitCursor;

                    //表示対象・凡例を初期化
                    this.clbLsp1.Items.Clear();
                    this.legendList1.DelGroupList(Properties.LongitudinalSectionGraphResources.RESULT_CALC);

                    //ファイルを読み込む
                    a_sr = new System.IO.StreamReader(a_ofd.FileName, System.Text.Encoding.GetEncoding("shift_jis"));
                    _readDrawGraphSet(ref a_sr);    //グラフ設定
                    _readDrawTarget(ref a_sr);      //表示対象
                    _readDrawLegend(ref a_sr);      //凡例
                    _redraw();  //[2013.01.24]

//Nishi 2015/1/7 PATHを変更する
                    McLspViewDefine.g_sCommonMPData_Path = System.IO.Path.GetDirectoryName(a_ofd.FileName);
//Nishi 2015/1/7 PATHを変更する
                    m_RestoreDrawFileName = a_ofd.FileName; //[2013.01.23]
                    btnOverwriteDrawStatus.Enabled = true;  //[2013.01.23]
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sr != null)
                {
                    a_sr.Close();
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>描画データ出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnOutDrawData_Click( sender, e )：（描画データ出力ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnOutDrawData_Click(object sender, EventArgs e)
        {
            //[2013.01.05]
            Cursor a_preCursor = Cursor.Current;
            string a_sTmpFile = "";
            System.IO.StreamWriter a_sw = null;

            try
            {
                //SaveFileDialogクラスのインスタンスを作成
                SaveFileDialog a_sfd = new SaveFileDialog();

                //はじめのファイル名を指定する
                //a_sfd.FileName = "新しいファイル.html";
                //はじめに表示されるフォルダを指定する
                //a_sfd.InitialDirectory = @"C:\";
                //[ファイルの種類]に表示される選択肢を指定する
                //a_sfd.Filter =
                //    "Excelファイル(*.xls)|*.xls";
                a_sfd.Filter = Properties.Resources.STRING_SAVEFILEDIALOG_FILTER_EXCEL;  // 多言語対応
                //[ファイルの種類]ではじめに
                //「csvファイル」が選択されているようにする
                a_sfd.FilterIndex = 1;
                //タイトルを設定する
                //a_sfd.Title = "保存先のファイルを指定してください";
                a_sfd.Title = Properties.Resources.STRING_SAVEFILEDIALOG_TITLE;          // 多言語対応
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                //[2013.02.05]
                a_sfd.InitialDirectory = McLspViewDefine.g_sCommonMPData_Path;
                //a_sfd.RestoreDirectory = true;
                //既に存在するファイル名を指定したとき警告する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.OverwritePrompt = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                a_sfd.CheckPathExists = true;

                //ダイアログを表示する
                if (a_sfd.ShowDialog() == DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    //Console.WriteLine(a_sfd.FileName);
                    Cursor.Current = Cursors.WaitCursor;
                    a_sTmpFile = System.IO.Path.GetTempFileName();
                    a_sw = new System.IO.StreamWriter(a_sTmpFile, false, System.Text.Encoding.GetEncoding("shift_jis"));
                    //ファイルに書き込む
                    _writeOutDrawKP(ref a_sw);  //KP
                    a_sw.Close();
                    a_sw = null;

                    //Excelマクロファイルパス[2013.02.06]
                    string strMacroPath = McLspViewDefine.g_MyGyomuPath + @"\" + McLspViewDefine.MCLSPVIEW_ID + ".xls";
                    //string strMacroPath = HySEnvInf.GetHomeDirectory().ToString() + @"\jp.go.nilim.Longitudinal_profile_H24.xls";
                    // Excel操作用COMオブジェクトを生成する
                    object oExcel = CreateObject("Excel.Application");
                    //ワークブックコレクションオブジェクトを生成する。
                    object oBooks = oExcel.GetType().InvokeMember("Workbooks", BindingFlags.GetProperty, null, oExcel, null);

                    //Excelファイルのオープン
                    object oBook = oBooks.GetType().InvokeMember(
                                          "Open", BindingFlags.InvokeMethod, null,
                                          oBooks, new object[] { 
                                                       strMacroPath
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing
                                                     , Type.Missing 
                                                     });

                    // Excelファイルの表示
                    oExcel.GetType().InvokeMember("Visible", BindingFlags.SetProperty, null, oExcel, new object[] { true });

                    //マクロ実行(Testというサブプロシージャを実行する)
                    //oExcel.Run("Test");
                    //oExcel.GetType().InvokeMember("Save", System.Reflection.BindingFlags.InvokeMethod, null, oExcel, new object[] { a_sfd.FileName });
                    oExcel.GetType().InvokeMember("Run", BindingFlags.InvokeMethod, null, oExcel, new object[] { "OutDrawData", a_sfd.FileName, a_sTmpFile });

                    //保存
                    //oExcel.GetType().InvokeMember("Save", System.Reflection.BindingFlags.InvokeMethod, null, oExcel, new object[] { a_sfd.FileName });
                    //閉じる
                    oExcel.GetType().InvokeMember("Quit", System.Reflection.BindingFlags.InvokeMethod, null, oExcel, null);
                    //COM解放
                    System.Runtime.InteropServices.Marshal.FinalReleaseComObject(oBook);
                    System.Runtime.InteropServices.Marshal.FinalReleaseComObject(oBooks);
                    System.Runtime.InteropServices.Marshal.FinalReleaseComObject(oExcel);
                    oBook = null;
                    oBooks = null;
                    oExcel = null;
//Nishi 2015/1/7 PATHを変更する
                    McLspViewDefine.g_sCommonMPData_Path = System.IO.Path.GetDirectoryName(a_sfd.FileName);
//Nishi 2015/1/7 PATHを変更する
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sw != null)
                {
                    a_sw.Close();
                }
                if (a_sTmpFile.Length > 0)
                {
                    File.Delete(a_sTmpFile);
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>縦断データファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFileNameLsp_Click( sender, e )：（縦断データファイル選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFileNameLsp_Click(object sender, EventArgs e)
        {
            //[2013.01.08]
            Cursor a_preCursor = Cursor.Current;
            System.IO.StreamReader a_sr = null;

            try
            {
                _selectFile(txtFileNameLsp);

                if (txtFileNameLsp.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_LongitudinalFileName = txtFileNameLsp.Text.Trim();    //[2013.02.12]
                    //縦断データを読込みclLsp2にリスト反映
                    _setXItemNamesLongitudinal(txtFileNameLsp.Text.Trim());
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sr != null)
                {
                    a_sr.Close();
                }
                Cursor.Current = a_preCursor;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>計算結果データファイル選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFileNameLsp_Click( sender, e )：（計算結果データファイル選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFileNameCalcResult_Click(object sender, EventArgs e)
        {
            //[2013.01.08]
            try
            {
                _selectFile(txtFileNameCalcResult);

                if (txtFileNameCalcResult.Text.Trim().Length > 0)
                {
                    switch (cmbTargetData.SelectedIndex)
                    {
                        case 0:     //一次元時系列情報
                            clbLsp1.Items.Add(txtFileNameCalcResult.Text.Trim());
                            //計算結果データを読込みclbLsp1にリストを反映
                            //_setXItemNamesCalcResult1(txtFileNameCalcResult.Text.Trim());
                            break;
                        case 1:     //準二次元不等流計算結果
                            //計算結果データを読込みclbLsp1にリストを反映
                            _setXItemNamesCalcResult2(txtFileNameCalcResult.Text.Trim());
                            break;
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>計算結果項目選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> clbLsp1_SelectedIndexChanged( sender, e )：（計算結果項目変更時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void clbLsp1_SelectedIndexChanged(object sender, EventArgs e)
        {
            string sGroup = Properties.LongitudinalSectionGraphResources.RESULT_CALC; //水位
            for (int i = 0; i < clbLsp1.Items.Count; i++)
            {
                string sItemName = clbLsp1.Items[i].ToString();
                if (clbLsp1.CheckedIndices.Contains(i))
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sItemName);
                    //描画
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sItemName);
                }
            }

            if (m_IsAutoFit == true)
            {
                //_getTimeStampAll();
            }
            _redraw();

        }

        /// <summary><para>method outline:</para>
        /// <para>トラックバースクロール時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> trackBar1_Scroll( sender, e )：（トラックバースクロール時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            m_iDataRow = trackBar1.Value;
            //lblTime.Text = m_TimeItems[m_iDataRow - 1].dTimeOrDay.ToString("yyyy/MM/dd HH:mm");
            _redraw();
        }

        /// <summary><para>method outline:</para>
        /// <para>Forwardクリック時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> picForward_Click( sender, e )：（Forwardクリック時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void picForward_Click(object sender, EventArgs e)
        {
            //[2013.01.22]
            if (!InputCheckNum(txtSpeed, lblSpeed.Text))
                return;

            m_timerKind = 1;
            timer1.Interval = (int)(decimal.Parse(txtSpeed.Text) * 1000);
            timer1.Enabled = true;

            trackBar1.Enabled = false;

            /*
            picForward.Enabled = false; 
            picStop.Enabled = true;
            picBackward.Enabled = true;
            picPause.Enabled = true;
             */ 
        }

        /// <summary><para>method outline:</para>
        /// <para>Stopクリック時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> picStop_Click( sender, e )：（Stopクリック時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void picStop_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            m_iDataRow = 1;
            trackBar1.Value = m_iDataRow;
            _redraw();

            trackBar1.Enabled = true;

            /*
            picForward.Enabled = true;
            picStop.Enabled = false;
            picBackward.Enabled = false;
            picPause.Enabled = false;
             */ 
        }

        /// <summary><para>method outline:</para>
        /// <para>タイマー発生時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> timer1_Click( sender, e )：（タイマー発生時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (m_timerKind == 1)
            {
                m_iDataRow++;
                if (m_iDataRow <= m_TimeItems.Count)
                {
                    trackBar1.Value = m_iDataRow;
                    _redraw();
                }
                else
                {
                    m_iDataRow--;   //[2013.02.05]bug-fixed.
                    timer1.Enabled = false;

                    trackBar1.Enabled = true;

                    /*
                    picForward.Enabled = false;
                    picStop.Enabled = true;
                    picBackward.Enabled = true;
                    picPause.Enabled = false;
                     */ 
                }
            }
            else
            {
                m_iDataRow--;
                if (m_iDataRow >= 1)
                {
                    trackBar1.Value = m_iDataRow;
                    _redraw();
                }
                else
                {
                    m_iDataRow++;   //[2013.02.05]bug-fixed.
                    timer1.Enabled = false;

                    trackBar1.Enabled = true;

                    /*
                    picForward.Enabled = true;
                    picStop.Enabled = true;
                    picBackward.Enabled = false;
                    picPause.Enabled = false;
                     */ 
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Backwardクリック時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> picBackward_Click( sender, e )：（Backwardクリック時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void picBackward_Click(object sender, EventArgs e)
        {
            //[2013.01.22]
            if (!InputCheckNum(txtSpeed, lblSpeed.Text))
                return;

            m_timerKind = 2;
            timer1.Interval = (int)(decimal.Parse(txtSpeed.Text)*1000);
            timer1.Enabled = true;

            trackBar1.Enabled = false;

            /*
            picForward.Enabled = true;
            picStop.Enabled = true;
            picBackward.Enabled = false;
            picPause.Enabled = true;
             */ 
        }

        /// <summary><para>method outline:</para>
        /// <para>Pauseクリック時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> picPause_Click( sender, e )：（Pauseクリック時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void picPause_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;

            trackBar1.Enabled = true;

            /*
            picForward.Enabled = true;
            picStop.Enabled = true;
            picBackward.Enabled = true;
            picPause.Enabled = false;
             */ 
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ画像マウスクリック時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> picKP_MouseClick( sender, e )：（グラフ画像マウスクリック時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">MouseEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void picKP_MouseClick(object sender, MouseEventArgs e)
        {

            PictureBox pb = (PictureBox)sender;
            //クリックされた位置を画像上の位置に変換
            Point imgPoint = new Point(
                (int)Math.Round((e.X - m_displayRectahgle.X) / 1F),
                (int)Math.Round((e.Y - m_displayRectahgle.Y) / 1F));
            //Console.WriteLine(imgPoint);

            int a_x = 0;
            int a_y = 0;
            //int a_CIdx = 0;
            bool a_IsFound = false;

            if (cmbTargetData.SelectedIndex == 0){
                foreach (McLspViewKPItems a_items in m_KPItems)
                {
                    foreach (McLspViewKPItem a_item in a_items)
                    {
                        a_x = (int)a_item.GX;
                        a_y = (int)a_item.GY;

                        if ((((a_x + 4) >= imgPoint.X) && (a_x - 4 <= imgPoint.X)) &&
                           (((a_y + 4) >= imgPoint.Y) && (a_y - 4 <= imgPoint.Y)))
                        {
                            //Console.WriteLine("found!" + "KP=" + a_item.sSectionID + ",Val=" + a_item.DataVal.ToString());

                            a_item.Selected = true; //[2013.01.24]選択状態を追加
                            
                            /*[2013.01.24]
                            McLspViewDefine.g_TargetLspFileName = txtFileNameLsp.Text; //縦断データファイル
                            McLspViewDefine.g_TargetItemFileName = a_items.ItemName;   //計算結果データファイル

                            McLspViewDefine.g_TargetSectionID = a_item.sSectionID;    //KP
                            McLspViewDefine.g_TargetDistance = a_item.Distance;    //累加距離
                            McLspViewDefine.g_TargetCalcIndex = a_item.CalcIndex;
                            */

                            McLspViewDefine.g_TargetLabelKPP = this.labelAxisKPP.Text; //ラベル
                            McLspViewDefine.g_TargetLabelKPS = this.labelAxisKPS.Text; //ラベル

                            McLspViewDefine.g_TargetStartKP = m_TimeItems[0].dTimeOrDay;
                            McLspViewDefine.g_TargetEndKP = m_TimeItems[m_TimeItems.Count - 1].dTimeOrDay;

                            if (m_TimeFrm == null)
                            {
                                m_TimeFrm = new McLspViewTimeGraph(this);
                                m_TimeFrm.Show();
                            }
                            m_TimeFrm.Redraw();
                            m_TimeFrm.Activate();

                            a_IsFound = true;

                            break;
                        }

                        //a_CIdx++;

                        /*
                        if ((a_x == imgPoint.X) && (a_y == imgPoint.Y))
                        {
                            Console.WriteLine("found!" + "KP=" + a_item.sSectionID + ",Val=" + a_item.DataVal.ToString());
                        }
                        */
                    }
                    if (a_IsFound == true)
                    {
                        break;
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ画像マウス移動時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> picKP_MouseMove( sender, e )：（グラフ画像マウス移動時のイベント）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">MouseEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void picKP_MouseMove(object sender, MouseEventArgs e)
        {
            PictureBox pb = (PictureBox)sender;
            //クリックされた位置を画像上の位置に変換
            Point imgPoint = new Point(
                (int)Math.Round((e.X - m_displayRectahgle.X) / 1F),
                (int)Math.Round((e.Y - m_displayRectahgle.Y) / 1F));
            //Console.WriteLine(imgPoint);

            int a_x = 0;
            int a_y = 0;
            bool a_IsFound = false;

            if (cmbTargetData.SelectedIndex == 0)
            {
                foreach (McLspViewKPItems a_items in m_KPItems)
                {
                    foreach (McLspViewKPItem a_item in a_items)
                    {
                        a_x = (int)a_item.GX;
                        a_y = (int)a_item.GY;

                        if ((((a_x + 4) >= imgPoint.X) && (a_x - 4 <= imgPoint.X)) &&
                           (((a_y + 4) >= imgPoint.Y) && (a_y - 4 <= imgPoint.Y)))
                        {
                            m_toolTip.SetToolTip(picKP, "KP=" + a_item.sSectionID + "\nVal=" + a_item.DataVal.ToString());
                            a_IsFound = true;
                            break;
                        }
                        /*
                        if (((int)a_item.GX == imgPoint.X) && ((int)a_item.GY == imgPoint.Y))
                        {
                            //Console.WriteLine("found!" + "KP=" + a_item.sSectionID + ",Val=" + a_item.DataVal.ToString());
                            m_toolTip.SetToolTip(picKP, "KP=" + a_item.sSectionID + "\nVal=" + a_item.DataVal.ToString());
                        }
                        */ 
                    }
                    if (a_IsFound == true)
                    {
                        break;
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnDelFile_Click( sender, e )：（ファイル削除ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">EventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnDelFile_Click(object sender, EventArgs e)
        {
            string a_sVal = "";
            string a_sFileName = "";    //[2013.02.08]
            int a_iCnt = 0;
            int a_iMax = 0;

            try
            {
                a_iMax = this.clbLsp1.Items.Count - 1;
                for (a_iCnt = a_iMax; a_iCnt >= 0; a_iCnt--)
                {
                    foreach (string a in this.clbLsp1.SelectedItems)    //[2013.02.07]
                    {
                        //Console.WriteLine(a);
                        if (a.Equals(this.clbLsp1.Items[a_iCnt].ToString()) == true)
                        {
                            a_sFileName = this.clbLsp1.Items[a_iCnt].ToString();
                            this.clbLsp1.Items.RemoveAt(a_iCnt);
                            break;
                        }
                    }
                }
                a_sVal = Properties.LongitudinalSectionGraphResources.RESULT_CALC;

                //凡例から削除
                legendList1.DelList(a_sVal,a_sFileName);   //[2013.02.08]

                _redraw();  //[2013.02.04]bug-fixed.
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void clbLsp2_SelectedIndexChanged(object sender, EventArgs e)
        {
            string sGroup = Properties.LongitudinalSectionGraphResources.LONGITUDINAL; //縦断
            for (int i = 0; i < clbLsp2.Items.Count; i++)
            {
                string sItemName = clbLsp2.Items[i].ToString();
                if (clbLsp2.CheckedIndices.Contains(i))
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sItemName);
                    //描画
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sItemName);
                }
            }

            if (m_IsAutoFit == true)
            {
                //_getTimeStampAll();
            }
            _redraw();
        }

        private void btnOverwriteDrawStatus_Click_1(object sender, EventArgs e)
        {
            Cursor a_preCursor = Cursor.Current;
            System.IO.StreamWriter a_sw = null;

            try
            {
                Cursor.Current = Cursors.WaitCursor;
                //ファイルに書き込む
                a_sw = new System.IO.StreamWriter(m_RestoreDrawFileName, false, System.Text.Encoding.GetEncoding("shift_jis"));
                _writeDrawGraphSet(ref a_sw);   //グラフ設定
                _writeDrawTarget(ref a_sw);     //表示対象
                _writeDrawLegend(ref a_sw);     //凡例
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_sw != null)
                {
                    a_sw.Close();
                    a_sw = null;
                }
                Cursor.Current = a_preCursor;
            }
        }

        private void McLspViewDotNetForm_HelpButtonClicked(object sender, CancelEventArgs e)
        {
            try
            {
                System.Diagnostics.Process.Start(McLspViewDefine.g_sCommonMP_Path + "ToolManual\\" + McLspViewDefine.MCLSPVIEW_ID +"\\" + McLspViewDefine.MCLSPVIEW_ID +".pdf");
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void chkPrintLegend_CheckedChanged(object sender, EventArgs e)
        {   //[2013.02.08]
            if (chkPrintLegend.Checked == true)
            {
                chkPrintFileName.Enabled = true;
            }
            else
            {
                chkPrintFileName.Enabled = false;
                chkPrintFileName.Checked = false;
            }
        }

        //********** 速度改善他対応 2011.03.04 add_s **************************************************

    }
}