﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　グラフ設定画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class McLspViewTimeGraph : Form
    {
        private McLspViewDotNetForm m_pfrm = null;
        /*[2013.01.24]
        private string m_TargetLspFileName = "";
        private string m_TargetItemFileName = "";
        private decimal m_TargetDistance = 0;
        private int m_TargetCalcIndex = 0;
        */ 
        private DateTime m_TargetStartKP;
        private DateTime m_TargetEndKP;

        /// <summary> KPデータリスト </summary>
        public McLspViewKPItems[] m_KPItems = null;
        /// <summary> グラフ縦軸数 </summary>
        private int m_X_Num = 0;

        /// <summary> KPグラフY軸の最大値 </summary>
        private float m_KPMaxYP = 5.0F;	// グラフY軸の最大値
        /// <summary> KPグラフY軸の最大値 </summary>
        private float m_KPMinYP = -5.0F;	// グラフY軸の最大値
        /// <summary> KPグラフY軸のセパレート値 </summary>
        private float m_KPSepYP = 1.0F;	// グラフY軸のセパレート値

        /// <summary> KPグラフY軸の最大値(２軸) </summary>
        private float m_KPMaxYS = 5.0F;	// グラフY軸の最大値
        /// <summary> KPグラフY軸の最大値(２軸) </summary>
        private float m_KPMinYS = -5.0F;	// グラフY軸の最大値
        ///// <summary> KPグラフY軸のセパレート値(２軸) </summary>
        //private float m_KPSepYS = 1.0F;	// グラフY軸のセパレート値

        /// <summary> ２軸の有無 </summary>
        private bool m_IsKPYS = false;
        /// <summary> 最初の主軸 </summary>
        private bool m_IsFirstKPYP = true;
        /// <summary> 最初の２軸 </summary>
        private bool m_IsFirstKPYS = true;

        /// <summary> KPグラフY軸の表示目盛掛け率 </summary>
        //private float m_KPRateY = 0.0F;     //add 2011.03.08

        ///// <summary> グラフ自動調整表示の有無 </summary>
        //private bool m_IsAutoFit = true;    //[2010.06.03]
        
        #region 内部メソッド
        #region "絶対パス取得"
        private string _getLocalPath(string h_fileName)
        {
            Uri a_targetPath = new Uri(McLspViewDefine.g_uriCommonMP_Path, h_fileName);

            return a_targetPath.LocalPath;
        }
        #endregion

        #region 最大値調整[2013.01.24]
        private float _adjustMaxVal(float h_max)
        {
            float a_fRet = h_max;
            a_fRet = (float)Math.Ceiling(h_max);
            /*
            if (h_max >= 0)
                a_fRet = (float)Math.Ceiling(h_max);
            else
                a_fRet = (float)Math.Floor(h_max);
            */

            return a_fRet;
        }
        #endregion
        #region 最小値調整[2013.01.24]
        private float _adjustMinVal(float h_min)
        {
            float a_fRet = h_min;
            a_fRet = (float)Math.Floor(h_min);
            /*
            if (h_min >= 0)
                a_fRet = (float)Math.Ceiling(h_min);
            else
                a_fRet = (float)Math.Floor(h_min);
            */

            return a_fRet;
        }
        #endregion

        #region KP実測値2の読み込み
        /// <summary><para>method outline:</para>
        /// <para>KP実測値2の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readKPTimeCSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McLspViewKPItems：KPデータリスト</param>
        /// <param name="h_fileName">ファイル名</param>
        /// <param name="h_calcINdex">計算インデックス</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readKPTimeCSVFile(
            int h_idx,  //[2010.05.07]
            ref McLspViewKPItems h_items,
            string h_fileName,
            int h_calcINdex
            )
        {
            try
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //int iTargetCnt2 = 0;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                //次に計算結果を取得
                iDataIdx = 0;       //格納するデータリストのインデックス
                iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //iTargetCnt2 = 0;

                using (StreamReader a_sr = new StreamReader(
                    _getLocalPath(h_fileName), System.Text.Encoding.GetEncoding(932)))  //[2013.02.05]
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //int a_iCnt = 0;
                    //int a_iTidx = 1;
                    //bool a_isOK = false;
                    //int a_inIdx = 0;

                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    //4行目からデータを取得
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);

                        DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                        decimal fValue = (decimal)McLspViewDefine.g_InvalidValue;
                        string a_sVal = a_split[h_calcINdex].Trim();    //[2013.01.24]
                        if (a_sVal.Length > 0)
                        {
                            fValue = decimal.Parse(a_sVal);         //Data0
                        }
                        if (m_pfrm.m_KPRateYP != 0 && fValue != (decimal)McLspViewDefine.g_InvalidValue)
                        {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                            fValue *= (decimal)m_pfrm.m_KPRateYP;
                        }

                        if (cs_DTChange > m_TargetEndKP)
                            break;      //期間終了を超えたら読込み終了
                        if (cs_DTChange < m_TargetStartKP)
                            continue;   //期間開始に達していない場合は読み飛ばし

                        string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                        while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }
                        if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                        {   //時刻が一致するなら格納
                            h_items[iDataIdx].DataVal = fValue;

                            //最小・最大値セット
                            if (fValue != (decimal)McLspViewDefine.g_InvalidValue)
                            {   //欠測値以外なら最小・最大値セット
                                //最初の対象となるデータの場合、最小・最大値を初期化
                                if (h_items.AxisKind == 1)
                                {
                                    if (m_IsFirstKPYP == true)
                                    {
                                        m_KPMinYP = (float)fValue;
                                        m_KPMaxYP = (float)fValue;
                                        m_IsFirstKPYP = false;
                                    }
                                    m_KPMinYP = Math.Min(m_KPMinYP, (float)fValue);
                                    m_KPMaxYP = Math.Max(m_KPMaxYP, (float)fValue);
                                }
                                else
                                {
                                    if (m_IsFirstKPYS == true)
                                    {
                                        m_KPMinYS = (float)fValue;  //[2013.01.24]
                                        m_KPMaxYS = (float)fValue;  //[2013.01.24]
                                        m_IsFirstKPYS = false;
                                    }
                                    m_KPMinYS = Math.Min(m_KPMinYS, (float)fValue); //[2013.01.24]
                                    m_KPMaxYS = Math.Max(m_KPMaxYS, (float)fValue); //[2013.01.24]
                                }
                                iTargetCnt++;
                            }
                        }
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region KP描画
        /// <summary><para>method outline:</para>
        /// <para>KP1描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawKP();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawKP()
        {
            try
            {
                this.lblTargetKP.Text = ""; //[2013.01.24]

                m_KPMaxYP = 5.0F;	// グラフY軸の最大値
                m_KPMinYP = -5.0F;	// グラフY軸の最大値
                m_KPSepYP = 1.0F;	// グラフY軸のセパレート値
                //m_FlowMeterMaxY = 50.0F;	// グラフY軸の最大値
                //m_FlowMeterMinY = 0.0F;	// グラフY軸の最大値
                m_KPMaxYS = 5.0F;	// グラフY軸の最大値
                m_KPMinYS = -5.0F;	// グラフY軸の最大値

                m_IsKPYS = false;    //２軸の有無
                m_IsFirstKPYP = true;
                m_IsFirstKPYS = true;

                m_KPItems = null;

                int a_idx = 0;

                //[2013.01.24]
                foreach (McLspViewKPItems a_pitems in m_pfrm.m_KPItems)
                {
                    foreach (McLspViewKPItem a_pitem in a_pitems)
                    {
                        if (a_pitem.Selected == true)
                        {   //選択状態
                            if (this.lblTargetKP.Text.Length >0)
                                this.lblTargetKP.Text += ",";               //[2013.01.24]
                            this.lblTargetKP.Text += a_pitem.sSectionID;    //[2013.01.24]

                            Array.Resize<McLspViewKPItems>(ref m_KPItems, a_idx + 1);   //配列を動的に増やす。

                            m_KPItems[a_idx] = new McLspViewKPItems();
                            m_KPItems[a_idx].ItemName = a_pitems.ItemName;

                            //凡例リストから色・線種を取得
                            string sLineStyle;
                            float fLineSize, fMarkSize;
                            bool bDrawLine, bDrawPoint;
                            int a_iAxis;
//Nishi
                            enumPlotForm enumMarkerPnt;
                            m_KPItems[a_idx].LineColor = m_pfrm.legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
                                a_pitems.ItemName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis, out enumMarkerPnt);
                            m_KPItems[a_idx].LineColor = m_pfrm.legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
                                a_pitems.ItemName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis, out enumMarkerPnt);
                            m_KPItems[a_idx].LineColor = m_pfrm.legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
                                a_pitems.ItemName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis, out enumMarkerPnt);
//                            m_KPItems[a_idx].LineColor = m_pfrm.legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
//                                a_pitems.ItemName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis);
//                            m_KPItems[a_idx].LineColor = m_pfrm.legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
//                                a_pitems.ItemName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis);
//                            m_KPItems[a_idx].LineColor = m_pfrm.legendList1.GetLegend(Properties.LongitudinalSectionGraphResources.RESULT_CALC,  //水位
//                                a_pitems.ItemName, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint, out a_iAxis);
//Nishi
                            m_KPItems[a_idx].LineStyle = m_pfrm.legendList1.GetDashStyle(sLineStyle);
                            m_KPItems[a_idx].LineSize = fLineSize;
                            m_KPItems[a_idx].MarkSize = fMarkSize;
                            if (bDrawLine) m_KPItems[a_idx].PlotKind = enumPlotKind.Line;
//Nishi
//                            if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumPlotForm.FillCircle;
                            if (bDrawPoint) m_KPItems[a_idx].PlotForm = enumMarkerPnt;
//Nishi
                            m_KPItems[a_idx].AxisKind = a_iAxis;  //[2013.01.24]
                            if (a_iAxis == 2)
                                m_IsKPYS = true;

                            for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                            {
                                McLspViewKPItem a_item = new McLspViewKPItem();
                                a_item.sTimeOrDay = m_TargetStartKP.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                                /*
                                if (rdoByMinute.Checked == true)
                                {   //分単位
                                    a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                                }
                                else if (rdoByHour.Checked == true)
                                {   //時間単位
                                    a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                                }
                                */
                                a_item.TimeOrDay = a_iCnt;
                                a_item.DataVal = (decimal)McLspViewDefine.g_InvalidValue2; //[2010.06.02]
                                m_KPItems[a_idx].Add(a_item);	// Listに追加
                            }

                            _readKPTimeCSVFile(
                                a_idx,  //[2010.05.07]
                                ref m_KPItems[a_idx],
                                a_pitems.ItemName,  //m_Folder_KP + "\\" + a_sVal[2013.01.04]
                                a_pitem.CalcIndex   //[2013.01.24]
                                );
                            a_idx++;
                        }
                    }
                }

                //[2012.02.04]
                //Y軸最大値
                if (McLspViewDefine.g_Time_KP_MaxYP == McLspViewDefine.g_InvalidValue)
                {
                    if (m_KPMaxYP == McLspViewDefine.g_InvalidValue)
                    {
                        m_KPMaxYP = 5.0F;
                    }
                }
                else
                {
                    m_KPMaxYP = McLspViewDefine.g_Time_KP_MaxYP;
                }
                //Y軸最小値
                if (McLspViewDefine.g_Time_KP_MinYP == McLspViewDefine.g_InvalidValue)
                {
                    if (m_KPMinYP == McLspViewDefine.g_InvalidValue)
                    {
                        m_KPMinYP = -5.0F;
                    }
                }
                else
                {
                    m_KPMinYP = McLspViewDefine.g_Time_KP_MinYP;
                }

                //[2013.01.24]---↓
                if (McLspViewDefine.g_Time_KP_MaxYP == McLspViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_KPMaxYP = _adjustMaxVal(m_KPMaxYP);
                }
                else
                {   //最大値の指定がある場合
                }

                if (McLspViewDefine.g_Time_KP_MinYP == McLspViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_KPMinYP = _adjustMinVal(m_KPMinYP);
                }
                else
                {   //最小値の指定がある場合
                }
                m_KPSepYP = (m_KPMaxYP - m_KPMinYP) / McLspViewDefine.g_KP_SepNumY;

                /*
                //double a_dLen = Math.Floor(m_KPMaxY - m_KPMinY);
                double a_dLen = Math.Ceiling(m_KPMaxY - m_KPMinY);
                int a_iLen = 0;
                if (a_dLen > 10)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 10);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                m_KPSepY = a_iLen;

                if (m_KPItems.Length > 0)
                {
                    if (m_KPMinY + (a_dLen / a_iLen) * a_iLen >= m_KPMaxY)
                    {
                        m_KPMaxY += m_KPSepY;
                        m_KPMinY -= m_KPSepY;
                    }
                }
                */
                //[2013.01.24]---↑

                //m_KPMaxY += (m_KPSepY - (Math.Abs(m_KPMaxY) % m_KPSepY));
                //m_KPMinY -= (m_KPSepY - (Math.Abs(m_KPMinY) % m_KPSepY));

                /*
                if ((Math.Abs(m_KPMaxY) % m_KPSepY) != 0)
                {
                    m_KPMaxY += m_KPSepY;
                }

                if ((Math.Abs(m_KPMinY) % m_KPSepY) != 0)
                {
                    m_KPMinY -= m_KPSepY;
                }
                */

                //[2013.01.24]
                /*
                if (m_KPMaxY == m_KPMinY)
                {
                    m_KPMaxY += m_KPSepY;
                    m_KPMinY -= m_KPSepY;
                }
                */

                //２軸[2013.02.04]---↓
                //Y軸最大値
                if (McLspViewDefine.g_Time_KP_MaxYS == McLspViewDefine.g_InvalidValue)
                {
                }
                else
                {
                    m_KPMaxYS = McLspViewDefine.g_Time_KP_MaxYS;
                }
                //Y軸最小値
                if (McLspViewDefine.g_Time_KP_MinYS == McLspViewDefine.g_InvalidValue)
                {
                }
                else
                {
                    m_KPMinYS = McLspViewDefine.g_Time_KP_MinYS;
                }
                if (McLspViewDefine.g_Time_KP_MaxYS == McLspViewDefine.g_InvalidValue)
                {   //最大値の指定がない場合
                    m_KPMaxYS = _adjustMaxVal(m_KPMaxYS);
                }
                else
                {   //最大値の指定がある場合
                }
                if (McLspViewDefine.g_Time_KP_MinYS == McLspViewDefine.g_InvalidValue)
                {   //最小値の指定がない場合
                    m_KPMinYS = _adjustMinVal(m_KPMinYS);
                }
                else
                {   //最小値の指定がある場合
                }

                if (m_IsKPYS == false)
                {
                    m_KPMinYS = McLspViewDefine.g_InvalidValue2;
                    m_KPMaxYS = McLspViewDefine.g_InvalidValue2;
                }
                //[2013.01.24]---↑

                McLspViewKP a_gw = new McLspViewKP();

                //a_gw.m_sep_bottom = 0;
                a_gw.m_sep_left = 50;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2013.01.15]
                a_gw.m_sep_top = 20;
                //a_gw.m_sep_bottom = 20; //[2013.01.15]

                a_gw.ImageWidth = this.picKP.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picKP.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = McLspViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_KPMaxYP;	// グラフY軸の最大値
                a_gw.GraphMinY = m_KPMinYP;	// グラフY軸の最小値
                a_gw.GraphSepY = m_KPSepYP;	// グラフY軸のセパレート値
                a_gw.SepNumY = McLspViewDefine.g_KP_SepNumY;   //[2013.01.24] 
                //a_gw.GraphMeasureYFormat = "###,###,##0.###";  //[2013.01.24]
                a_gw.GraphMeasureYFormat = "###,###,##0.0";  //[2015.02.22] 小数点１桁表示対応
                a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;       //[2010.03.07]

                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = false;	// Y軸の反転
                a_gw.StartTime = m_TargetStartKP; //[2010.03.07]

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                //a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式[2013.01.24]
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                //[2013.02.05]フォントサイズ---↓
                if (McLspViewDefine.g_Time_FontSize != McLspViewDefine.g_InvalidValue)
                {
                    a_gw.m_font1 = new Font(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_NAME,
                                    McLspViewDefine.g_Time_FontSize);
                }
                else
                {
                    a_gw.m_font1 = new Font(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_NAME,
                                    float.Parse(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_SIZE));
                }
                //[2013.02.05]フォントサイズ---↑

                a_gw.InitGraph(m_TargetStartKP, m_TargetEndKP, 0, ref m_KPMinYS, ref m_KPMaxYS);	//[2013.01.24] グラフの初期化
                a_gw.DrawGraphBackGround();	// グラフの初期化

                //KPの描画
                if (m_KPItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_KPItems.Length; a_iCnt++)
                    {
                        a_gw.SetKPItems(false,m_KPItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                this.picKP.Image = a_gw.m_bm;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 再描画
        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_redraw();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Redraw()
        {
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                TimeSpan a_ts = m_TargetEndKP - m_TargetStartKP;

                m_X_Num = (Convert.ToInt32(a_ts.TotalMinutes));

                /*
                if (rdoByMinute.Checked == true)
                {   //分単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalMinutes));
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalHours));
                }
                */ 

                _drawKP();
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion

        #region 後処理
        private void _terminate()
        {
            foreach (McLspViewKPItems a_pitems in m_pfrm.m_KPItems)
            {
                foreach (McLspViewKPItem a_pitem in a_pitems)
                {
                    if (a_pitem.Selected == true)
                    {   //選択状態
                        a_pitem.Selected = false;
                    }
                }
            }
            m_pfrm.m_TimeFrm = null;
        }
        #endregion
        #endregion

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLspViewTimeGraph csHySEvSetForm = new McLspViewTimeGraph() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLspViewTimeGraph(McLspViewDotNetForm h_pfrm)
        {
            InitializeComponent();

            m_pfrm = h_pfrm;

            /*
            Console.WriteLine(m_pfrm.m_TargetLspFileName);
            Console.WriteLine(m_pfrm.m_TargetItemFileName);
            Console.WriteLine(m_pfrm.m_TargetDistance);
             */ 
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Dispose();
            _terminate();
        }

        private void McLspViewTimeGraph_Load(object sender, EventArgs e)
        {
            //this.lblTargetKP.Text = McLspViewDefine.g_TargetSectionID;
            //this.lblTargetItem.Text = McLspViewDefine.g_TargetItemFileName;

            this.labelAxisKPP.Text = McLspViewDefine.g_TargetLabelKPP;
            this.labelAxisKPS.Text = McLspViewDefine.g_TargetLabelKPS;

            /*[2013.01.24]
            m_TargetLspFileName = McLspViewDefine.g_TargetLspFileName;
            m_TargetItemFileName = McLspViewDefine.g_TargetItemFileName;
            m_TargetDistance = McLspViewDefine.g_TargetDistance;
            m_TargetCalcIndex = McLspViewDefine.g_TargetCalcIndex;
            */ 

            m_TargetStartKP = McLspViewDefine.g_TargetStartKP;
            m_TargetEndKP = McLspViewDefine.g_TargetEndKP;

            //m_KPRateY = m_pfrm.m_KPRateY;

            Redraw();   //[2013.01.24]
        }

        private void McLspViewTimeGraph_FormClosed(object sender, FormClosedEventArgs e)
        {
            //m_pfrm.m_TimeFrm = null;
        }

        private void McLspViewTimeGraph_FormClosing(object sender, FormClosingEventArgs e)
        {
            _terminate();
        }

        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            McTimeGraphSetForm a_frm = null;

            try
            {
                a_frm = new McTimeGraphSetForm();
                a_frm.AxisLabelKPP = labelAxisKPP.Text;
                //a_frm.AxisRateKPLeft = m_KPRateYP;

                a_frm.AxisLabelKPS = labelAxisKPS.Text;

                if (a_frm.ShowDialog(this) == DialogResult.OK)
                {
                    labelAxisKPP.Text = a_frm.AxisLabelKPP;
                    //m_KPRateYP = a_frm.AxisRateKPLeft;

                    labelAxisKPS.Text = a_frm.AxisLabelKPS;
                }
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
                MessageBox.Show(exp.Message,
                    Properties.LongitudinalSectionGraphResources.CAPTION_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (a_frm != null)
                    a_frm.Dispose();
                a_frm = null;
            }
        }

        private void btnRedraw_Click(object sender, EventArgs e)
        {
            Redraw();
        }
    }
}
