﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace jp.go.nilim.Longitudinal_profile_H26
{
    public partial class McTimeGraphSetForm : Form
    {
        /// <summary>
        /// プロパティ：主軸ラベル
        /// </summary>
        public string AxisLabelKPP
        {
            get
            {
                return txtAxisLabelP.Text;
            }
            set
            {
                txtAxisLabelP.Text = value;
            }
        }
        /// <summary>
        /// プロパティ：ハイドロ(下)左軸 表示目盛
        /// </summary>
        public float AxisRateKPLeft
        {
            get
            {
                float fVal = 0;
                float.TryParse(txtAxisRateKP.Text, out fVal);
                return fVal;
            }
            set
            {
                if (value == 0)
                    txtAxisRateKP.Text = "";
                else
                    txtAxisRateKP.Text = value.ToString();
            }
        }

        /// <summary>
        /// プロパティ：２軸ラベル
        /// </summary>
        public string AxisLabelKPS
        {
            get
            {
                return txtAxisLabelS.Text;
            }
            set
            {
                txtAxisLabelS.Text = value;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTimeGraphSetForm csNewProjectForm = new McTimeGraphSetForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public McTimeGraphSetForm()
        {
            InitializeComponent();
        }

        private void McTimeGraphSetForm_Load(object sender, EventArgs e)
        {
            //主軸
            if (McLspViewDefine.g_Time_KP_MaxYP != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MaxYP.Text = McLspViewDefine.g_Time_KP_MaxYP.ToString();
            }
            if (McLspViewDefine.g_Time_KP_MinYP != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MinYP.Text = McLspViewDefine.g_Time_KP_MinYP.ToString();
            }

            //２軸
            if (McLspViewDefine.g_Time_KP_MaxYS != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MaxYS.Text = McLspViewDefine.g_Time_KP_MaxYS.ToString();
            }
            if (McLspViewDefine.g_Time_KP_MinYS != McLspViewDefine.g_InvalidValue)
            {
                txtKP_MinYS.Text = McLspViewDefine.g_Time_KP_MinYS.ToString();
            }

            //文字サイズ[2013.02.05]
            if (McLspViewDefine.g_Time_FontSize != McLspViewDefine.g_InvalidValue)
            {
                txtFontSize.Text = McLspViewDefine.g_Time_FontSize.ToString();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = InputCheckNum(txt, sCaption) </para>
        /// </example>
        /// <param name="txt">TextBox</param>
        /// <param name="sCaption">項目名</param>
        /// <returns>true=正常/false=入力エラーあり</returns>
        private bool InputCheckNum(TextBox txt, string sCaption)
        {
            if (!string.IsNullOrEmpty(txt.Text) && txt.Text.Trim().Length != 0)
            {   //入力あり
                float fVal = 0;
                if (!float.TryParse(txt.Text.Trim(), out fVal))
                {
                    //{0}には数値を入力して下さい。
                    MessageBox.Show(string.Format(Properties.LongitudinalSectionGraphResources.MSG_ERROR_INPUT_NUMERICAL_VALUE, sCaption),
                        Properties.LongitudinalSectionGraphResources.CAPTION_INPUT_ERROR, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    txt.Focus();
                    return false;
                }
            }
            return true;
        }

        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            try
            {
                //------------------------------------------------------------
                // 入力チェック
                //------------------------------------------------------------
                //主軸 表示目盛
                if (!InputCheckNum(txtAxisRateKP, lblAxisRateLevel.Text))
                    return;
                //主軸 最大値
                if (!InputCheckNum(txtKP_MaxYP, lblWaterLevel_MaxYP.Text))
                    return;
                //主軸 最小値
                if (!InputCheckNum(txtKP_MinYP, lblWaterLevel_MinYP.Text))
                    return;

                //２軸 表示目盛
                //if (!InputCheckNum(txtAxisRateKP, lblAxisRateLevel.Text))
                //    return;
                //２軸 最大値
                if (!InputCheckNum(txtKP_MaxYS, lblWaterLevel_MaxYS.Text))
                    return;
                //２軸 最小値
                if (!InputCheckNum(txtKP_MinYS, lblWaterLevel_MinYS.Text))
                    return;

                //フォントサイズ[2013.02.05]
                if (!InputCheckNum(txtFontSize, lblFontSize.Text))
                    return;

                //------------------------------------------------------------
                //主軸
                if (txtKP_MaxYP.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_Time_KP_MaxYP = Convert.ToSingle(txtKP_MaxYP.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_Time_KP_MaxYP = McLspViewDefine.g_InvalidValue;
                }
                if (txtKP_MinYP.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_Time_KP_MinYP = Convert.ToSingle(txtKP_MinYP.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_Time_KP_MinYP = McLspViewDefine.g_InvalidValue;
                }

                //２軸
                if (txtKP_MaxYS.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_Time_KP_MaxYS = Convert.ToSingle(txtKP_MaxYS.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_Time_KP_MaxYS = McLspViewDefine.g_InvalidValue;
                }
                if (txtKP_MinYS.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_Time_KP_MinYS = Convert.ToSingle(txtKP_MinYS.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_Time_KP_MinYS = McLspViewDefine.g_InvalidValue;
                }

                //フォントサイズ[2013.02.05]
                if (txtFontSize.Text.Trim().Length > 0)
                {
                    McLspViewDefine.g_Time_FontSize = Convert.ToSingle(txtFontSize.Text.Trim());
                }
                else
                {
                    McLspViewDefine.g_Time_FontSize = McLspViewDefine.g_InvalidValue;
                }

                this.DialogResult = DialogResult.OK;
                this.Close();
                //this.Dispose();
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
            }
        }
    }
}
