// <summary>ソースコード：スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/01][新規作成]</para>
    /// </remarks>
    public class McLspViewDotNetScreen : HySDotNetAddInBaseScreen //[2013.01.18]パッケージ化
    {
        /// <summary>フォーム</summary>
        protected McLspViewDotNetForm m_csGraphViewForm=null;
        /// <summary>ビューアジョブ</summary>
        protected McLspViewViewerJob m_csJob = null;

        // 定数定義
        ///// <summary>画面デフォルト幅</summary>
        //static private readonly int DEFAULT_WIDTH = 700;
        ///// <summary>画面デフォルト高さ</summary>
        //static private readonly int DEFAULT_HEIGHT = 450;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetProjectCtlScreen csScreen = new McDotNetProjectCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLspViewDotNetScreen()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csGraphViewForm = new McLspViewDotNetForm(this);
            //m_csGraphViewForm.Text = "画面";
            //m_csGraphViewForm.Width = DEFAULT_WIDTH;
            //m_csGraphViewForm.Height = DEFAULT_HEIGHT;
            //m_csGraphViewForm.StartPosition = FormStartPosition.Manual;
            m_csGraphViewForm.SetDesktopLocation(10, 0);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            m_csGraphViewForm = null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McLspViewDefine.MCLSPVIEW_BUSINESS_KIND.GetString()));
            m_csGraphViewForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            m_csJob = csViewer.GetViewerJob(McLspViewDefine.MCLSPVIEW_BUSINESS_KIND.GetString()) as McLspViewViewerJob;
            
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csGraphViewForm.Show();
        }    
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            //m_csGraphViewForm.Close();    //⇒★これを実行するとフォームの「×」の処理が上手く行かなくなる。[2010.01.29]
            m_csJob.DeleteScreen(this);
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csGraphViewForm.Hide();
        }       
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            //m_csGraphViewForm.Width = DEFAULT_WIDTH;
            //m_csGraphViewForm.Height = DEFAULT_HEIGHT;
            m_csGraphViewForm.WindowState = FormWindowState.Normal;
            m_csGraphViewForm.StartPosition = FormStartPosition.Manual;
            m_csGraphViewForm.SetDesktopLocation(10, 0);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csGraphViewForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csGraphViewForm.Activate();
        }
            
        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            /* Do Nothing
            HySEventObject csEvObj = csEvent as HySEventObject;
            if (csEvObj != null)
            {
                long lEvNo = csEvObj.GetEventNo();
                long lSubEvNo = csEvObj.GetSubEventNo();
            }
            */
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            /* Do Nothing
            ((HySEventObject)csEvent).SetToSimKind(HysAddinScreenDefineGraphView.BUSINESS_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
            */
            return true;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            // Do Nothing
        }

    }
}
