﻿// <summary>ソースコード：アドインスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// [2013.01.18]パッケージ化↓
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
namespace CommonMP.HYSSOP._SYSTEM_
{
    public class HYSSOP_USRSCREEN_FACTORY_CREATOR_IMPLE : HYSSOP_USRSCREEN_FACTORY_CREATOR
    {
        public CommonMP.HYSSOP.Interface.HSViewer.HySScreenFactory CreateFactory()
        {
            // ToDo 自作の画面ファクトリ（ネームスペース付き）を new して下さい。
            return new jp.go.nilim.Longitudinal_profile_H26.McLspViewScreenFactory();
        }
    }
}
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// [2013.01.18]パッケージ化↑
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>アドインスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McLspViewScreenFactory : HySDotNetAddInBaseScreenFactory     //[2013.01.18]パッケージ化 
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetScreenFactory csFactory = new McDotNetScreenFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLspViewScreenFactory()
        {
            SetFactoryID(McLspViewDefine.MCLSPVIEW_FACTORY_ID_SCREEN);
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void SetSimKind(HySKind csSimKindID)    //[2013.01.18]パッケージ化
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySKind GetSimKind()    //[2013.01.18]パッケージ化
        {
            return McLspViewDefine.MCLSPVIEW_BUSINESS_KIND;
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean EqualSimKind(HySKind csSimKindID)   //[2013.01.18]パッケージ化
        {
            return McLspViewDefine.MCLSPVIEW_BUSINESS_KIND.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子：予備（使用せず）</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)   //[2013.01.18]パッケージ化
        {
            HySScreen csScreen = null;
            if (csSimulatorKind.Equals(McLspViewDefine.MCLSPVIEW_BUSINESS_KIND) == true)
            {
                if (McLspViewDefine.MCLSPVIEW_SCREEN.Equals(csScreenKind) == true)
                {
                    csScreen = new McLspViewDotNetScreen();
                }
                else
                {
                }
            }
            return csScreen;
        }
    }
}
