﻿//using System;
//using System.Collections.Generic;
//using System.Text;
using System;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>KPデータグラフ表示</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public class McLspViewKP : McLspViewImageLib
    {
		/**********************************************************************
		 * 定数の定義
		**********************************************************************/
        /// <summary> 描画色：ペン </summary>
		private Pen m_pen_KP = new Pen(Color.Indigo,1.5F);
        /// <summary> KP描画色：塗りつぶし </summary>
        private SolidBrush m_brush_KP = new SolidBrush(Color.Indigo);

		/**********************************************************************
		 * 変数の定義
		**********************************************************************/
        /// <summary> 断面ID </summary>
        private string m_SectionID;		// 断面ID

        /// <summary> Y軸セパレート値(２軸) </summary>
        private float m_KP_sep_ys_val = 0;
        /// <summary> Y軸セパレート値(２軸) </summary>
        private float m_KPSepYS = 0;
        /// <summary> Y軸最小値(２軸) </summary>
        private float m_KPMinYS = 0;
        /// <summary> X軸：一つ前の値(２軸) </summary>
        private float m_KPPrevXS = McLspViewDefine.g_InvalidValue2; //[2010.06.02]
        /// <summary> Y軸：一つ前の値(２軸) </summary>
        private float m_KPPrevYS = McLspViewDefine.g_InvalidValue2; //[2010.06.02]
        
        /**********************************************************************
         * プロパティの定義
        **********************************************************************/
        /// <summary>
        /// 断面
        /// </summary>
		public string SectionID	// 断面
		{
			set
			{
				m_SectionID = value;
			}
			get
			{
				return m_SectionID;
			}
		}
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public McLspViewKP()
		{
			
		}

        //*********************************************************************
        // @(f)
        // 機能      : グラフの初期化
        //
        // 引数      : なし
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitGraph(h_stTime, h_edTime, h_mode, ref h_FlowMeterMinY, ref h_FlowMeterMaxY)</para>
        /// </example>
        /// <param name="h_stTime">開始時刻</param>
        /// <param name="h_edTime">終了時刻</param>
        /// <param name="h_mode">0：分単位、1：時間単位</param>
        /// <param name="h_KPMinYS">KP最小値</param>
        /// <param name="h_KPMaxYS">KP最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void InitGraph(
            DateTime h_stTime,
            DateTime h_edTime,
            int h_mode,  //0：分単位、1：時間単位
            ref float h_KPMinYS,
            ref float h_KPMaxYS
            )
        {
            //Y軸の調整
            float a_fTmpY = (ImageHeight - (m_sep_top + m_sep_bottom)) / (GraphMaxY - GraphMinY);
            if ((a_fTmpY * GraphSepY) < (m_font1.Size * 2))
            {
                GraphSepY = Convert.ToInt32((m_font1.Size * 2) / a_fTmpY);
            }
            else
            {
            }

            InitializeGraph();
            _drawGraphBackGround();

            //[2013.01.24]---↓
            if (h_KPMinYS != McLspViewDefine.g_InvalidValue2)
            {
                //[2013.01.24]---↓
                m_KPSepYS = (h_KPMaxYS - h_KPMinYS) / m_num_y_graph;   //切り上げ
                //m_KPSepYS = Convert.ToInt32(Math.Ceiling((h_KPMaxYS - h_KPMinYS) / m_num_y_graph));   //切り上げ
                //h_KPMaxYS = h_KPMinYS + (m_KPSepYS * m_num_y_graph);
                //[2013.01.24]---↑

                m_KP_sep_ys_val = (ImageHeight - (m_sep_top + m_sep_bottom)) / (h_KPMaxYS - h_KPMinYS);
                m_KPMinYS = h_KPMinYS;
                //流量のY軸目盛表示
                for (int a_iCnt = 0; a_iCnt <= m_num_y_graph; a_iCnt++)
                {
                    DrawYMeasureString2(
                        //(a_iCnt * m_KPSepYS + h_KPMinYS).ToString("###,###,##0.###"), //[2013.01.24]
                        (a_iCnt * m_KPSepYS + h_KPMinYS).ToString("###,###,##0.0"), //[2015.02.22] 小数点１桁表示対応
                        ImageWidth - m_sep_right + 5,   //Y軸目盛不具合対応 2011.03.04 文字が欠けているので+2->+5に変更
                        ImageHeight - m_sep_bottom - ((a_iCnt * m_KPSepYS) * m_KP_sep_ys_val) - m_font1.Size / 2
                        );
                }
            }
            //[2013.01.24]---↑

            //X軸の目盛表示
            //[2010.03.07]日時範囲の計算
            DateTime a_stTime = h_stTime;
            TimeSpan a_tTmp = h_edTime - h_stTime;
            int a_Xnum = 0;
            int a_Xsep = 0;
            int a_disp = 0; //1：時間表示、2：日表示、3：月表示、4：年表示
            if (a_tTmp.Days < 7)
            {   //1週間以内
                a_disp = 1;
                if (h_edTime.Day > h_stTime.Day)
                {   //日付が異なる
                    //2日分とする。
                    a_Xnum = 24 * (a_tTmp.Days + 1);
                    switch (a_tTmp.Days)
                    {
                        case 0:
                            a_Xsep = 1;
                            break;
                        case 1:
                            a_Xsep = 2;
                            break;
                        case 2:
                            a_Xsep = 2;
                            break;
                        case 3:
                            a_Xsep = 4;
                            break;
                        case 4:
                            a_Xsep = 4;
                            break;
                        case 5:
                            a_Xsep = 4;
                            break;
                        case 6:
                            a_Xsep = 6;
                            break;
                        //case 7:
                        //    a_Xsep = 6;
                        //    break;
                    }
                }
                else
                {   //日付が同じ
                    //該当日分とする。
                    a_Xnum = 24;
                    a_Xsep = 1;
                }
            }
            else if (a_tTmp.Days < 31)
            {   //1週間～１ヶ月以内
                a_Xnum = 24 * (a_tTmp.Days + 1);
                if (a_tTmp.Days == 7)
                {
                    a_disp = 1;
                    a_Xsep = 8;
                }
                else if ((a_tTmp.Days >= 8) && (a_tTmp.Days <= 15))
                {
                    a_disp = 1;
                    a_Xsep = 12;
                }
                else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 30))
                {
                    a_disp = 2;
                    a_Xsep = 24;
                }
            }
            else if (a_tTmp.Days < 366)
            {   //1ヶ月から1年以内
                a_Xnum = 24 * (a_tTmp.Days + 1);
                if (a_tTmp.Days == 31)
                {
                    a_disp = 2;
                    a_Xsep = 24;
                }
                else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 365))
                {
                    a_disp = 3;
                    a_Xsep = 24 * 30;
                }
            }
            else
            {   //1年越え
                a_disp = 4;
                a_Xnum = 24 * (a_tTmp.Days + 1);
                a_Xsep = 24 * 366;
            }

            if (h_mode == 0)
            {   //分単位
                a_Xnum *= 60;
                a_Xsep *= 60;
            }

            Pen m_pen2 = new Pen(Color.LightGray, 0.5f);
            m_pen2.DashStyle = System.Drawing.Drawing2D.DashStyle.Dash;

            string a_day = "";  // h_stTime.ToString("yyyy/MM/dd");
            for (int a_iCnt = 1; a_iCnt <= GraphMaxX + 1; a_iCnt += Convert.ToInt32(GraphSepX))
            {
                string a_sVal = "";
                string a_sValXM = "";
                string a_sValXM2 = "";
                string a_sValXM3 = "";
                string a_sValXM4 = "";
                string a_sValXyear = "";
                string a_sValXmonth = "";
                string a_sValXday = "";

                if (((a_iCnt - 1) % a_Xsep) == 0)
                {
                    if (h_mode == 0)
                    {   //分単位
                        a_stTime = h_stTime.AddMinutes((a_iCnt - 1));
                    }
                    else
                    {   //時間単位
                        a_stTime = h_stTime.AddHours((a_iCnt - 1));
                    }

                    switch (a_disp)
                    {
                        case 1:     //時間表示
                            a_sValXM = string.Format("({0})", Properties.LongitudinalSectionGraphResources.HOUR);   //(時)
                            a_sValXM2 = Properties.LongitudinalSectionGraphResources.DAY;   //日
                            a_sValXM3 = Properties.LongitudinalSectionGraphResources.MONTH;   //月
                            a_sValXM4 = Properties.LongitudinalSectionGraphResources.YEAR;   //年
                            a_sVal = a_stTime.ToString("HH");
                            a_sValXday = a_stTime.ToString("dd");
                            a_sValXmonth = a_stTime.ToString("MM");
                            a_sValXyear = a_stTime.ToString("yyyy");
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(8, 2).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                                if (a_day.Substring(5, 2).Equals(a_sValXmonth) == true)
                                {
                                    a_sValXmonth = "";
                                }
                                if (a_day.Substring(0, 4).Equals(a_sValXyear) == true)
                                {
                                    a_sValXyear = "";
                                }
                            }
                            break;
                        case 2:     //日表示
                            a_sValXM = string.Format("({0})", Properties.LongitudinalSectionGraphResources.DAY); ;  //(日)
                            a_sValXM2 = Properties.LongitudinalSectionGraphResources.MONTH;   //月
                            a_sValXM3 = Properties.LongitudinalSectionGraphResources.YEAR;   //年
                            a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("dd");
                            a_sValXday = a_stTime.ToString("MM");
                            a_sValXmonth = a_stTime.ToString("yyyy");
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(5, 2).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                                if (a_day.Substring(0, 4).Equals(a_sValXmonth) == true)
                                {
                                    a_sValXmonth = "";
                                }
                            }
                            break;
                        case 3:     //月表示
                            a_sValXM = string.Format("({0})", Properties.LongitudinalSectionGraphResources.MONTH);  //(月)
                            a_sValXM2 = Properties.LongitudinalSectionGraphResources.YEAR;
                            a_sValXM3 = "";
                            a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("MM");
                            a_sValXday = a_stTime.ToString("yyyy");
                            a_sValXmonth = "";
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(0, 4).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                            }
                            break;
                        case 4:     //年表示
                            a_sValXM = string.Format("({0})", Properties.LongitudinalSectionGraphResources.YEAR);  //(年)
                            a_sValXM2 = "";
                            a_sValXM3 = "";
                            a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("yyyy");
                            a_sValXday = "";
                            a_sValXmonth = "";
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                            }
                            break;
                    }
                }

                //タイトル
                m_g.DrawString(
                    a_sValXM,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 2.5) - 5,
                        ImageHeight - m_sep_bottom + m_font1.Size / 2)
                    );
                m_g.DrawString(
                    a_sValXM2,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0) - 5,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 1.8))
                    );
                m_g.DrawString(
                    a_sValXM3,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0) - 5,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 3))
                    );
                m_g.DrawString(
                    a_sValXM4,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0) - 5,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 4.3))
                    );

                //X値
                m_g.DrawString(
                    a_sVal,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + m_font1.Size / 2)
                    );

                //if (a_day.Equals(a_stTime.ToString("yyyy/MM/dd")) == false)
                //{
                m_g.DrawString(
                    a_sValXday,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 1.8))
                    );
                m_g.DrawString(
                    a_sValXmonth,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  // + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 3))
                    );
                m_g.DrawString(
                    a_sValXyear,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  // + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 4.3))
                    );
                a_day = a_stTime.ToString("yyyy/MM/dd");
                //}

                if (a_sVal.Length > 0)
                {   //表示あり
                    if ((a_iCnt > 1) && (a_iCnt <= GraphMaxX))
                    {
                        m_g.DrawLine(
                            m_pen2,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_Height - m_sep_bottom,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_sep_top
                            );
                    }
                }
            }
            /*
            m_g.DrawString(
                "(KP)",
                m_font1,
                Brushes.Black,
                new PointF(
                    ImageWidth - m_sep_right + m_font1.Size / 2,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                    ImageHeight - m_sep_bottom - m_font1.Size / 2)
                );
            */
        }
        
        //*********************************************************************
		// @(f)
		// 機能      : グラフの初期化
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitGraph(h_stTime, h_edTime, h_mode, ref h_FlowMeterMinY, ref h_FlowMeterMaxY)</para>
        /// </example>
        /// <param name="h_stKP">開始KP</param>
        /// <param name="h_edKP">終了KP</param>
        /// <param name="h_KP">KPリスト</param>
        /// <param name="h_KPMinYS">KP最小値</param>
        /// <param name="h_KPMaxYS">KP最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void InitGraph(
            float h_stKP,
            float h_edKP,
            McLspViewKPItems h_KP,
            ref float h_KPMinYS,
            ref float h_KPMaxYS
            )
		{
            //Y軸の調整
            float a_fTmpY = (ImageHeight - (m_sep_top + m_sep_bottom)) / (GraphMaxY - GraphMinY);
            if ((a_fTmpY * GraphSepY) < (m_font1.Size * 2))
            {
                GraphSepY = Convert.ToInt32((m_font1.Size * 2) / a_fTmpY);
            }
            else
            {
            }

			InitializeGraph();
			_drawGraphBackGround();

            //[2013.01.24]---↓
            if (h_KPMinYS != McLspViewDefine.g_InvalidValue2)
            {
                //[2013.01.24]---↓
                m_KPSepYS = (h_KPMaxYS - h_KPMinYS) / m_num_y_graph;   //切り上げ
                //m_KPSepYS = Convert.ToInt32(Math.Ceiling((h_KPMaxYS - h_KPMinYS) / m_num_y_graph));   //切り上げ
                //h_KPMaxYS = h_KPMinYS + (m_KPSepYS * m_num_y_graph);
                //[2013.01.24]---↑

                m_KP_sep_ys_val = (ImageHeight - (m_sep_top + m_sep_bottom)) / (h_KPMaxYS - h_KPMinYS);
                m_KPMinYS = h_KPMinYS;
                //流量のY軸目盛表示
                for (int a_iCnt = 0; a_iCnt <= m_num_y_graph; a_iCnt++)
                {
                    DrawYMeasureString2(
                        //(a_iCnt * m_KPSepYS + h_KPMinYS).ToString("###,###,##0.###"), //[2013.01.24]
                        (a_iCnt * m_KPSepYS + h_KPMinYS).ToString("###,###,##0.0"), //[2015.02.22] 小数点１桁表示対応
                        ImageWidth - m_sep_right + 5,   //Y軸目盛不具合対応 2011.03.04 文字が欠けているので+2->+5に変更
                        ImageHeight - m_sep_bottom - ((a_iCnt * m_KPSepYS) * m_KP_sep_ys_val) - m_font1.Size / 2
                        );
                }
            }
            //[2013.01.24]---↑

            if (h_KP == null)
            {
                return;
            }

            //X軸の目盛表示
            /*
            float a_stKP = h_stKP;
            float a_tKP = h_edKP - h_stKP;
            //int a_Xnum = 0;
            int a_Xsep = 2;
             */
            
            //float a_tKP = h_edKP - h_stKP;
            int a_xSep = 2;
            float a_fwVal = ImageWidth - m_sep_left - m_sep_right;
            int a_iwVal = (int)(a_fwVal / h_KP.XNum);
            if (a_iwVal < 5)
            {
                a_xSep = 8;
            }
            else //else if (a_iwVal < 10)
            {
                a_xSep = 4;
            }

            //[2013.02.06]bug-fixed.---↓
            if (McLspViewDefine.g_XAxisPitch != McLspViewDefine.g_InvalidValue)
            {
                a_xSep = (int)McLspViewDefine.g_XAxisPitch;
            }
            //[2013.02.06]bug-fixed.---↑
            int a_xCount = 0;
            bool a_bIsOK = false;   

            Pen m_pen2 = new Pen(Color.LightGray, 0.5f);
            m_pen2.DashStyle = System.Drawing.Drawing2D.DashStyle.Dash;
            Font a_font1 = new Font(Properties.LongitudinalSectionGraphResources.DEFAULT_FONT_NAME,
                float.Parse("8"));

            //int a_iXPitch = 0;  //[2013.02.05]

            for (int a_iCnt = 1; a_iCnt <= GraphMaxX + 1; a_iCnt+=Convert.ToInt32(GraphSepX))
            {
                string a_sVal = "";
                a_bIsOK = false;

                /*
                a_stKP = h_stKP + ((a_iCnt - 1) * a_Xsep);

                if (((a_iCnt - 1) % a_Xsep) == 0)
                {
                    a_sVal = a_stKP.ToString();
                }
                 */

                a_sVal = h_KP[a_iCnt - 1].sSectionID;   //[2013.01.22]
                //a_sVal = h_KP[a_iCnt - 1].sSectionID.Replace("k", "");    //[2013.01.22]

                if (a_sVal.Length > 0)
                {   //表示あり
                    a_xCount++;

                    if (a_xCount == 1)
                    {
                        a_bIsOK = true;
                        //a_iXPitch = 1;  //[2013.02.05]
                    }
                    else
                    {
                        if ((a_xCount % a_xSep) == 0)
                        {
                            a_bIsOK = true;

                            //[2013.02.05]---↓
                            /*
                            if (McLspViewDefine.g_XAxisPitch != McLspViewDefine.g_InvalidValue)
                            {
                                if (a_iXPitch < McLspViewDefine.g_XAxisPitch)
                                {
                                    a_iXPitch++;
                                    a_bIsOK = false;
                                }else{
                                    a_iXPitch = 1;
                                }
                            }
                            */
                            //[2013.02.05]---↑
                        }
                    }
                }

                //X値
                if (a_bIsOK == true)
                {
                    if (a_sVal.IndexOf("-") >= 0)
                    {
                        m_g.DrawString(
                            a_sVal,
                            m_font1,
                            Brushes.Black,
                            new PointF(
                                m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2 - 10,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                                ImageHeight - m_sep_bottom + m_font1.Size / 2)
                            );
                    }
                    else
                    {
                        m_g.DrawString(
                            a_sVal,
                            m_font1,
                            Brushes.Black,
                            new PointF(
                                m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                                ImageHeight - m_sep_bottom + m_font1.Size / 2)
                            );
                    }

                    if ((a_iCnt > 1) && (a_iCnt <= GraphMaxX))
                    {
                        m_g.DrawLine(
                            m_pen2,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_Height - m_sep_bottom,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_Height - (m_sep_bottom + (m_num_y_graph * (m_sep_y_graph * GraphSepY)))    //m_sep_top
                            );
                        /*
                        m_g.DrawLine(
                            m_pen2,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_Height - m_sep_bottom,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_sep_top
                            );
                         */ 
                    }
                }
            }

            /*[2013.01.22]表示は不要
            m_g.DrawString(
            "(KP)",
            m_font1,
            Brushes.Black,
            new PointF(
                ImageWidth - m_sep_right + m_font1.Size / 2,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                ImageHeight - m_sep_bottom - m_font1.Size / 2)
            );
            */
		}

		//*********************************************************************
		// @(f)
		// 機能      : KPの値設定
		//
        // 引数      : ARG1 - McLspViewKPItemsオブジェクト
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>KPの値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetKPItems(val)</para>
        /// </example>
        /// <param name="val">McLspViewKPItems: KPデータリスト</param>
        /// <param name="h_bIsNumeric">bool:数値か否か</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetKPItems(bool h_bIsNumeric, McLspViewKPItems val)
		{
            _setGraphValue(h_bIsNumeric,val);
        }

		//*********************************************************************
		// @(f)
		// 機能      : グラフの描画実行
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /*/// <summary><para>method outline:</para>
        /// <para>グラフの描画実行</para>
        /// </summary>
        public void MakeGraph()
		{
            MakeImageFile();
		}*/

		//*********************************************************************
		// @(f)
		// 機能      : グラフの背景描画
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの背景描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawGraphBackGround()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		private void _drawGraphBackGround()
		{
            //string a_strTmp = "";
			//string a_strTmp2 = "";

			//-----------------------------------------------------------------
			// 凡例の描画
			//-----------------------------------------------------------------
            /*
			DrawLegend(
				m_pen_KP,
				m_brush_KP,
				"KP",
				1,
                enumPlotKind.Line,
                enumPlotForm.FillTriangle
				);
            */
			//-----------------------------------------------------------------
			// タイトル文字の描画
			//-----------------------------------------------------------------
			// Y軸
            /*
			DrawYUnitString(
				"(m)"
				);
             */

            /*[2010.03.07]
            DrawYTitleStringVertical(
				"KP",
                ""
				);
            m_g.DrawString(
                "(m)",
                m_font1, Brushes.Black,
                new PointF(0, m_sep_top)
                );
            DrawYTitleStringVertical2(
                "流量",
                ""
                );
            m_g.DrawString(
                "(m3/s)",
                m_font1, Brushes.Black,
                new PointF(ImageWidth - Convert.ToSingle(m_font1.Size * 4.5), m_sep_top + m_font1.Size)
                );
             */

			// X軸
			// タイトル文字の描画
            /*
			if (GraphKind == enumGraphKind.IsTime)
			{
				a_strTmp = "(時)";
				a_strTmp2 = "時刻";
			}
			else if (GraphKind == enumGraphKind.IsDay)
			{
				a_strTmp = "(日)";
				a_strTmp2 = "日";
			}
             */
            /*
			DrawXUnitString(
				a_strTmp
				);
             */ 
            /*
			DrawXTitleString(
				a_strTmp2
				);
            */
		}	

		//*********************************************************************
		// @(f)
		// 機能      : グラフのKPの値描画
		//
        // 引数      : ARG1 - McLspViewKPItemsオブジェクト
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフのKPの値描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setGraphValue(val)</para>
        /// </example>
        /// <param name="val">McLspViewKPItems: KPデータリスト</param>
        /// <param name="h_bIsNumeric">bool: 数値か否か</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setGraphValue(bool h_bIsNumeric, McLspViewKPItems val)
		{
            try
            {
                float a_GX = 0; //[2013.01.16]
                float a_GY = 0; //[2013.01.16]

                //[2010.03.07]
                enumPlotKind a_pk = enumPlotKind.Nothing;
                enumPlotForm a_pf = enumPlotForm.Nothing;

                if (McLspViewDefine.g_IsLine == true)
                {
                    a_pk = enumPlotKind.Line;
                }

                if (McLspViewDefine.g_IsPoint == true)
                {
                    a_pf = enumPlotForm.FillCircle;
                    //a_pf = enumPlotForm.Triangle;                  // test
                }

                int a_iListCount = val.Count;	// リスト数を取得
                float a_prev_KP = InvalidValue;
                float a_prev_X = 0;

                m_PrevX = McLspViewDefine.g_InvalidValue2; //[2010.06.02]
                m_PrevY = McLspViewDefine.g_InvalidValue2; //[2010.06.02]


                m_brush_KP.Color = val.LineColor;   //色変更
                m_pen_KP.Color = val.LineColor;     //色変更
                m_pen_KP.DashStyle = val.LineStyle; //線種変更
                m_pen_KP.Width = val.LineSize;      //線の太さ変更
                this.m_size_Legend = val.MarkSize;          //ポイントの大きさ変更
                a_pk = val.PlotKind;                        //ライン描画
                a_pf = val.PlotForm;                        //ポイント描画      // add min

                for (int a_iCnt = 1; a_iCnt <= a_iListCount; a_iCnt++)
                {
                    //-------------------------------------------------------------
                    // KP表示
                    //-------------------------------------------------------------
                    if (h_bIsNumeric == true)
                    {
                        //[2013.01.24]
                        if (val.AxisKind ==1)
                            PlotGraphValue(
                                m_pen_KP,
                                m_brush_KP,
                                (float)val[a_iCnt - 1].Distance,
                                (float)val[a_iCnt - 1].DataVal,
                                a_prev_X,
                                ref a_prev_KP,
                                //a_iCnt,
                                a_pk,
                                a_pf,
                                ref a_GX, //[2013.01.16]
                                ref a_GY  //[2013.01.16]
                                );
                        else
                            _plotGraphValue2(
                                m_pen_KP,
                                m_brush_KP,
                                (float)val[a_iCnt - 1].Distance,
                                (float)val[a_iCnt - 1].DataVal,
                                a_prev_X,
                                ref a_prev_KP,
                                //a_iCnt,
                                a_pk,
                                a_pf,
                                ref a_GX, //[2013.01.16]
                                ref a_GY  //[2013.01.16]
                                );

                        a_prev_X = (float)val[a_iCnt - 1].Distance;
                    }
                    else
                    {
                        //[2013.01.24]
                        if (val.AxisKind == 1)
                            PlotGraphValue(
                                m_pen_KP,
                                m_brush_KP,
                                val[a_iCnt - 1].TimeOrDay,
                                (float)val[a_iCnt - 1].DataVal,
                                a_prev_X,
                                ref a_prev_KP,
                                //a_iCnt,
                                a_pk,
                                a_pf,
                                ref a_GX, //[2013.01.16]
                                ref a_GY  //[2013.01.16]
                                );
                        else
                            _plotGraphValue2(
                                m_pen_KP,
                                m_brush_KP,
                                val[a_iCnt - 1].TimeOrDay,
                                (float)val[a_iCnt - 1].DataVal,
                                a_prev_X,
                                ref a_prev_KP,
                                //a_iCnt,
                                a_pk,
                                a_pf,
                                ref a_GX, //[2013.01.16]
                                ref a_GY  //[2013.01.16]
                                );

                        a_prev_X = val[a_iCnt - 1].TimeOrDay;
                    }

                    if (val[a_iCnt - 1].DataVal != (decimal)McLspViewDefine.g_InvalidValue2)
                    {
                        val[a_iCnt - 1].GX = a_GX; //[2013.01.16]
                        val[a_iCnt - 1].GY = a_GY;  //[2013.01.16]
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }

        //*********************************************************************
        // @(f)
        // 機能      : グラフの２軸の値描画
        //
        // 引数      : ARG1 - McGraphViewFlowMeterItemsオブジェクト
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの２軸の値描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_plotGraphValue2(p, b, xv, yv, pxv, pyv, gk, pk)</para>
        /// </example>
        /// <param name="p">描画色：ペン</param>
        /// <param name="b">描画色：塗りつぶし</param>
        /// <param name="xv">X値：現在値</param>
        /// <param name="yv">Y値：現在値</param>
        /// <param name="pxv">X値：一つ前</param>
        /// <param name="pyv">Y値：一つ前</param>
        /// <param name="gk">グラフプロット種別：enumPlotKind</param>
        /// <param name="pk">グラフプロット型：enumPlotForm</param>
        /// <param name="gx">描画位置X</param>
        /// <param name="gy">描画位置Y</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _plotGraphValue2(
            Pen p,
            Brush b,
            float xv,
            float yv,
            float pxv,
            ref float pyv,
            //int i,
            enumPlotKind gk,
            enumPlotForm pk,
            ref float gx,   //[2013.01.16]
            ref float gy    //[2013.01.16]
            )
        {
            float a_fTmp = yv;
            float a_fxTmp = 0;
            float a_fxTmp2 = 0;
            float a_fxTmp3 = 0;
            float a_fyTmp1 = 0;
            float a_fyTmp2 = 0;

            a_fxTmp2 = m_sep_left + (m_sep_x_graph * (xv - GraphMinX));

            //[2010.06.02]↓
            if (pyv > McLspViewDefine.g_InvalidValue2)
            {
                m_KPPrevXS = pxv;
            }
            //[2010.06.02]↑
            a_fxTmp3 = m_sep_left + (m_sep_x_graph * (m_KPPrevXS - GraphMinX));  //[2010.06.02]
            //a_fxTmp3 = m_sep_left + (m_sep_x_graph * (pxv - GraphMinX));  //[2010.06.02]

            if (gk == enumPlotKind.Line)
            {
                //[2010.02.18]
                if (pyv > InvalidValue)  //(pyv != m_InvalidValue)
                {
                    //[2010.02.18]
                    if (a_fTmp > InvalidValue)   //(a_fTmp != m_InvalidValue)
                    {
                        //[2010.06.02]↓
                        if (pyv != McLspViewDefine.g_InvalidValue2)
                        {
                            m_KPPrevYS = pyv;
                        }

                        if ((m_KPPrevYS != McLspViewDefine.g_InvalidValue2) &&
                            (a_fTmp != McLspViewDefine.g_InvalidValue2))
                        {
                            a_fyTmp1 = m_Height - (m_sep_bottom + ((m_KPPrevYS - m_KPMinYS) * m_KP_sep_ys_val));
                            //a_fyTmp1 = m_Height - (m_sep_bottom + ((pyv - m_FlowMeterMinY) * m_FlowMeter_sep_y_val)); //[2010.06.02]
                            a_fyTmp2 = m_Height - (m_sep_bottom + ((a_fTmp - m_KPMinYS) * m_KP_sep_ys_val));

                            m_g.DrawLine(
                                p,
                                a_fxTmp3 + a_fxTmp,
                                a_fyTmp1,
                                a_fxTmp2 + a_fxTmp,
                                a_fyTmp2
                                );

                            //[2010.03.22]bug-fixed.
                            //if (pk == enumPlotForm.FillCircle)
                            //{
                            //    float a_size_Legend = m_size_Legend;
                            //    m_g.FillEllipse(
                            //        b,
                            //        a_fxTmp3 + a_fxTmp - (a_size_Legend / 2),
                            //        a_fyTmp1 - (a_size_Legend / 2),
                            //        a_size_Legend,
                            //        a_size_Legend
                            //        );
                            //}

                            // add min
                            float a_size_Legend = m_size_Legend;
                            switch (pk)
                            {
                                case enumPlotForm.FillCircle:
                                        m_g.FillEllipse(
                                        b,
                                        a_fxTmp3 + a_fxTmp - (a_size_Legend / 2),
                                        a_fyTmp1 - (a_size_Legend / 2),
                                        a_size_Legend,
                                        a_size_Legend
                                        );
                                    break;
                                case enumPlotForm.FillRectangle:
                                        m_g.FillRectangle(
                                        b,
                                        a_fxTmp3 + a_fxTmp - (a_size_Legend / 2),
                                        a_fyTmp1 - (a_size_Legend / 2),
                                        a_size_Legend,
                                        a_size_Legend
                                        );
                                    break;
                                case enumPlotForm.FillTriangle:
                                        PointF[] a_pf2 = new PointF[3];
                                        a_pf2[0] = new PointF(a_fxTmp3 + a_fxTmp - (a_size_Legend / 1.8F), a_fyTmp1 + (a_size_Legend / 1.8F));
                                        a_pf2[1] = new PointF(a_fxTmp3 + a_fxTmp + (a_size_Legend / 1.8F), a_fyTmp1 + (a_size_Legend / 1.8F));
                                        a_pf2[2] = new PointF(a_fxTmp3 + a_fxTmp, a_fyTmp1 - (a_size_Legend / 1.8F));
                                        m_g.FillPolygon(
                                        b,
                                        a_pf2,
                                        System.Drawing.Drawing2D.FillMode.Winding
                                        );
                                    break;
                            }
                        }
                        //[2010.06.02]↑
                    }
                }
                else
                {   //[2010.06.02]
                    m_KPPrevYS = McLspViewDefine.g_InvalidValue2;
                }
            }

            a_fyTmp1 = m_Height - (m_sep_bottom + ((a_fTmp - m_KPMinYS) * m_KP_sep_ys_val));

            //[2010.02.18]
            if (a_fTmp > InvalidValue)   //(a_fTmp != m_InvalidValue)
            {
                //[2010.03.22]bug-fixed.
                //if (pk == enumPlotForm.FillCircle)
                //{
                //    float a_size_Legend = m_size_Legend;
                //    m_g.FillEllipse(
                //        b,
                //        a_fxTmp2 + a_fxTmp - (a_size_Legend / 2),
                //        a_fyTmp1 - (a_size_Legend / 2),
                //        a_size_Legend,
                //        a_size_Legend
                //        );
                //}

                // add min
                float a_size_Legend = m_size_Legend;
                switch (pk)
                {
                    case enumPlotForm.FillCircle:
                        m_g.FillEllipse(
                        b,
                        a_fxTmp2 + a_fxTmp - (a_size_Legend / 2),
                        a_fyTmp1 - (a_size_Legend / 2),
                        a_size_Legend,
                        a_size_Legend
                        );
                        break;
                    case enumPlotForm.FillRectangle:
                        m_g.FillRectangle(
                        b,
                        a_fxTmp2 + a_fxTmp - (a_size_Legend / 2),
                        a_fyTmp1 - (a_size_Legend / 2),
                        a_size_Legend,
                        a_size_Legend
                        );
                        break;
                    case enumPlotForm.FillTriangle:
                        PointF[] a_pf2 = new PointF[3];
                        a_pf2[0] = new PointF(a_fxTmp2 + a_fxTmp - (a_size_Legend / 1.8F), a_fyTmp1 + (a_size_Legend / 1.8F));
                        a_pf2[1] = new PointF(a_fxTmp2 + a_fxTmp + (a_size_Legend / 1.8F), a_fyTmp1 + (a_size_Legend / 1.8F));
                        a_pf2[2] = new PointF(a_fxTmp2 + a_fxTmp, a_fyTmp1 - (a_size_Legend / 1.8F));
                        m_g.FillPolygon(
                        b,
                        a_pf2,
                        System.Drawing.Drawing2D.FillMode.Winding
                        );
                        break;
                }
            }

            pyv = a_fTmp;

            gx = a_fxTmp2 + a_fxTmp;    //[2013.02.04]bug-fixed.
            gy = a_fyTmp1;              //[2013.01.16]

        }

        //*********************************************************************
        // @(f)
        // 機能      : グラフの水面のブラシ描画
        //
        // 引数      : ARG1 - Color値（ブラシ）
        //             ARG2 - KP値(m)
        //
        // 返り値    : なし
        //
        // 機能説明  :
        //
        // 備考      :
        //
        //*********************************************************************
        /*/// <summary><para>method outline:</para>
        /// <para>グラフの水面のブラシ描画</para>
        /// </summary>
        /// <param name="h_color">Color値（ブラシ）</param>
        /// <param name="h_suii">KP値(m)</param>
        public void DrawWaterSection(
            Color h_color,
            double h_suii
            )
        {
            try
            {
                SolidBrush a_brush = new SolidBrush(Color.FromArgb(128, h_color));
                m_g.FillRectangle(
                    a_brush,
                    m_sep_left,
                    m_Height - Convert.ToSingle((m_sep_bottom + ((m_Height - m_sep_bottom - m_sep_top) / (GraphMaxY - GraphMinY) * (h_suii - GraphMinY)))),
                    Convert.ToSingle((m_sep_x_val * m_num_x_graph) * m_sep_x_graph),
                    Convert.ToSingle((m_Height - m_sep_bottom - m_sep_top) / (GraphMaxY - GraphMinY) * (h_suii - GraphMinY))
                    );
            }
            catch(Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        */
       
    }
}
