﻿//using System;
//using System.Collections.Generic;
//using System.Text;
using System;
using System.Collections;

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>KPデータコレクション</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public class McLspViewKPItems : CollectionBase
    {
        /**********************************************************************
         * 変数の定義
        **********************************************************************/
        /// <summary> 項目名 </summary>
        private string m_sItemName = "";
        /// <summary> 処理中インデックス </summary>
        private int m_NowIdx = 1;
        //private string[] m_AlertMsg = null;
        /// <summary> 線の色 </summary>
        private System.Drawing.Color m_LineColor = System.Drawing.Color.Indigo;
        /// <summary> 線種 </summary>
        private System.Drawing.Drawing2D.DashStyle m_LineStyle = System.Drawing.Drawing2D.DashStyle.Solid;
        /// <summary> 線の太さ </summary>
        private float m_LineSize = 1.5F;
        /// <summary> マークの大きさ </summary>
        private float m_MarkSize = 4.0F;
        /// <summary> 描画：ライン </summary>
        private enumPlotKind m_PlotKind = enumPlotKind.Nothing;
        /// <summary> 描画：マーク </summary>
        private enumPlotForm m_PlotForm = enumPlotForm.Nothing;
        /// <summary> X軸の数 </summary>
        private int m_XNum = 0;

        /// <summary> 軸種別（1：主軸、2：２軸） </summary>
        private int m_AxisKind = 1;

        /**********************************************************************
         * プロパティの定義
        **********************************************************************/
        /// <summary>
        /// 項目名
        /// </summary>
        public string ItemName	//項目名
        {
            set
            {
                m_sItemName = value;
            }
            get
            {
                return m_sItemName;
            }
        }

        /// <summary>
        /// 処理中インデックス
        /// </summary>
        public int NowIdx	//インデックス
        {
            set
            {
                m_NowIdx = value;
            }
            get
            {
                return m_NowIdx;
            }
        }

        ///// <summary>
        ///// 
        ///// </summary>
        //public string[] AlertMsg	//アラートメッセージ
        //{
        //    set
        //    {
        //        m_AlertMsg = value;
        //    }
        //    get
        //    {
        //        return m_AlertMsg;
        //    }
        //}

        /// <summary>
        /// 線の色
        /// </summary>
        public System.Drawing.Color LineColor
        {
            set
            {
                m_LineColor = value;
            }
            get
            {
                return m_LineColor;
            }
        }
        /// <summary>
        /// 線種
        /// </summary>
        public System.Drawing.Drawing2D.DashStyle LineStyle
        {
            set
            {
                m_LineStyle = value;
            }
            get
            {
                return m_LineStyle;
            }
        }
        /// <summary>
        /// 線の太さ
        /// </summary>
        public float LineSize
        {
            set
            {
                m_LineSize = value;
            }
            get
            {
                return m_LineSize;
            }
        }
        /// <summary>
        /// マークの大きさ
        /// </summary>
        public float MarkSize
        {
            set
            {
                m_MarkSize = value;
            }
            get
            {
                return m_MarkSize;
            }
        }
        /// <summary>
        /// 描画：ライン
        /// </summary>
        public enumPlotKind PlotKind
        {
            set
            {
                m_PlotKind = value;
            }
            get
            {
                return m_PlotKind;
            }
        }
        /// <summary>
        /// 描画：マーク
        /// </summary>
        public enumPlotForm PlotForm
        {
            set
            {
                m_PlotForm = value;
            }
            get
            {
                return m_PlotForm;
            }
        }
        /// <summary>
        /// X軸の数
        /// </summary>
        public int XNum
        {
            set
            {
                m_XNum = value;
            }
            get
            {
                return m_XNum;
            }
        }
        /// <summary>
        /// 軸の種別
        /// </summary>
        public int AxisKind
        {
            set
            {
                m_AxisKind = value;
            }
            get
            {
                return m_AxisKind;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLspViewKPItems csKPItems = new McLspViewKPItems()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLspViewKPItems()
		{
			
		}
        /// <summary><para>method outline:</para>
        /// <para>KPデータ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLspViewKPItem csKPItem = csKPItems[index]</para>
        /// </example>
        /// <param name="index">インデックス</param>
        /// <returns>KPデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public McLspViewKPItem this[ int index ]  
		{
			get  
			{
				return( (McLspViewKPItem) List[index] );
			}
			set  
			{
				List[index] = value;
			}
		}
        /// <summary><para>method outline:</para>
        /// <para>追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Add(value)</para>
        /// </example>
        /// <param name="value">McLspViewKPItem：KPの値</param>
        /// <returns>新しい要素が挿入された位置</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public int Add( McLspViewKPItem value )  
		{
			return( List.Add( value ) );
		}
        /// <summary><para>method outline:</para>
        /// <para>インデックス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>IndexOf(value)</para>
        /// </example>
        /// <param name="value">McLspViewKPItem：KPの値</param>
        /// <returns>リストに存在する場合は value のインデックス。それ以外の場合は -1</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public int IndexOf( McLspViewKPItem value )  
		{
			return( List.IndexOf( value ) );
		}
        /// <summary><para>method outline:</para>
        /// <para>挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Insert(index, value)</para>
        /// </example>
        /// <param name="index">int：インデックス</param>
        /// <param name="value">McLspViewKPItem：KPの値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void Insert( int index, McLspViewKPItem value )  
		{
			List.Insert( index, value );
		}
        /// <summary><para>method outline:</para>
        /// <para>削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Remove(value)</para>
        /// </example>
        /// <param name="value">McLspViewKPItem：KPの値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void Remove( McLspViewKPItem value )  
		{
			List.Remove( value );
		}
        /// <summary><para>method outline:</para>
        /// <para>特定の値が格納されているか判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Contains(value)</para>
        /// </example>
        /// <param name="value">McLspViewKPItem：KPの値</param>
        /// <returns>true=存在する/false=しない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public bool Contains( McLspViewKPItem value )  
		{
			// If value is not of type Int16, this will return false.
			return( List.Contains( value ) );
		}
        /*
        /// <summary>
        /// OnInsert
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <param name="value">値</param>
		protected override void OnInsert( int index, Object value )  
		{
			//			if ( value.GetType() != Type.GetType("McLspViewKPItem") )
			//				throw new ArgumentException( "value must be of type McLspViewKPItem.", "value" );
		}
        /// <summary>
        /// OnRemove
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <param name="value">値</param>
		protected override void OnRemove( int index, Object value )  
		{
			//			if ( value.GetType() != Type.GetType("McLspViewKPItem") )
			//				throw new ArgumentException( "value must be of type McLspViewKPItem.", "value" );
		}
        /// <summary>
        /// OnSet
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <param name="oldValue">値</param>
        /// <param name="newValue">値</param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			//			if ( newValue.GetType() != Type.GetType("McLspViewKPItem") )
			//				throw new ArgumentException( "newValue must be of type McLspViewKPItem.", "newValue" );
		}
        /// <summary>
        /// OnValidate
        /// </summary>
        /// <param name="value">値</param>
		protected override void OnValidate( Object value )  
		{
			//			if ( value.GetType() != Type.GetType("McLspViewKPItem") )
			//				throw new ArgumentException( "value must be of type McLspViewKPItem." );
		}
        */
    }
}
