using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace jp.go.nilim.Longitudinal_profile_H26
{
    /// <summary><para>class outline:</para>
    /// <para>定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class McLspViewDefine
    {
        /// <summary>業務種別識別子：システム内でユニークな値としてください</summary>
        static public readonly string MCLSPVIEW_ID = "jp.go.nilim.Longitudinal_profile_H26";

        // ===========================
        // 種別識別子関係
        // ===========================
        /// <summary>業務種別識別子：システム内でユニークな値としてください</summary>
        static public readonly HySKind MCLSPVIEW_BUSINESS_KIND = new HySObjectKind(MCLSPVIEW_ID);
        //static public readonly HySKind MCLSPVIEW_BUSINESS_KIND = new HySObjectKind("HsAddin.McLspViewBusiProc");
        /// <summary>画面ファクトリーID：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier MCLSPVIEW_FACTORY_ID_SCREEN = new HySID(MCLSPVIEW_ID +".Factory.Screen");
        //static public readonly HySIdentifier MCLSPVIEW_FACTORY_ID_SCREEN = new HySID("HsAddin.McLspView.Factory.Screen");
        /// <summary>ビューア内処理ファクトリー：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier MCLSPVIEW_FACTORY_ID_VIEWRJOB = new HySID(MCLSPVIEW_ID+".Factory.ViewerJob");
        //static public readonly HySIdentifier MCLSPVIEW_FACTORY_ID_VIEWRJOB = new HySID("HsAddin.McLspView.Factory.ViewerJob");


        // ===========================
        // 画面識別子関係
        // ===========================
        /// <summary>プロジェクト管理画面：本業務内でユニークな値としてください</summary>
        static public readonly HySKind MCLSPVIEW_SCREEN = new HySObjectKind(MCLSPVIEW_ID+".Screen");
        //static public readonly HySKind MCLSPVIEW_SCREEN = new HySObjectKind("McLspView.Screen");
        // ToDo 画面のIDを追加（画面数分）


        // ===========================
        // メニューコールバック番号定義関係
        // ===========================
        /// <summary>何らかの処理：本業務内でユニークな値としてください</summary>
        static public readonly long MCLSPVIEW_DO_SOMETHING = 1;
        /// <summary>サンプル画面表示開始：本業務内でユニークな値としてください</summary>
        static public readonly long MCLSPVIEW_DISP_SCREEN = 10;
        // ToDo メニューからのコールバック番号を追加定義（メニュー数分）

        // ===========================
        // グラフ設定
        // ===========================
        /// <summary>欠測値</summary>
        static public readonly float g_InvalidValue = -9999;
        /// <summary>欠測値</summary>
        static public readonly float g_InvalidValue2 = -9998;  //[2010.06.01]
        /// <summary>KPY軸最大値（主軸）</summary>
        static public float g_KP_MaxYP = g_InvalidValue;
        /// <summary>KPY軸最小値（主軸）</summary>
        static public float g_KP_MinYP = g_InvalidValue;
        /// <summary>KPY軸最大値（２軸）</summary>
        static public float g_KP_MaxYS = g_InvalidValue;
        /// <summary>KPY軸最小値（２軸）</summary>
        static public float g_KP_MinYS = g_InvalidValue;
        /// <summary>KPフォントサイズ</summary>
        static public float g_FontSize = g_InvalidValue;    //[2013.02.05]

        /// <summary>X軸間隔</summary>
        static public float g_XAxisPitch = g_InvalidValue;    //[2013.02.05]

        /// <summary>KPY軸区切数</summary>
        static public int g_KP_SepNumY = 10;  //[2013.01.24]

        /// <summary>KPY軸最大値（主軸）</summary>
        static public float g_Time_KP_MaxYP = g_InvalidValue;
        /// <summary>KPY軸最小値（主軸）</summary>
        static public float g_Time_KP_MinYP = g_InvalidValue;
        /// <summary>KPY軸最大値（２軸）</summary>
        static public float g_Time_KP_MaxYS = g_InvalidValue;
        /// <summary>KPY軸最小値（２軸）</summary>
        static public float g_Time_KP_MinYS = g_InvalidValue;
        /// <summary>KPフォントサイズ</summary>
        static public float g_Time_FontSize = g_InvalidValue;   //[2013.02.05]

        /// <summary>未使用</summary>
        static public Boolean g_IsLine = true;
        /// <summary>未使用</summary>
        static public Boolean g_IsPoint = true;

        /// <summary> 縦断データファイル </summary>
        static public string g_TargetLspFileName = "";
        /// <summary> 計算結果データファイル </summary>
        static public string g_TargetItemFileName = "";
        /// <summary> KP </summary>
        static public string g_TargetSectionID = "";
        /// <summary> 累加距離 </summary>
        static public decimal g_TargetDistance = 0;
        /// <summary> 計算結果インデックス </summary>
        static public int g_TargetCalcIndex = 0;
        /// <summary> ラベル </summary>
        static public string g_TargetLabelKPP = "";
        /// <summary> ラベル </summary>
        static public string g_TargetLabelKPS = "";
        /// <summary> 開始時刻 </summary>
        static public DateTime g_TargetStartKP;
        /// <summary> 終了時刻 </summary>
        static public DateTime g_TargetEndKP;

        /// <summary> CommonMPDataパス </summary>
        static public string g_sCommonMPData_Path = null; //[2013.02.07]
        /// <summary> CommonMPbinパス </summary>
        static public string g_sCommonMP_Path = null; //[2013.02.07]
        /// <summary> CommonMPbinパス </summary>
        static public Uri g_uriCommonMP_Path = null; //[2013.02.07]
        /// <summary> 自身業務パス </summary>
        static public string g_MyGyomuPath = null; //[2013.02.06]
        /// <summary> 縦断ファイル名 </summary>
        static public string g_LongitudinalFileName = "";   //[2013.02.12]
    }
}
