﻿// <summary>ソースコード：アドインスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// ↓↓↓　下記コードが必須　↓↓↓
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
namespace CommonMP.HYSSOP._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ツールファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2013/1/29][新規作成]</para>
    /// </remarks>
    public class HYSSOP_USRSCREEN_FACTORY_CREATOR_IMPLE : HYSSOP_USRSCREEN_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>ツールのファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreenFactory csToolFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ツールのファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYSSOP.Interface.HSViewer.HySScreenFactory CreateFactory()
        {
            // ToDo 自作の画面ファクトリ（ネームスペース付き）を new して下さい。
            return new jp.go.yyyy.MySysToolSample.MyToolSampleScreenFactory();
        }
    }
}
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// ↑↑↑　上記コードが必須　↑↑↑
//★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

namespace jp.go.yyyy.MySysToolSample
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>アドインスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class MyToolSampleScreenFactory : HySDotNetAddInBaseScreenFactory
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetScreenFactory csFactory = new McDotNetScreenFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public MyToolSampleScreenFactory()
        {
            // ToDo 独自のファクトリＩＤを設定して下さい。
            //    コンストラクター－内で　ファクトリＩＤを設定する
            SetFactoryID(MyToolSampleDefine.BUSINESS_KIND); // ←必須
        } 


        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySKind GetSimKind()
        {
            // ToDo シミュレーション（業務ＩＤ）を取得する
            return MyToolSampleDefine.BUSINESS_KIND;
            // ↑ HsAddinDotNetSampleViewerJobFactory.GetSimKind()と同じ値を返す事。
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean EqualSimKind(HySKind csSimKindID)
        {
            // ToDo シミュレーション（業務ＩＤ）が同じか否かを判断する
            return MyToolSampleDefine.BUSINESS_KIND.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子：予備（使用せず）</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySDotNetAddInBaseScreen csScreen = null;
            if (csSimulatorKind.Equals(MyToolSampleDefine.BUSINESS_KIND) == true)
            {
                // ToDo 独自の HySDotNetAddInBaseScreen 派生クラスを生成してください
                if (MyToolSampleDefine.SAMPLE_SCREEN.Equals(csScreenKind) == true)
                { // SAMPLE_SCREEN を作成する必要があるならば、
                    csScreen = new MyToolSampleDotNetScreen();
                }
                //else if (HysAddinScreenDefineSample.XXXXXX_SCREEN.Equals(csScreenKind) == true)
                //{ // 別に指定する SCREEN を作成する必要があるならば
                //}
            }
            return csScreen;
        }
    }
}
