﻿// <summary>ソースコード：GoogleEarth GISファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSGIS.HySGoogleEarthGIS
{
    /// <summary><para>class outline:</para>
    /// <para>GoogleEarth GISファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/05/01][新規作成]</para>
    /// <para>Remarks</para>
    /// </remarks>
    public class HySGoogleEarthGISFactory : HySFactoryMono, HySGISFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDioVistaGISFactory csGis = new HySDioVistaGISFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGoogleEarthGISFactory()
        {
            this.SetFactoryID(HySGoogleEarthDef.FACTORY_ID_GIS);
        }

        /// <summary><para>method outline:</para>
        /// <para>GISエンジンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISEngine csGISEngine = CreateGIS( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GISエンジンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySGISEngine CreateGIS()
        {
            HySGISEngine csGISEngine = new HySGoogleEarthGIS();
            return csGISEngine;
        }

        /// <summary><para>method outline:</para>
        /// <para>GIS種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetGISKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GIS種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetGISKind()
        {
            return HySGoogleEarthDef.GIS_KIND_GOOGLE_EARTH;
        }
        /// <summary><para>method outline:</para>
        /// <para>GIS種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualGISKind( csGISKindID ) </para>
        /// </example>
        /// <param name="csGISKindID">GIS種別識別子</param>
        /// <returns>識別子が一致すればtrue、異なればfalse</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualGISKind(HySKind csGISKindID)
        {
            return (GetGISKind()).Equals(csGISKindID);
        }

    }
}
