﻿// <summary>ソースコード：GoogleEarth GIS用常数定義</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSGIS.HySGoogleEarthGIS
{
    /// <summary><para>class outline:</para>
    /// <para>GoogleEarth専用定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/05/01][新規作成]</para>
    /// </remarks>
    static public class HySGoogleEarthDef
    {
        /// <summary>GIS識別用文字列</summary>
        static public readonly String GOOGLE = "GOOGLEEARTH_GIS";

        /// <summary>DioVISTA種別識別子</summary>
        static public readonly HySObjectKind GIS_KIND_GOOGLE_EARTH = new
            HySObjectKind(new HySString(HySGoogleEarthDef.GOOGLE));

        // =======================
        // ファクトリ識別子
        // =======================
        /// <summary>>GoogleEarth用GISファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_GIS = new HySID("GOOGLE_EARTH.Factory.GIS");
    }
}
