﻿// <summary>ソースコード：HySGoogleEarth次元メッシュ情報ビュー</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using System.Diagnostics;
using System.Threading;
using System.IO;

using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using EARTHLib;

namespace CommonMP.HYSSOP.OptionImpl.HSGIS.HySGoogleEarthGIS
{
    /// <summary><para>class outline:</para>
    /// <para>HySGoogleEarth 2次元メッシュ情報ビュー</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/05/01][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>メッシュ情報を表示する</para>
    /// </remarks>
    public class HySGoogleEarthDim2MeshView : HySGISDim2MeshView
    {
        /// <summary>凡例、色属性情報等 </summary>
        protected HySGeoLegendInf m_csLegendInf=new HySGeoLegendInf();
        /// <summary>セルの表示アイテム位置番号：０固定 </summary>
        protected long m_lDispIdx = 0;
        /// <summary> KML ﾌｧｲﾙ名称（ﾌﾙﾊﾟｽ付き）</summary>
        protected string m_sDispKMLFileName = "";
        
        /// <summary><para>method outline:</para>
        /// <para>指定データの画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowMeshData (csD2MeshSerialData)</para>
        /// </example>
        /// <param name="csD2MeshSerialData">表示するメッシュデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ShowMeshData(HySGeoDim2MeshSerialData csD2MeshSerialData)
        {
            try
            {
                m_lDispIdx = 0; // ０固定(重要)

                // 色属性、凡例等情報読取得
                string sLegendFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendAny.xml";
                m_csLegendInf.ReadXMLFile(sLegendFile);
                m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.clampToGround);

                if (HySDataKindDefine.WATER_LEVEL.Equals(csD2MeshSerialData.GetCellDataCharacteristic().GetDataKind(m_lDispIdx)) == true ||
                    HySDataKindDefine.FLOODING_WATER_DEPTH.Equals(csD2MeshSerialData.GetCellDataCharacteristic().GetDataKind(m_lDispIdx)) == true)
                {
                    sLegendFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendWaterLevel.xml";
                    m_csLegendInf.ReadXMLFile(sLegendFile);
                    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.relativeToGround);

                }
                // 特殊な凡例が追加されたならば、コードを書き加える
                //else if (HySDataKindDefine.SCALOR_RAIN_FALL.Equals(csD2MeshSerialData.GetCellDataCharacteristic().GetDataKind(0)) == true)
                //{
                //    string sFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendRain.xml";
                //    m_csLegendInf.ReadXMLFile(sFile);
                //    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.absolute);
                //}
                //else
                //{
                //    sFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendAny.xml";
                //    m_csLegendInf.ReadXMLFile(sFile);
                //    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.clampToGround);
                //}
                
                // ----------------
                // KMLﾌｧｲﾙ作成開始 
                // ----------------
                m_sDispKMLFileName = HySEnvInf.GetHomeDirectory().ToString() + "\\temp\\GoogleDispKML.kml";
                //m_sDispKMLFileName = "C:\\tmp\\GoogleDispKML.kml";
                //   もし、GoogleDispKML.kmlﾌｧｲﾙが出来ているにもかかわらず表示されない場合、
                //   KML ﾌｧｲﾙの置き場所が　特殊な文字の入ったﾌｫﾙﾀﾞｰ(例：C#など)になると　GoogleEarth が 認識しないようなので、
                //   安全な場所(C:\\tmp\\GoogleDispKML.kml)に 作成する
                HySFile csFile = new HySFile(m_sDispKMLFileName);
                // KMLﾌｧｲﾙオープン
                if (csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) != 0)
                {
                    return;
                }

                // KMLﾌｧｲﾙ書き出し
                HySGeoKMLWirteTool.WriteKmlMeshData(csFile, csD2MeshSerialData, m_lDispIdx, m_csLegendInf);

                // KMLﾌｧｲﾙクローズ
                csFile.Close();

                // --------------------
                // GoogleEarth表示開始 
                // --------------------
                // GoogeleEarth APIに　今作成したKMLファイルを読み込ませる
                if (HySGoogleEarthGIS.mg_csEarth == null)
                {
                    HySGoogleEarthGIS.mg_csEarth = new ApplicationGE();
                }
                HySGoogleEarthGIS.mg_csEarth.OpenKmlFile(m_sDispKMLFileName, 0);

            }
            catch (Exception e)
            {
            }
        }
        


        /// <summary><para>method outline:</para>
        /// <para>アニメーション開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> StartAnimation( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void StartAnimation()
        {
            if (m_csD2MeshSerialData == null)
            {
                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HySGoogleEarthDim2MeshView", "StartAnimation", "表示データ（m_csD2MeshSerialData）がnullです"); // 必要に応じてログ出力
                return;
            }

            if (m_csD2MeshSerialData.GetDataMeshKind() == HySGeoMesh.MESH_DATA_KIND.PATTARN_DATA_HOLD)
            {
                return;
            }

            try
            {
                this.ShowMeshData(m_csD2MeshSerialData);
                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HySGoogleEarthDim2MeshView", "StartAnimation", "ShowMeshData(m_csD2MeshSerialData)"); // 必要に応じてログ出力
            }
            catch (Exception e)
            {
            }
            finally
            {

            }
        }
        /// <summary><para>method outline:</para>
        /// <para>アニメーション停止</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PauseAnimation( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void PauseAnimation()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }
        /// <summary><para>method outline:</para>
        /// <para>アニメーション再生位置リセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetAnimation( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ResetAnimation()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }

        ///// <summary>非時系列メッシュ情報表示用ファイル管理テーブル</summary>
        //protected Hashtable m_csKMLFileName = new Hashtable();
        ///// <summary>非時系列メッシュ情報表示用ファイル管理テーブル</summary>
        //protected Hashtable m_csMakeKMLFlg = new Hashtable();

        ///// <summary><para>method outline:</para>
        ///// <para>指定データの画面表示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ShowMeshData (csD2MeshData)</para>
        ///// </example>
        ///// <param name="csD2MeshData">表示するメッシュデータ</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //private void ShowMeshData(HySGeoDim2MeshData csD2MeshData)
        //{
        //    try
        //    {
        //        m_lDispIdx = 0; // ０固定(重要)

        //        HySTime csTime = csD2MeshData.GetLastTime();
        //        if (m_csMakeKMLFlg[csTime.GetTime()] != csD2MeshData)
        //        {
        //            // 色属性、凡例等情報読取得
        //            string sLegendFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendAny.xml";
        //            m_csLegendInf.ReadXMLFile(sLegendFile);
        //            m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.clampToGround);

        //            if (HySDataKindDefine.WATER_LEVEL.Equals(csD2MeshData.GetCellDataCharacteristic().GetDataKind(m_lDispIdx)) == true ||
        //                HySDataKindDefine.FLOODING_WATER_DEPTH.Equals(csD2MeshData.GetCellDataCharacteristic().GetDataKind(m_lDispIdx)) == true)
        //            {
        //                sLegendFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendWaterLevel.xml";
        //                m_csLegendInf.ReadXMLFile(sLegendFile);
        //                m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.relativeToGround);

        //            }
        //            // 特殊な凡例が追加されたならば、コードを書き加える
        //            //else if (HySDataKindDefine.SCALOR_RAIN_FALL.Equals(csD2MeshData.GetCellDataCharacteristic().GetDataKind(0)) == true)
        //            //{
        //            //    string sFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendRain.xml";
        //            //    m_csLegendInf.ReadXMLFile(sFile);
        //            //    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.absolute);
        //            //}
        //            //else
        //            //{
        //            //    sFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendAny.xml";
        //            //    m_csLegendInf.ReadXMLFile(sFile);
        //            //    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.clampToGround);
        //            //}

        //            // ----------------
        //            // KMLﾌｧｲﾙ作成開始 
        //            // ----------------
        //            m_csKMLFileName[csTime.GetTime()] = HySEnvInf.GetHomeDirectory() + new HySString("..\\temp\\GoogleEarth\\" + csTime.GetTime().ToString() + ".kml");
        //            m_csMakeKMLFlg[csTime.GetTime()] = csD2MeshData;
        //            // KMLﾌｧｲﾙオープン
        //            HySFile csFile = new HySFile((HySString)m_csKMLFileName[csTime.GetTime()]);
        //            if (csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) != 0)
        //            {
        //                return;
        //            }
        //            // KMLﾌｧｲﾙ書き出し
        //            HySGeoKMLWirteTool.WriteKmlMeshData(csFile, csD2MeshData, m_lDispIdx, m_csLegendInf);

        //            // KMLﾌｧｲﾙクローズ
        //            csFile.Close();

        //            // --------------------
        //            // GoogleEarth表示開始 
        //            // --------------------
        //            // GoogeleEarth APIに　今作成したKMLファイルを読み込ませる
        //            if (HySGoogleEarthGIS.mg_csEarth == null)
        //            {
        //                HySGoogleEarthGIS.mg_csEarth = new ApplicationGE();
        //            }
        //            string kmlFile = ((HySString)m_csKMLFileName[csTime.GetTime()]).ToString();
        //            HySGoogleEarthGIS.mg_csEarth.OpenKmlFile(kmlFile, 0);
        //        }
        //    }
        //    catch (Exception e)
        //    {
        //    }
        //}

        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Show( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Show()
        {
            //this.ShowMeshData(m_csD2MeshData);
        }
        /// <summary><para>method outline:</para>
        /// <para>画面非表示化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Hide( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Hide()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }
        /// <summary><para>method outline:</para>
        /// <para>画面更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Renew( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Renew()
        {
            Show();
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Close( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Close()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            // Do Nothing
            // Google Earth の場合には処理実装せず
        }
    }
}
