﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSAddinJob.Sample
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HsAddinSampleJob : HySDotNetAddInBaseJob
    {
        //// <summary>業務動作中フラグ（例）</summary>
        //protected bool m_bWorkFlg = false;
        /// <summary>起動されたプロセスのハンドル（例）</summary>
        System.Diagnostics.Process m_hProcess = null;


        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必須メソッド</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            
            if (lCallBackNo == HysAddinJobDefineSample.SAMPLE_DO_SOMETHING)
            {   // 何らかの処理(例：画面表示)
                lRtn = this.DoSomething();
            }
            else if (lCallBackNo == HysAddinJobDefineSample.SAMPLE_DISP_MANUAL)
            {   // 何らかの処理(例：マニュアル表示)
                lRtn = this.DispManual();
            } 
            else
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理を必要としないならば、本メソッドは実装しなくても良い</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            // 処理例
            //m_bWorkFlg = true; // 処理開始したことをフラグに覚えさせておく
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理を必要としないならば、本メソッドは実装しなくても良い</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            // 処理例
            if (System.Diagnostics.Process.GetProcessesByName("HcAddInSampleApplication").Length > 0)
            {   // 起動中のプロセスが存在する時
                m_hProcess.Kill(); // 強制終了
            }

            //m_bWorkFlg = false; // 処理終了したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// Terminate() による処理が終了していない場合等　false を返す。
        /// 特別な処理を必要としないならば、本メソッドは実装しなくても良い
        /// </para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // 処理例
            // 処理中でなければ(m_bWorkFlg==false)、本業務処理はＥｘｉｔしてもＯＫと判断して true を返す
            //if (m_bWorkFlg == true)
            //{
            //    return false;
            //}
            //else
            //{
            //    return true;
            //}
            return true;
        }


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ToDo　コールバックに対応する処理が必要な場合に処理を追加する
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★


        /// <summary><para>method outline:</para>
        /// <para>例）何らかの処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = DoSomething( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サンプルメソッド</para>
        /// </remarks>
        protected virtual long DoSomething()
        {
            // 何らかの処理を行う　業務固有メソッド
            //
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★
            //此処では例として　サンプルアプリケーションを起動する。
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★
            if (System.Diagnostics.Process.GetProcessesByName("HcAddInSampleApplication").Length < 1)
            {   // 既に起動中のプロセスが無い時
                HySString csExeFile = new HySString("HcAddInSampleApplication.exe");
                HySFile csFile = new HySFile(csExeFile);
                if( csFile.Exist() == true )
                {
                    m_hProcess = System.Diagnostics.Process.Start(csExeFile.ToString());

                    if (m_hProcess != null)
                    {
                        HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HsAddinSampleJob", "DoSomething", "HcAddInSampleApplication.exeを起動(HandleID="+m_hProcess.ToString() + ")"); // 必要に応じてログ出力
                    }
                    else
                    {
                        HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HsAddinSampleJob", "DoSomething", "HcAddInSampleApplication.exe起動失敗"); // 必要に応じてログ出力
                    }
                }
            }
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>例）何らかの処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = DispManual( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サンプルメソッド</para>
        /// </remarks>
        protected virtual long DispManual()
        {
            // 何らかの処理を行う　業務固有メソッド
            //
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★
            //此処では例として　PDFファイルを表示する。
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★

            HySString csPDFFile = HySEnvInf.GetHomeDirectory() + new HySString("\\help\\AddInSamples\\AddinJobManual.pdf");
            HySFile csFile = new HySFile(csPDFFile);
            if (csFile.Exist() == true)
            {
                //Process.Start(csPDFFile.ToString());
                Help.ShowHelp(new Control(), csPDFFile.ToString());

            }

            return 0;
        }
    }
}
