// <summary>ソースコード：スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSAddin.Sample
{
    /// <summary><para>class outline:</para>
    /// <para>スクリーンクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HsAddinSampleDotNetScreen : HySDotNetAddInBaseScreen
    {
        /// <summary>.net画面フォーム</summary>
        protected HsAddinSampleDotNetForm m_csSampleForm=null;
        /// <summary>ビューアジョブ</summary>
        protected HsAddinDotNetSampleViewerJob m_csSampleJob = null;

        // 定数定義
        /// <summary>画面デフォルト幅</summary>
        static private readonly int DEFAULT_WIDTH = 500;
        /// <summary>画面デフォルト高さ</summary>
        static private readonly int DEFAULT_HEIGHT = 550;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetProjectCtlScreen csScreen = new McDotNetProjectCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HsAddinSampleDotNetScreen()
        {
        }
               
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> なし </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリークを防ぐため</para>
        /// </remarks>
        ~HsAddinSampleDotNetScreen()
        {
            m_csSampleForm = null;  // メモリーリークを防ぐため、自変数はnullクリアしておく
            m_csSampleJob = null;  // メモリーリークを防ぐため、自変数はnullクリアしておく
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            // >>>>> ●必須● Formを生成する ●必須●>>>>>>
            m_csSampleForm = new HsAddinSampleDotNetForm(this);
            // >>>>> ●必須●　親クラスにFormを設定する ●必須●>>>>>>
            base.SetViewForm(m_csSampleForm);

            // 画面サイズ(もしも、プログラムから変更したい場合)
            //m_csSampleForm.Width = DEFAULT_WIDTH;
            //m_csSampleForm.Height = DEFAULT_HEIGHT;

            // 画面表示位置
            m_csSampleForm.SetDesktopLocation(350, 40);

            // 各種設定
            m_csSampleForm.WindowState = FormWindowState.Normal;
            m_csSampleForm.StartPosition = FormStartPosition.Manual;
            m_csSampleForm.Text = "サンプル画面";

            //base.SetViewForm(m_csSampleForm);
            // >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            m_csSampleForm = null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            // >>>>> ●必須●　SetViewer() メソッドをオーバーライドした場合には　親クラス処理をコール　 ●必須●>>>>>>
            base.SetViewer(csViewer);

            // 便利の為、Jobクラスをキャストしておく
            m_csSampleJob = m_csVJob as HsAddinDotNetSampleViewerJob;
            
            // 必要ならば　業務固有の独自処理を行う

            // 独自処理が無くて、且つ　Jobをキャストしておく必要が無いならば、本メソッドは不要 
        }

     }
}
