﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HSAddin.Sample
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内画面制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HsAddinDotNetSampleViewerJob : HySDotNetAddInBaseJob
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;


        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;

            if (lCallBackNo == HysAddinScreenDefineSample.SAMPLE_DISP_SCREEN)
            {   // サンプル画面表示開始
                lRtn = this.DispSomeScreen();
            }     
            else if (lCallBackNo == HysAddinScreenDefineSample.SAMPLE_DO_SOMETHING)
            {   // 何らかの処理
                lRtn = this.DoSomething();
            }
            else
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            // 処理例
            m_bWorkFlg = true; // 処理開始したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            // 処理例
            m_bWorkFlg = false; // 処理終了したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // 処理例
            // 処理中でなければ(m_bWorkFlg==false)、本業務処理はＥｘｉｔしてもＯＫと判断して true を返す
            if (m_bWorkFlg == true)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ToDo　コールバックに対応する処理が必要な場合に処理を追加する
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        /// <summary><para>method outline:</para>
        /// <para>例）何らかの処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = DoSomething( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サンプルメソッド</para>
        /// </remarks>
        protected virtual long DoSomething()
        {
            // 何らかの処理を行う　業務固有メソッド
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★
            //此処では例として　PDFファイルを表示する。
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★

            HySString csPDFFile = HySEnvInf.GetHomeDirectory() + new HySString("\\help\\AddInSamples\\AddinScreenManual.pdf");
            HySFile csFile = new HySFile(csPDFFile);
            if (csFile.Exist() == true)
            {
                //Process.Start(csPDFFile.ToString());
                Help.ShowHelp(new Control(), csPDFFile.ToString());

            }
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>例）画面表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = DoSomething( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>サンプルメソッド</para>
        /// </remarks>
        protected virtual long DispSomeScreen()
        {
            // 何らかの処理を行う　業務固有メソッド
            //
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★
            //此処では例として　サンプル画面をを表示する。
            //★★★★★★★★★★★★★★★★★★★★★★★★★★★

            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HsAddinDotNetSampleViewerJob", "DispSomeScreen", "画面表示開始"); // 必要に応じてログ出力

            HySID csID = null;
            csID = new HySID("ArbitraryCode");  // 画面には ユニークな値を一意に設定

            // 同じ種類の画面を同時に複数表示したいときには
            //csID = new HySID("ArbitraryCode" + m_lPrmNo.ToString()); // 例えば左記の通り、ＩＤを変更すると、異なる画面が表示される
            //m_lPrmNo += 1; // 此処の画面を区別する為に、一貫番号をインクリメントする。
            // 同じ種類の画面を一枚だけ表示したい時には、同じIDを画面につけると、既に画面が表示されていれば、
            // 新たに、画面を表示しない

            // 注意：csID は　HySDotNetAddInBaseJob内でユニークである必要がある。

            // 画面表示
            HySDotNetAddInBaseScreen csDotNetScreen = this.CmndShowScreen((HySObjectKind)HysAddinScreenDefineSample.SAMPLE_SCREEN, csID) as HySDotNetAddInBaseScreen;
            if (csDotNetScreen != null)
            {   // 表示に成功ならば
                csDotNetScreen.ActivateForm();  // 表示した画面を最前面に持ってくる
            }

            return 0;
        }

        /// <summary>画面ユニーク番号（一貫番号）設定用のワーク </summary>
        static protected long m_lPrmNo = 0;

    }
}
