﻿using System;
using System.Collections.Generic;
//using System.Linq;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>GIS制御プロセス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HyssopGISCtlMainProgram
    {
        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
        /// </remarks>
        [STAThread]
        static int Main(string[] sArgs)
        {
            //Application.EnableVisualStyles();
            //Application.SetCompatibleTextRenderingDefault(false);
            //Application.Run(new HySGISCtlMainForm());

            HyssopGISCtlMainProgram.startLOG();
            int iRtn = 0;
            HySString csCinfigFileName = null;
            csCinfigFileName = new HySString("CommonMP.cfg");
            // 起動引数チェック
            if (sArgs.Length == 0)
            {
                // Do Nothing
                //csCinfigFileName = new HySString("CommonMP.cfg");
            }
            else if (sArgs[0] == "-c")
            {
                csCinfigFileName = new HySString(sArgs[1]);
            }

            // 二重起動チェックを行う。
            if (System.Diagnostics.Process.GetProcessesByName(
                System.Diagnostics.Process.GetCurrentProcess().ProcessName).Length <= 1)
            {   // 起動されていない場合のみ起動する。

                // システム制御生成
                HySExtGISController csSysCtl = new HySExtGISController();
                csSysCtl.SetSystemController(csSysCtl);
                //csSysCtl.SetConfigureFileName(new HySString("CommonMP.cfg"));
                csSysCtl.SetConfigureFileName(csCinfigFileName);

                HyssopGISCtlMainProgram.DebugLOG("end of new csSysCtl");
                // システム制御初期処理
                if (csSysCtl.Initialize() == true)
                {
                    HyssopGISCtlMainProgram.DebugLOG("end of csSysCtl.Initialize()");
                    // システム起動
                    if (csSysCtl.WakeUp() == true)
                    {
                        HyssopGISCtlMainProgram.DebugLOG("end of csSysCtl.WakeUp()");
                        //// メイン画面起動
                        csSysCtl.Run();
                        HyssopGISCtlMainProgram.DebugLOG("end of csSysCtl.Run()");
                        csSysCtl.ShutDown();
                        HyssopGISCtlMainProgram.DebugLOG("end of csSysCtl.ShutDown()");
                    }
                    else
                    {
                        HyssopGISCtlMainProgram.ErrorLOG("fail csSysCtl.WakeUp()");
                        iRtn = -1;
                    }
                }
                else
                {
                    HyssopGISCtlMainProgram.ErrorLOG("fail csSysCtl.Initialize()");
                    iRtn = -1;
                }
            }
            HyssopGISCtlMainProgram.DebugLOG("end of HyssopGISCtlMainProgram.Main( ) reteurn code ="+ iRtn.ToString() );
            System.Environment.Exit(iRtn);
            return iRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ログ出力(デバッグ)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HyssopGISCtlMainProgram.DebugLOG(msg); </para>
        /// </example>
        /// <param name="msg">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void DebugLOG(string msg)
        {
            HySFile csErrFile = new HySFile("..\\log\\HyssopGISController_LOG.txt");
            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            csErrFile.WriteText(" DebugMsg : (" + msg + ")");
            csErrFile.Close();
        }
        /// <summary><para>method outline:</para>
        /// <para>ログ出力(エラー)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HyssopGISCtlMainProgram.ErrorLOG(msg); </para>
        /// </example>
        /// <param name="msg">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void ErrorLOG(string msg)
        {
            HySFile csErrFile = new HySFile("..\\log\\HyssopGISController_LOG.txt");
            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            csErrFile.WriteText("*ErrorMsg : "+DateTime.Now.ToString()+" (" + msg + ")");
            csErrFile.Close();
        }
        /// <summary><para>method outline:</para>
        /// <para>ログ初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HyssopGISCtlMainProgram.startLOG(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void startLOG()
        {
            HySFile csErrFile = new HySFile("..\\log\\HyssopGISController_LOG.txt");
            csErrFile.Delete();
        }
    }
}
