using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HysGISControllerJob
{
    /// <summary><para>class outline:</para>
    /// <para>定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HysGISJobControllerDefine
    {
        // ===========================
        // 種別識別子関係
        // ===========================
        /// <summary>業務種別識別子：システム内でユニークな値としてください（メニューに登録します）</summary>
        static public readonly HySKind BUSINESS_KIND = new HySObjectKind("Hyssop.GISControllerJob.HysAddinGISJobBusiProc");
        /// <summary>ビューア内処理ファクトリー：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier FACTORY_ID_VIEWRJOB = new HySID("Hyssop.GISControllerJob.Factory.ViewerJob");

        /// <summary>起動するＧＩＳコントローラーの実行体名</summary>
        static public readonly HySString GIS_CONTROLLER_EXE_NAME = new HySString("HyssopGISController.exe");

        // ===========================
        // メニューコールバック番号定義関係
        // ===========================
        /// <summary>ツール：GoogleEarth表示処理</summary>
        static public readonly long DISP_GOOGLE_EARTH_GIS = 60351;
        /// <summary>ツール：コントローラー起動</summary>
        static public readonly long WAKEUP_GIS_CONTROLLER = 60352;
        /// <summary>解説表示</summary>
        static public readonly long SAMPLE_DISP_MANUAL = 60353;
        // ToDo メニューからのコールバック番号を追加定義（メニュー数分）


        // ===========================
        // Google Earth Install ﾃﾞｨﾚｸﾄﾘ
        //     フルパス指定
        //  GoogleEarthをインストールしているディレクトリに変更して下さい。
        // ===========================
        /// <summary>ツール：GoogleEarth表示処理</summary>
        static public readonly string GOOGLE_EARTH_PATH = "C:\\Program Files\\Google\\Google Earth\\client\\googleearth.exe";

    }
}
