﻿// <summary>ソースコード：メインビューアクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>メインビューアクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HySGISCtlViewer : HySViewerBase //HySViewer
    {
        /// <summary>メインフレーム</summary>
        protected HySGISCtlMainForm m_csMainForm;
        /// <summary>画面内業務処理 </summary>
        protected HySGISCtlViewerJob m_csCtlJob;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySGISCtlViewer csViewer = new HySGISCtlViewer( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISCtlViewer()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean Initialize()
        {
            HyssopGISCtlMainProgram.DebugLOG("start of HySGISCtlViewer.Initialize()");

            m_csCtlJob = new HySGISCtlViewerJob();// ビューア内部処理生成
            m_csCtlJob.SetViewer(this);   // 各種設定
            m_csCtlJob.SetSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);


            m_csCtlJob.SetScreenFactory(m_csFactoryManager.GetScreenFactorySet());
            m_csCtlJob.SetViewFormFactory(m_csFactoryManager.GetViewFormFactorySet());


            HyssopGISCtlMainProgram.DebugLOG("start of Application.EnableVisualStyles()");
            Application.EnableVisualStyles();
            // フォームを生成する前に必ず実行する必要がある。
            Application.SetCompatibleTextRenderingDefault(false);

            // メインフレーム生成
            m_csMainForm = new HySGISCtlMainForm(this);
            // 画面表示位置
            m_csMainForm.SetDesktopLocation(5, 45);
            m_csMainForm.WindowState = FormWindowState.Normal;
            m_csMainForm.StartPosition = FormStartPosition.Manual;
            HyssopGISCtlMainProgram.DebugLOG("end of new HySGISCtlMainForm()");


            //HySGISCtlMainForm の 表示位置は、一番左端に持って行きたい


            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean Terminate()
        {
            //return base.Terminate();
            return m_csCtlJob.Terminate();
        }

        /// <summary><para>method outline:</para>
        /// <para>起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Run()
        {
            // 本番アプリケーション動作開始
            HyssopGISCtlMainProgram.DebugLOG("start of Application.Run(m_csMainForm) in  HySGISCtlViewer.Run()");
            m_csMainForm.VeryFirstJob();
            Application.Run(m_csMainForm);
            HyssopGISCtlMainProgram.DebugLOG("end   of Application.Run(m_csMainForm) in  HySGISCtlViewer.Run()");
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        override public Boolean EventCallback(HySSysEvent csEvent)
        {
            return m_csCtlJob.EventCallback(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean ExitOK()
        {
            return m_csCtlJob.ExitOK();
        }
        /// <summary><para>method outline:</para>
        /// <para>プロセス終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Exit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Exit()
        {
            m_csCtlJob.Terminate();
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddViewerJob( csViewerJob ) </para>
        /// </example>
        /// <param name="csViewerJob">ビューア内部処理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddViewerJob(HySViewerJob csViewerJob)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewerJob csJob = GetViewerJob(csKey) </para>
        /// </example>
        /// <param name="csKey">取得識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySViewerJob GetViewerJob(HySStringRoot csKey)
        {
            return m_csCtlJob;
        }
        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySGISCtlViewerJob csJob = GetJob( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySGISCtlViewerJob GetJob()
        {
            return m_csCtlJob;
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>フォームのMdiClientコントロールを探して返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MdiClient m_cForm = GetMdiClient() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>見つかったMdiClientコントロール</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private MdiClient GetMdiClient()
        {
            foreach (Control csControl in m_csMainForm.Controls)
            {
                if (csControl is MdiClient)
                {
                    return (MdiClient)csControl;
                }
            }
            return null;
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>メインフレーム取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetMainForm csForm = GetMainForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>メインフレーム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySGISCtlMainForm GetMainForm()
        {
            return (HySGISCtlMainForm)m_csMainForm;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント監視処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EventWatch( csCtl ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面以外から　色々なスレッドで来るイベントを監視し、画面のスレッドに乗り換える処理</para>
        /// </remarks>
        virtual public void EventWatch()
        {
            // ビューア制御のイベント監視処理
            //((HySViewerController)m_csViewerCtl).TryWatchEvent();
            // Do Nothing 必要が生じた時には、実装（例えば、別スレッドから画面へのイベントを飛ばす等）
        }

    }
}
