﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.CompilerServices;
using System.IO;
using System.Threading;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
//using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;


namespace CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア共通処理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HySGISCtlViewerJob : HySViewerJob
    {
        /// <summary>シミュレータ識別子</summary>
        protected HySKind m_csSimKindID;

        /// <summary>ビューア</summary>
        protected HySViewer m_csViewer;

        /// <summary>フォームファクトリ</summary>
        protected HySViewFormFactory m_csViewFormFactory;


        /// <summary>スクリーン識別管理ハッシュテーブル</summary>
        protected Hashtable m_csScreenTbl = null;
        /// <summary>スクリーン識別キー管理リスト</summary>
        protected IList m_csScreenKeyList = null;


        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;


        /// <summary>ＫＭＬ出力データ</summary>
        protected HySDataRoot m_csKMLData = null;
        /// <summary>ＫＭＬファイル名称（フルパス）</summary>
        protected HySString m_csKMLOutFile = null;

        // 常数定義
        /// <summary>KML出力スレッド動作中フラグ</summary>
        static public  bool KMLOUT_THREAD_WORK = false;
        /// <summary>KML出力状態フラグ</summary>
        static public bool KMLOUT_STATUS = false;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewerSystemJob csJob = new HySDotNetViewerSystemJob( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISCtlViewerJob()
        {
            m_csSimKindID = HySDefine.COMMON_SYS_BUSIPROCEDURE;
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューアを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetViewr( csViewr ) </para>
        /// </example>
        /// <param name="csViewr">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetViewer(HySViewer csViewr)
        {
            m_csViewer = csViewr;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンファクトリを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetScreenFactory( csViewr ) </para>
        /// </example>
        /// <param name="csScreenFactory">スクリーンファクトリ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetScreenFactory(HySScreenFactory csScreenFactory)
        {
            // Do Nothing
            //m_csScreenFactory = csScreenFactory;
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームファクトリを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetViewFormFactory( csViewrFormFactory ) </para>
        /// </example>
        /// <param name="csViewFormFactory">フォームファクトリ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetViewFormFactory(HySViewFormFactory csViewFormFactory)
        {
            if (csViewFormFactory != null)
            {
                m_csViewFormFactory = csViewFormFactory;
            }
            else
            {
                HyssopGISCtlMainProgram.ErrorLOG("null_viewFactory set in HySGISCtlViewerJob.SetViewFormFactory()");
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Initialize()
        {
            m_bWorkFlg = true;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Terminate()
        {
            m_bWorkFlg = false;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            // 全スクリーンの終了処理を実行

            for (long lLp = 1; lLp <= m_csScreenKeyList.Count; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    csScreen.Terminate();
                    csScreen = null;
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean ExitOK()
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            // Do Nothing
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            HySEventObject csEventObj = csEvent as HySEventObject;
            long lEventNo = csEventObj.GetEventNo();
            long lSubEventNo = csEventObj.GetSubEventNo();

            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {   // 表示イベントならば
                bRtn=this.CmndShowScreen(lSubEventNo, csEventObj);
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {   // 一般のイベントならば
                if (lSubEventNo == HySGISCtlDefine.KML_OUT)
                {
                    bRtn=this.PutKMLFile(csEventObj);
                }
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CmndShowScreen( lEventSubNo,csEvent ) </para>
        /// </example>
        /// <param name="lEventSubNo">イベント番号</param>
        /// <param name="csEvent">イベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean CmndShowScreen(long lEventSubNo, HySEventObject csEvent)
        {
            Boolean bRtn = true;
            HySScreen csScreen = null;

            HySID csScreenID = null;
            HySKind csScreenKind = null;


            //HySEventObject csDispEvent = null;

            if (lEventSubNo == HySGISCtlDefine.DISP_BASE_MAP)
            {
                csScreenID = new HySID(HySDefine.DISP_FORM_GIS_BASEMAP.ToString());
                csScreen = this.GetScreen(csScreenID);
                if (csScreen == null)
                {
                    csScreen = new CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController.HySGISBaseMapScreen();
                    //csScreen = new HySGISBaseMapScreen();
                    csScreen.SetID(csScreenID);

                    this.SetScreen(csScreen); // スクリーン設定
                }
                csScreenKind = HySDefine.DISP_FORM_GIS_BASEMAP;
            }
            else if (lEventSubNo == HySGISCtlDefine.DISP_MAP_FIGURE)
            {   // 地図上自由図形表示の場合
                csScreenID = new HySID(HySDefine.DISP_FORM_GIS_FIGURE.ToString());
                 
                csScreen = this.GetScreen(csScreenID);
                if (csScreen == null)
                {
                    csScreen = new HySGISMapFigureScreen();
                    csScreen.SetID(csScreenID);

                    this.SetScreen(csScreen); // スクリーン設定
                }

                csScreenKind = HySDefine.DISP_FORM_GIS_FIGURE;
            }
            else if (lEventSubNo == HySGISCtlDefine.DISP_2D_MESH)
            {
                csScreenID = new HySID(HySDefine.DISP_FORM_GIS2D_MESH.ToString());  // <-- 複数毎表示するときには、ＩＤの取り方を考える。
                                                                                    // 例：ファイル名＋データＩＤ名
                csScreen = this.GetScreen(csScreenID);
                if (csScreen == null)
                {
                    csScreen = new CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController.HySGISDim2MeshScreen();
                    csScreen.SetID(csScreenID);

                    this.SetScreen(csScreen); // スクリーン設定
                }

                csScreenKind = HySDefine.DISP_FORM_GIS2D_MESH;
            }
            else if (lEventSubNo == HySGISCtlDefine.DISP_3D_MESH)
            {
                //csScreen = new HySGISDim3MeshScreen();
            }

            if (csScreen != null)
            {
                csScreen.SetSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                csScreen.SetViewer(m_csViewer); // ビューア設定
                csScreen.SetViewerJob(this); // ビューアジョブ設定

                HySViewForm csViewFrom = m_csViewFormFactory.CreateViewForm(HySDefine.COMMON_DISP_BUSIPROCEDURE, csScreenID, csScreenKind);
                if (csViewFrom != null)
                {  // 対応画面フォーム正常生成の場合
                    ((HySScreen)csScreen).SetViewForm(csViewFrom); // フォーム設定

                    long lRtn = this.SetDispData(lEventSubNo,csEvent,csScreen);
                    if (lRtn == -1)
                    {
                        // 処理異常
                        bRtn = false;
                    }
                    //csDispEvent.SetSubData(csDispCnt);
                }

                csScreen.Initialize(); // 画面初期化
                //csScreen.SetDispEventData(csEvent); // 特殊イベント処理
                csScreen.ShowScreen(); // スクリーン可視化
            }

            return bRtn;
        }

        /// <summary><para>method outline</para>
        /// <para>キー指定スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetScreen( csKey ) </para>
        /// </example>
        /// <param name="csKey">スクリーン識別情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual HySScreen GetScreen(HySID csKey)
        {
            HySScreen csScreen = m_csScreenTbl[csKey.ToString()] as HySScreen;
            return csScreen;
        }
        /// <summary><para>method outline:</para>
        /// <para>スクリーンを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetScreen( csScreen, csKey ) </para>
        /// </example>
        /// <param name="csScreen">スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void SetScreen(HySScreen csScreen )
        {
            HySID csKey = csScreen.GetID() as HySID;
            m_csScreenTbl[csKey.ToString()] = csScreen;
            m_csScreenKeyList.Add(new HySString(csKey.ToString()));
        }

        /// <summary><para>method outline:</para>
        /// <para>表示画面設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = SetDispData( lEventSubNo,csEvent ) </para>
        /// </example>
        /// <param name="lEventSubNo">イベント番号</param>
        /// <param name="csEvent">イベント</param>
        /// <param name="csScreen">スクリーンインスタンス</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long SetDispData(long lEventSubNo, HySEventObject csEvent, HySScreen csScreen)
        {
            long lRtn = -1;
            if (lEventSubNo == HySGISCtlDefine.DISP_BASE_MAP)
            {
                //csDispData = csContainer.GetData(new HySString(HySDefine.DISP_FORM_GIS_BASEMAP.ToString())) as HySGeoBaseMapData;
                //HySGeoBaseMapData csGisData = new HySGeoBaseMapData(36.0, 140.0, 250000);
                HySGeoBaseMapData csGisData = new HySGeoBaseMapData(35.30, 138.725, 15000, 50, 0);
                ((CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController.HySGISBaseMapScreen)csScreen).SetDispData(csGisData);
                lRtn = 0;
            }
            else if (lEventSubNo == HySGISCtlDefine.DISP_MAP_FIGURE)
            {   // 地図上自由図形表示の場合

            }
            else if (lEventSubNo == HySGISCtlDefine.DISP_2D_MESH)
            {
                HySGeoDim2MeshSerialData csDispData = this.MakeD2MeshDispData(csEvent);
                if (csDispData != null)
                {
                    ((CommonMP.HYSSOP.OptionImpl.HSViewer.HyssopGISController.HySGISDim2MeshScreen)csScreen).SetDispData(csDispData);
                    lRtn = 0;
                }
                else
                {
                    // 処理異常
                    lRtn = -1;
                }
            }
            else if (lEventSubNo == HySGISCtlDefine.DISP_3D_MESH)
            {
            }

            return lRtn;
        }

           
        /// <summary><para>method outline:</para>
        /// <para>表示データ作成処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MakeD2MeshDispData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>
        /// HySGeoDim2MeshSerialData:生成された表示データ
        ///  設定が異常の場合には、null が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual HySGeoDim2MeshSerialData MakeD2MeshDispData(HySEventObject csEvent)
        {
            HySGeoDim2MeshSerialData csRtn = null;
            try
            {
                HySSelectDataInf csSlctInf = csEvent.GetData() as HySSelectDataInf;
                if (csSlctInf != null)
                {
                    string sDataFileName = csSlctInf.GetFileName();
                    long lSlctItemNo = csSlctInf.GetSelectDataItemNo();

                    //  sDataFileName から　データファイルを読み出す。
                    HySString csDispDataName = new HySString(sDataFileName);
                    HySFile csFile = new HySFile(csDispDataName);

                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)
                    {
                        // Open 出来なかったときの異常処理
                        HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlViewerJob.MakeD2MeshDispData():" + "File Open Failed.");
                        return null;
                    }
                    HySGeoDim2MeshSerialData scD2MeshData = null;

                    scD2MeshData = HySGeoDim2MeshSerialData.CSVHeaderRead(csFile);
                    if (scD2MeshData != null)
                    {
                        scD2MeshData.ReadCSVFileDataOnly(csFile);
                    }
                    else
                    {
                        // else 時の異常処理
                        HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlViewerJob.MakeD2MeshDispData():" + "Data Create Failed.");
                        csFile.Close();
                        return null;
                    }
                    csFile.Close();

                    // lSlctItemNoで指定された　セル内のデータ用いて、　セル内のデータが１つのGISデータを生成する
                    // ★　読み込んだ　scD2MeshDataのなかには　セル内に複数の情報が入っているため、
                    // ★　このうちの一つのセルだけの情報を取り出して　新しい HySGeoDim2MeshSerialDataを作成する。

                    long lDtDimLon = scD2MeshData.GetLonDimension();
                    long lDtDimLat = scD2MeshData.GetLatDimension();
                    HySDataCharacteristicInCell csCellCharactor = scD2MeshData.GetCellDataCharacteristic();
                    long lCellCharaIdxNum = csCellCharactor.m_lDim;

                    //HySGeoDim2MeshSerialData scDispD2MeshData = new HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, lDtDimLon, lDtDimLat, lCellCharaIdxNum);
                    HySGeoDim2MeshSerialData scDispD2MeshData = new HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD, lDtDimLon, lDtDimLat, 1);

                    HySDataCharacteristicInCell csNewCellCharactor = new HySDataCharacteristicInCell(1);
                    csNewCellCharactor.m_csDataKind[0] = csCellCharactor.m_csDataKind[lSlctItemNo];
                    csNewCellCharactor.m_csLabel[0] = csCellCharactor.m_csLabel[lSlctItemNo];
                    csNewCellCharactor.m_csUnit[0] = csCellCharactor.m_csUnit[lSlctItemNo];
                            //csNewCellCharactor.m_csDataKind[0] = HySDataKindDefineANY_VALUE;  //DioVista CMP.ini 内に設定されていないと、DioVista上で表示されない。
                    scDispD2MeshData.SetCellDataCharacteristic(csNewCellCharactor);

                    // 位置を取得
                    double dSWLat = 0.0;
                    double dSWLon = 0.0;
                    double dNELat = 0.0;
                    double dNELon = 0.0;
                    scD2MeshData.GetLocation(ref dSWLat, ref dSWLon, ref dNELat, ref dNELon);
                    scDispD2MeshData.SetLocation(dSWLat, dSWLon, dNELat, dNELon);

                    // 高度を取得
                    double dUpAlt = 0.0;
                    double dLwAlt = 0.0;
                    scD2MeshData.GetAltitude(ref dUpAlt, ref dLwAlt);
                    scDispD2MeshData.SetAltitude(dUpAlt, dLwAlt);

                    long lDtCnt = scD2MeshData.GetCount(); // データ数
                    HySGeoDim2MeshData csRcdDt = null;
                    HySGeoDim2MeshData csDispRcdDt = null;
                    HySCellData[,] csCells;
                    HySCellData[,] csDispCells;

                    scD2MeshData.SetCursorFirst();
                    for (long lLp = 0; lLp < lDtCnt; lLp++)
                    {
                        csRcdDt = scD2MeshData.GetCursorData() as HySGeoDim2MeshData;
                        csCells = csRcdDt.GetMeshData();
                        csDispRcdDt = scDispD2MeshData.CreateNewRecord() as HySGeoDim2MeshData;
                        csDispCells = csDispRcdDt.GetMeshData();
                        for (long lLp2 = 0; lLp2 < lDtDimLon; lLp2++)
                        {
                            for (long lLp3 = 0; lLp3 < lDtDimLat; lLp3++)
                            {
                                csDispCells[lLp2, lLp3].m_dData[0] = csCells[lLp2, lLp3].m_dData[lSlctItemNo];
                            }
                        }
                        csDispRcdDt.SetTime(csRcdDt.GetLastTime());
                        scDispD2MeshData.AddData(csDispRcdDt);
                        scD2MeshData.MoveCursorNext();
                    }

                    // lSlectItemNo から選択されたセル内データを読み出し、新しいデータファイルに入れ替える
                    csRtn = scDispD2MeshData;


                }
            }
            catch (Exception ex)
            {
                // 例外発生
                HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlViewerJob.MakeD2MeshDispData():" + ex.Message);
                return null;
            }
            return csRtn;
        }



        /// <summary><para>method outline:</para>
        /// <para>ＫＭＬ出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutKMLFile(csEvent) </para>
        /// </example>
        /// <param name="csEvent">イベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool PutKMLFile(HySEventObject csEvent)
        {

            //セレクトされた情報から、HySGeoDim2MeshSerialDataを作成する
            m_csKMLData = this.MakeD2MeshDispData(csEvent);
            if (m_csKMLData != null)
            {
                HySString csKMLFile = csEvent.GetSubData() as HySString; // KML ファイル名
                m_csKMLOutFile = csKMLFile;
                // 別スレッドを立てて実行
                ThreadStart ThSt = new ThreadStart(this.KMLFileOutThreadJob);
                Thread t = new Thread(ThSt);
                t.Start();
            }
            else
            {
                // 処理異常
                return false;
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＫＭＬファイル作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> KMLFileOutThreadJob() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ＫＭＬ出力は時間がかかるので、別スレッドにする,別プロセスにしても良い....</para>
        /// </remarks>
        public void KMLFileOutThreadJob()
        {
            KMLOUT_THREAD_WORK = true;
            try
            {
                // ＫＭＬ作成
                WriteKMLData((HySGeoDim2MeshSerialData)m_csKMLData, m_csKMLOutFile);

            }
            catch (Exception ex)
            {
                // 処理異常
                HyssopGISCtlMainProgram.ErrorLOG("HySGISCtlViewerJob.KMLFileOutThreadJob():" + ex.Message);
                // 異常終了報告
                KMLOUT_THREAD_WORK = false;
                KMLOUT_STATUS = false;
                return;
            }
            // 作成完了報告
            KMLOUT_THREAD_WORK = false;
            KMLOUT_STATUS = true;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定データの画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowMeshData (csD2MeshSerialData)</para>
        /// </example>
        /// <param name="csD2MeshSerialData">表示するメッシュデータ</param>
        /// <param name="sWriteKMLFileName">書き出す</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WriteKMLData(HySGeoDim2MeshSerialData csD2MeshSerialData, HySString sWriteKMLFileName)
        {
            // <summary>凡例、色属性情報等 </summary>
            HySGeoLegendInf m_csLegendInf=new HySGeoLegendInf();
            // <summary>セルの表示アイテム位置番号：０固定 </summary>
            long m_lDispIdx = 0;
            //// <summary> KML ﾌｧｲﾙ名称（ﾌﾙﾊﾟｽ付き）</summary>
            //string m_sDispKMLFileName = "";

            try
            {
                m_lDispIdx = 0; // ０固定(重要)

                // 色属性、凡例等情報読取得
                string sLegendFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendAny.xml";
                m_csLegendInf.ReadXMLFile(sLegendFile);
                m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.clampToGround);

                if (HySDataKindDefine.WATER_LEVEL.Equals(csD2MeshSerialData.GetCellDataCharacteristic().GetDataKind(m_lDispIdx)) == true ||
                    HySDataKindDefine.FLOODING_WATER_DEPTH.Equals(csD2MeshSerialData.GetCellDataCharacteristic().GetDataKind(m_lDispIdx)) == true)
                {
                    sLegendFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendWaterLevel.xml";
                    m_csLegendInf.ReadXMLFile(sLegendFile);
                    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.relativeToGround);

                }
                // 特殊な凡例が追加されたならば、コードを書き加える
                //else if (HySDataKindDefine.SCALOR_RAIN_FALL.Equals(csD2MeshSerialData.GetCellDataCharacteristic().GetDataKind(0)) == true)
                //{
                //    string sFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendRain.xml";
                //    m_csLegendInf.ReadXMLFile(sFile);
                //    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.absolute);
                //}
                //else
                //{
                //    sFile = HySEnvInf.GetHomeDirectory().ToString() + "\\SystemData\\GISLegendInf\\GISLegendAny.xml";
                //    m_csLegendInf.ReadXMLFile(sFile);
                //    m_csLegendInf.SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode.clampToGround);
                //}

                // ----------------
                // KMLﾌｧｲﾙ作成開始 
                // ----------------
                HySFile csFile = new HySFile(sWriteKMLFileName);
                // KMLﾌｧｲﾙオープン
                if (csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) != 0)
                {
                    return;
                }

                // KMLﾌｧｲﾙ書き出し
                HySGeoKMLWirteTool.WriteKmlMeshData(csFile, csD2MeshSerialData, m_lDispIdx, m_csLegendInf);

                // KMLﾌｧｲﾙクローズ
                csFile.Close();

            }
            catch (Exception e)
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeUndoEvent(long lCallBackNo)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeRedoEvent(long lCallBackNo)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCutEvent(long lCallBackNo)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeCopyEvent(long lCallBackNo)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticePasteEvent(long lCallBackNo)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeDeleteEvent(long lCallBackNo)
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void NoticeAllSelectEvent(long lCallBackNo)
        {
            // Do Nothing
        }

    }
}
