﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYSSOP.OptionImpl.HysGISControllerJob
{
    /// <summary><para>class outline:</para>
    /// <para>ビューアジョブクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// </remarks>
    public class HysGISControllerJob : HySDotNetAddInBaseJob
    {
        /// <summary>起動されたプロセスのハンドル（例）</summary>
        System.Diagnostics.Process m_hProcess = null;

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必須メソッド</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;

            if (lCallBackNo == HysGISJobControllerDefine.DISP_GOOGLE_EARTH_GIS)
            {   // GoogleEarth 起動ならば
                lRtn = this.ExecuteGoogleEarth();
            }
            else if (lCallBackNo == HysGISJobControllerDefine.WAKEUP_GIS_CONTROLLER)
            {   // ＧＳＩコントローラを起動する
                lRtn = this.WakeupGISController();
            }
            else if (lCallBackNo == HysGISJobControllerDefine.SAMPLE_DISP_MANUAL)
            {   // マニュアル表示
                lRtn = this.DispManual();
            } 

            else
            {
                lRtn = -1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理を必要としないならば、本メソッドは実装しなくても良い</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            // 処理例
            //m_bWorkFlg = true; // 処理開始したことをフラグに覚えさせておく
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理を必要としないならば、本メソッドは実装しなくても良い</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            //// 処理例(HySGISCtlMainForm.CheckCMPTimer()にて代替処理を行っている為実装不要)
            //if (System.Diagnostics.Process.GetProcessesByName("HcAddInSampleApplication").Length > 0)
            //{   // 起動中のプロセスが存在する時
            //    m_hProcess.Kill(); // 強制終了
            //}

            //m_bWorkFlg = false; // 処理終了したことをフラグに覚えさせておく
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// Terminate() による処理が終了していない場合等　false を返す。
        /// 特別な処理を必要としないならば、本メソッドは実装しなくても良い
        /// </para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // 処理例
            // 処理中でなければ(m_bWorkFlg==false)、本業務処理はＥｘｉｔしてもＯＫと判断して true を返す
            //if (m_bWorkFlg == true)
            //{
            //    return false;
            //}
            //else
            //{
            //    return true;
            //}
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>GoogleEarthを起動する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ExecuteGoogleEarth( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long ExecuteGoogleEarth()
        {
            long lRtn = 0;

            Process process = new Process();
            process.StartInfo.RedirectStandardOutput = true;  // コンソールを開かなくする
            process.StartInfo.CreateNoWindow = true; // コンソール・ウィンドウを開かない
            process.StartInfo.UseShellExecute = false; // シェル機能を使用しない （必須）
            process.StartInfo.FileName = HysGISJobControllerDefine.GOOGLE_EARTH_PATH;
            //process.StartInfo.Arguments = "-c ..\\temp\\exit.xml";
            process.Start();

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳコントローラープロセスを起動する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = WakeupGISController( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual long WakeupGISController()
        {
            long lRtn = -1;
            if (System.Diagnostics.Process.GetProcessesByName("HyssopGISController").Length < 1)
            {   // 既に起動中のプロセスが無い時
                HySString csExeFile = HysGISJobControllerDefine.GIS_CONTROLLER_EXE_NAME;
                HySFile csFile = new HySFile(csExeFile);
                if (csFile.Exist() == true)
                {
                    m_hProcess = System.Diagnostics.Process.Start(csExeFile.ToString());// +" -c CommonMP.cfg");
                    //Process.Start(csExeFile.ToString()); 
                    lRtn = 0;
                }
                else
                {
                    HySLog.LogOut(HySLog.ONLINE, "Not found (" + csExeFile.ToString() + ")");
                }
            }
            else
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, "cannot execute two \"HyssopGISController.exe\" simultaneously");
            }
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>PDFファイルを表示する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = DispManual( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0 : 正常　、-1 : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        protected virtual long DispManual()
        {
            HySString csPDFFile = HySEnvInf.GetHomeDirectory() + new HySString("\\help\\AddInSamples\\GoogleEarthSample2DGISDisp.pdf");
            HySFile csFile = new HySFile(csPDFFile);
            if (csFile.Exist() == true)
            {
                //Process.Start(csPDFFile.ToString());
                Help.ShowHelp(new Control(), csPDFFile.ToString());
            }

            return 0;
        }
    }
}
