﻿// <summary>ビューア内業務処理生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYSSOP.OptionImpl.HysGISControllerJob
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内処理ファクトリ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2012/01/22][新規作成]</para>
    /// </remarks>
    public class HysGISControllerJobFactory : HySDotNetAddInBaseJobFactory
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetViewerJobFactory csFactory = new McDotNetViewerJobFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HysGISControllerJobFactory()
        {
            // コンストラクター－内で　ファクトリＩＤを設定する
            // ToDo 独自のファクトリＩＤを設定して下さい。
            SetFactoryID(HysGISJobControllerDefine.FACTORY_ID_VIEWRJOB);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySKind GetSimKind()
        {
            // ToDo シミュレーション（業務ＩＤ）を取得する
            return HysGISJobControllerDefine.BUSINESS_KIND;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean EqualSimKind(HySKind csSimKindID)
        {
            // ToDo シミュレーション（業務ＩＤ）が同じか否かを判断する
            return HysGISJobControllerDefine.BUSINESS_KIND.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューアジョブクラス生成</para>   
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewrJob csViewerJob = CreateViewerJob( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ビューアクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySViewerJob CreateViewerJob()
        {
            // ToDo 独自の HySViewerJob 派生クラスを生成してください
            return  new HysGISControllerJob();
        }
    }
}
